/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.RuleToHostMap;
import groove.grammar.rule.Valuation;
import groove.grammar.rule.VarMap;
import groove.grammar.type.TypeElement;
import groove.graph.Node;
import groove.match.rete.DominoEventListener;
import groove.match.rete.LookupEntry;
import groove.match.rete.LookupTable;
import groove.match.rete.ReteNetworkNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class AbstractReteMatch
implements VarMap {
    private final boolean injective;
    private final ReteNetworkNode origin;
    protected AbstractReteMatch specialPrefix;
    private boolean deleted = false;
    private final List<AbstractReteMatch> superMatches = new ArrayList<AbstractReteMatch>();
    private final List<AbstractReteMatch> subMatches = new ArrayList<AbstractReteMatch>();
    private final Collection<Collection<? extends AbstractReteMatch>> containerCollections = new ArrayList<Collection<? extends AbstractReteMatch>>();
    private final List<DominoEventListener> dominoListeners = new ArrayList<DominoEventListener>();
    protected Valuation valuation = null;
    private int hashCode = 0;
    protected static Valuation emptyMap = new Valuation();

    public AbstractReteMatch(ReteNetworkNode origin, boolean injective) {
        this.injective = injective;
        this.origin = origin;
    }

    public boolean isInjective() {
        return this.injective;
    }

    public abstract Object[] getAllUnits();

    public abstract int size();

    public ReteNetworkNode getOrigin() {
        return this.origin;
    }

    public boolean conformsWith(RuleToHostMap anchorMap) {
        LookupTable lookup = this.origin.getPatternLookupTable();
        Object[] units = this.getAllUnits();
        boolean result = true;
        for (Map.Entry entry : anchorMap.edgeMap().entrySet()) {
            int i = lookup.getEdge((RuleEdge)entry.getKey());
            assert (i != -1);
            if (units[i].equals(entry.getValue())) continue;
            result = false;
            break;
        }
        if (result) {
            for (Map.Entry<Object, Object> entry : anchorMap.nodeMap().entrySet()) {
                Node actual;
                LookupEntry idx = lookup.getNode((RuleNode)entry.getKey());
                if (idx == null || (actual = idx.lookup(units)).equals(entry.getValue())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public void addContainerCollection(Collection<? extends AbstractReteMatch> c) {
        this.containerCollections.add(c);
    }

    public void removeContainerCollection(Collection<? extends AbstractReteMatch> c) {
        this.containerCollections.remove(c);
    }

    public void addDominoListener(DominoEventListener listener) {
        this.dominoListeners.add(listener);
    }

    public void removeDominoListener(DominoEventListener listener) {
        this.dominoListeners.remove(listener);
    }

    public static boolean checkInjectiveOverlap(HostNodeSet s1, HostNodeSet s2) {
        boolean result = true;
        HostNodeSet largerNodes = s1.size() > s2.size() ? s1 : s2;
        HostNodeSet smallerNodes = largerNodes == s1 ? s2 : s1;
        for (HostNode n : smallerNodes) {
            if (!largerNodes.contains(n)) continue;
            result = false;
            break;
        }
        return result;
    }

    public abstract HostNodeSet getNodes();

    public void addSuperMatch(AbstractReteMatch theSuperMatch) {
        this.superMatches.add(theSuperMatch);
        theSuperMatch.subMatches.add(this);
    }

    public synchronized void dominoDelete(AbstractReteMatch callerSubMatch) {
        if (!this.isDeleted()) {
            this.markDeleted();
            for (AbstractReteMatch abstractReteMatch : this.subMatches) {
                if (abstractReteMatch.isDeleted() || abstractReteMatch == callerSubMatch) continue;
                abstractReteMatch.superMatches.remove(this);
            }
            this.subMatches.clear();
            for (AbstractReteMatch abstractReteMatch : this.superMatches) {
                if (abstractReteMatch.isDeleted()) continue;
                abstractReteMatch.dominoDelete(this);
            }
            for (Collection collection : this.containerCollections) {
                collection.remove(this);
            }
            this.containerCollections.clear();
            for (DominoEventListener dominoEventListener : this.dominoListeners) {
                dominoEventListener.matchRemoved(this);
            }
            this.dominoListeners.clear();
        }
    }

    public synchronized void dominoDeleteAfter() {
        for (AbstractReteMatch superMatch : this.superMatches) {
            superMatch.dominoDelete(this);
        }
        this.superMatches.clear();
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    protected void markDeleted() {
        this.deleted = true;
    }

    protected Valuation getMergedValuation(AbstractReteMatch m) {
        Valuation result = this.valuation == null ? (m.valuation == null ? emptyMap : m.valuation) : this.valuation.getMerger(m.valuation);
        return result;
    }

    protected static Valuation getMergedValuation(AbstractReteMatch[] matches) {
        Valuation result = emptyMap;
        int i = 0;
        while (i < matches.length && result != null) {
            Valuation v = matches[i].getValuation();
            result = result.getMerger(v);
            ++i;
        }
        return result;
    }

    public AbstractReteMatch getSpecialPrefix() {
        return this.specialPrefix;
    }

    public final synchronized int hashCode() {
        if (this.hashCode == 0) {
            int result = this.computeHashCode();
            this.hashCode = result == 0 ? 1 : result;
        }
        return this.hashCode;
    }

    protected int computeHashCode() {
        int prime = 31;
        int result = this.getOrigin().hashCode();
        Object[] units = this.getAllUnits();
        int length = units.length;
        int i = 0;
        while (i < length) {
            Object unit = units[i];
            if (unit != this) {
                result = prime * result + unit.hashCode();
            }
            ++i;
        }
        return result;
    }

    @Override
    public Valuation getValuation() {
        return this.valuation;
    }

    @Override
    public TypeElement getVar(LabelVar var) {
        return (TypeElement)this.valuation.get(var);
    }

    @Override
    public void putAllVar(Valuation valuation) {
        this.valuation.putAll(valuation);
    }

    @Override
    public TypeElement putVar(LabelVar var, TypeElement value) {
        return this.valuation.put(var, value);
    }
}

