/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeNode;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.NodeComparator;
import groove.match.plan.AbstractSearchItem;
import groove.match.plan.PlanSearchStrategy;
import groove.match.plan.SearchItem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class Edge2SearchItem
extends AbstractSearchItem {
    final RuleEdge edge;
    final TypeEdge type;
    final RuleNode source;
    final TypeNode sourceType;
    final RuleNode target;
    final TypeNode targetType;
    final boolean selfEdge;
    private final Set<RuleNode> boundNodes;
    int edgeIx;
    int sourceIx;
    int targetIx;
    boolean sourceFound;
    boolean targetFound;
    private static final NodeComparator nodeComparator = NodeComparator.instance();

    public Edge2SearchItem(RuleEdge edge) {
        assert (((RuleLabel)edge.label()).isSharp() || ((RuleLabel)edge.label()).isAtom() || ((RuleLabel)edge.label()).isWildcard());
        assert (edge.getType() != null || ((RuleLabel)edge.label()).isWildcard());
        this.edge = edge;
        this.type = edge.getType();
        this.source = (RuleNode)edge.source();
        TypeNode sourceType = this.source.getType();
        this.sourceType = this.source.isSharp() || this.type == null || sourceType != this.type.source() ? sourceType : null;
        this.target = (RuleNode)edge.target();
        TypeNode targetType = this.target.getType();
        this.targetType = this.target.isSharp() || this.type == null || targetType != this.type.target() ? targetType : null;
        this.selfEdge = this.source == this.target;
        this.boundNodes = new HashSet<RuleNode>();
        this.boundNodes.add(this.source);
        this.boundNodes.add(this.target);
    }

    @Override
    public Collection<? extends RuleNode> bindsNodes() {
        return this.boundNodes;
    }

    @Override
    public Collection<? extends RuleEdge> bindsEdges() {
        return Collections.singleton(this.edge);
    }

    public RuleEdge getEdge() {
        return this.edge;
    }

    public String toString() {
        return String.format("Find %s", this.getEdge());
    }

    @Override
    public int compareTo(SearchItem other) {
        int result = super.compareTo(other);
        if (result != 0) {
            return result;
        }
        RuleEdge otherEdge = ((Edge2SearchItem)other).getEdge();
        result = ((RuleLabel)this.getEdge().label()).compareTo((Label)otherEdge.label());
        if (result != 0) {
            return result;
        }
        result = nodeComparator.compare((Node)this.getEdge().source(), (Node)otherEdge.source());
        if (result != 0) {
            return result;
        }
        result = nodeComparator.compare((Node)this.getEdge().target(), (Node)otherEdge.target());
        return result;
    }

    @Override
    public void activate(PlanSearchStrategy strategy) {
        this.edgeIx = strategy.getEdgeIx(this.edge);
        this.sourceFound = strategy.isNodeFound(this.source);
        this.sourceIx = strategy.getNodeIx(this.source);
        if (this.selfEdge) {
            this.targetFound = this.sourceFound;
            this.targetIx = this.sourceIx;
        } else {
            this.targetFound = strategy.isNodeFound(this.target);
            this.targetIx = strategy.getNodeIx(this.target);
        }
    }

    @Override
    int getRating() {
        return ((RuleLabel)this.edge.label()).hashCode();
    }

    @Override
    int computeHashCode() {
        int result = super.computeHashCode();
        return result * 31 + this.getEdge().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Edge2SearchItem other = (Edge2SearchItem)obj;
        return this.getEdge().equals(other.getEdge());
    }

    @Override
    public final SearchItem.Record createRecord(PlanSearchStrategy.Search search) {
        if (this.isPreMatched(search)) {
            return this.createDummyRecord();
        }
        if (this.isSingular(search)) {
            return this.createSingularRecord(search);
        }
        return this.createMultipleRecord(search);
    }

    boolean isPreMatched(PlanSearchStrategy.Search search) {
        return search.getEdgeSeed(this.edgeIx) != null;
    }

    boolean isSingular(PlanSearchStrategy.Search search) {
        return this.sourceFound && this.targetFound;
    }

    AbstractSearchItem.SingularRecord createSingularRecord(PlanSearchStrategy.Search search) {
        return new Edge2SingularRecord(search, this.edgeIx, this.sourceIx, this.targetIx);
    }

    AbstractSearchItem.MultipleRecord<HostEdge> createMultipleRecord(PlanSearchStrategy.Search search) {
        return new Edge2MultipleRecord(search, this.edgeIx, this.sourceIx, this.targetIx, this.sourceFound, this.targetFound);
    }

    boolean checkEdgeType(HostEdge image) {
        return this.type == null || this.type.subsumes(image.getType());
    }

    boolean checkSourceType(HostNode imageSource) {
        return this.sourceType == null || this.sourceType.subsumes(imageSource.getType(), this.source.isSharp());
    }

    boolean checkTargetType(HostNode imageTarget) {
        return this.targetType == null || this.targetType.subsumes(imageTarget.getType(), this.target.isSharp());
    }

    class Edge2MultipleRecord
    extends AbstractSearchItem.MultipleRecord<HostEdge> {
        private final int edgeIx;
        final int sourceIx;
        final int targetIx;
        private final boolean sourceFound;
        private final boolean targetFound;
        private HostNode sourceSeed;
        private HostNode targetSeed;
        HostNode sourceFind;
        HostNode targetFind;
        HostEdge selected;

        Edge2MultipleRecord(PlanSearchStrategy.Search search, int edgeIx, int sourceIx, int targetIx, boolean sourceFound, boolean targetFound) {
            super(search);
            this.edgeIx = edgeIx;
            this.sourceIx = sourceIx;
            this.targetIx = targetIx;
            this.sourceFound = sourceFound;
            this.targetFound = targetFound;
            assert (search.getEdge(edgeIx) == null) : String.format("Edge %s already in %s", edge2SearchItem.edge, search);
        }

        @Override
        public void initialise(HostGraph host) {
            super.initialise(host);
            this.sourceSeed = this.search.getNodeSeed(this.sourceIx);
            this.targetSeed = this.search.getNodeSeed(this.targetIx);
        }

        @Override
        void init() {
            this.sourceFind = this.sourceSeed;
            if (this.sourceFind == null && this.sourceFound) {
                this.sourceFind = this.search.getNode(this.sourceIx);
                assert (this.sourceFind != null) : String.format("Source node of %s not found", Edge2SearchItem.this.edge);
            }
            this.targetFind = this.targetSeed;
            if (this.targetFind == null && this.targetFound) {
                this.targetFind = this.search.getNode(this.targetIx);
                assert (this.targetFind != null) : String.format("Target node of %s not found", Edge2SearchItem.this.edge);
            }
            this.initImages();
        }

        @Override
        boolean write(HostEdge image) {
            if (!Edge2SearchItem.this.checkEdgeType(image)) {
                return false;
            }
            if (!this.writeSourceImage(image)) {
                return false;
            }
            if (!this.writeTargetImage(image)) {
                this.eraseSourceImage();
                return false;
            }
            if (!this.search.putEdge(this.edgeIx, image)) {
                this.eraseSourceImage();
                this.eraseTargetImage();
                return false;
            }
            this.selected = image;
            return true;
        }

        private boolean writeSourceImage(HostEdge image) {
            HostNode imageSource = image.source();
            if (this.sourceFind == null) {
                this.eraseTargetImage();
                if (!Edge2SearchItem.this.checkSourceType(imageSource)) {
                    return false;
                }
                if (!this.search.putNode(this.sourceIx, imageSource)) {
                    return false;
                }
            } else if (imageSource != this.sourceFind) {
                return false;
            }
            return true;
        }

        private boolean writeTargetImage(HostEdge image) {
            HostNode imageTarget = image.target();
            if (Edge2SearchItem.this.selfEdge) {
                if (imageTarget != image.source()) {
                    return false;
                }
            } else if (this.targetFind == null) {
                if (!Edge2SearchItem.this.checkTargetType(imageTarget)) {
                    return false;
                }
                if (!this.search.putNode(this.targetIx, imageTarget)) {
                    return false;
                }
            } else if (imageTarget != this.targetFind) {
                return false;
            }
            return true;
        }

        @Override
        void erase() {
            this.search.putEdge(this.edgeIx, null);
            this.eraseSourceImage();
            this.eraseTargetImage();
            this.selected = null;
        }

        private void eraseSourceImage() {
            if (this.sourceFind == null) {
                this.search.putNode(this.sourceIx, null);
            }
        }

        private void eraseTargetImage() {
            if (this.targetFind == null && !Edge2SearchItem.this.selfEdge) {
                this.search.putNode(this.targetIx, null);
            }
        }

        void initImages() {
            Set<Object> result = null;
            Set labelEdgeSet = this.host.edgeSet((Label)Edge2SearchItem.this.type.label());
            if (this.sourceFind != null) {
                Set nodeEdgeSet = this.host.edgeSet(this.sourceFind);
                if (nodeEdgeSet.size() < labelEdgeSet.size()) {
                    result = nodeEdgeSet;
                }
            } else if (this.targetFind != null) {
                Set nodeEdgeSet = this.host.edgeSet(this.targetFind);
                if (nodeEdgeSet == null) {
                    assert (this.targetFind instanceof ValueNode) : String.format("Host graph does not contain edges for node %s", this.targetFind);
                    result = Collections.emptySet();
                } else if (nodeEdgeSet.size() < labelEdgeSet.size()) {
                    result = nodeEdgeSet;
                }
            }
            if (result == null) {
                result = labelEdgeSet;
            }
            this.initImages(result);
        }

        final void initImages(Set<? extends HostEdge> imageSet) {
            this.imageIter = imageSet.iterator();
        }

        public String toString() {
            return String.valueOf(Edge2SearchItem.this.toString()) + " = " + this.selected;
        }
    }

    class Edge2SingularRecord
    extends AbstractSearchItem.SingularRecord {
        private HostNode sourceSeed;
        private HostNode targetSeed;
        private final int edgeIx;
        private final int sourceIx;
        private final int targetIx;
        private HostEdge image;

        public Edge2SingularRecord(PlanSearchStrategy.Search search, int edgeIx, int sourceIx, int targetIx) {
            super(search);
            this.edgeIx = edgeIx;
            this.sourceIx = sourceIx;
            this.targetIx = targetIx;
        }

        @Override
        public void initialise(HostGraph host) {
            super.initialise(host);
            this.sourceSeed = this.search.getNodeSeed(this.sourceIx);
            this.targetSeed = this.search.getNodeSeed(this.targetIx);
        }

        @Override
        boolean find() {
            HostEdge image = this.getEdgeImage();
            assert (image != null);
            boolean result = this.isImageCorrect(image);
            if (result) {
                this.image = image;
                this.write();
            }
            return result;
        }

        @Override
        final boolean write() {
            return this.search.putEdge(this.edgeIx, this.image);
        }

        @Override
        void erase() {
            this.search.putEdge(this.edgeIx, null);
        }

        boolean isImageCorrect(HostEdge image) {
            return this.host.containsEdge(image);
        }

        private HostEdge getEdgeImage() {
            HostNode sourceFind = this.sourceSeed;
            if (sourceFind == null) {
                sourceFind = this.search.getNode(this.sourceIx);
            }
            assert (sourceFind != null) : String.format("Source node of %s has not been found", Edge2SearchItem.this.edge);
            HostNode targetFind = this.targetSeed;
            if (targetFind == null) {
                targetFind = this.search.getNode(this.targetIx);
            }
            assert (targetFind != null) : String.format("Target node of %s has not been found", Edge2SearchItem.this.edge);
            return this.host.getFactory().createEdge(sourceFind, this.getType(), targetFind);
        }

        TypeEdge getType() {
            return Edge2SearchItem.this.type;
        }

        @Override
        public String toString() {
            return String.valueOf(Edge2SearchItem.this.toString()) + " = " + this.getEdgeImage();
        }
    }
}

