/*
 * Decompiled with CFR 0.152.
 */
package groove.match;

import groove.grammar.Condition;
import groove.grammar.host.HostGraph;
import groove.grammar.rule.Anchor;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.RuleToHostMap;
import groove.grammar.rule.Valuation;
import groove.match.MatcherFactory;
import groove.match.SearchEngine;
import groove.match.SearchStrategy;
import groove.match.TreeMatch;
import groove.match.ValueOracle;
import groove.util.Visitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Matcher
implements SearchStrategy {
    private final SearchEngine engine;
    private final Condition condition;
    private final Anchor seed;
    private SearchStrategy inner;
    private ValueOracle oracle;
    private final Visitor.Finder<TreeMatch> finder = Visitor.newFinder(null);
    private final Visitor.Collector<TreeMatch, List<TreeMatch>> collector = Visitor.newCollector(null);

    public Matcher(MatcherFactory factory, Condition condition, Anchor seed) {
        this.engine = factory.getEngine();
        this.condition = condition;
        if (seed == null && condition.getOp().hasPattern()) {
            seed = new Anchor();
            seed.addAll(condition.getInputNodes());
            seed.addAll(condition.getRoot().edgeSet());
            seed.addAll(condition.getRoot().varSet());
        }
        this.seed = seed;
        this.oracle = factory.getOracle();
    }

    public TreeMatch find(HostGraph host, RuleToHostMap seedMap) {
        Visitor.Finder<TreeMatch> finder = this.finder.newInstance();
        TreeMatch result = (TreeMatch)this.traverse(host, seedMap, finder);
        finder.dispose();
        return result;
    }

    public List<TreeMatch> findAll(HostGraph host, RuleToHostMap seedMap) {
        ArrayList<TreeMatch> result = new ArrayList<TreeMatch>();
        Visitor.Collector collector = this.collector.newInstance(result);
        this.traverse(host, seedMap, collector);
        collector.dispose();
        return result;
    }

    @Override
    public <T> T traverse(HostGraph host, RuleToHostMap seedMap, Visitor<TreeMatch, T> visitor) {
        assert (this.isCorrectSeeding(seedMap));
        assert (host.getFactory().getTypeFactory().getGraph() == this.condition.getTypeGraph());
        return this.getSearchStrategy().traverse(host, seedMap, visitor);
    }

    public final Condition getCondition() {
        return this.condition;
    }

    public final Anchor getSeed() {
        return this.seed;
    }

    @Override
    public SearchEngine getEngine() {
        return this.engine;
    }

    @Override
    public ValueOracle getOracle() {
        return this.oracle;
    }

    public void setOracle(ValueOracle oracle) {
        assert (oracle != null);
        this.oracle = oracle;
    }

    private final boolean isCorrectSeeding(RuleToHostMap seedMap) throws IllegalArgumentException {
        if (seedMap == null) {
            if (this.seed != null && !this.seed.isEmpty()) {
                throw new IllegalArgumentException("Unmatched seed keys: " + this.seed);
            }
        } else {
            if (!seedMap.nodeMap().keySet().equals(this.seed.nodeSet())) {
                HashSet<RuleNode> seedNodes = new HashSet<RuleNode>(this.seed.nodeSet());
                seedNodes.removeAll(seedMap.nodeMap().keySet());
                if (!seedNodes.isEmpty()) {
                    throw new IllegalArgumentException("Unmatched seed nodes: " + seedNodes);
                }
                HashMap seedNodeMap = new HashMap(seedMap.nodeMap());
                Set seedNodeKeys = seedNodeMap.keySet();
                seedNodeKeys.removeAll(this.seed.nodeSet());
                for (RuleEdge edge : this.seed.edgeSet()) {
                    seedNodeKeys.remove(edge.source());
                    seedNodeKeys.remove(edge.target());
                }
                seedNodeKeys.retainAll(this.getCondition().getPattern().nodeSet());
                if (!seedNodeMap.isEmpty()) {
                    throw new IllegalArgumentException("Spurious node seeding: " + seedNodeMap);
                }
            }
            if (!seedMap.edgeMap().keySet().equals(this.seed.edgeSet())) {
                HashSet<RuleEdge> seedEdges = new HashSet<RuleEdge>(this.seed.edgeSet());
                seedEdges.removeAll(seedMap.edgeMap().keySet());
                if (!seedEdges.isEmpty()) {
                    throw new IllegalArgumentException("Unmatched seed edges: " + seedEdges);
                }
                HashMap seedEdgeMap = new HashMap(seedMap.edgeMap());
                seedEdgeMap.keySet().removeAll(this.seed.edgeSet());
                seedEdgeMap.keySet().retainAll(this.getCondition().getPattern().edgeSet());
                if (!seedEdges.isEmpty()) {
                    throw new IllegalArgumentException("Spurious edge seeding: " + seedEdgeMap);
                }
            }
            if (!seedMap.getValuation().keySet().equals(this.seed.varSet())) {
                HashSet<LabelVar> seedVars = new HashSet<LabelVar>(this.seed.varSet());
                seedVars.removeAll(seedMap.getValuation().keySet());
                if (!seedVars.isEmpty()) {
                    throw new IllegalArgumentException("Unmatched seed variables: " + seedVars);
                }
                Valuation seedValuation = new Valuation(seedMap.getValuation());
                seedValuation.keySet().removeAll(this.seed.varSet());
                seedValuation.keySet().retainAll(this.getCondition().getPattern().varSet());
                if (!seedVars.isEmpty()) {
                    throw new IllegalArgumentException("Spurious variable seeding: " + seedValuation);
                }
            }
        }
        return true;
    }

    public final SearchStrategy getSearchStrategy() {
        if (this.inner == null || this.inner.getEngine() != this.getEngine()) {
            this.inner = this.getEngine().createMatcher(this.getCondition(), this.getSeed(), this.getOracle());
        }
        return this.inner;
    }
}

