/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.control.CtrlTransition;
import groove.grammar.Rule;
import groove.grammar.host.HostNode;
import groove.graph.ALabel;
import groove.graph.Label;
import groove.lts.ActionLabel;
import groove.lts.GraphState;
import groove.lts.MatchResult;
import groove.lts.RecipeTransitionLabel;
import groove.transform.AbstractRuleEvent;
import groove.transform.RuleEvent;
import java.util.Arrays;

public class RuleTransitionLabel
extends ALabel
implements ActionLabel {
    private final RuleEvent event;
    private final CtrlTransition ctrlTrans;
    private final HostNode[] addedNodes;
    private static final char BEGIN_CHAR = '<';
    private static final char END_CHAR = '>';
    private static final boolean REUSE_LABELS = false;

    private RuleTransitionLabel(GraphState source, MatchResult match, HostNode[] addedNodes) {
        this.event = match.getEvent();
        this.ctrlTrans = match.getCtrlTransition();
        this.addedNodes = addedNodes;
    }

    @Override
    public Rule getAction() {
        return this.event.getRule();
    }

    public RuleEvent getEvent() {
        return this.event;
    }

    public CtrlTransition getCtrlTransition() {
        return this.ctrlTrans;
    }

    public HostNode[] getAddedNodes() {
        return this.addedNodes;
    }

    @Override
    public String text() {
        return this.text(false);
    }

    public String text(boolean anchored) {
        StringBuilder result = new StringBuilder();
        boolean brackets = this.getAction().getSystemProperties().isShowTransitionBrackets();
        if (brackets) {
            result.append('<');
        }
        if (this.getCtrlTransition().hasRecipe()) {
            result.append(this.getCtrlTransition().getRecipe());
            result.append('/');
        }
        result.append(((AbstractRuleEvent)this.getEvent()).getLabelText(this.addedNodes, anchored));
        if (brackets) {
            result.append('>');
        }
        return result.toString();
    }

    @Override
    protected int computeHashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.addedNodes);
        result = 31 * result + this.event.hashCode();
        result = 31 * result + this.ctrlTrans.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleTransitionLabel other = (RuleTransitionLabel)obj;
        if (!Arrays.equals(this.addedNodes, other.addedNodes)) {
            return false;
        }
        if (!this.event.equals(other.event)) {
            return false;
        }
        return this.ctrlTrans.equals(other.ctrlTrans);
    }

    @Override
    public int compareTo(Label obj) {
        if (!(obj instanceof ActionLabel)) {
            throw new IllegalArgumentException(String.format("Can't compare %s and %s", this.getClass(), obj.getClass()));
        }
        int result = super.compareTo(obj);
        if (result != 0) {
            return result;
        }
        if (obj instanceof RecipeTransitionLabel) {
            return -1;
        }
        RuleTransitionLabel other = (RuleTransitionLabel)obj;
        result = this.getCtrlTransition().compareTo(other.getCtrlTransition());
        if (result != 0) {
            return result;
        }
        result = this.getEvent().compareTo(other.getEvent());
        return result;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static final String text(GraphState source, MatchResult match, boolean anchored) {
        return RuleTransitionLabel.createLabel(source, match, null).text(anchored);
    }

    public static final RuleTransitionLabel createLabel(GraphState source, MatchResult match, HostNode[] addedNodes) {
        RuleTransitionLabel result = new RuleTransitionLabel(source, match, addedNodes);
        return result;
    }
}

