/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.control.CtrlTransition;
import groove.grammar.Rule;
import groove.grammar.host.HostNode;
import groove.graph.Element;
import groove.lts.DefaultRuleTransition;
import groove.lts.GraphState;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import groove.lts.RuleTransitionStub;
import groove.transform.RuleEvent;
import java.util.Arrays;

abstract class AbstractRuleTransitionStub
implements RuleTransitionStub {
    private final GraphState target;
    private final CtrlTransition ctrlTrans;
    private final RuleEvent event;
    private final HostNode[] addedNodes;

    AbstractRuleTransitionStub(MatchResult match, HostNode[] addedNodes, GraphState target) {
        this.event = match.getEvent();
        this.ctrlTrans = match.getCtrlTransition();
        this.addedNodes = addedNodes;
        this.target = target;
    }

    @Override
    public GraphState getTarget(GraphState source) {
        return this.target;
    }

    public final RuleEvent getEvent() {
        return this.event;
    }

    @Override
    public final Rule getAction() {
        return this.getEvent().getRule();
    }

    @Override
    public MatchResult getKey(GraphState source) {
        return new MatchResult(this.event, this.ctrlTrans);
    }

    @Override
    public HostNode[] getAddedNodes(GraphState source) {
        return this.addedNodes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof AbstractRuleTransitionStub && this.equalsStub((AbstractRuleTransitionStub)obj);
    }

    @Override
    public RuleTransition toTransition(GraphState source) {
        return new DefaultRuleTransition(source, this.getKey(source), this.getAddedNodes(source), this.getTarget(source), this.isSymmetry());
    }

    protected boolean equalsStub(AbstractRuleTransitionStub other) {
        boolean result;
        boolean bl = result = this.target == other.target && this.getEvent() == other.getEvent() && this.isSymmetry() == other.isSymmetry();
        assert (!result || Arrays.equals(this.addedNodes, other.addedNodes));
        return result;
    }

    public int compareTo(Element obj) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.getEvent().hashCode() + this.target.hashCode();
    }
}

