/*
 * Decompiled with CFR 0.152.
 */
package groove.io.graph;

import groove.io.ExtensionFilter;
import groove.util.Groove;
import java.io.File;
import java.net.URL;

public class PriorityFileName {
    public static final int DEFAULT_PRIORITY = 0;
    public static final String SEPARATOR = ".";
    private final boolean explicitPriority;
    private final int priority;
    private final String ruleName;
    private String extension;

    public PriorityFileName(String fullName) {
        int separatorPos = fullName.indexOf(SEPARATOR);
        if (separatorPos <= 0) {
            this.priority = 0;
            this.explicitPriority = false;
        } else {
            boolean validStartNumber;
            int startNumber;
            try {
                startNumber = new Integer(fullName.substring(0, separatorPos));
                validStartNumber = true;
            }
            catch (NumberFormatException numberFormatException) {
                startNumber = 0;
                validStartNumber = false;
                separatorPos = -1;
            }
            this.priority = startNumber;
            this.explicitPriority = validStartNumber;
            if (this.priority < 0) {
                throw new NumberFormatException("Invalid rule priority " + this.priority);
            }
        }
        this.ruleName = fullName.substring(separatorPos + 1);
    }

    public PriorityFileName(File file) {
        this(ExtensionFilter.getPureName(file));
        this.extension = file.getName().substring(this.ruleName.length());
    }

    public PriorityFileName(URL url) {
        this(Groove.toFile(url));
    }

    public PriorityFileName(String ruleName, int priority, boolean explicitPriority) {
        this.ruleName = ruleName;
        this.priority = priority;
        this.explicitPriority = explicitPriority;
    }

    PriorityFileName(String ruleName, int priority) {
        this(ruleName, priority, priority != 0);
    }

    public Integer getPriority() {
        return this.priority;
    }

    public boolean hasPriority() {
        return this.explicitPriority;
    }

    public String getActualName() {
        return this.ruleName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String toString() {
        if (this.explicitPriority) {
            return this.priority + SEPARATOR + this.ruleName;
        }
        return this.ruleName;
    }
}

