/*
 * Decompiled with CFR 0.152.
 */
package groove.io.graph;

import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.graph.Edge;
import groove.graph.GraphInfo;
import groove.graph.Node;
import groove.gui.layout.JEdgeLayout;
import groove.gui.layout.JVertexLayout;
import groove.gui.layout.LayoutMap;
import groove.gui.look.LineStyle;
import groove.io.FileType;
import groove.io.HTMLConverter;
import groove.io.graph.AttrEdge;
import groove.io.graph.AttrGraph;
import groove.io.graph.AttrNode;
import groove.util.ExprParser;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

public class LayoutIO {
    private static LayoutIO instance = new LayoutIO();
    public static final String VERSION_PREFIX = "v";
    public static final String NODE_PREFIX = "n";
    public static final String EDGE_PREFIX = "e";
    public static final String INFO_PREFIX = "i";
    public static final String COMMENT_PREFIX = "#";
    public static final int VERSION1 = 1;
    public static final int VERSION2 = 2;
    public static final int CURRENT_VERSION_NUMBER = 2;
    private static final String LAYOUT_FORMAT_ERROR = String.format("Error in %s file", FileType.LAYOUT.getExtension());
    private static final char DOUBLE_QUOTE = '\"';
    private static final String WHITESPACE = " ";
    private static final Point2D DEFAULT_EDGE_VECTOR = new Point2D.Double(50.0, 0.0);

    private LayoutIO() {
    }

    /*
     * Unable to fully structure code
     */
    public void loadLayout(AttrGraph graph, InputStream in) throws IOException {
        layoutReader = new BufferedReader(new InputStreamReader(in));
        result = new LayoutMap();
        errors = new FormatErrorSet();
        try {
            version = 1;
            nextLine = layoutReader.readLine();
            while (nextLine != null) {
                block11: {
                    try {
                        parts = ExprParser.splitExpr(nextLine, " ");
                        if (parts.length <= 0) break block11;
                        command = parts[0];
                        if (command.equals("n")) {
                            this.putVertexLayout(result, parts, graph);
                            break block11;
                        }
                        if (command.equals("e")) {
                            this.putEdgeLayout(result, parts, graph, version);
                            break block11;
                        }
                        if (!command.equals("v")) break block11;
                        try {
                            version = Integer.parseInt(parts[1]);
                            break block11;
                        }
                        catch (NumberFormatException v0) {
                            throw new FormatException("Format error in version number %s", new Object[]{parts[1]});
                        }
                    }
                    catch (FormatException exc) {
                        ** for (error : exc.getErrors())
                    }
lbl-1000:
                    // 1 sources

                    {
                        errors.add(String.valueOf(LayoutIO.LAYOUT_FORMAT_ERROR) + ": %s", new Object[]{error});
                        continue;
                    }
                }
                nextLine = layoutReader.readLine();
            }
        }
        finally {
            layoutReader.close();
            in.close();
        }
        GraphInfo.addErrors(graph, errors);
        GraphInfo.setLayoutMap(graph, result);
    }

    private void putVertexLayout(LayoutMap layoutMap, String[] parts, AttrGraph graph) throws FormatException {
        AttrNode node = graph.getNode(parts[1]);
        if (node == null) {
            throw new FormatException("Unknown node " + parts[1], new Object[0]);
        }
        Rectangle bounds = LayoutIO.toBounds(parts, 2);
        if (bounds == null) {
            throw new FormatException("Bounds for " + parts[1] + " cannot be parsed", new Object[0]);
        }
        layoutMap.putNode((Node)node, new JVertexLayout(bounds));
    }

    private AttrEdge putEdgeLayout(LayoutMap layoutMap, String[] parts, AttrGraph graph, int version) throws FormatException {
        if (parts.length < 7) {
            throw new FormatException("Incomplete edge layout line", new Object[0]);
        }
        AttrNode source = graph.getNode(parts[1]);
        if (source == null) {
            throw new FormatException("Unknown node " + parts[1], new Object[0]);
        }
        AttrNode target = graph.getNode(parts[2]);
        if (target == null) {
            throw new FormatException("Unknown node " + parts[2], new Object[0]);
        }
        String labelTextWithQuotes = parts[3];
        String labelText = ExprParser.toUnquoted(labelTextWithQuotes, '\"');
        AttrEdge edge = graph.getEdge(source, labelText, target);
        if (edge == null) {
            throw new FormatException("Unknown edge %s --%s-> %s", source, labelText, target);
        }
        try {
            int lineStyle;
            List<Point2D> points;
            if (parts.length == 5) {
                points = null;
                lineStyle = LineStyle.DEFAULT_VALUE.getCode();
            } else {
                points = LayoutIO.toPoints(parts, 6);
                if (points.size() <= 1) {
                    throw new FormatException("Edge layout needs at least 2 points", new Object[0]);
                }
                lineStyle = Integer.parseInt(parts[parts.length - 1]);
                if (!LineStyle.isStyle(lineStyle)) {
                    lineStyle = LineStyle.DEFAULT_VALUE.getCode();
                }
                LayoutIO.correctPoints(points, layoutMap.getLayout(source), layoutMap.getLayout(target));
            }
            Point2D labelPosition = LayoutIO.calculateLabelPosition(LayoutIO.toPoint(parts, 4), points, version, source == target);
            layoutMap.putEdge((Edge)edge, new JEdgeLayout(points, labelPosition, LineStyle.getStyle(lineStyle)));
        }
        catch (NumberFormatException exc) {
            throw new FormatException("Number format error " + HTMLConverter.toUppercase(exc.getMessage(), false), new Object[0]);
        }
        return edge;
    }

    public static void correctPoints(List<Point2D> points, JVertexLayout sourceLayout, JVertexLayout targetLayout) {
        LayoutIO.correctPoint(points, 0, sourceLayout);
        LayoutIO.correctPoint(points, points.size() - 1, targetLayout);
    }

    private static void correctPoint(List<Point2D> points, int i, JVertexLayout layout) {
        Rectangle2D bounds;
        if (layout != null && !(bounds = layout.getBounds()).contains(points.get(i))) {
            points.set(i, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
        }
    }

    public static Point2D calculateLabelPosition(Point2D label, List<Point2D> points, int version, boolean isLoop) {
        Point2D result;
        if (version == 1) {
            if (points != null && points.size() > 0) {
                Point2D relativePos = LayoutIO.version1RelativePos(label, points);
                result = LayoutIO.version2LabelPos(relativePos, LayoutIO.version2LabelVector(points, isLoop));
            } else {
                result = new Point2D.Double(label.getX(), 0.0);
            }
        } else {
            result = label;
        }
        return result;
    }

    private static Point2D version1RelativePos(Point2D label, List<Point2D> points) {
        Rectangle2D tmp = LayoutIO.version1PaintBounds(points);
        int unit = 1000;
        Point2D p0 = points.get(0);
        Point2D p1 = points.get(1);
        Point2D pe = points.get(points.size() - 1);
        double x0 = tmp.getX();
        int xdir = 1;
        if (p0.getX() > pe.getX() || p0.getX() == pe.getX() && p1.getX() > p0.getX()) {
            x0 += tmp.getWidth();
            xdir = -1;
        }
        double y0 = tmp.getY();
        int ydir = 1;
        if (p0.getY() > pe.getY() || p0.getY() == pe.getY() && p1.getY() > p0.getY()) {
            y0 += tmp.getHeight();
            ydir = -1;
        }
        double x = x0 + (double)xdir * (tmp.getWidth() * label.getX() / (double)unit);
        double y = y0 + (double)ydir * (tmp.getHeight() * label.getY() / (double)unit);
        return new Point2D.Double(x - p0.getX(), y - p0.getY());
    }

    private static Rectangle2D version1PaintBounds(List<Point2D> points) {
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Point2D point : points) {
            minX = Math.min(minX, point.getX());
            maxX = Math.max(maxX, point.getX());
            minY = Math.min(minY, point.getY());
            maxY = Math.max(maxY, point.getY());
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    private static Point2D version2LabelVector(List<Point2D> points, boolean isLoop) {
        Point2D result = null;
        Point2D begin = points.get(0);
        Point2D end = points.get(points.size() - 1);
        if (!isLoop && !begin.equals(end)) {
            double dx = end.getX() - begin.getX();
            double dy = end.getY() - begin.getY();
            result = new Point2D.Double(dx, dy);
        } else if (points.size() > 0) {
            double sumX = 0.0;
            double sumY = 0.0;
            for (Point2D point : points) {
                sumX += point.getX() - begin.getX();
                sumY += point.getY() - begin.getY();
            }
            int n = points.size() / 2;
            result = new Point2D.Double(sumX / (double)n, sumY / (double)n);
        }
        if (result == null || result.getX() == 0.0 && result.getY() == 0.0) {
            result = DEFAULT_EDGE_VECTOR;
        }
        return result;
    }

    private static Point2D version2LabelPos(Point2D pos, Point2D edge) {
        double vector2 = edge.getX() * edge.getX() + edge.getY() * edge.getY();
        double ratio = (edge.getX() * pos.getX() + edge.getY() * pos.getY()) / vector2;
        double distance = (-pos.getX() * edge.getY() + pos.getY() * edge.getX()) / Math.sqrt(vector2);
        return new Point2D.Double(ratio * 1000.0, distance);
    }

    public static Rectangle toBounds(String[] s, int i) {
        if (s.length - i < 4) {
            return null;
        }
        return new Rectangle(Integer.parseInt(s[i + 0]), Integer.parseInt(s[i + 1]), Integer.parseInt(s[i + 2]), Integer.parseInt(s[i + 3]));
    }

    public static Point toPoint(String[] s, int i) {
        if (s.length - i < 2) {
            return null;
        }
        return new Point(Integer.parseInt(s[i + 0]), Integer.parseInt(s[i + 1]));
    }

    public static List<Point2D> toPoints(String[] s, int i) {
        LinkedList<Point2D> result = new LinkedList<Point2D>();
        int j = i;
        while (j < s.length - 1) {
            result.add(LayoutIO.toPoint(s, j));
            j += 2;
        }
        return result;
    }

    public static LayoutIO getInstance() {
        return instance;
    }
}

