/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.util;

import groove.gui.look.EdgeEnd;
import groove.gui.look.Line;
import groove.gui.look.Look;
import groove.gui.look.NodeShape;
import groove.gui.look.Values;
import groove.gui.look.VisualKey;
import groove.gui.look.VisualMap;
import groove.util.Duo;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class TikzStylesExtractor {
    public static final Set<Look> mainLooks = EnumSet.of(Look.BASIC, new Look[]{Look.CREATOR, Look.CONNECT, Look.DATA, Look.EMBARGO, Look.ERASER, Look.NESTING, Look.PRODUCT, Look.REMARK, Look.TYPE, Look.ABSTRACT, Look.SUBTYPE, Look.STATE, Look.TRANS, Look.START, Look.CTRL_TRANSIENT_STATE, Look.CTRL_OMEGA_TRANS, Look.CTRL_EXIT_TRANS, Look.CTRL_OMEGA_EXIT_TRANS});
    private static final Set<Look> mainNodeLooks = EnumSet.of(Look.BASIC, new Look[]{Look.CREATOR, Look.DATA, Look.EMBARGO, Look.ERASER, Look.NESTING, Look.PRODUCT, Look.REMARK, Look.TYPE, Look.ABSTRACT, Look.STATE, Look.START, Look.CTRL_TRANSIENT_STATE});
    private static final Set<Look> mainEdgeLooks = EnumSet.of(Look.BASIC, new Look[]{Look.CREATOR, Look.CONNECT, Look.EMBARGO, Look.ERASER, Look.NESTING, Look.REMARK, Look.TYPE, Look.ABSTRACT, Look.SUBTYPE, Look.TRANS, Look.CTRL_OMEGA_TRANS, Look.CTRL_EXIT_TRANS, Look.CTRL_OMEGA_EXIT_TRANS});
    private static final Set<Look> modifyingLooks = EnumSet.of(Look.NODIFIED, new Look[]{Look.BIDIRECTIONAL, Look.NO_ARROW, Look.COMPOSITE, Look.OPEN, Look.FINAL, Look.RESULT, Look.TRANSIENT, Look.ABSENT, Look.ACTIVE, Look.GRAYED_OUT});
    private static final Set<Look> unusedLooks = EnumSet.of(Look.REGULAR, Look.ADDER, Look.PATTERN, Look.EQUIV_CLASS);
    private static final Set<VisualKey> usedKeys = EnumSet.of(VisualKey.BACKGROUND, new VisualKey[]{VisualKey.DASH, VisualKey.EDGE_SOURCE_SHAPE, VisualKey.EDGE_TARGET_SHAPE, VisualKey.FOREGROUND, VisualKey.LINE_WIDTH, VisualKey.NODE_SHAPE});
    private static final Set<VisualKey> unusedKeys = EnumSet.of(VisualKey.ADORNMENT, new VisualKey[]{VisualKey.COLOR, VisualKey.EDGE_SOURCE_LABEL, VisualKey.EDGE_SOURCE_POS, VisualKey.EDGE_TARGET_LABEL, VisualKey.EDGE_TARGET_POS, VisualKey.EMPHASIS, VisualKey.ERROR, VisualKey.FONT, VisualKey.INNER_LINE, VisualKey.INSET, VisualKey.LABEL, VisualKey.LABEL_POS, VisualKey.LINE_STYLE, VisualKey.NODE_POS, VisualKey.NODE_SIZE, VisualKey.OPAQUE, VisualKey.POINTS, VisualKey.VISIBLE});
    private final StringBuilder result = new StringBuilder();
    public static final String NODE_SUFFIX = "_node";
    public static final String EDGE_SUFFIX = "_edge";
    private static final String NEW_LINE = "\n";
    private static final String BEGIN_TIKZ_STYLE = "\\tikzstyle{";
    private static final String MID_TIKZ_STYLE = "}=";
    private static final String END_TIKZ_STYLE = "\n";
    private static final String ROUNDED_CORNERS_KEY = "rounded corners";
    private static final String HEADER = "% Package that defines the styles used in Tikz figures exported in GROOVE.\n% This file was automatically generated by the TikzStylesExtraction utility.\n\n\\ProvidesPackage{groove2tikz}\n\\RequirePackage{tikz}\n\\usepackage[T1]{fontenc}\n\\usepackage{amssymb}\n\n% Includes for Tikz.\n\\usetikzlibrary{arrows,automata,positioning,er}\n\n% Dimension styles.\n\\newcommand{\\tikzfontsize}{\\footnotesize}\n\\newcommand{\\tikzscale}{2}\n\n\\tikzstyle every node=[font=\\tikzfontsize\\sffamily, inner sep=2.5pt, minimum size=9pt]\n\n% Extra style for edge labels.\n\\tikzstyle{lab}=[fill=white, inner sep=1pt]\n\n% Extra style for parameter adornments.\n\\tikzstyle{par_node}=[draw=black, fill=black, text=white, shape=rectangle, font=\\scriptsize\\sffamily, inner sep=1pt, minimum size=4pt, anchor=east]\n\n% Default colors for TeX strings.\n";
    private static final String MAIN_STYLE_COMMENT = "\n% Main styles. (Should be used first in a node and edge definition.)\n";
    private static final String MOD_STYLE_COMMENT = "\n% Modifying styles. (To be used in conjunction - AFTER - a main style.)\n\n";
    private static final String FOOTER = "\n% Ugly hack to allow nodes with multiple lines.\n\\newcommand{\\ml}[1]{\n\\begin{tabular}{@{}c@{}}#1\\vspace{-2pt}\\end{tabular}\n}\n";

    public static final void main(String[] args) {
        TikzStylesExtractor.checkConsistency();
        TikzStylesExtractor extractor = new TikzStylesExtractor();
        extractor.run();
        System.out.println(extractor.result);
    }

    private static final void checkConsistency() {
        EnumSet<Look> allLooks = EnumSet.allOf(Look.class);
        allLooks.removeAll(mainLooks);
        allLooks.removeAll(modifyingLooks);
        allLooks.removeAll(unusedLooks);
        EnumSet<VisualKey> allKeys = EnumSet.allOf(VisualKey.class);
        allKeys.removeAll(usedKeys);
        allKeys.removeAll(unusedKeys);
        if (!allLooks.isEmpty() || !allKeys.isEmpty()) {
            System.err.println("Cowardly refusing to run due to inconsistencies.");
            if (!allLooks.isEmpty()) {
                System.err.println("Don't know how to handle the following looks: " + allLooks);
                System.err.println("Did you add new entries in the Look enumeration?");
            }
            if (!allKeys.isEmpty()) {
                System.err.println("Don't know how to handle the following visual keys: " + allKeys);
                System.err.println("Did you add new entries in the VisualKey enumeration?");
            }
            System.exit(1);
        }
    }

    private TikzStylesExtractor() {
    }

    private void run() {
        this.append(HEADER);
        this.appendMainColors();
        this.appendMainStyles();
        this.appendModifyingStyles();
        this.append(FOOTER);
    }

    private void appendMainColors() {
        Line.ColorType[] colorTypeArray = Line.ColorType.values();
        int n = colorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line.ColorType cType = colorTypeArray[n2];
            Color color = cType.getColor();
            if (color != null) {
                this.append("\\definecolor{" + cType.name().toLowerCase() + "_c}{RGB}" + Style.getColorStringDefinition(color) + "\n");
            }
            ++n2;
        }
    }

    private void appendMainStyles() {
        this.append(MAIN_STYLE_COMMENT);
        for (Look mainLook : mainLooks) {
            Style style = new Style(mainLook);
            VisualMap visualMap = mainLook.getVisuals();
            for (VisualKey key : usedKeys) {
                Object value = visualMap.get(key);
                style.addEntry(key, value);
            }
            style.fix();
            this.append(style.toString());
        }
    }

    private void appendModifyingStyles() {
        this.append(MOD_STYLE_COMMENT);
        ArrayList<StyleDuo> styles = new ArrayList<StyleDuo>();
        for (Look modifyingLook : modifyingLooks) {
            styles.clear();
            this.append(BEGIN_TIKZ_STYLE);
            this.append(modifyingLook.name().toLowerCase());
            this.append(MID_TIKZ_STYLE);
            this.computeModifyingStyle(modifyingLook, styles);
            this.append(((Object)styles).toString());
            this.append("\n");
        }
    }

    private void computeModifyingStyle(Look look, List<StyleDuo> styles) {
        String defaultEdgeEnd = Style.getEdgeEndShape(EdgeEnd.ARROW);
        VisualMap visuals = look.getVisuals();
        switch (look) {
            case NODIFIED: {
                Style.writeNodeShape(visuals.getNodeShape(), styles);
                styles.add(new StyleDuo("minimum size", "4pt"));
                break;
            }
            case BIDIRECTIONAL: {
                styles.add(new StyleDuo(String.valueOf(defaultEdgeEnd) + "-" + defaultEdgeEnd, null));
                break;
            }
            case NO_ARROW: {
                styles.add(new StyleDuo("-", null));
                break;
            }
            case COMPOSITE: {
                String srcEdgeEnd = Style.getEdgeEndShape(visuals.getEdgeSourceShape());
                styles.add(new StyleDuo(String.valueOf(srcEdgeEnd) + "-" + defaultEdgeEnd, null));
                break;
            }
            case OPEN: 
            case FINAL: 
            case RESULT: {
                Style.writeBackgroundColor(visuals.getBackground(), styles);
                break;
            }
            case TRANSIENT: {
                Style.writeNodeShape(visuals.getNodeShape(), styles);
                styles.add(new StyleDuo(ROUNDED_CORNERS_KEY, "0pt"));
                Style.writeForegroundColor(visuals.getForeground(), styles);
                break;
            }
            case ABSENT: {
                Style.writeDash(visuals.getDash(), styles);
                break;
            }
            case ACTIVE: {
                Style.writeForegroundColor(visuals.getForeground(), styles);
                Style.writeLineWidth(visuals.getLineWidth(), styles);
                break;
            }
            case GRAYED_OUT: {
                Style.writeForegroundColor(visuals.getForeground(), styles);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid modifying look!");
            }
        }
    }

    private void append(String string) {
        this.result.append(string);
    }

    public static final class Style {
        Color background;
        Color foreground;
        float[] dash;
        EdgeEnd sourceEnd;
        EdgeEnd targetEnd;
        float lineWidth;
        NodeShape nodeShape;
        final Look look;
        final List<StyleDuo> nodes;
        final List<StyleDuo> edges;

        Style(Look look) {
            this.look = look;
            this.nodes = new ArrayList<StyleDuo>();
            this.edges = new ArrayList<StyleDuo>();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            if (!this.nodes.isEmpty()) {
                sb.append(TikzStylesExtractor.BEGIN_TIKZ_STYLE);
                sb.append(String.valueOf(this.look.name().toLowerCase()) + TikzStylesExtractor.NODE_SUFFIX);
                sb.append(TikzStylesExtractor.MID_TIKZ_STYLE);
                sb.append(this.nodes.toString());
                sb.append("\n");
            }
            if (!this.edges.isEmpty()) {
                sb.append(TikzStylesExtractor.BEGIN_TIKZ_STYLE);
                sb.append(String.valueOf(this.look.name().toLowerCase()) + TikzStylesExtractor.EDGE_SUFFIX);
                sb.append(TikzStylesExtractor.MID_TIKZ_STYLE);
                sb.append(this.edges.toString());
                sb.append("\n");
            }
            return sb.toString();
        }

        void addEntry(VisualKey key, Object value) {
            switch (key) {
                case BACKGROUND: {
                    this.background = (Color)value;
                    break;
                }
                case DASH: {
                    this.dash = (float[])value;
                    break;
                }
                case EDGE_SOURCE_SHAPE: {
                    this.sourceEnd = (EdgeEnd)((Object)value);
                    break;
                }
                case EDGE_TARGET_SHAPE: {
                    this.targetEnd = (EdgeEnd)((Object)value);
                    break;
                }
                case FOREGROUND: {
                    this.foreground = (Color)value;
                    break;
                }
                case LINE_WIDTH: {
                    this.lineWidth = ((Float)value).floatValue();
                    break;
                }
                case NODE_SHAPE: {
                    this.nodeShape = (NodeShape)((Object)value);
                    break;
                }
            }
        }

        void fix() {
            if (mainNodeLooks.contains((Object)this.look)) {
                Style.writeNodeShape(this.nodeShape, this.nodes);
                Style.writeDash(this.dash, this.nodes);
                Style.writeLineWidth(this.lineWidth, this.nodes);
                Style.writeForegroundColor(this.foreground, this.nodes);
                Style.writeBackgroundColor(this.background, this.nodes);
            }
            if (mainEdgeLooks.contains((Object)this.look)) {
                this.edges.add(new StyleDuo("draw", null));
                this.writeEdgeEnds();
                Style.writeDash(this.dash, this.edges);
                Style.writeLineWidth(this.lineWidth, this.edges);
                Style.writeEdgeColor(this.foreground, this.edges);
            }
        }

        private void writeEdgeEnds() {
            String srcEnd = Style.getEdgeEndShape(this.sourceEnd);
            String tgtEnd = Style.getEdgeEndShape(this.targetEnd);
            this.edges.add(new StyleDuo(String.valueOf(srcEnd) + "-" + tgtEnd, null));
        }

        static void writeLineWidth(float lineWidth, List<StyleDuo> styles) {
            int w = (int)Math.floor((double)lineWidth / 2.0);
            if (w > 0) {
                styles.add(new StyleDuo("line width", String.valueOf(w) + "pt"));
            }
        }

        static void writeDash(float[] dash, List<StyleDuo> styles) {
            if (dash == Values.NESTED_DASH) {
                styles.add(new StyleDuo("densely dotted", null));
            } else if (dash != Values.NO_DASH) {
                styles.add(new StyleDuo("densely dashed", null));
            }
        }

        static void writeForegroundColor(Color foreground, List<StyleDuo> styles) {
            String c = Style.getColorString(foreground);
            styles.add(new StyleDuo("draw", c));
            styles.add(new StyleDuo("text", c));
        }

        static void getForegroundColor(Color foreground, List<String> styles) {
            String c = Style.getColorString(foreground);
            styles.add("draw=" + c);
            styles.add("text=" + c);
        }

        static void writeBackgroundColor(Color background, List<StyleDuo> styles) {
            String c = Style.getColorString(background);
            styles.add(new StyleDuo("fill", c));
        }

        static void getBackgroundColor(Color background, List<String> styles) {
            String c = Style.getColorString(background);
            styles.add("fill=" + c);
        }

        static void writeEdgeColor(Color foreground, List<StyleDuo> styles) {
            String c = Style.getColorString(foreground);
            styles.add(new StyleDuo("color", c));
        }

        static void getEdgeColor(Color foreground, List<String> styles) {
            String c = Style.getColorString(foreground);
            styles.add("color=" + c);
        }

        static String getEdgeEndShape(EdgeEnd end) {
            switch (end) {
                case ARROW: 
                case NESTING: 
                case UNFILLED: {
                    return "stealth'";
                }
                case COMPOSITE: {
                    return "diamond";
                }
                case DOUBLE_LINE: {
                    return "";
                }
                case NONE: {
                    return "";
                }
                case SIMPLE: {
                    return "to";
                }
                case SUBTYPE: {
                    return "open triangle 60";
                }
            }
            throw new IllegalArgumentException("Default fall-thought in edge end shape! Did you add a new edge end shape?");
        }

        static void writeNodeShape(NodeShape nodeShape, List<StyleDuo> styles) {
            switch (nodeShape) {
                case DIAMOND: {
                    styles.add(new StyleDuo("shape", "diamond"));
                    styles.add(new StyleDuo("shape aspect", "2"));
                    break;
                }
                case ELLIPSE: {
                    styles.add(new StyleDuo("shape", "ellipse"));
                    break;
                }
                case OVAL: {
                    styles.add(new StyleDuo("shape", "rectangle"));
                    styles.add(new StyleDuo(TikzStylesExtractor.ROUNDED_CORNERS_KEY, "4pt"));
                    break;
                }
                case RECTANGLE: {
                    styles.add(new StyleDuo("shape", "rectangle"));
                    styles.add(new StyleDuo(TikzStylesExtractor.ROUNDED_CORNERS_KEY, "0pt"));
                    break;
                }
                case ROUNDED: {
                    styles.add(new StyleDuo("shape", "rectangle"));
                    styles.add(new StyleDuo(TikzStylesExtractor.ROUNDED_CORNERS_KEY, "1pt"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Default fall-thought in node shape! Did you add a new node shape?");
                }
            }
        }

        static String getColorString(Color color) {
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            return "{rgb,255:red," + r + ";" + "green," + g + ";" + "blue," + b + "}";
        }

        static String getColorStringDefinition(Color color) {
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            return "{" + r + "," + g + "," + b + "}";
        }
    }

    private static final class StyleDuo
    extends Duo<String> {
        public StyleDuo(String one, String two) {
            super(one, two);
        }

        @Override
        public String toString() {
            String one = (String)this.one();
            String two = (String)this.two();
            if (two == null) {
                return one;
            }
            return String.format("%s=%s", one, two);
        }
    }
}

