/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.util;

import groove.grammar.aspect.AspectKind;
import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.GraphInfo;
import groove.graph.Node;
import groove.gui.jgraph.AspectJVertex;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JModel;
import groove.gui.jgraph.JVertex;
import groove.gui.layout.JCellLayout;
import groove.gui.layout.JEdgeLayout;
import groove.gui.layout.JVertexLayout;
import groove.gui.layout.LayoutMap;
import groove.gui.look.Look;
import groove.gui.look.MultiLabel;
import groove.io.external.util.TeXLineFormat;
import groove.io.external.util.TikzStylesExtractor;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.jgraph.util.Bezier;

public final class GraphToTikz<G extends Graph> {
    private final JGraph<G> jGraph;
    private final JModel<G> model;
    private final Graph graph;
    private final LayoutMap layoutMap;
    private final StringBuilder result;
    private static final String ENTER = "\n";
    private static final String BEGIN_TIKZ_FIG = "\\begin{tikzpicture}[scale=\\tikzscale]";
    private static final String END_TIKZ_FIG = "\\end{tikzpicture}";
    private static final String BEGIN_NODE = "\\node";
    private static final String AT_KEYWORD = "at";
    private static final String BEGIN_NODE_LAB = " {\\ml{";
    private static final String END_NODE_LAB = "}};\n";
    private static final String BEGIN_EDGE_LAB = " {\\ml{";
    private static final String END_EDGE_LAB = "}}";
    private static final String EMPTY_NODE_LAB = "{};\n";
    private static final String BEGIN_EDGE = "\\path";
    private static final String END_PATH = "\n";
    private static final String END_EDGE = ";\n";
    private static final String NODE = "node[lab]";
    private static final String PAR_NODE_SUFFIX = "p";
    private static final String PAR_NODE_STYLE = "par_node";
    private static final String DOUBLE_DASH = "--";
    private static final String ANGLE = "-|";
    private static final String BEGIN_CONTROLS = ".. controls ";
    private static final String END_CONTROLS = " .. ";
    private static final String AND = " and ";
    private static final String NORTH = ".north -| ";
    private static final String SOUTH = ".south -| ";
    private static final String EAST = ".east |- ";
    private static final String WEST = ".west |- ";
    private static final String NORTH_WEST = ".north west";
    private static final String DOC = "% To use this figure in your LaTeX document\n% import the package groove/resources/groove2tikz.sty\n%\n";

    private GraphToTikz(JGraph<G> jGraph) {
        this.jGraph = jGraph;
        this.model = this.jGraph.getModel();
        this.graph = this.model.getGraph();
        this.layoutMap = GraphInfo.getLayoutMap(this.graph);
        this.result = new StringBuilder();
    }

    public static <N extends Node, E extends Edge> void export(JGraph<?> graph, PrintWriter writer) {
        writer.print(GraphToTikz.convert(graph));
    }

    public static <G extends Graph> String convert(JGraph<G> jGraph) {
        return super.doConvert();
    }

    private static String enclose(String string, String start, String end) {
        return String.valueOf(start) + string + end;
    }

    private static String enclosePar(String string) {
        return GraphToTikz.enclose(string, "(", ")");
    }

    private static String encloseBrack(String string) {
        return GraphToTikz.enclose(string, "[", "]");
    }

    private static String encloseCurly(String string) {
        return GraphToTikz.enclose(string, "{", "}");
    }

    private static String encloseSpace(String string) {
        return GraphToTikz.enclose(string, " ", " ");
    }

    private static int getSide(Rectangle2D bounds, Point2D point) {
        double x = point.getX();
        double y = point.getY();
        double ulx = bounds.getX();
        double uly = bounds.getY();
        double brx = bounds.getMaxX();
        double bry = bounds.getMaxY();
        double scale = 0.1;
        double dx = bounds.getWidth() * scale / 2.0;
        double dy = bounds.getHeight() * scale / 2.0;
        double minX = ulx + dx;
        double minY = uly + dy;
        double maxX = brx - dx;
        double maxY = bry - dy;
        int side = 0;
        if (x >= brx && y >= minY && y <= maxY) {
            side = 1;
        } else if (y <= uly && x >= minX && x <= maxX) {
            side = 2;
        } else if (x <= ulx && y >= minY && y <= maxY) {
            side = 3;
        } else if (y >= bry && x >= minX && x <= maxX) {
            side = 4;
        }
        return side;
    }

    private static String getCoordString(int side) {
        String result;
        switch (side) {
            case 1: {
                result = EAST;
                break;
            }
            case 2: {
                result = NORTH;
                break;
            }
            case 3: {
                result = WEST;
                break;
            }
            case 4: {
                result = SOUTH;
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    private static Point2D convertRelativeLabelPositionToAbsolute(Point2D geometry, List<Point2D> points) {
        Point2D pt = points.get(0);
        if (pt != null) {
            double length = 0.0;
            int pointCount = points.size();
            double[] segments = new double[pointCount];
            int i = 1;
            while (i < pointCount) {
                Point2D tmp = points.get(i);
                if (tmp != null) {
                    double segment;
                    double dx = pt.getX() - tmp.getX();
                    double dy = pt.getY() - tmp.getY();
                    segments[i - 1] = segment = Math.sqrt(dx * dx + dy * dy);
                    length += segment;
                    pt = tmp;
                }
                ++i;
            }
            double x = geometry.getX() / 1000.0;
            double y = geometry.getY();
            double dist = x * length;
            length = 0.0;
            int index = 1;
            double segment = segments[0];
            while (dist > length + segment && index < pointCount - 1) {
                length += segment;
                segment = segments[index++];
            }
            double factor = (dist - length) / segment;
            Point2D p0 = points.get(index - 1);
            Point2D pe = points.get(index);
            if (p0 != null && pe != null) {
                double dx = pe.getX() - p0.getX();
                double dy = pe.getY() - p0.getY();
                double nx = dy / segment;
                double ny = dx / segment;
                x = p0.getX() + dx * factor - nx * y;
                y = p0.getY() + dy * factor + ny * y;
                return new Point2D.Double(x, y);
            }
        }
        return null;
    }

    private static boolean isNodifiedEdge(JVertex<?> node) {
        return node instanceof AspectJVertex && ((AspectJVertex)node).isNodeEdge();
    }

    private static boolean hasParameter(JVertex<?> node) {
        return node instanceof AspectJVertex ? ((AspectJVertex)node).getNode().hasParam() : false;
    }

    private static boolean hasNonEmptyLabel(JEdge<?> edge) {
        return !edge.getVisuals().getLabel().isEmptyLine();
    }

    private static AspectKind getAttributeKind(JVertex<?> node) {
        return node instanceof AspectJVertex ? ((AspectJVertex)node).getNode().getAttrKind() : AspectKind.DEFAULT;
    }

    private static boolean isProductNode(JVertex<?> node) {
        return GraphToTikz.getAttributeKind(node) == AspectKind.PRODUCT;
    }

    private void append(String string) {
        this.result.append(string);
    }

    private void append(StringBuilder sb) {
        this.result.append((CharSequence)sb);
    }

    private String doConvert() {
        JCellLayout layout;
        this.appendTikzHeader();
        for (Node node : this.graph.nodeSet()) {
            JVertex<G> vertex = this.model.getJCellForNode(node);
            this.model.synchroniseLayout(vertex);
            layout = null;
            if (this.layoutMap != null) {
                layout = this.layoutMap.getLayout(node);
            }
            this.appendTikzNode(vertex, (JVertexLayout)layout);
        }
        this.append("\n");
        HashSet<JCell<G>> hashSet = new HashSet<JCell<G>>();
        for (Edge edge : this.graph.edgeSet()) {
            JCell<G> jCell;
            layout = null;
            if (this.layoutMap != null) {
                layout = this.layoutMap.getLayout(edge);
            }
            if (hashSet.contains(jCell = this.model.getJCellForEdge(edge))) continue;
            this.appendTikzEdge(jCell, (JEdgeLayout)layout);
            hashSet.add(jCell);
        }
        this.appendTikzFooter();
        return this.result.toString();
    }

    private void appendTikzHeader() {
        this.append(DOC);
        this.append("\\begin{tikzpicture}[scale=\\tikzscale]\n");
    }

    private void appendTikzFooter() {
        this.append("\\end{tikzpicture}\n");
    }

    private void appendTikzNode(JVertex<G> node, JVertexLayout layout) {
        MultiLabel lines;
        if (!node.getVisuals().isVisible()) {
            return;
        }
        this.append(BEGIN_NODE);
        this.appendNodeStyles(node);
        this.appendNode(node);
        if (layout != null) {
            this.append("at ");
            this.appendPoint(this.getCenterPoint(layout.getBounds()));
        }
        if ((lines = node.getVisuals().getLabel()).isEmpty() || GraphToTikz.isNodifiedEdge(node)) {
            this.append(EMPTY_NODE_LAB);
        } else {
            this.append(" {\\ml{");
            this.append(lines.toString(TeXLineFormat.instance()));
            this.append(END_NODE_LAB);
        }
        if (GraphToTikz.hasParameter(node)) {
            this.appendParameterNode((AspectJVertex)node);
        }
    }

    private void appendParameterNode(AspectJVertex node) {
        String nodeId = node.getNode().toString();
        String nr = String.valueOf(node.getNode().getParamNr());
        this.append(BEGIN_NODE + GraphToTikz.encloseBrack(PAR_NODE_STYLE));
        this.append(GraphToTikz.encloseSpace(GraphToTikz.enclosePar(String.valueOf(nodeId) + PAR_NODE_SUFFIX)));
        this.append(GraphToTikz.encloseSpace(AT_KEYWORD));
        this.append(GraphToTikz.enclosePar(String.valueOf(nodeId) + NORTH_WEST));
        this.append(" " + GraphToTikz.encloseCurly(nr) + END_EDGE);
    }

    private void appendNodeStyles(JVertex<G> node) {
        ArrayList<String> styles = new ArrayList<String>();
        styles.add("");
        for (Look look : node.getLooks()) {
            if (TikzStylesExtractor.mainLooks.contains((Object)look)) {
                styles.set(0, String.valueOf(look.name().toLowerCase()) + "_node");
                continue;
            }
            styles.add(look.name().toLowerCase());
        }
        this.addAdditionalStyles(node, styles);
        this.append(styles.toString());
    }

    private void addAdditionalStyles(JVertex<G> node, List<String> styles) {
        Color color = node.getVisuals().getColor();
        if (color != null) {
            TikzStylesExtractor.Style.getForegroundColor(color, styles);
            TikzStylesExtractor.Style.getBackgroundColor(node.getVisuals().getBackground(), styles);
        }
    }

    private void addAdditionalStyles(JEdge<G> edge, List<String> styles) {
        Color color = edge.getVisuals().getColor();
        if (color != null) {
            TikzStylesExtractor.Style.getEdgeColor(color, styles);
        }
    }

    private void appendNode(JVertex<G> node) {
        this.append(GraphToTikz.encloseSpace(GraphToTikz.enclosePar(node.getNode().toString())));
    }

    private void appendNode(JVertex<G> node, Point2D point) {
        int side = this.getSide(node, point);
        if (side == 0 || GraphToTikz.isProductNode(node) || GraphToTikz.isNodifiedEdge(node)) {
            this.appendNode(node);
        } else {
            String coord = GraphToTikz.getCoordString(side);
            String nodeName = node.getNode().toString();
            this.append(GraphToTikz.enclosePar(String.valueOf(nodeName) + coord + this.getPointString(point, false)));
        }
    }

    private void appendPoint(List<Point2D> points, int i) {
        this.appendPoint(points.get(i));
    }

    private void appendPoint(Point2D point) {
        double x = point.getX();
        double y = point.getY();
        this.appendPoint(x, y, true, this.result);
    }

    private Point2D getCenterPoint(Rectangle2D bounds) {
        return new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
    }

    private void appendPoint(double x, double y, boolean usePar, StringBuilder s) {
        double scale = 100.0;
        double adjX = x / scale;
        double adjY = -1.0 * (y / scale);
        String format = "%5.3f, %5.3f";
        Formatter f = new Formatter();
        if (usePar) {
            format = GraphToTikz.enclosePar(format);
        }
        s.append(f.format(Locale.US, format, adjX, adjY).toString());
        f.close();
    }

    private String getPointString(Point2D point, boolean usePar) {
        double x = point.getX();
        double y = point.getY();
        StringBuilder s = new StringBuilder();
        this.appendPoint(x, y, usePar, s);
        return s.toString();
    }

    private int getSide(JVertex<G> vertex, Point2D point) {
        JVertexLayout layout;
        int side = 0;
        if (this.layoutMap != null && (layout = this.layoutMap.getLayout(vertex.getNode())) != null) {
            Rectangle2D bounds = layout.getBounds();
            side = GraphToTikz.getSide(bounds, point);
        }
        return side;
    }

    private void appendTikzEdge(JCell<G> cell, JEdgeLayout layout) {
        if (cell instanceof JEdge) {
            JEdge edge = (JEdge)cell;
            this.appendTikzEdge(edge, layout);
        }
    }

    private void appendTikzEdge(JEdge<G> edge, JEdgeLayout layout) {
        block8: {
            block7: {
                if (!edge.getVisuals().isVisible()) {
                    return;
                }
                this.append(BEGIN_EDGE);
                this.appendEdgeStyles(edge);
                if (layout == null) break block7;
                switch (layout.getLineStyle()) {
                    case ORTHOGONAL: {
                        this.appendOrthogonalLayout(edge, layout);
                        break block8;
                    }
                    case BEZIER: {
                        this.appendBezierLayout(edge, layout);
                        break block8;
                    }
                    case SPLINE: {
                        this.appendSplineLayout(edge, layout);
                        break block8;
                    }
                    case MANHATTAN: {
                        this.appendManhattanLayout(edge, layout);
                        break block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown line style!");
                    }
                }
            }
            this.appendDefaultLayout(edge);
        }
        this.append(END_EDGE);
    }

    private void appendEdgeStyles(JEdge<G> edge) {
        ArrayList<String> styles = new ArrayList<String>();
        styles.add("");
        for (Look look : edge.getLooks()) {
            if (TikzStylesExtractor.mainLooks.contains((Object)look)) {
                styles.set(0, String.valueOf(look.name().toLowerCase()) + "_edge");
                continue;
            }
            styles.add(look.name().toLowerCase());
        }
        this.addAdditionalStyles(edge, styles);
        this.append(styles.toString());
    }

    private void appendDefaultLayout(JEdge<G> edge) {
        JVertex<G> srcVertex = edge.getSourceVertex();
        JVertex<G> tgtVertex = edge.getTargetVertex();
        this.appendSourceNode(srcVertex, tgtVertex);
        this.append(GraphToTikz.encloseSpace(DOUBLE_DASH));
        this.appendEdgeLabelInPath(edge);
        this.appendTargetNode(srcVertex, tgtVertex);
    }

    private void appendOrthogonalLayout(JEdge<G> edge, JEdgeLayout layout, String connection) {
        JVertex<G> srcVertex = edge.getSourceVertex();
        JVertex<G> tgtVertex = edge.getTargetVertex();
        List<Point2D> points = layout.getPoints();
        if (points.size() == 2) {
            this.appendSourceNode(srcVertex, tgtVertex);
            this.append(GraphToTikz.encloseSpace(connection));
            this.appendTargetNode(srcVertex, tgtVertex);
        } else {
            int firstPoint = 1;
            int lastPoint = points.size() - 2;
            this.appendNode(srcVertex, points.get(firstPoint));
            this.append(GraphToTikz.encloseSpace(connection));
            int i = firstPoint;
            while (i <= lastPoint) {
                this.appendPoint(points, i);
                if (i == lastPoint && connection.equals(ANGLE) && this.isHorizontalOrVertical(points, i, tgtVertex)) {
                    this.append(GraphToTikz.encloseSpace(DOUBLE_DASH));
                } else {
                    this.append(GraphToTikz.encloseSpace(connection));
                }
                ++i;
            }
            this.appendNode(tgtVertex, points.get(lastPoint));
        }
        this.append("\n");
        this.appendEdgeLabel(edge, layout, points);
    }

    private void appendOrthogonalLayout(JEdge<G> edge, JEdgeLayout layout) {
        this.appendOrthogonalLayout(edge, layout, DOUBLE_DASH);
    }

    private void appendBezierLayout(JEdge<G> edge, JEdgeLayout layout) {
        JVertex<G> srcVertex = edge.getSourceVertex();
        JVertex<G> tgtVertex = edge.getTargetVertex();
        List<Point2D> points = layout.getPoints();
        Bezier bezier = new Bezier(points.toArray(new Point2D[points.size()]));
        Point2D[] bPoints = bezier.getPoints();
        if (bPoints == null) {
            this.appendDefaultLayout(edge);
            return;
        }
        if (points.size() <= 4) {
            boolean isLoop = srcVertex.getNode().equals(tgtVertex.getNode());
            this.appendNode(srcVertex);
            int i = 1;
            int j = 0;
            while (j < bPoints.length - 1) {
                this.append(BEGIN_CONTROLS);
                if (isLoop) {
                    if (i == points.size() - 1) {
                        this.appendPoint(points, i - 1);
                    } else {
                        this.appendPoint(bPoints[j]);
                    }
                    this.append(AND);
                    if (i == 1) {
                        this.appendPoint(points, i);
                    } else {
                        this.appendPoint(bPoints[j + 1]);
                    }
                } else {
                    this.appendPoint(bPoints[j]);
                    this.append(AND);
                    this.appendPoint(bPoints[j + 1]);
                }
                this.append(END_CONTROLS);
                if (points.size() > 3 && i < points.size() - 1) {
                    this.appendPoint(points, i);
                }
                ++i;
                ++j;
            }
            this.appendNode(tgtVertex);
        } else {
            this.appendNode(srcVertex);
            this.append(BEGIN_CONTROLS);
            this.appendPoint(bPoints[0]);
            this.append(END_CONTROLS);
            this.appendPoint(points, 1);
            int i = 2;
            while (i < points.size() - 1) {
                this.append(BEGIN_CONTROLS);
                this.appendPoint(bPoints[2 * i - 3]);
                this.append(AND);
                this.appendPoint(bPoints[2 * i - 2]);
                this.append(END_CONTROLS);
                this.appendPoint(points, i);
                ++i;
            }
            this.append(BEGIN_CONTROLS);
            this.appendPoint(bPoints[bPoints.length - 1]);
            this.append(END_CONTROLS);
            this.appendNode(tgtVertex);
        }
        this.append("\n");
        this.appendEdgeLabel(edge, layout, points);
    }

    private void appendSplineLayout(JEdge<G> edge, JEdgeLayout layout) {
        System.err.println("Sorry, the SPLINE line style is not yet supported, using BEZIER style...");
        this.appendBezierLayout(edge, layout);
    }

    private void appendManhattanLayout(JEdge<G> edge, JEdgeLayout layout) {
        this.appendOrthogonalLayout(edge, layout, ANGLE);
    }

    private void appendSourceNode(JVertex<G> srcNode, JVertex<G> tgtNode) {
        if (this.layoutMap != null) {
            JVertexLayout tgtLayout = this.layoutMap.getLayout(tgtNode.getNode());
            if (tgtLayout != null) {
                Rectangle2D tgtBounds = tgtLayout.getBounds();
                Point2D.Double tgtCenter = new Point2D.Double(tgtBounds.getCenterX(), tgtBounds.getCenterY());
                this.appendNode(srcNode, tgtCenter);
            }
        } else {
            this.appendNode(srcNode);
        }
    }

    private void appendTargetNode(JVertex<G> srcNode, JVertex<G> tgtNode) {
        if (this.layoutMap != null) {
            JVertexLayout srcLayout = this.layoutMap.getLayout(srcNode.getNode());
            JVertexLayout tgtLayout = this.layoutMap.getLayout(tgtNode.getNode());
            if (srcLayout != null && tgtLayout != null) {
                Rectangle2D tgtBounds = tgtLayout.getBounds();
                Point2D.Double tgtCenter = new Point2D.Double(tgtBounds.getCenterX(), tgtBounds.getCenterY());
                int side = this.getSide(srcNode, tgtCenter);
                if (side == 0) {
                    Rectangle2D srcBounds = srcLayout.getBounds();
                    Point2D.Double srcCenter = new Point2D.Double(srcBounds.getCenterX(), srcBounds.getCenterY());
                    this.appendNode(tgtNode, srcCenter);
                } else {
                    this.appendNode(tgtNode);
                }
            }
        } else {
            this.appendNode(tgtNode);
        }
    }

    private void appendEdgeLabelInPath(JEdge<G> edge) {
        if (GraphToTikz.hasNonEmptyLabel(edge)) {
            this.append(NODE);
            this.appendEdgeLabel(edge);
        }
    }

    private void appendEdgeLabel(JEdge<G> edge) {
        if (GraphToTikz.hasNonEmptyLabel(edge)) {
            StringBuilder text;
            MultiLabel lines = edge.getVisuals().getLabel();
            List<Point2D> points = edge.getVisuals().getPoints();
            if (this.jGraph.isShowArrowsOnLabels()) {
                Point2D start = points.get(0);
                Point2D end = points.get(points.size() - 1);
                text = lines.toString(TeXLineFormat.instance(), start, end);
            } else {
                text = lines.toString(TeXLineFormat.instance());
            }
            this.append(" {\\ml{");
            this.append(text);
            this.append(END_EDGE_LAB);
        }
    }

    private void appendEdgeLabel(JEdge<G> edge, JEdgeLayout layout, List<Point2D> points) {
        if (GraphToTikz.hasNonEmptyLabel(edge)) {
            Point2D labelPos = GraphToTikz.convertRelativeLabelPositionToAbsolute(layout.getLabelPosition(), points);
            this.append(NODE);
            this.append(GraphToTikz.encloseSpace(AT_KEYWORD));
            this.appendPoint(labelPos);
            this.appendEdgeLabel(edge);
        }
    }

    private boolean isHorizontalOrVertical(List<Point2D> points, int index, JVertex<G> tgtVertex) {
        JVertexLayout layout;
        boolean result = false;
        if (this.layoutMap != null && (layout = this.layoutMap.getLayout(tgtVertex.getNode())) != null) {
            Rectangle2D tgtBounds = layout.getBounds();
            if (points.get(index).getY() == points.get(index + 1).getY() || GraphToTikz.getSide(tgtBounds, points.get(index)) != 0) {
                result = true;
            }
        }
        return result;
    }
}

