/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.gxl;

import de.gupro.gxl.gxl_1_0.BagType;
import de.gupro.gxl.gxl_1_0.EdgeType;
import de.gupro.gxl.gxl_1_0.GraphType;
import de.gupro.gxl.gxl_1_0.NodeType;
import de.gupro.gxl.gxl_1_0.SeqType;
import de.gupro.gxl.gxl_1_0.SetType;
import de.gupro.gxl.gxl_1_0.TupType;
import de.gupro.gxl.gxl_1_0.TypedElementType;
import groove.io.conceptual.Acceptor;
import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.Name;
import groove.io.conceptual.Timer;
import groove.io.conceptual.lang.InstanceExporter;
import groove.io.conceptual.lang.gxl.GxlResource;
import groove.io.conceptual.lang.gxl.GxlUtil;
import groove.io.conceptual.lang.gxl.TypeToGxl;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.value.BoolValue;
import groove.io.conceptual.value.ContainerValue;
import groove.io.conceptual.value.CustomDataValue;
import groove.io.conceptual.value.EnumValue;
import groove.io.conceptual.value.IntValue;
import groove.io.conceptual.value.RealValue;
import groove.io.conceptual.value.StringValue;
import groove.io.conceptual.value.TupleValue;
import groove.io.conceptual.value.Value;
import groove.io.external.PortException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBElement;

public class InstanceToGxl
extends InstanceExporter<Object> {
    private TypeToGxl m_typeToGxl;
    private GxlResource m_gxlResource;
    private GraphType m_instanceGraph;
    private int m_nextNode = 1;

    public InstanceToGxl(TypeToGxl typeToGxl) {
        this.m_typeToGxl = typeToGxl;
        this.m_gxlResource = (GxlResource)this.m_typeToGxl.getResource();
    }

    @Override
    public void addInstanceModel(InstanceModel instanceModel) throws PortException {
        this.m_instanceGraph = this.m_gxlResource.getInstanceGraph("graph_" + instanceModel.getTypeModel().getName(), instanceModel.getName());
        int timer = Timer.start("IM to GXL");
        this.visitInstanceModel(instanceModel);
        Timer.stop(timer);
    }

    @Override
    public void visit(groove.io.conceptual.value.Object object, Object param) {
        if (this.hasElement(object)) {
            return;
        }
        Class cmClass = (Class)object.getType();
        String classNodeId = this.m_typeToGxl.getId(cmClass);
        String id = object.getName();
        if (id == null) {
            id = this.getNodeId();
        }
        NodeType objectNode = this.createNode(id, "#" + classNodeId, cmClass.getId().getNamespace());
        this.setElement(object, objectNode);
        for (Map.Entry fieldEntry : object.getValue().entrySet()) {
            Value fieldValue = (Value)fieldEntry.getValue();
            if (fieldValue == null || fieldValue == groove.io.conceptual.value.Object.NIL) continue;
            if (this.m_typeToGxl.isAttribute((Field)fieldEntry.getKey())) {
                JAXBElement attrObject = (JAXBElement)this.getElement(fieldValue);
                GxlUtil.setAttribute((TypedElementType)objectNode, ((Field)fieldEntry.getKey()).getName().toString(), attrObject.getValue(), GxlUtil.AttrTypeEnum.AUTO);
                continue;
            }
            String fieldEdgeId = "#" + this.m_typeToGxl.getId((Field)fieldEntry.getKey());
            if (fieldValue instanceof ContainerValue) {
                ContainerValue cv = (ContainerValue)fieldValue;
                boolean isordered = ((Container)cv.getType()).getContainerType() == Container.Kind.ORD || ((Container)cv.getType()).getContainerType() == Container.Kind.SEQ;
                int index = 0;
                Iterator iterator = cv.getValue().iterator();
                while (iterator.hasNext()) {
                    Value subValue = (Value)iterator.next();
                    NodeType valueNode = (NodeType)this.getElement(subValue);
                    EdgeType edge = this.createEdge(objectNode, valueNode, fieldEdgeId);
                    if (!isordered) continue;
                    edge.setToorder(BigInteger.valueOf(index++));
                }
                continue;
            }
            NodeType valueNode = (NodeType)this.getElement(fieldValue);
            this.createEdge(objectNode, valueNode, fieldEdgeId);
        }
    }

    @Override
    public void visit(RealValue realval, Object param) {
        if (this.hasElement(realval)) {
            return;
        }
        JAXBElement floatElem = GxlUtil.g_objectFactory.createFloat(new Float(realval.getValue()));
        this.setElement(realval, floatElem);
    }

    @Override
    public void visit(StringValue stringval, Object param) {
        if (this.hasElement(stringval)) {
            return;
        }
        JAXBElement stringElem = GxlUtil.g_objectFactory.createString(stringval.getValue());
        this.setElement(stringval, stringElem);
    }

    @Override
    public void visit(IntValue intval, Object param) {
        if (this.hasElement(intval)) {
            return;
        }
        JAXBElement intElem = GxlUtil.g_objectFactory.createInt(intval.getValue());
        this.setElement(intval, intElem);
    }

    @Override
    public void visit(BoolValue boolval, Object param) {
        if (this.hasElement(boolval)) {
            return;
        }
        JAXBElement boolElem = GxlUtil.g_objectFactory.createBool(new Boolean(boolval.getValue()));
        this.setElement(boolval, boolElem);
    }

    @Override
    public void visit(EnumValue enumval, Object param) {
        if (this.hasElement(enumval)) {
            return;
        }
        JAXBElement enumElem = GxlUtil.g_objectFactory.createEnum(enumval.getValue().toString());
        this.setElement(enumval, enumElem);
    }

    @Override
    public void visit(ContainerValue containerval, Object param) {
        if (this.hasElement(containerval)) {
            return;
        }
        SetType cntType = null;
        JAXBElement cntElem = null;
        switch (((Container)containerval.getType()).getContainerType()) {
            case SET: {
                cntType = GxlUtil.g_objectFactory.createSetType();
                cntElem = GxlUtil.g_objectFactory.createSet(cntType);
                break;
            }
            case BAG: {
                cntType = GxlUtil.g_objectFactory.createBagType();
                cntElem = GxlUtil.g_objectFactory.createBag((BagType)cntType);
                break;
            }
            case SEQ: 
            case ORD: {
                cntType = GxlUtil.g_objectFactory.createSeqType();
                cntElem = GxlUtil.g_objectFactory.createSeq((SeqType)cntType);
            }
        }
        this.setElement(containerval, cntElem);
        Iterator iterator = containerval.getValue().iterator();
        while (iterator.hasNext()) {
            Value subVal = (Value)iterator.next();
            JAXBElement cntValue = (JAXBElement)this.getElement(subVal);
            cntType.getBagOrSetOrSeq().add(cntValue);
        }
    }

    @Override
    public void visit(TupleValue tupleval, Object param) {
        if (this.hasElement(tupleval)) {
            return;
        }
        if (this.m_typeToGxl.isAttribute(tupleval.getType())) {
            TupType tupType = GxlUtil.g_objectFactory.createTupType();
            JAXBElement tupElem = GxlUtil.g_objectFactory.createTup(tupType);
            this.setElement(tupleval, tupElem);
            for (Map.Entry entry : tupleval.getValue().entrySet()) {
                JAXBElement tupValue = (JAXBElement)this.getElement((Acceptor)entry.getValue());
                tupType.getBagOrSetOrSeq().add(tupValue);
            }
        } else {
            Class cmClass = this.m_typeToGxl.getTupleClass((Tuple)tupleval.getType());
            groove.io.conceptual.value.Object o = new groove.io.conceptual.value.Object(cmClass, null);
            for (Map.Entry entry : tupleval.getValue().entrySet()) {
                o.setFieldValue(cmClass.getField(Name.getName("_" + entry.getKey())), (Value)entry.getValue());
            }
            this.setElement(tupleval, this.getElement(o));
        }
    }

    @Override
    public void visit(CustomDataValue dataval, Object param) {
        if (this.hasElement(dataval)) {
            return;
        }
        JAXBElement stringElem = GxlUtil.g_objectFactory.createString(dataval.getValue());
        this.setElement(dataval, stringElem);
    }

    private NodeType createNode(String id, String type, Id packageId) {
        NodeType newNode = new NodeType();
        newNode.setId(id);
        if (type != null) {
            GxlUtil.setElemType((TypedElementType)newNode, String.valueOf(this.m_gxlResource.getTypePath()) + type);
        }
        this.m_instanceGraph.getNodeOrEdgeOrRel().add(newNode);
        return newNode;
    }

    private EdgeType createEdge(NodeType from, NodeType to, String type) {
        EdgeType newEdge = new EdgeType();
        newEdge.setFrom((Object)from);
        newEdge.setTo((Object)to);
        if (type != null) {
            GxlUtil.setElemType((TypedElementType)newEdge, type);
        }
        this.m_instanceGraph.getNodeOrEdgeOrRel().add(newEdge);
        return newEdge;
    }

    private String getNodeId() {
        return "n" + this.m_nextNode++;
    }
}

