/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.gxl;

import de.gupro.gxl.gxl_1_0.AttrType;
import de.gupro.gxl.gxl_1_0.BagType;
import de.gupro.gxl.gxl_1_0.CompositeValueType;
import de.gupro.gxl.gxl_1_0.EdgeType;
import de.gupro.gxl.gxl_1_0.GraphElementType;
import de.gupro.gxl.gxl_1_0.GraphType;
import de.gupro.gxl.gxl_1_0.GxlType;
import de.gupro.gxl.gxl_1_0.LocatorType;
import de.gupro.gxl.gxl_1_0.NodeType;
import de.gupro.gxl.gxl_1_0.ObjectFactory;
import de.gupro.gxl.gxl_1_0.SeqType;
import de.gupro.gxl.gxl_1_0.SetType;
import de.gupro.gxl.gxl_1_0.TupType;
import de.gupro.gxl.gxl_1_0.TypeType;
import de.gupro.gxl.gxl_1_0.TypedElementType;
import groove.io.conceptual.type.BoolType;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.type.IntType;
import groove.io.conceptual.type.RealType;
import groove.io.conceptual.type.StringType;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.type.Type;
import groove.io.conceptual.value.BoolValue;
import groove.io.conceptual.value.ContainerValue;
import groove.io.conceptual.value.CustomDataValue;
import groove.io.conceptual.value.EnumValue;
import groove.io.conceptual.value.IntValue;
import groove.io.conceptual.value.RealValue;
import groove.io.conceptual.value.StringValue;
import groove.io.conceptual.value.TupleValue;
import groove.io.conceptual.value.Value;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;

public class GxlUtil {
    public static String g_gxlTypeGraphURI = "http://www.gupro.de/GXL/gxl-1.0.gxl";
    public static final JAXBContext g_context;
    public static final Marshaller g_marshaller;
    public static final Unmarshaller g_unmarshaller;
    public static final ObjectFactory g_objectFactory;

    static {
        try {
            g_context = JAXBContext.newInstance((String)GxlType.class.getPackage().getName());
            g_marshaller = g_context.createMarshaller();
            g_marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            g_unmarshaller = g_context.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        g_objectFactory = new ObjectFactory();
    }

    public static String getElemType(TypedElementType elem) {
        String type = null;
        Map attrMap = elem.getType().getOtherAttributes();
        for (QName attr : attrMap.keySet()) {
            String fullType;
            if (!attr.getPrefix().equals("xlink") || !attr.getLocalPart().equals("href")) continue;
            if (((String)attrMap.get(attr)).startsWith(g_gxlTypeGraphURI)) {
                fullType = (String)attrMap.get(attr);
                if (!fullType.startsWith(String.valueOf(g_gxlTypeGraphURI) + "#")) continue;
                type = fullType.substring(g_gxlTypeGraphURI.length() + 1);
                break;
            }
            if (((String)attrMap.get(attr)).startsWith("#")) {
                fullType = (String)attrMap.get(attr);
                type = fullType.substring(1);
                break;
            }
            fullType = (String)attrMap.get(attr);
            if (fullType.indexOf("#") == -1) continue;
            type = fullType.substring(fullType.indexOf("#") + 1);
        }
        return type;
    }

    public static void setElemType(TypedElementType elem, String type) {
        TypeType typeType = new TypeType();
        Map attrMap = typeType.getOtherAttributes();
        attrMap.put(new QName("http://www.w3.org/1999/xlink", "href", "xlink"), type);
        elem.setType(typeType);
    }

    public static Map<NodeType, NodeWrapper> wrapGraph(GraphType graph) {
        HashMap<NodeType, NodeWrapper> nodes = new HashMap<NodeType, NodeWrapper>();
        HashMap<EdgeType, EdgeWrapper> edges = new HashMap<EdgeType, EdgeWrapper>();
        for (GraphElementType elem : graph.getNodeOrEdgeOrRel()) {
            if (elem instanceof NodeType) {
                GxlUtil.getWrapper(nodes, (NodeType)elem);
                continue;
            }
            if (!(elem instanceof EdgeType)) continue;
            GxlUtil.getWrapper(nodes, edges, (EdgeType)elem);
        }
        return nodes;
    }

    private static NodeWrapper getWrapper(Map<NodeType, NodeWrapper> nodes, NodeType node) {
        if (nodes.containsKey(node)) {
            return nodes.get(node);
        }
        NodeWrapper nw = new NodeWrapper(node);
        nodes.put(node, nw);
        return nw;
    }

    private static EdgeWrapper getWrapper(Map<NodeType, NodeWrapper> nodes, Map<EdgeType, EdgeWrapper> edges, EdgeType edge) {
        if (edges.containsKey(edge)) {
            return edges.get(edge);
        }
        EdgeWrapper ew = new EdgeWrapper(edge);
        edges.put(edge, ew);
        if (edge.getFrom() instanceof NodeType) {
            NodeType source = (NodeType)edge.getFrom();
            NodeType target = (NodeType)edge.getTo();
            NodeWrapper sourceWrapper = GxlUtil.getWrapper(nodes, source);
            NodeWrapper targetWrapper = GxlUtil.getWrapper(nodes, target);
            ew.setWrapper(sourceWrapper, targetWrapper);
            sourceWrapper.addEdge(ew);
            targetWrapper.addIncomingEdge(ew);
        } else if (edge.getFrom() instanceof EdgeType) {
            EdgeType source = (EdgeType)edge.getFrom();
            EdgeType target = (EdgeType)edge.getTo();
            EdgeWrapper sourceWrapper = GxlUtil.getWrapper(nodes, edges, source);
            EdgeWrapper targetWrapper = GxlUtil.getWrapper(nodes, edges, target);
            ew.setWrapper(sourceWrapper, targetWrapper);
            sourceWrapper.addEdge(ew);
            targetWrapper.addIncomingEdge(ew);
        }
        return ew;
    }

    public static Object getAttribute(TypedElementType elem, String name, AttrTypeEnum type) {
        List attrs = elem.getAttr();
        Object value = null;
        for (AttrType attr : attrs) {
            if (!name.equals(attr.getName())) continue;
            if (type == AttrTypeEnum.AUTO) {
                if (attr.getString() != null) {
                    type = AttrTypeEnum.STRING;
                } else if (attr.isBool() != null) {
                    type = AttrTypeEnum.BOOL;
                } else if (attr.getInt() != null) {
                    type = AttrTypeEnum.INT;
                } else if (attr.getFloat() != null) {
                    type = AttrTypeEnum.FLOAT;
                } else if (attr.getLocator() != null) {
                    type = AttrTypeEnum.LOCATOR;
                } else if (attr.getEnum() != null) {
                    type = AttrTypeEnum.ENUM;
                } else if (attr.getBag() != null) {
                    type = AttrTypeEnum.BAG;
                } else if (attr.getSet() != null) {
                    type = AttrTypeEnum.SET;
                } else if (attr.getSeq() != null) {
                    type = AttrTypeEnum.SEQ;
                } else if (attr.getTup() != null) {
                    type = AttrTypeEnum.TUP;
                }
            }
            switch (type) {
                case STRING: {
                    value = attr.getString();
                    return value;
                }
                case BOOL: {
                    value = attr.isBool();
                    return value;
                }
                case INT: {
                    value = attr.getInt();
                    return value;
                }
                case FLOAT: {
                    value = attr.getFloat();
                    return value;
                }
                case LOCATOR: {
                    value = attr.getLocator();
                    return value;
                }
                case ENUM: {
                    value = attr.getEnum();
                    return value;
                }
                case BAG: {
                    value = attr.getBag();
                    return value;
                }
                case SET: {
                    value = attr.getSet();
                    return value;
                }
                case SEQ: {
                    value = attr.getSeq();
                    return value;
                }
                case TUP: {
                    value = attr.getTup();
                    return value;
                }
            }
        }
        return null;
    }

    public static void setAttribute(TypedElementType elem, String name, Object value, AttrTypeEnum type) {
        List attrs = elem.getAttr();
        AttrType attr = null;
        for (AttrType curAttr : attrs) {
            if (!curAttr.getName().equals(name)) continue;
            attr = curAttr;
            break;
        }
        if (attr == null) {
            attr = new AttrType();
            attrs.add(attr);
        }
        if (type == AttrTypeEnum.AUTO) {
            if (value instanceof String) {
                type = AttrTypeEnum.STRING;
            } else if (value instanceof Boolean) {
                type = AttrTypeEnum.BOOL;
            } else if (value instanceof BigInteger) {
                type = AttrTypeEnum.INT;
            } else if (value instanceof Float) {
                type = AttrTypeEnum.FLOAT;
            } else if (value instanceof LocatorType) {
                type = AttrTypeEnum.LOCATOR;
            } else if (value instanceof BagType) {
                type = AttrTypeEnum.BAG;
            } else if (value instanceof SetType) {
                type = AttrTypeEnum.SET;
            } else if (value instanceof SeqType) {
                type = AttrTypeEnum.SEQ;
            } else if (value instanceof TupType) {
                type = AttrTypeEnum.TUP;
            }
        }
        attr.setName(name);
        switch (type) {
            case STRING: {
                attr.setString((String)value);
                return;
            }
            case BOOL: {
                attr.setBool((Boolean)value);
                return;
            }
            case INT: {
                attr.setInt((BigInteger)value);
                return;
            }
            case FLOAT: {
                attr.setFloat((Float)value);
                return;
            }
            case LOCATOR: {
                attr.setLocator((LocatorType)value);
                return;
            }
            case ENUM: {
                attr.setEnum((String)value);
                return;
            }
            case BAG: {
                attr.setBag((BagType)value);
                return;
            }
            case SET: {
                attr.setSet((SetType)value);
                return;
            }
            case SEQ: {
                attr.setSeq((SeqType)value);
                return;
            }
            case TUP: {
                attr.setTup((TupType)value);
                return;
            }
        }
    }

    public static Object getAttrObject(AttrType attr) {
        if (attr.isBool() != null) {
            return attr.isBool();
        }
        if (attr.getInt() != null) {
            return attr.getInt();
        }
        if (attr.getFloat() != null) {
            return attr.getFloat();
        }
        if (attr.getString() != null) {
            return attr.getString();
        }
        if (attr.getLocator() != null) {
            return attr.getLocator();
        }
        if (attr.getSet() != null) {
            return attr.getSet();
        }
        if (attr.getBag() != null) {
            return attr.getBag();
        }
        if (attr.getSeq() != null) {
            return attr.getSeq();
        }
        if (attr.getTup() != null) {
            return attr.getTup();
        }
        if (attr.getEnum() != null) {
            return attr.getEnum();
        }
        return null;
    }

    public static Value getTypedAttrValue(AttrType attr, Type type) {
        Object o = GxlUtil.getAttrObject(attr);
        if (o == null) {
            return null;
        }
        JAXBElement elem = new JAXBElement(new QName("attr"), o.getClass(), o);
        return GxlUtil.getTypedValue(elem, type);
    }

    public static Value getTypedValue(JAXBElement<?> elem, Type type) {
        Object o = elem.getValue();
        if (type instanceof DataType) {
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            if (type instanceof IntType && o instanceof BigInteger) {
                return new IntValue(((BigInteger)o).intValue());
            }
            if (type instanceof RealType && o instanceof Float) {
                return new RealValue(((Float)o).floatValue());
            }
            if (type instanceof BoolType && o instanceof Boolean) {
                return BoolValue.getInstance((Boolean)o);
            }
            if (type instanceof StringType && o instanceof String) {
                return new StringValue((String)o);
            }
            if (type instanceof StringType && o instanceof LocatorType) {
                return new StringValue(((LocatorType)o).toString());
            }
            return null;
        }
        if (type instanceof Container) {
            Container ct = (Container)type;
            ContainerValue cv = new ContainerValue(ct);
            switch (ct.getContainerType()) {
                case BAG: {
                    if (o instanceof BagType) break;
                    return null;
                }
                case SET: {
                    if (o instanceof SetType) break;
                    return null;
                }
                case SEQ: {
                    if (o instanceof SeqType) break;
                    return null;
                }
                case ORD: {
                    throw new IllegalArgumentException("ORD not supported as GXL import type");
                }
            }
            CompositeValueType gxlContainer = (CompositeValueType)o;
            List elems = gxlContainer.getBagOrSetOrSeq();
            for (JAXBElement subElem : elems) {
                Value v = GxlUtil.getTypedValue(subElem, ct.getType());
                if (v == null) {
                    return null;
                }
                cv.addValue(v);
            }
            return cv;
        }
        if (type instanceof Tuple) {
            Tuple tup = (Tuple)type;
            if (!(o instanceof TupType)) {
                return null;
            }
            List elems = ((TupType)o).getBagOrSetOrSeq();
            if (elems.size() != tup.getTypes().size()) {
                return null;
            }
            ArrayList<Value> values = new ArrayList<Value>();
            int i = 0;
            for (JAXBElement subElem : elems) {
                Value v = GxlUtil.getTypedValue(subElem, tup.getTypes().get(i++));
                if (v == null) {
                    return null;
                }
                values.add(v);
            }
            TupleValue tv = new TupleValue(tup, values.toArray(new Value[values.size()]));
            return tv;
        }
        return null;
    }

    public static JAXBElement<?> valueToGxl(Value val) {
        if (val instanceof BoolValue) {
            return g_objectFactory.createBool(((BoolValue)val).getValue());
        }
        if (val instanceof IntValue) {
            return g_objectFactory.createInt(((IntValue)val).getValue());
        }
        if (val instanceof StringValue) {
            return g_objectFactory.createString(((StringValue)val).getValue());
        }
        if (val instanceof RealValue) {
            return g_objectFactory.createFloat(new Float(((RealValue)val).getValue()));
        }
        if (val instanceof EnumValue) {
            return g_objectFactory.createEnum(((EnumValue)val).getValue().toString());
        }
        if (val instanceof CustomDataValue) {
            return g_objectFactory.createString(((CustomDataValue)val).getValue());
        }
        if (val instanceof ContainerValue) {
            ContainerValue cv = (ContainerValue)val;
            SetType cvt = null;
            JAXBElement elem = null;
            switch (((Container)cv.getType()).getContainerType()) {
                case SET: {
                    cvt = g_objectFactory.createSetType();
                    elem = g_objectFactory.createSet(cvt);
                    break;
                }
                case BAG: {
                    cvt = g_objectFactory.createBagType();
                    elem = g_objectFactory.createBag((BagType)cvt);
                    break;
                }
                case SEQ: 
                case ORD: {
                    cvt = g_objectFactory.createSeqType();
                    elem = g_objectFactory.createSeq((SeqType)cvt);
                }
            }
            Iterator iterator = cv.getValue().iterator();
            while (iterator.hasNext()) {
                Value subVal = (Value)iterator.next();
                cvt.getBagOrSetOrSeq().add(GxlUtil.valueToGxl(subVal));
            }
            return elem;
        }
        if (val instanceof TupleValue) {
            TupType tup = new TupType();
            JAXBElement tupElem = g_objectFactory.createTup(tup);
            for (Map.Entry tupEntry : ((TupleValue)val).getValue().entrySet()) {
                tup.getBagOrSetOrSeq().add(GxlUtil.valueToGxl((Value)tupEntry.getValue()));
            }
            return tupElem;
        }
        return null;
    }

    public static enum AttrTypeEnum {
        STRING,
        BOOL,
        INT,
        FLOAT,
        LOCATOR,
        ENUM,
        BAG,
        SET,
        SEQ,
        TUP,
        AUTO;

    }

    public static class EdgeWrapper {
        private EdgeType m_edge;
        private String m_type;
        private NodeWrapper m_nodeFrom;
        private NodeWrapper m_nodeTo;
        private EdgeWrapper m_edgeFrom;
        private EdgeWrapper m_edgeTo;
        private List<EdgeWrapper> m_edges = new ArrayList<EdgeWrapper>();
        private List<EdgeWrapper> m_incomingEdges = new ArrayList<EdgeWrapper>();
        private boolean m_nodeEdge;

        public EdgeWrapper(EdgeType edge) {
            this.m_edge = edge;
            this.m_type = GxlUtil.getElemType((TypedElementType)edge);
            assert (this.m_type != null);
        }

        public EdgeType getEdge() {
            return this.m_edge;
        }

        public void setWrapper(NodeWrapper nodeFrom, NodeWrapper nodeTo) {
            this.m_nodeFrom = nodeFrom;
            this.m_nodeTo = nodeTo;
            this.m_nodeEdge = true;
        }

        public void setWrapper(EdgeWrapper edgeFrom, EdgeWrapper edgeTo) {
            this.m_edgeFrom = edgeFrom;
            this.m_edgeTo = edgeTo;
            this.m_nodeEdge = false;
        }

        public NodeWrapper getSource() {
            return this.m_nodeFrom;
        }

        public NodeWrapper getTarget() {
            return this.m_nodeTo;
        }

        public EdgeWrapper getSourceEdge() {
            return this.m_edgeFrom;
        }

        public EdgeWrapper getTargetEdge() {
            return this.m_edgeTo;
        }

        public List<EdgeWrapper> getEdges() {
            return this.m_edges;
        }

        public List<EdgeWrapper> getIncomingEdges() {
            return this.m_incomingEdges;
        }

        protected void addEdge(EdgeWrapper edge) {
            assert (edge.getSourceEdge() == this);
            this.m_edges.add(edge);
        }

        protected void addIncomingEdge(EdgeWrapper edge) {
            assert (edge.getTargetEdge() == this);
            this.m_incomingEdges.add(edge);
        }

        public String getType() {
            return this.m_type;
        }

        public boolean connectsNodes() {
            return this.m_nodeEdge;
        }
    }

    public static class GraphWrapper {
        private GraphType m_graph;
        private String m_type;
        private Set<NodeWrapper> m_nodes = new HashSet<NodeWrapper>();

        public GraphWrapper(GraphType graph) {
            this.m_graph = graph;
            this.m_type = GxlUtil.getElemType((TypedElementType)graph);
            assert (this.m_type != null);
        }

        protected void addNode(NodeWrapper node) {
            this.m_nodes.add(node);
        }

        public GraphType getGraph() {
            return this.m_graph;
        }

        public String getType() {
            return this.m_type;
        }

        public Set<NodeWrapper> getNodes() {
            return this.m_nodes;
        }
    }

    public static class NodeWrapper {
        private NodeType m_node;
        private String m_type;
        private List<EdgeWrapper> m_edges = new ArrayList<EdgeWrapper>();
        private List<EdgeWrapper> m_incomingEdges = new ArrayList<EdgeWrapper>();

        public NodeWrapper(NodeType node) {
            this.m_node = node;
            this.m_type = GxlUtil.getElemType((TypedElementType)node);
            assert (this.m_type != null);
        }

        protected void addEdge(EdgeWrapper edge) {
            assert (edge.getSource() == this);
            this.m_edges.add(edge);
        }

        protected void addIncomingEdge(EdgeWrapper edge) {
            assert (edge.getTarget() == this);
            this.m_incomingEdges.add(edge);
        }

        public NodeType getNode() {
            return this.m_node;
        }

        public List<EdgeWrapper> getEdges() {
            return this.m_edges;
        }

        public List<EdgeWrapper> getIncomingEdges() {
            return this.m_incomingEdges;
        }

        public String getType() {
            return this.m_type;
        }

        public void sortEdges() {
            Collections.sort(this.m_edges, new Comparator<EdgeWrapper>(){

                @Override
                public int compare(EdgeWrapper ew1, EdgeWrapper ew2) {
                    int stringCompare = ew1.getType().compareTo(ew2.getType());
                    if (stringCompare == 0) {
                        BigInteger eo1 = ew1.getEdge().getToorder();
                        BigInteger eo2 = ew2.getEdge().getToorder();
                        if (eo1 == null || eo2 == null) {
                            if (eo1 == null) {
                                return eo2 == null ? 0 : 1;
                            }
                            return -1;
                        }
                        return eo1.compareTo(eo2);
                    }
                    return stringCompare;
                }
            });
        }
    }
}

