/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.gxl;

import de.gupro.gxl.gxl_1_0.EdgemodeType;
import de.gupro.gxl.gxl_1_0.GraphType;
import de.gupro.gxl.gxl_1_0.GxlType;
import de.gupro.gxl.gxl_1_0.TypedElementType;
import groove.io.Util;
import groove.io.conceptual.Timer;
import groove.io.conceptual.lang.ExportException;
import groove.io.conceptual.lang.ExportableResource;
import groove.io.conceptual.lang.gxl.GxlUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

public class GxlResource
extends ExportableResource {
    private GxlType m_gxlTypeType;
    private GxlType m_gxlTypeInstance;
    private GxlType m_gxlTypeTemp;
    private Map<String, GraphType> m_graphs = new HashMap<String, GraphType>();
    private File m_typeFile;
    private File m_instanceFile;
    private String relPath;

    public GxlResource(File typeTarget, File instanceTarget) {
        if (typeTarget != null) {
            this.m_typeFile = typeTarget;
        }
        if (instanceTarget != null) {
            this.m_instanceFile = instanceTarget.equals(typeTarget) ? this.m_typeFile : instanceTarget;
        }
        this.relPath = this.m_typeFile == this.m_instanceFile || this.m_typeFile == null ? "" : Util.getRelativePath(new File(this.m_instanceFile.getAbsoluteFile().getParent()), this.m_typeFile.getAbsoluteFile()).toString();
        this.m_gxlTypeType = new GxlType();
        this.m_gxlTypeTemp = new GxlType();
        this.m_gxlTypeInstance = this.m_typeFile == this.m_instanceFile ? this.m_gxlTypeType : new GxlType();
    }

    public GraphType getTypeGraph(String graphId) {
        if (this.m_graphs.containsKey(graphId)) {
            return this.m_graphs.get(graphId);
        }
        GraphType graph = new GraphType();
        graph.setId(graphId);
        graph.setEdgeids(Boolean.valueOf(true));
        GxlUtil.setElemType((TypedElementType)graph, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#gxl-1.0");
        if (this.m_typeFile != null) {
            this.m_gxlTypeType.getGraph().add(graph);
        } else {
            this.m_gxlTypeTemp.getGraph().add(graph);
        }
        this.m_graphs.put(graphId, graph);
        return graph;
    }

    public GraphType getInstanceGraph(String typeId, String name) {
        if (this.m_graphs.containsKey(name)) {
            return this.m_graphs.get(name);
        }
        GraphType graph = new GraphType();
        graph.setId(name);
        GxlUtil.setElemType((TypedElementType)graph, String.valueOf(this.getTypePath()) + "#" + typeId);
        graph.setEdgeids(Boolean.valueOf(false));
        graph.setEdgemode(EdgemodeType.DEFAULTDIRECTED);
        this.m_gxlTypeInstance.getGraph().add(graph);
        this.m_graphs.put(name, graph);
        return graph;
    }

    public String getTypePath() {
        return this.relPath;
    }

    @Override
    public boolean export() throws ExportException {
        return this.export(false);
    }

    public boolean export(boolean oldStyle) throws ExportException {
        int timer = Timer.start("Save GXL");
        JAXBElement mainElement = GxlUtil.g_objectFactory.createGxl(this.m_gxlTypeType);
        JAXBElement instanceElement = null;
        if (this.m_instanceFile != null && this.m_gxlTypeInstance != this.m_gxlTypeType) {
            instanceElement = GxlUtil.g_objectFactory.createGxl(this.m_gxlTypeInstance);
        }
        try {
            if (!oldStyle) {
                FileOutputStream os;
                if (this.m_typeFile != null) {
                    os = new FileOutputStream(this.m_typeFile);
                    GxlUtil.g_marshaller.marshal((Object)mainElement, (OutputStream)os);
                    ((OutputStream)os).close();
                }
                if (this.m_instanceFile != null && instanceElement != null) {
                    os = new FileOutputStream(this.m_instanceFile);
                    GxlUtil.g_marshaller.marshal((Object)instanceElement, (OutputStream)os);
                    ((OutputStream)os).close();
                }
            } else {
                BufferedWriter out;
                String xmlString;
                ByteArrayOutputStream os;
                if (this.m_typeFile != null) {
                    os = new ByteArrayOutputStream();
                    GxlUtil.g_marshaller.marshal((Object)mainElement, (OutputStream)os);
                    xmlString = os.toString("UTF-8");
                    xmlString = xmlString.replaceAll("standalone=\"yes\"", "").replaceAll("xmlns:xlink=\"http://www.w3.org/1999/xlink\"", "").replaceAll("<gxl[^>]*>", "<!DOCTYPE gxl SYSTEM \"http://www.gupro.de/GXL/gxl-1.0.dtd\">\n<gxl xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
                    out = new BufferedWriter(new FileWriter(this.m_typeFile));
                    out.write(xmlString);
                    out.close();
                }
                if (this.m_instanceFile != null && instanceElement != null) {
                    os = new ByteArrayOutputStream();
                    GxlUtil.g_marshaller.marshal((Object)instanceElement, (OutputStream)os);
                    xmlString = os.toString("UTF-8");
                    xmlString = xmlString.replaceAll("standalone=\"yes\"", "").replaceAll("xmlns:xlink=\"http://www.w3.org/1999/xlink\"", "").replaceAll("<gxl[^>]*>", "<!DOCTYPE gxl SYSTEM \"http://www.gupro.de/GXL/gxl-1.0.dtd\">\n<gxl xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
                    out = new BufferedWriter(new FileWriter(this.m_instanceFile));
                    out.write(xmlString);
                    out.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new ExportException(e);
        }
        catch (JAXBException e) {
            throw new ExportException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ExportException(e);
        }
        catch (IOException e) {
            throw new ExportException(e);
        }
        Timer.stop(timer);
        return true;
    }
}

