/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.graphviz;

import com.alexmerz.graphviz.objects.Edge;
import com.alexmerz.graphviz.objects.Graph;
import com.alexmerz.graphviz.objects.Node;
import com.alexmerz.graphviz.objects.PortNode;
import groove.io.conceptual.Acceptor;
import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.Timer;
import groove.io.conceptual.lang.InstanceExporter;
import groove.io.conceptual.lang.graphviz.GraphvizResource;
import groove.io.conceptual.lang.graphviz.TypeToGraphviz;
import groove.io.conceptual.property.AbstractProperty;
import groove.io.conceptual.property.ContainmentProperty;
import groove.io.conceptual.property.DefaultValueProperty;
import groove.io.conceptual.property.IdentityProperty;
import groove.io.conceptual.property.KeysetProperty;
import groove.io.conceptual.property.OppositeProperty;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.type.Type;
import groove.io.conceptual.value.ContainerValue;
import groove.io.conceptual.value.CustomDataValue;
import groove.io.conceptual.value.TupleValue;
import groove.io.conceptual.value.Value;
import groove.io.external.PortException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InstanceToGraphviz
extends InstanceExporter<Node> {
    private Map<Id, Graph> m_packageGraphs = new HashMap<Id, Graph>();
    private Map<InstanceModel, Graph> m_instanceGraphs = new HashMap<InstanceModel, Graph>();
    private TypeToGraphviz m_typeToGraphviz;
    private GraphvizResource m_resource;
    private int m_nodeId;

    public InstanceToGraphviz(TypeToGraphviz typeToGraphviz) {
        this.m_typeToGraphviz = typeToGraphviz;
        this.m_resource = (GraphvizResource)this.m_typeToGraphviz.getResource();
    }

    @Override
    public void addInstanceModel(InstanceModel instanceModel) throws PortException {
        int timer = Timer.start("IM to DOT");
        Graph instanceGraph = this.m_resource.getInstanceGraph(instanceModel.getName());
        this.m_instanceGraphs.put(instanceModel, instanceGraph);
        this.m_packageGraphs.put(Id.ROOT, instanceGraph);
        this.visitInstanceModel(instanceModel);
        Timer.stop(timer);
    }

    @Override
    public void visit(groove.io.conceptual.value.Object object, Object param) {
        if (this.hasElement(object)) {
            return;
        }
        Graph objectGraph = this.getPackageGraph(((Class)object.getType()).getId().getNamespace());
        Node objectNode = new Node();
        objectGraph.addNode(objectNode);
        this.setElement(object, objectNode);
        objectNode.setId(new com.alexmerz.graphviz.objects.Id());
        objectNode.getId().setId(this.getElementId());
        String objectLabel = object.getName();
        if (objectLabel == null) {
            objectLabel = ((Class)object.getType()).getId().getName().toString();
        }
        objectNode.setAttribute("label", objectLabel);
        for (Map.Entry entry : object.getValue().entrySet()) {
            Type fieldType = ((Field)entry.getKey()).getType();
            boolean isContainer = false;
            if (fieldType instanceof Container) {
                fieldType = ((Container)fieldType).getType();
                isContainer = true;
            }
            String fieldName = ((Field)entry.getKey()).getName().toString();
            if ((fieldType instanceof Class || fieldType instanceof Tuple) && fieldName.matches("edge[0-9]*")) {
                fieldName = null;
            }
            if (fieldType instanceof Class || fieldType instanceof Tuple) {
                if (isContainer) {
                    ContainerValue cVal = (ContainerValue)entry.getValue();
                    Iterator iterator = cVal.getValue().iterator();
                    while (iterator.hasNext()) {
                        Value v = (Value)iterator.next();
                        Edge fieldEdge = new Edge();
                        Node fieldNode = (Node)this.getElement(v);
                        fieldEdge.setSource(new PortNode(objectNode));
                        fieldEdge.setTarget(new PortNode(fieldNode));
                        if (fieldName != null) {
                            fieldEdge.setAttribute("label", fieldName);
                        }
                        fieldEdge.setType(2);
                        this.getPackageGraph(Id.ROOT).addEdge(fieldEdge);
                    }
                    continue;
                }
                Edge fieldEdge = new Edge();
                Node fieldNode = (Node)this.getElement((Acceptor)entry.getValue());
                fieldEdge.setSource(new PortNode(objectNode));
                fieldEdge.setTarget(new PortNode(fieldNode));
                if (fieldName != null) {
                    fieldEdge.setAttribute("label", fieldName);
                }
                fieldEdge.setType(2);
                this.getPackageGraph(Id.ROOT).addEdge(fieldEdge);
                continue;
            }
            if (fieldType instanceof Container) continue;
            String valueLabel = "";
            if (isContainer) {
                ContainerValue cVal = (ContainerValue)entry.getValue();
                valueLabel = String.valueOf(valueLabel) + "[";
                boolean first = true;
                Iterator iterator = cVal.getValue().iterator();
                while (iterator.hasNext()) {
                    Value v = (Value)iterator.next();
                    if (!first) {
                        valueLabel = String.valueOf(valueLabel) + ", ";
                    }
                    valueLabel = String.valueOf(valueLabel) + v.toString();
                    first = false;
                }
                valueLabel = String.valueOf(valueLabel) + "]";
            } else {
                valueLabel = String.valueOf(valueLabel) + ((Value)entry.getValue()).toString();
            }
            objectNode.setAttribute(fieldName, valueLabel);
        }
    }

    @Override
    public void visit(TupleValue tupleval, Object param) {
        if (this.hasElement(tupleval)) {
            return;
        }
        Graph tupleGraph = this.getPackageGraph(Id.ROOT);
        Node tupleNode = new Node();
        tupleGraph.addNode(tupleNode);
        tupleNode.setId(new com.alexmerz.graphviz.objects.Id());
        tupleNode.getId().setId(this.getElementId());
        tupleNode.setAttribute("shape", "record");
        String label = "";
        boolean first = true;
        for (Map.Entry entry : tupleval.getValue().entrySet()) {
            Type type = ((Tuple)tupleval.getType()).getTypes().get((Integer)entry.getKey());
            boolean isContainer = type instanceof Container;
            if (!first) {
                label = String.valueOf(label) + "|";
            }
            if (this.isNodeType(type)) {
                String port = "<t" + entry.getKey() + ">";
                label = String.valueOf(label) + port;
                if (isContainer) {
                    ContainerValue cVal = (ContainerValue)entry.getValue();
                    Iterator iterator = cVal.getValue().iterator();
                    while (iterator.hasNext()) {
                        Value v = (Value)iterator.next();
                        Edge valueEdge = new Edge();
                        Node valueNode = (Node)this.getElement(v);
                        valueEdge.setSource(new PortNode(tupleNode, port));
                        valueEdge.setTarget(new PortNode(valueNode));
                        valueEdge.setAttribute("label", "<" + entry.getKey() + ">");
                        valueEdge.setType(2);
                        this.getPackageGraph(Id.ROOT).addEdge(valueEdge);
                    }
                } else {
                    Node valueNode = (Node)this.getElement((Acceptor)entry.getValue());
                    Edge valueEdge = new Edge();
                    valueEdge.setSource(new PortNode(tupleNode));
                    valueEdge.setTarget(new PortNode(valueNode));
                    valueEdge.setAttribute("label", "<" + entry.getKey() + ">");
                    valueEdge.setType(2);
                    this.getPackageGraph(Id.ROOT).addEdge(valueEdge);
                }
            } else {
                label = String.valueOf(label) + ((Value)entry.getValue()).toString();
            }
            label = String.valueOf(label) + type.toString();
            first = false;
        }
        tupleNode.setAttribute("label", label);
        this.setElement(tupleval, tupleNode);
    }

    @Override
    public void visit(CustomDataValue dataval, Object param) {
    }

    @Override
    public void visit(AbstractProperty abstractProperty, Object param) {
    }

    @Override
    public void visit(ContainmentProperty containmentProperty, Object param) {
    }

    @Override
    public void visit(IdentityProperty identityProperty, Object param) {
    }

    @Override
    public void visit(KeysetProperty keysetProperty, Object param) {
    }

    @Override
    public void visit(OppositeProperty oppositeProperty, Object param) {
    }

    @Override
    public void visit(DefaultValueProperty defaultValueProperty, Object param) {
    }

    private Graph getPackageGraph(Id namespace) {
        if (this.m_packageGraphs.containsKey(namespace)) {
            return this.m_packageGraphs.get(namespace);
        }
        Graph parent = this.getPackageGraph(namespace.getNamespace());
        Graph packageGraph = new Graph();
        parent.getSubgraphs().add(packageGraph);
        com.alexmerz.graphviz.objects.Id graphId = new com.alexmerz.graphviz.objects.Id();
        graphId.setId("\"cluster_" + namespace.getName().toString() + "\"");
        packageGraph.addAttribute("label", namespace.getName().toString());
        packageGraph.setId(graphId);
        this.m_packageGraphs.put(namespace, packageGraph);
        return packageGraph;
    }

    private boolean isNodeType(Type type) {
        if (type instanceof Container) {
            type = ((Container)type).getType();
        }
        return type instanceof Class || type instanceof Tuple;
    }

    private String getElementId() {
        return "N" + this.m_nodeId++;
    }
}

