/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.configuration;

import groove.grammar.model.FormatException;
import groove.grammar.model.ResourceKind;
import groove.gui.Simulator;
import groove.gui.dialog.ErrorDialog;
import groove.io.conceptual.configuration.ConfigAction;
import groove.io.conceptual.configuration.ConfigurationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public abstract class ConfigDialog
extends JDialog
implements ActionListener {
    protected final Simulator m_simulator;
    protected URL m_schemaURL;
    protected String m_activeModel;
    protected String m_selectedModel;
    private JComboBox m_configsList;
    private boolean m_ignoreCombobox = false;
    private final Map<ConfigAction.Type, ConfigAction> actionMap = new EnumMap<ConfigAction.Type, ConfigAction>(ConfigAction.Type.class);

    public ConfigDialog(Simulator simulator) {
        super(simulator.getFrame(), "Config Dialog", true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ConfigDialog.this.m_selectedModel = null;
                ConfigDialog.this.close();
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigDialog.this.setVisible(false);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(actionListener, stroke, 2);
        this.m_simulator = simulator;
        this.buildGUI();
        this.setSize(800, 600);
    }

    public String getConfig() {
        this.setLocationRelativeTo(this.m_simulator.getFrame());
        this.m_selectedModel = null;
        this.setVisible(true);
        if (this.hasModels()) {
            return this.m_selectedModel;
        }
        return null;
    }

    private void close() {
        super.dispose();
    }

    private void buildGUI() {
        this.m_schemaURL = this.getClass().getClassLoader().getResource("groove/io/conceptual/configuration/ConfigSchema.xsd");
        if (this.m_schemaURL == null) {
            throw new RuntimeException("Unable to load the XML schema resource groove/io/conceptual/configuration/ConfigSchema.xsd");
        }
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.getAction(ConfigAction.Type.NEW));
        toolBar.addSeparator();
        this.m_configsList = new JComboBox();
        this.m_configsList.setEditable(false);
        this.m_configsList.addActionListener(this);
        toolBar.add(this.m_configsList);
        toolBar.add(this.getAction(ConfigAction.Type.SAVE));
        toolBar.addSeparator();
        toolBar.add(this.getAction(ConfigAction.Type.COPY));
        toolBar.add(this.getAction(ConfigAction.Type.DELETE));
        toolBar.add(this.getAction(ConfigAction.Type.RENAME));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)toolBar, "North");
        this.getContentPane().add((Component)this.getXMLPanel(), "Center");
        JButton okBtn = new JButton("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.m_selectedModel = ConfigDialog.this.m_activeModel;
                ConfigDialog.this.getAction(ConfigAction.Type.SAVE).execute();
                ConfigDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(okBtn);
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.m_selectedModel = null;
                ConfigDialog.this.dispose();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(okBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(cancelBtn);
        this.getContentPane().add((Component)buttonPane, "South");
        if (this.hasModels()) {
            this.m_activeModel = this.m_simulator.getModel().getGrammar().getNames(ResourceKind.CONFIG).iterator().next();
        }
        this.refreshGUI();
        this.loadModel();
    }

    protected abstract JPanel getXMLPanel();

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object current;
        if (this.m_ignoreCombobox) {
            return;
        }
        if (ae.getSource() == this.m_configsList && !(current = this.m_configsList.getSelectedItem()).equals(this.m_activeModel)) {
            this.m_activeModel = (String)current;
            this.loadModel();
        }
    }

    private ConfigAction getAction(ConfigAction.Type type) {
        ConfigAction result = this.actionMap.get((Object)type);
        if (result == null) {
            result = new ConfigAction(this.m_simulator, type, this);
            this.actionMap.put(type, result);
            result.setEnabled(true);
        }
        return result;
    }

    private void refreshGUI() {
        this.getAction(ConfigAction.Type.RENAME).setEnabled(this.hasModels());
        this.getAction(ConfigAction.Type.COPY).setEnabled(this.hasModels());
        this.getAction(ConfigAction.Type.DELETE).setEnabled(this.hasModels());
        this.refreshList();
    }

    private void refreshList() {
        this.m_ignoreCombobox = true;
        this.m_configsList.removeAllItems();
        Set<String> names = this.m_simulator.getModel().getGrammar().getNames(ResourceKind.CONFIG);
        if (!this.hasModels()) {
            String newStr = new String("<New>");
            this.m_configsList.addItem(newStr);
            this.m_configsList.setSelectedItem(newStr);
            this.m_ignoreCombobox = false;
            return;
        }
        Object[] nameArray = names.toArray();
        Arrays.sort(nameArray);
        Object[] objectArray = nameArray;
        int n = nameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            this.m_configsList.addItem(name);
            if (name.equals(this.m_activeModel)) {
                this.m_configsList.setSelectedItem(name);
            }
            ++n2;
        }
        this.m_ignoreCombobox = false;
    }

    public void executeAction(ConfigAction.Type type, String modelName) {
        try {
            switch (type) {
                case NEW: {
                    this.m_activeModel = modelName;
                    this.newModel();
                    this.saveModel();
                    this.refreshGUI();
                    break;
                }
                case SAVE: {
                    if (!this.hasModels()) {
                        this.m_activeModel = modelName;
                        this.saveModel();
                        this.refreshGUI();
                        break;
                    }
                    this.saveModel();
                    break;
                }
                case DELETE: {
                    if (!this.hasModels()) {
                        return;
                    }
                    try {
                        this.m_simulator.getModel().getStore().deleteTexts(ResourceKind.CONFIG, Collections.singletonList(this.m_activeModel));
                        this.m_activeModel = !this.hasModels() ? null : this.m_simulator.getModel().getGrammar().getNames(ResourceKind.CONFIG).iterator().next();
                    }
                    catch (IOException e) {
                        new ErrorDialog((Component)this.m_simulator.getFrame(), "Error deleting configuration", e).setVisible(true);
                    }
                    this.refreshGUI();
                    this.loadModel();
                    break;
                }
                case RENAME: {
                    if (!this.hasModels()) {
                        return;
                    }
                    try {
                        this.m_simulator.getModel().getStore().rename(ResourceKind.CONFIG, this.m_activeModel, modelName);
                        this.m_activeModel = modelName;
                    }
                    catch (IOException e) {
                        new ErrorDialog((Component)this.m_simulator.getFrame(), "Error renaming configuration", e).setVisible(true);
                    }
                    this.refreshGUI();
                    this.loadModel();
                    break;
                }
                case COPY: {
                    if (!this.hasModels()) {
                        return;
                    }
                    try {
                        String xmlString = (String)this.m_simulator.getModel().getGrammar().getResource(ResourceKind.CONFIG, this.m_activeModel).toResource();
                        this.m_simulator.getModel().getStore().putTexts(ResourceKind.CONFIG, Collections.singletonMap(modelName, xmlString));
                        this.m_activeModel = modelName;
                    }
                    catch (FormatException formatException) {
                        return;
                    }
                    catch (IOException e) {
                        new ErrorDialog((Component)this.m_simulator.getFrame(), "Error copying configuration", e).setVisible(true);
                    }
                    this.refreshGUI();
                    this.loadModel();
                }
            }
        }
        catch (ConfigurationException configurationException) {}
    }

    protected abstract void newModel();

    private void loadModel() {
        if (!this.hasModels()) {
            this.newModel();
            return;
        }
        String xmlString = null;
        try {
            xmlString = (String)this.m_simulator.getModel().getGrammar().getResource(ResourceKind.CONFIG, this.m_activeModel).toResource();
        }
        catch (FormatException formatException) {
            return;
        }
        try {
            this.loadModel(xmlString);
        }
        catch (ConfigurationException configurationException) {}
    }

    protected abstract void loadModel(String var1) throws ConfigurationException;

    private void saveModel() throws ConfigurationException {
        Document doc = this.getDocument();
        Transformer transformer = null;
        Exception exc = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            this.m_simulator.getModel().getStore().putTexts(ResourceKind.CONFIG, Collections.singletonMap(this.m_activeModel, xmlString));
        }
        catch (TransformerConfigurationException e) {
            exc = e;
        }
        catch (IOException e) {
            exc = e;
        }
        catch (TransformerException e) {
            exc = e;
        }
        if (exc != null) {
            new ErrorDialog((Component)this.m_simulator.getFrame(), "Error saving configuration resource " + this.m_activeModel, exc).setVisible(true);
        }
    }

    protected abstract Document getDocument() throws ConfigurationException;

    public boolean hasModels() {
        Set<String> names = this.m_simulator.getModel().getGrammar().getNames(ResourceKind.CONFIG);
        return names.size() > 0;
    }
}

