/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.control.CtrlTransition;
import groove.grammar.Action;
import groove.grammar.QualName;
import groove.grammar.Recipe;
import groove.grammar.Rule;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.grammar.model.RuleModel;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.SimulatorModel;
import groove.gui.display.ControlDisplay;
import groove.gui.display.DisplayKind;
import groove.gui.display.RuleDisplay;
import groove.gui.display.TextTab;
import groove.gui.tree.AbstractResourceTree;
import groove.gui.tree.DisplayTreeCellRenderer;
import groove.gui.tree.DisplayTreeNode;
import groove.gui.tree.MatchTreeNode;
import groove.gui.tree.RecipeTreeNode;
import groove.gui.tree.RuleTreeNode;
import groove.lts.GraphState;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import groove.util.Duo;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RuleTree
extends AbstractResourceTree {
    private final DefaultTreeModel ruleDirectory;
    private final DisplayTreeNode topDirectoryNode;
    private final Map<String, Collection<RuleTreeNode>> ruleNodeMap = new HashMap<String, Collection<RuleTreeNode>>();
    private final Map<String, Recipe> recipeMap = new HashMap<String, Recipe>();
    private final Map<MatchResult, MatchTreeNode> matchNodeMap = new HashMap<MatchResult, MatchTreeNode>();
    private boolean anchorImageOptionListenerSet = false;

    public RuleTree(RuleDisplay display) {
        super(display);
        this.setLargeModel(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setEnabled(false);
        this.setToggleClickCount(0);
        this.setCellRenderer(new DisplayTreeCellRenderer(this));
        this.getSelectionModel().setSelectionMode(4);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.cellRenderer;
        renderer.setLeafIcon(Icons.GRAPH_MATCH_ICON);
        this.topDirectoryNode = new DisplayTreeNode();
        this.ruleDirectory = new DefaultTreeModel(this.topDirectoryNode, true);
        this.setModel(this.ruleDirectory);
        ActionMap am = this.getActionMap();
        am.put("Step Back", this.getActions().getBackAction());
        am.put("Step Forward", this.getActions().getForwardAction());
        InputMap im = this.getInputMap();
        im.put(Options.BACK_KEY, "Step Back");
        im.put(Options.FORWARD_KEY, "Step Forward");
        this.installListeners();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    void activateListeners() {
        super.activateListeners();
        this.getSimulatorModel().addListener(this, SimulatorModel.Change.STATE, SimulatorModel.Change.MATCH);
    }

    @Override
    TreeSelectionListener createSelectionListener() {
        return new RuleSelectionListener();
    }

    @Override
    MouseListener createMouseListener() {
        return new MyMouseListener();
    }

    @Override
    JPopupMenu createPopupMenu(TreeNode node) {
        JPopupMenu res = super.createPopupMenu(node);
        if (node instanceof RuleTreeNode) {
            res.add(this.getActions().getSetPriorityAction());
            res.add(this.getActions().getShiftPriorityAction(true));
            res.add(this.getActions().getShiftPriorityAction(false));
            res.add(this.getActions().getEditRulePropertiesAction());
        } else if (node instanceof MatchTreeNode) {
            res.addSeparator();
            res.add(this.getActions().getApplyMatchAction());
        }
        return res;
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        this.suspendListeners();
        boolean renewSelection = false;
        if (changes.contains((Object)SimulatorModel.Change.GRAMMAR)) {
            GrammarModel grammar = source.getGrammar();
            if (grammar == null) {
                this.clearAllMaps();
                this.topDirectoryNode.removeAllChildren();
                this.ruleDirectory.reload();
            } else {
                this.loadGrammar(grammar);
            }
            this.refresh(source.getState());
            renewSelection = true;
        } else {
            if (changes.contains((Object)SimulatorModel.Change.GTS) || changes.contains((Object)SimulatorModel.Change.STATE)) {
                this.refresh(source.getState());
                renewSelection = true;
            }
            if (changes.contains((Object)SimulatorModel.Change.MATCH) || changes.contains((Object)SimulatorModel.Change.RULE)) {
                renewSelection = true;
            }
        }
        if (renewSelection) {
            ResourceModel<?> ruleModel = source.getResource(ResourceKind.RULE);
            this.selectMatch((RuleModel)ruleModel, source.getMatch());
        }
        this.activateListeners();
    }

    private void clearAllMaps() {
        this.ruleNodeMap.clear();
        this.recipeMap.clear();
        this.matchNodeMap.clear();
    }

    private void loadGrammar(GrammarModel grammar) {
        this.setShowAnchorsOptionListener();
        this.clearAllMaps();
        this.topDirectoryNode.removeAllChildren();
        DisplayTreeNode topNode = this.topDirectoryNode;
        Map<Integer, Set<ActionEntry>> priorityMap = this.getPriorityMap(grammar);
        ArrayList<TreePath> expandedPaths = new ArrayList<TreePath>();
        ArrayList<TreePath> selectedPaths = new ArrayList<TreePath>();
        for (Map.Entry<Integer, Set<ActionEntry>> priorityEntry : priorityMap.entrySet()) {
            DisplayTreeNode parentNode;
            String name;
            int priority = priorityEntry.getKey();
            HashMap<String, AbstractResourceTree.FolderTreeNode> dirNodeMap = new HashMap<String, AbstractResourceTree.FolderTreeNode>();
            if (priorityMap.size() > 1) {
                topNode = new PriorityTreeNode(priority);
                this.topDirectoryNode.add(topNode);
                dirNodeMap.clear();
            }
            HashMap<String, RuleEntry> ruleEntryMap = new HashMap<String, RuleEntry>();
            ArrayList<RecipeEntry> recipes = new ArrayList<RecipeEntry>();
            for (ActionEntry action : priorityEntry.getValue()) {
                if (action instanceof RecipeEntry) {
                    recipes.add((RecipeEntry)action);
                    this.recipeMap.put(action.getName(), ((RecipeEntry)action).getRecipe());
                    continue;
                }
                ruleEntryMap.put(action.getName(), (RuleEntry)action);
            }
            ArrayList<String> subruleNames = new ArrayList<String>();
            for (RecipeEntry recipe : recipes) {
                name = recipe.getName();
                parentNode = this.addParentNode(topNode, dirNodeMap, QualName.getParent(name));
                DisplayTreeNode recipeNode = this.createActionNode(recipe, expandedPaths, selectedPaths);
                parentNode.insertSorted(recipeNode);
                Set<Rule> subrules = recipe.getRecipe().getRules();
                if (subrules == null) continue;
                for (Rule sr : subrules) {
                    String srName = sr.getFullName();
                    RuleEntry srEntry = (RuleEntry)ruleEntryMap.get(srName);
                    if (srEntry != null) {
                        DisplayTreeNode srNode = this.createActionNode(srEntry, expandedPaths, selectedPaths);
                        recipeNode.insertSorted(srNode);
                    }
                    subruleNames.add(srName);
                }
            }
            ruleEntryMap.keySet().removeAll(subruleNames);
            for (RuleEntry ruleEntry : ruleEntryMap.values()) {
                name = ruleEntry.getName();
                parentNode = this.addParentNode(topNode, dirNodeMap, QualName.getParent(name));
                DisplayTreeNode ruleNode = this.createActionNode(ruleEntry, expandedPaths, selectedPaths);
                parentNode.insertSorted(ruleNode);
            }
        }
        for (TreePath path : expandedPaths) {
            this.expandPath(path);
        }
        this.ruleDirectory.reload(this.topDirectoryNode);
        for (TreePath path : expandedPaths) {
            this.expandPath(path);
        }
        this.setSelectionPaths(selectedPaths.toArray(new TreePath[0]));
    }

    private DisplayTreeNode createActionNode(ActionEntry action, List<TreePath> expandedPaths, List<TreePath> selectedPaths) {
        Set<String> selection = this.getSimulatorModel().getSelectSet(ResourceKind.RULE);
        String name = action.getName();
        DisplayTreeNode node = action.createTreeNode();
        TreePath path = new TreePath(node.getPath());
        expandedPaths.add(path);
        if (selection.contains(name)) {
            selectedPaths.add(path);
        }
        return node;
    }

    private Map<Integer, Set<ActionEntry>> getPriorityMap(GrammarModel grammar) {
        TreeMap<Integer, Set<ActionEntry>> result = new TreeMap<Integer, Set<ActionEntry>>(Action.PRIORITY_COMPARATOR);
        HashSet<String> subRuleNames = new HashSet<String>();
        for (Recipe recipe : grammar.getControlModel().getRecipes()) {
            int priority = 0;
            HashSet<RecipeEntry> recipes = (HashSet<RecipeEntry>)result.get(priority);
            if (recipes == null) {
                recipes = new HashSet<RecipeEntry>();
                result.put(priority, recipes);
            }
            recipes.add(new RecipeEntry(recipe));
            Set<Rule> subrules = recipe.getRules();
            if (subrules == null) continue;
            for (Rule subrule : subrules) {
                if (subrule.getPriority() != priority) continue;
                String ruleName = subrule.getFullName();
                recipes.add((RecipeEntry)((Object)new RuleEntry(grammar.getRuleModel(ruleName))));
                subRuleNames.add(ruleName);
            }
        }
        for (ResourceModel resourceModel : grammar.getResourceSet(ResourceKind.RULE)) {
            RuleModel ruleModel = (RuleModel)resourceModel;
            if (subRuleNames.contains(ruleModel.getFullName())) continue;
            int priority = ruleModel.getPriority();
            HashSet<RuleEntry> rules = (HashSet<RuleEntry>)result.get(priority);
            if (rules == null) {
                rules = new HashSet<RuleEntry>();
                result.put(priority, rules);
            }
            rules.add(new RuleEntry(ruleModel));
        }
        return result;
    }

    private void setShowAnchorsOptionListener() {
        JMenuItem showAnchorsOptionItem;
        if (!this.anchorImageOptionListenerSet && (showAnchorsOptionItem = this.getSimulator().getOptions().getItem("Show anchors")) != null) {
            showAnchorsOptionItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    RuleTree.this.suspendListeners();
                    RuleTree.this.refresh(RuleTree.this.getSimulatorModel().getState());
                    RuleTree.this.activateListeners();
                }
            });
            this.anchorImageOptionListenerSet = true;
        }
    }

    private DisplayTreeNode addParentNode(DisplayTreeNode topNode, Map<String, AbstractResourceTree.FolderTreeNode> dirNodeMap, String parentName) {
        if (parentName.isEmpty()) {
            return topNode;
        }
        AbstractResourceTree.FolderTreeNode result = dirNodeMap.get(parentName);
        if (result == null) {
            DisplayTreeNode grandParentNode = this.addParentNode(topNode, dirNodeMap, QualName.getParent(parentName));
            result = new AbstractResourceTree.FolderTreeNode(QualName.getLastName(parentName));
            grandParentNode.insertSorted(result);
            dirNodeMap.put(parentName, result);
        }
        return result;
    }

    private void refresh(GraphState state) {
        TreeSet<MatchResult> matches = new TreeSet<MatchResult>(MatchResult.COMPARATOR);
        if (state != null) {
            for (RuleTransition trans : state.getRuleTransitions()) {
                matches.add(trans.getKey());
            }
            matches.addAll(state.getMatches());
        }
        this.refreshMatches(state, matches);
        this.setEnabled(this.getGrammar() != null);
    }

    private void selectMatch(RuleModel rule, MatchResult match) {
        MatchTreeNode node;
        ArrayList<DisplayTreeNode> treeNodes = new ArrayList<DisplayTreeNode>();
        if (match != null && (node = this.matchNodeMap.get(match)) != null) {
            treeNodes.add(node);
        }
        if (treeNodes.isEmpty() && rule != null) {
            treeNodes.addAll(this.ruleNodeMap.get(rule.getFullName()));
        }
        TreePath[] paths = new TreePath[treeNodes.size()];
        int i = 0;
        while (i < treeNodes.size()) {
            paths[i] = new TreePath(((DefaultMutableTreeNode)treeNodes.get(i)).getPath());
            ++i;
        }
        this.setSelectionPaths(paths);
    }

    private void refreshMatches(GraphState state, Collection<? extends MatchResult> matches) {
        String ruleName;
        for (MatchTreeNode matchNode : this.matchNodeMap.values()) {
            this.ruleDirectory.removeNodeFromParent(matchNode);
        }
        this.matchNodeMap.clear();
        Set<CtrlTransition> triedTransitions = state == null ? Collections.emptySet() : state.getSchedule().getTriedTransitions();
        HashSet<Duo<String>> triedPairs = new HashSet<Duo<String>>();
        for (CtrlTransition t : triedTransitions) {
            String ruleName2 = t.getRule().getFullName();
            String recipeName = t.hasRecipe() ? t.getRecipe().getFullName() : null;
            triedPairs.add(Duo.newDuo(ruleName2, recipeName));
        }
        ArrayList<RuleTreeNode> treeNodes = new ArrayList<RuleTreeNode>();
        for (Collection<RuleTreeNode> collection : this.ruleNodeMap.values()) {
            treeNodes.addAll(collection);
            for (RuleTreeNode n : collection) {
                ruleName = n.getName();
                Recipe ruleRecipe = this.getRecipe(n);
                String recipeName = ruleRecipe == null ? null : ruleRecipe.getFullName();
                boolean tried = triedPairs.contains(Duo.newDuo(ruleName, recipeName));
                n.setTried(tried);
            }
        }
        for (RuleTreeNode ruleTreeNode : treeNodes) {
            this.expandPath(new TreePath(ruleTreeNode.getPath()));
        }
        for (RuleTreeNode ruleTreeNode : treeNodes) {
            this.collapsePath(new TreePath(ruleTreeNode.getPath()));
        }
        for (MatchResult matchResult : matches) {
            Rule rule = matchResult.getEvent().getRule();
            Recipe recipe = matchResult.getCtrlTransition().getRecipe();
            ruleName = rule.getFullName();
            for (RuleTreeNode ruleNode : this.ruleNodeMap.get(ruleName)) {
                if (recipe != null && !recipe.equals(this.getRecipe(ruleNode))) continue;
                int nrOfMatches = ruleNode.getChildCount();
                MatchTreeNode matchNode = new MatchTreeNode(this.getSimulatorModel(), state, matchResult, nrOfMatches + 1, this.getSimulator().getOptions().isSelected("Show anchors"));
                this.ruleDirectory.insertNodeInto(matchNode, ruleNode, nrOfMatches);
                this.expandPath(new TreePath(ruleNode.getPath()));
                this.matchNodeMap.put(matchResult, matchNode);
            }
        }
    }

    private Recipe getRecipe(RuleTreeNode ruleNode) {
        Recipe result = null;
        TreeNode parent = ruleNode.getParent();
        if (parent instanceof RecipeTreeNode) {
            result = ((RecipeTreeNode)parent).getRecipe();
        }
        return result;
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String result = value instanceof DisplayTreeNode ? ((DisplayTreeNode)value).getText() : super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        return result;
    }

    private final ControlDisplay getControlDisplay() {
        return (ControlDisplay)this.getSimulator().getDisplaysPanel().getDisplay(DisplayKind.CONTROL);
    }

    private static interface ActionEntry {
        public String getName();

        public int getPriority();

        public DisplayTreeNode createTreeNode();

        public boolean isEnabled();
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            TreePath path = RuleTree.this.getPathForLocation(evt.getX(), evt.getY());
            if (path != null) {
                if (evt.getButton() == 3 && !RuleTree.this.isRowSelected(RuleTree.this.getRowForPath(path))) {
                    RuleTree.this.setSelectionPath(path);
                }
                DisplayKind toDisplay = null;
                Object lastComponent = path.getLastPathComponent();
                if (lastComponent instanceof RuleTreeNode) {
                    toDisplay = DisplayKind.RULE;
                } else if (lastComponent instanceof RecipeTreeNode) {
                    toDisplay = DisplayKind.CONTROL;
                } else if (lastComponent instanceof MatchTreeNode && RuleTree.this.getSimulatorModel().getDisplay() != DisplayKind.LTS) {
                    toDisplay = DisplayKind.STATE;
                }
                if (evt.getClickCount() == 1 && toDisplay != null) {
                    RuleTree.this.getSimulatorModel().setDisplay(toDisplay);
                } else if (evt.getClickCount() == 2 && toDisplay != null && toDisplay.hasResource()) {
                    RuleTree.this.getActions().getEditAction(toDisplay.getResource()).execute();
                }
            }
            this.maybeShowPopup(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getButton() != 1) {
                return;
            }
            TreePath path = RuleTree.this.getSelectionPath();
            if (path == null) {
                return;
            }
            Object selectedNode = path.getLastPathComponent();
            if (selectedNode instanceof MatchTreeNode && evt.getClickCount() == 2) {
                RuleTree.this.getActions().getApplyMatchAction().execute();
            }
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                TreePath selectedPath = RuleTree.this.getPathForLocation(evt.getX(), evt.getY());
                TreeNode selectedNode = selectedPath == null ? null : (TreeNode)selectedPath.getLastPathComponent();
                RuleTree.this.requestFocus();
                RuleTree.this.createPopupMenu(selectedNode).show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private static class PriorityTreeNode
    extends AbstractResourceTree.FolderTreeNode {
        public PriorityTreeNode(int priority) {
            super("Priority " + priority);
        }

        @Override
        public Icon getIcon() {
            return Icons.EMPTY_ICON;
        }
    }

    private class RecipeEntry
    implements ActionEntry {
        private final Recipe recipe;

        public RecipeEntry(Recipe recipe) {
            this.recipe = recipe;
        }

        @Override
        public String getName() {
            return this.getRecipe().getFullName();
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public RecipeTreeNode createTreeNode() {
            return new RecipeTreeNode(this.getRecipe());
        }

        @Override
        public boolean isEnabled() {
            return this.getRecipe().getBody() != null;
        }

        public Recipe getRecipe() {
            return this.recipe;
        }
    }

    private class RuleEntry
    implements ActionEntry {
        private final RuleModel model;

        public RuleEntry(RuleModel model) {
            this.model = model;
        }

        @Override
        public String getName() {
            return this.getModel().getFullName();
        }

        @Override
        public int getPriority() {
            return this.getModel().getPriority();
        }

        @Override
        public RuleTreeNode createTreeNode() {
            RuleTreeNode result = new RuleTreeNode(RuleTree.this.getParentDisplay(), this.getName());
            ArrayList<RuleTreeNode> nodes = (ArrayList<RuleTreeNode>)RuleTree.this.ruleNodeMap.get(this.getName());
            if (nodes == null) {
                nodes = new ArrayList<RuleTreeNode>();
                RuleTree.this.ruleNodeMap.put(this.getName(), nodes);
            }
            nodes.add(result);
            return result;
        }

        public RuleModel getModel() {
            return this.model;
        }

        @Override
        public boolean isEnabled() {
            return this.getModel().isEnabled();
        }
    }

    private class RuleSelectionListener
    extends AbstractResourceTree.MySelectionListener {
        @Override
        void setSelection(Collection<TreeNode> selectedNodes) {
            boolean done = false;
            for (TreeNode node : selectedNodes) {
                if (!(node instanceof MatchTreeNode)) continue;
                GraphState state = ((MatchTreeNode)node).getSource();
                MatchResult match = ((MatchTreeNode)node).getMatch();
                RuleTree.this.getSimulatorModel().setMatch(state, match);
                done = true;
                break;
            }
            if (!done) {
                for (TreeNode node : selectedNodes) {
                    if (!(node instanceof RecipeTreeNode)) continue;
                    String name = ((RecipeTreeNode)node).getName();
                    Recipe recipe = (Recipe)RuleTree.this.recipeMap.get(name);
                    RuleTree.this.getSimulatorModel().doSelectSet(ResourceKind.RULE, Collections.<String>emptySet());
                    RuleTree.this.getSimulatorModel().doSelect(ResourceKind.CONTROL, recipe.getControlName());
                    TextTab controlTab = (TextTab)RuleTree.this.getControlDisplay().getSelectedTab();
                    controlTab.select(recipe.getStartLine(), 0);
                    done = true;
                    break;
                }
            }
            if (!done) {
                super.setSelection(selectedNodes);
            }
        }
    }
}

