/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.Graph;
import groove.graph.Label;
import groove.gui.action.ActionStore;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JModel;
import groove.gui.menu.ShowHideMenu;
import groove.gui.tree.CheckboxTree;
import groove.gui.tree.LabelFilter;
import groove.gui.tree.TypeFilter;
import groove.io.HTMLConverter;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;

public class LabelTree<G extends Graph>
extends CheckboxTree
implements GraphModelListener,
TreeSelectionListener {
    private final JGraph<G> jGraph;
    private JModel<G> jModel;
    private final LabelFilter<G> labelFilter;
    private final boolean filtering;
    private static final Color SPECIAL_COLOR = Color.LIGHT_GRAY;

    public LabelTree(JGraph<G> jGraph, boolean filtering) {
        this.jGraph = jGraph;
        this.labelFilter = this.createLabelFilter();
        this.filtering = filtering;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setEnabled(jGraph.isEnabled());
        this.setLargeModel(true);
        this.installListeners();
    }

    LabelFilter<G> createLabelFilter() {
        return new LabelFilter();
    }

    void installListeners() {
        this.getJGraph().addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LabelTree.this.updateModel();
            }
        });
        this.getJGraph().addGraphSelectionListener(new GraphSelectionListener(){

            public void valueChanged(GraphSelectionEvent e) {
                LabelTree.this.clearSelection();
            }
        });
        this.getFilter().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                LabelTree.this.repaint();
                LabelTree.this.getJGraph().refreshCells((Set)arg);
            }
        });
        this.addMouseListener(new MyMouseListener());
    }

    void installJModelListeners(JModel<G> jModel) {
        jModel.addGraphModelListener(this);
    }

    void removeJModelListeners(JModel<G> jModel) {
        jModel.removeGraphModelListener(this);
    }

    @Override
    protected CheckboxTree.CellRenderer createRenderer() {
        return new MyTreeCellRenderer();
    }

    public Action createFilterAction(Object[] cells) {
        if (this.isFiltering()) {
            return new FilterAction(cells);
        }
        return null;
    }

    public JGraph<G> getJGraph() {
        return this.jGraph;
    }

    LabelFilter<G> getFilter() {
        return this.labelFilter;
    }

    public boolean hasFilter() {
        return this.getFilter() != null;
    }

    public boolean isFiltering() {
        return this.filtering;
    }

    public SortedSet<Label> getLabels() {
        TreeSet<Label> result = new TreeSet<Label>();
        for (LabelFilter.Entry entry : this.getFilter().getEntries()) {
            result.add(entry.getLabel());
        }
        return result;
    }

    public void synchroniseModel() {
        if (this.isModelStale()) {
            this.updateModel();
        }
    }

    boolean isModelStale() {
        return this.jModel != this.getJGraph().getModel();
    }

    public void updateModel() {
        if (this.jModel != null) {
            this.removeJModelListeners(this.jModel);
        }
        this.jModel = this.getJGraph().getModel();
        if (this.hasFilter()) {
            this.clearFilter();
        }
        if (this.jModel != null) {
            this.installJModelListeners(this.jModel);
            if (this.hasFilter()) {
                this.updateFilter();
            }
        }
        this.updateTree();
        this.setEnabled(this.jModel != null);
    }

    void clearFilter() {
        this.getFilter().clear();
    }

    void updateFilter() {
        for (JCell<G> cell : this.jModel.getRoots()) {
            this.getFilter().addJCell(cell);
        }
    }

    void updateTree() {
        this.removeTreeSelectionListener(this);
        HashSet<CheckboxTree.TreeNode> collapsedNodes = new HashSet<CheckboxTree.TreeNode>();
        int i = 0;
        while (i < this.getRowCount()) {
            CheckboxTree.TreeNode child;
            if (this.isCollapsed(i) && (child = (CheckboxTree.TreeNode)this.getPathForRow(i).getLastPathComponent()).getChildCount() > 0) {
                collapsedNodes.add(child);
            }
            ++i;
        }
        this.clearSelection();
        this.getTopNode().removeAllChildren();
        List<CheckboxTree.TreeNode> newNodes = this.fillTree();
        this.getModel().reload(this.getTopNode());
        for (CheckboxTree.TreeNode newNode : newNodes) {
            if (newNode.isLeaf()) continue;
            boolean expand = true;
            TreePath path = new TreePath(newNode.getPath());
            Object[] objectArray = path.getPath();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object node = objectArray[n2];
                if (collapsedNodes.contains(node)) {
                    expand = false;
                    break;
                }
                ++n2;
            }
            if (!expand) continue;
            this.expandPath(path);
        }
        this.addTreeSelectionListener(this);
    }

    List<CheckboxTree.TreeNode> fillTree() {
        ArrayList<CheckboxTree.TreeNode> result = new ArrayList<CheckboxTree.TreeNode>();
        TreeSet<LabelFilter.Entry> entries = new TreeSet<LabelFilter.Entry>(this.getFilter().getEntries());
        for (LabelFilter.Entry entry : entries) {
            if (!this.getFilter().hasJCells(entry)) continue;
            EntryNode labelNode = new EntryNode(this, entry, true);
            this.getTopNode().add(labelNode);
        }
        return result;
    }

    public void graphChanged(GraphModelEvent e) {
        boolean changed = false;
        GraphModelEvent.GraphModelChange change = e.getChange();
        changed = this.processEdit(change, changed);
        if (changed) {
            this.updateTree();
        }
    }

    private boolean processEdit(GraphModelEvent.GraphModelChange change, boolean changed) {
        int n;
        Object[] addedArray;
        HashMap changeMap = new HashMap();
        Map storedChange = change.getAttributes();
        if (storedChange != null) {
            changeMap.putAll(storedChange);
        }
        if ((addedArray = change.getInserted()) != null) {
            Object[] objectArray = addedArray;
            n = addedArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof JCell) {
                    JCell jCell = (JCell)element;
                    changed |= this.getFilter().addJCell(jCell);
                }
                changeMap.remove(element);
                ++n2;
            }
        }
        for (Map.Entry changeEntry : changeMap.entrySet()) {
            Object element = changeEntry.getKey();
            if (!(element instanceof JCell)) continue;
            JCell jCell = (JCell)element;
            changed |= this.getFilter().modifyJCell(jCell);
        }
        Object[] removedArray = change.getRemoved();
        if (removedArray != null) {
            Object[] objectArray = removedArray;
            int n3 = removedArray.length;
            n = 0;
            while (n < n3) {
                Object element = objectArray[n];
                if (element instanceof JCell) {
                    JCell jCell = (JCell)element;
                    changed |= this.getFilter().removeJCell(jCell);
                }
                ++n;
            }
        }
        return changed;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        HashSet<JCell<G>> emphSet = new HashSet<JCell<G>>();
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            TreePath[] treePathArray = selectionPaths;
            int n = selectionPaths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath selectedPath = treePathArray[n2];
                Object treeNode = selectedPath.getLastPathComponent();
                if (treeNode instanceof EntryNode) {
                    LabelFilter.Entry entry = ((EntryNode)treeNode).getEntry();
                    Set<JCell<G>> occurrences = this.getFilter().getJCells(entry);
                    if (occurrences != null) {
                        emphSet.addAll(occurrences);
                    }
                }
                ++n2;
            }
        }
        this.jGraph.setSelectionCells(emphSet.toArray());
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu result = new JPopupMenu();
        this.addActionItems(result);
        this.addFilterItems(result);
        this.addShowHideItems(result);
        return result;
    }

    private void addActionItems(JPopupMenu result) {
        TreePath[] selectedValues = this.getSelectionPaths();
        ActionStore actions = this.getJGraph().getActions();
        if (selectedValues != null && selectedValues.length == 1 && actions != null) {
            result.add(actions.getFindReplaceAction());
            if (this.getJGraph() instanceof AspectJGraph && actions.getSelectColorAction().isEnabled()) {
                result.add(actions.getSelectColorAction());
            }
            result.addSeparator();
        }
    }

    void addFilterItems(JPopupMenu menu) {
        TreePath[] selectedValues = this.getSelectionPaths();
        if (this.isFiltering() && selectedValues != null) {
            menu.add(new FilterAction(selectedValues, true));
            menu.add(new FilterAction(selectedValues, false));
            menu.addSeparator();
        }
    }

    private void addShowHideItems(JPopupMenu result) {
        JPopupMenu restMenu = new ShowHideMenu<G>(this.jGraph).getPopupMenu();
        while (restMenu.getComponentCount() > 0) {
            result.add(restMenu.getComponent(0));
        }
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof EntryNode) {
            LabelFilter.Entry entry = ((EntryNode)value).getEntry();
            return this.getText(entry);
        }
        return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
    }

    private String getText(LabelFilter.Entry entry) {
        StringBuilder text = new StringBuilder();
        Label label = entry.getLabel();
        boolean specialLabelColour = false;
        if (label.equals(TypeLabel.NODE)) {
            text.append("(none)");
            specialLabelColour = true;
        } else if (label.text().length() == 0) {
            text.append("(empty)");
            specialLabelColour = true;
        } else {
            text.append(TypeLabel.toHtmlString(label));
        }
        if (specialLabelColour) {
            HTMLConverter.createColorTag(SPECIAL_COLOR).on(text);
        }
        if (!this.getFilter().isSelected(entry)) {
            HTMLConverter.STRIKETHROUGH_TAG.on(text);
        }
        return HTMLConverter.HTML_TAG.on(text).toString();
    }

    public boolean isFiltered(JCell<G> jCell) {
        this.synchroniseModel();
        return this.hasFilter() && this.getFilter().isFiltered(jCell, this.getJGraph().isShowUnfilteredEdges());
    }

    public boolean isFiltered(Label key) {
        this.synchroniseModel();
        return this.hasFilter() && !this.getFilter().isSelected(this.getFilter().getEntry(key));
    }

    public static class EntryNode
    extends CheckboxTree.TreeNode {
        private final LabelTree<?> tree;
        private final LabelFilter.Entry entry;
        private final boolean topNode;

        EntryNode(LabelTree<?> tree, LabelFilter.Entry entry, boolean topNode) {
            this.tree = tree;
            this.entry = entry;
            this.topNode = topNode;
        }

        public int hashCode() {
            return this.entry.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EntryNode)) {
                return false;
            }
            EntryNode other = (EntryNode)obj;
            return this.entry.equals(other.entry);
        }

        public LabelFilter.Entry getEntry() {
            return this.entry;
        }

        public final boolean isTopNode() {
            return this.topNode;
        }

        public Icon getIcon() {
            return null;
        }

        @Override
        public final boolean hasCheckbox() {
            return this.tree.isFiltering() && this.isTopNode();
        }

        @Override
        public boolean isSelected() {
            return this.tree.getFilter().isSelected(this.getEntry());
        }

        @Override
        public void setSelected(boolean selected) {
            this.tree.getFilter().setSelected(this.getEntry(), selected);
        }

        @Override
        public final String toString() {
            return "Tree node for " + this.entry.toString();
        }
    }

    private class FilterAction
    extends AbstractAction {
        private final boolean filter;
        private final Collection<LabelFilter.Entry> entries;

        FilterAction(Object[] cells) {
            super("Filter labels");
            this.filter = true;
            this.entries = new ArrayList<LabelFilter.Entry>();
            Object[] objectArray = cells;
            int n = cells.length;
            int n2 = 0;
            while (n2 < n) {
                Object cell = objectArray[n2];
                JCell jCell = (JCell)cell;
                this.entries.addAll(LabelTree.this.getFilter().getEntries(jCell));
                ++n2;
            }
        }

        FilterAction(TreePath[] cells, boolean filter) {
            super(filter ? "Filter labels" : "Reset label filter");
            this.filter = filter;
            this.entries = new ArrayList<LabelFilter.Entry>();
            TreePath[] treePathArray = cells;
            int n = cells.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                Object treeNode = path.getLastPathComponent();
                if (treeNode instanceof EntryNode) {
                    LabelFilter.Entry entry = ((EntryNode)treeNode).getEntry();
                    this.entries.add(entry);
                }
                ++n2;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LabelTree.this.getFilter().setSelected(this.entries, !this.filter);
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object treeNode;
            TreePath path;
            if (LabelTree.this.hasFilter() && e.getClickCount() == 2 && (path = LabelTree.this.getPathForLocation(e.getPoint().x, e.getPoint().y)) != null && (treeNode = path.getLastPathComponent()) instanceof EntryNode) {
                LabelFilter.Entry entry = ((EntryNode)treeNode).getEntry();
                LabelTree.this.getFilter().changeSelected(entry);
            }
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                LabelTree.this.createPopupMenu().show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private class MyTreeCellRenderer
    extends CheckboxTree.CellRenderer {
        public MyTreeCellRenderer() {
            super(LabelTree.this);
        }

        @Override
        public JComponent getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JComponent result = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Icon labelIcon = null;
            if (this.getTreeNode() instanceof EntryNode) {
                TypeElement typeElement;
                TypeNode typeNode;
                Color color;
                EntryNode entryNode = (EntryNode)this.getTreeNode();
                LabelFilter.Entry entry = entryNode.getEntry();
                labelIcon = entryNode.getIcon();
                StringBuilder toolTipText = new StringBuilder();
                Set occurrences = LabelTree.this.getFilter().getJCells(entry);
                int count = occurrences == null ? 0 : occurrences.size();
                toolTipText.append(count);
                toolTipText.append(" occurrence");
                if (count != 1) {
                    toolTipText.append("s");
                }
                if (LabelTree.this.isFiltering()) {
                    if (toolTipText.length() != 0) {
                        toolTipText.append(HTMLConverter.HTML_LINEBREAK);
                    }
                    if (LabelTree.this.getFilter().isSelected(entry)) {
                        toolTipText.append("Visible label; doubleclick to filter");
                    } else {
                        toolTipText.append("Filtered label; doubleclick to show");
                    }
                }
                if (toolTipText.length() != 0) {
                    result.setToolTipText(HTMLConverter.HTML_TAG.on(toolTipText).toString());
                }
                if (entry instanceof TypeFilter.TypeEntry && (color = (typeNode = (typeElement = ((TypeFilter.TypeEntry)entry).getType()) instanceof TypeNode ? (TypeNode)typeElement : (TypeNode)((TypeEdge)typeElement).source()).getColor()) != null) {
                    this.getInner().setForeground(color);
                }
            }
            this.getInner().setIcon(labelIcon);
            return result;
        }
    }
}

