/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.gui.look.Line;
import groove.gui.look.LineFormat;
import java.awt.geom.Point2D;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MultiLabel {
    private final Map<Line, DirectBag> parts = new LinkedHashMap<Line, DirectBag>();
    private Direct direct = Direct.NONE;
    private static final String SP = "\u2009";
    private static final Line LA = Line.atom("\u25c2\u2009");
    private static final Line RA = Line.atom("\u2009\u25b8");
    private static final Line UAL = Line.atom("\u25b4\u2009");
    private static final Line DAL = Line.atom("\u25be\u2009");
    private static final Line UAR = Line.atom("\u2009\u25b4");
    private static final Line DAR = Line.atom("\u2009\u25be");

    public void add(Line line, Direct direct) {
        DirectBag dirs = this.parts.get(line);
        if (dirs == null) {
            dirs = DirectBag.ZERO;
        }
        switch (direct) {
            case FORWARD: {
                int backCount = dirs.get(Direct.BACKWARD);
                if (backCount <= 0) break;
                direct = Direct.BIDIRECTIONAL;
                dirs = dirs.dec(Direct.BACKWARD);
                break;
            }
            case BACKWARD: {
                int foreCount = dirs.get(Direct.FORWARD);
                if (foreCount <= 0) break;
                direct = Direct.BIDIRECTIONAL;
                dirs = dirs.dec(Direct.FORWARD);
            }
        }
        dirs = dirs.inc(direct);
        this.parts.put(line, dirs);
    }

    public void add(MultiLabel label) {
        for (Map.Entry<Line, DirectBag> entry : label.parts.entrySet()) {
            Line line = entry.getKey();
            DirectBag dirs = entry.getValue();
            DirectBag myDirs = this.parts.get(line);
            this.parts.put(line, myDirs == null ? dirs : myDirs.add(dirs));
        }
    }

    public Direct getDirect() {
        return this.direct;
    }

    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    public boolean isEmptyLine() {
        return this.parts.size() == 1 && this.parts.keySet().iterator().next().isEmpty();
    }

    public <R extends LineFormat.Builder<R>> StringBuilder toString(LineFormat<R> renderer, Point2D start, Point2D end) {
        R result = renderer.createResult();
        for (Map.Entry<Line, DirectBag> entry : this.parts.entrySet()) {
            Line line = entry.getKey();
            DirectBag dirBag = entry.getValue();
            Direct[] directArray = Direct.values();
            int n = directArray.length;
            int n2 = 0;
            while (n2 < n) {
                Direct dir = directArray[n2];
                int count = dirBag.get(dir);
                if (count > 0) {
                    if (!result.isEmpty()) {
                        result.appendLineBreak();
                    }
                    if (count > 1) {
                        String mult = "\u2009(" + count + ")";
                        line = line.append(mult);
                    }
                    if (start != null) {
                        Orient orient = dir.getOrient(start, end);
                        line = orient.decorate(line);
                    }
                    result.append(line.toString(renderer));
                }
                ++n2;
            }
        }
        return result.getResult();
    }

    public <R extends LineFormat.Builder<R>> StringBuilder toString(LineFormat<R> renderer) {
        return this.toString(renderer, null, null);
    }

    public String toString() {
        return this.parts.toString();
    }

    public static MultiLabel singleton(Line line, Direct direct) {
        MultiLabel result = new MultiLabel();
        if (line != null && !line.isEmpty()) {
            result.add(line, direct);
        }
        return result;
    }

    static /* synthetic */ Line access$0() {
        return LA;
    }

    static /* synthetic */ Line access$1() {
        return RA;
    }

    static /* synthetic */ Line access$2() {
        return UAL;
    }

    static /* synthetic */ Line access$3() {
        return DAR;
    }

    static /* synthetic */ Line access$4() {
        return DAL;
    }

    static /* synthetic */ Line access$5() {
        return UAR;
    }

    public static abstract class Direct
    extends Enum<Direct> {
        public static final /* enum */ Direct NONE = new Direct(){

            @Override
            public Orient getOrient(int dx, int dy) {
                return Orient.NONE;
            }
        };
        public static final /* enum */ Direct FORWARD = new Direct(){

            @Override
            public Orient getOrient(int dx, int dy) {
                if (Math.abs(dx) >= Math.abs(dy) * 3) {
                    return dx < 0 ? Orient.LEFT : Orient.RIGHT;
                }
                if (dy < 0) {
                    return dx <= 0 ? Orient.UP_LEFT : Orient.UP_RIGHT;
                }
                return dx < 0 ? Orient.DOWN_LEFT : Orient.DOWN_RIGHT;
            }
        };
        public static final /* enum */ Direct BACKWARD = new Direct(){

            @Override
            public Orient getOrient(int dx, int dy) {
                return FORWARD.getOrient(-dx, -dy);
            }
        };
        public static final /* enum */ Direct BIDIRECTIONAL = new Direct(){

            @Override
            public Orient getOrient(int dx, int dy) {
                if (Math.abs(dx) >= Math.abs(dy) * 3) {
                    return Orient.LEFT_RIGHT;
                }
                if (dy < 0) {
                    return Orient.UP_DOWN;
                }
                return Orient.DOWN_UP;
            }
        };
        private static final /* synthetic */ Direct[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Direct[]{NONE, FORWARD, BACKWARD, BIDIRECTIONAL};
        }

        public Direct union(Direct other) {
            Direct result;
            switch (this) {
                case BACKWARD: {
                    if (other == BACKWARD || other == BIDIRECTIONAL) {
                        result = BIDIRECTIONAL;
                        break;
                    }
                    result = this;
                    break;
                }
                case FORWARD: {
                    if (other == FORWARD || other == BIDIRECTIONAL) {
                        result = BIDIRECTIONAL;
                        break;
                    }
                    result = this;
                    break;
                }
                case NONE: {
                    result = other;
                    break;
                }
                case BIDIRECTIONAL: {
                    result = this;
                    break;
                }
                default: {
                    assert (false);
                    result = null;
                }
            }
            return result;
        }

        public abstract Orient getOrient(int var1, int var2);

        public Orient getOrient(Point2D start, Point2D end) {
            int dx = (int)(end.getX() - start.getX());
            int dy = (int)(end.getY() - start.getY());
            return this.getOrient(dx, dy);
        }

        public static Direct[] values() {
            Direct[] directArray = ENUM$VALUES;
            int n = directArray.length;
            Direct[] directArray2 = new Direct[n];
            System.arraycopy(ENUM$VALUES, 0, directArray2, 0, n);
            return directArray2;
        }

        public static Direct valueOf(String string) {
            return Enum.valueOf(Direct.class, string);
        }
    }

    private static class DirectBag {
        private final Map<Direct, Integer> values = new EnumMap<Direct, Integer>(Direct.class);
        private final Map<Direct, DirectBag> incMap = new EnumMap<Direct, DirectBag>(Direct.class);
        private final Map<Direct, DirectBag> decMap = new EnumMap<Direct, DirectBag>(Direct.class);
        private static final Map<DirectBag, DirectBag> pool = new HashMap<DirectBag, DirectBag>();
        public static final DirectBag ZERO = DirectBag.norm(new DirectBag());

        private DirectBag() {
            Direct[] directArray = Direct.values();
            int n = directArray.length;
            int n2 = 0;
            while (n2 < n) {
                Direct dir = directArray[n2];
                this.values.put(dir, 0);
                ++n2;
            }
        }

        private DirectBag(DirectBag orig) {
            this.values.putAll(orig.values);
        }

        public int get(Direct dir) {
            return this.values.get((Object)dir);
        }

        public DirectBag inc(Direct dir) {
            DirectBag result = this.incMap.get((Object)dir);
            if (result == null) {
                result = new DirectBag(this);
                result.values.put(dir, this.get(dir) + 1);
                result = DirectBag.norm(result);
                this.incMap.put(dir, result);
            }
            return result;
        }

        public DirectBag dec(Direct dir) {
            DirectBag result = this.decMap.get((Object)dir);
            if (result == null) {
                result = new DirectBag(this);
                result.values.put(dir, this.get(dir) - 1);
                result = DirectBag.norm(result);
                this.decMap.put(dir, result);
            }
            return result;
        }

        public DirectBag add(DirectBag other) {
            DirectBag result = new DirectBag();
            Direct[] directArray = Direct.values();
            int n = directArray.length;
            int n2 = 0;
            while (n2 < n) {
                Direct dir = directArray[n2];
                result.values.put(dir, this.get(dir) + other.get(dir));
                ++n2;
            }
            return DirectBag.norm(result);
        }

        public String toString() {
            return "DirectBag [" + this.values + "]";
        }

        public static DirectBag norm(DirectBag bag) {
            DirectBag result = pool.get(bag);
            if (result == null) {
                result = bag;
                pool.put(bag, result);
            }
            return bag;
        }
    }

    public static enum Orient {
        NONE(null, null),
        LEFT(MultiLabel.access$0(), null),
        RIGHT(null, MultiLabel.access$1()),
        LEFT_RIGHT(MultiLabel.access$0(), MultiLabel.access$1()),
        UP_DOWN(MultiLabel.access$2(), MultiLabel.access$3()),
        DOWN_UP(MultiLabel.access$4(), MultiLabel.access$5()),
        UP_LEFT(MultiLabel.access$2(), null),
        DOWN_LEFT(MultiLabel.access$4(), null),
        UP_RIGHT(null, MultiLabel.access$5()),
        DOWN_RIGHT(null, MultiLabel.access$3());

        private final Line left;
        private final Line right;

        private Orient(Line left, Line right) {
            this.left = left;
            this.right = right;
        }

        public Line decorate(Line line) {
            Line result = line;
            if (this.left != null) {
                result = this.left.append(result);
            }
            if (this.right != null) {
                result = result.append(this.right);
            }
            return result;
        }
    }
}

