/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.layout;

import groove.graph.Edge;
import groove.graph.Element;
import groove.graph.ElementMap;
import groove.graph.Node;
import groove.gui.layout.JCellLayout;
import groove.gui.layout.JEdgeLayout;
import groove.gui.layout.JVertexLayout;
import groove.gui.look.VisualMap;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.VertexView;

public class LayoutMap
implements Cloneable {
    private final Map<Node, JVertexLayout> nodeMap = new HashMap<Node, JVertexLayout>();
    private final Map<Edge, JEdgeLayout> edgeMap = new HashMap<Edge, JEdgeLayout>();

    public JVertexLayout getLayout(Node node) {
        return this.nodeMap.get(node);
    }

    public JEdgeLayout getLayout(Edge edge) {
        return this.edgeMap.get(edge);
    }

    public Map<Node, JVertexLayout> nodeMap() {
        return Collections.unmodifiableMap(this.nodeMap);
    }

    public Map<Edge, JEdgeLayout> edgeMap() {
        return Collections.unmodifiableMap(this.edgeMap);
    }

    public Map<Object, AttributeMap> toJAttrMap() {
        JCellLayout layout;
        HashMap<Object, AttributeMap> result = new HashMap<Object, AttributeMap>();
        for (Map.Entry<Node, JVertexLayout> entry : this.nodeMap().entrySet()) {
            layout = entry.getValue();
            result.put(entry.getKey(), layout.toJAttr());
        }
        for (Map.Entry<Element, JCellLayout> entry : this.edgeMap().entrySet()) {
            layout = entry.getValue();
            result.put(entry.getKey(), layout.toJAttr());
        }
        return result;
    }

    public JVertexLayout putNode(Node key, JVertexLayout layout) {
        if (!layout.isDefault()) {
            return this.nodeMap.put(key, layout);
        }
        return null;
    }

    public void putEdge(Edge key, JEdgeLayout layout) {
        if (layout.isDefault()) {
            this.edgeMap.remove(key);
        } else {
            this.edgeMap.put(key, layout);
        }
    }

    public void copyNodeWithOffset(Node newKey, Node oldKey, LayoutMap oldLayoutMap, double offsetX, double offsetY) {
        JVertexLayout oldLayout = oldLayoutMap.nodeMap.get(oldKey);
        if (oldLayout != null) {
            Rectangle2D oldBounds = oldLayout.getBounds();
            Rectangle2D.Double newBounds = new Rectangle2D.Double(oldBounds.getX() + offsetX, oldBounds.getY() + offsetY, oldBounds.getWidth(), oldBounds.getHeight());
            JVertexLayout newLayout = new JVertexLayout(newBounds);
            this.putNode(newKey, newLayout);
        }
    }

    public void copyEdgeWithOffset(Edge newKey, Edge oldKey, LayoutMap oldLayoutMap, double offsetX, double offsetY) {
        JEdgeLayout oldLayout = oldLayoutMap.edgeMap.get(oldKey);
        if (oldLayout != null) {
            List<Point2D> oldPoints = oldLayout.getPoints();
            ArrayList<Point2D> newPoints = new ArrayList<Point2D>();
            for (Point2D oldPoint : oldPoints) {
                newPoints.add(new Point2D.Double(oldPoint.getX() + offsetX, oldPoint.getY() + offsetY));
            }
            Point2D labelPosition = oldLayout.getLabelPosition();
            JEdgeLayout newLayout = new JEdgeLayout(newPoints, labelPosition, oldLayout.getLineStyle());
            this.putEdge(newKey, newLayout);
        }
    }

    public void putNode(Node key, VisualMap visuals) {
        this.putNode(key, JVertexLayout.newInstance(visuals));
    }

    public void putEdge(Edge key, VisualMap visuals) {
        this.putEdge(key, JEdgeLayout.newInstance(visuals));
    }

    public void putNode(Node key, AttributeMap jAttr) {
        this.putNode(key, JVertexLayout.newInstance(jAttr));
    }

    public void putEdge(Edge key, AttributeMap jAttr) {
        this.putEdge(key, JEdgeLayout.newInstance(jAttr));
    }

    public void load(LayoutMap other) {
        this.nodeMap.clear();
        this.nodeMap.putAll(other.nodeMap());
        this.edgeMap.clear();
        this.edgeMap.putAll(other.edgeMap());
    }

    public LayoutMap afterInverse(ElementMap other) {
        Element trafoValue;
        LayoutMap result = this.newInstance();
        for (Map.Entry<Node, JVertexLayout> entry : this.nodeMap().entrySet()) {
            trafoValue = other.getNode(entry.getKey());
            if (trafoValue == null) continue;
            result.putNode((Node)trafoValue, entry.getValue());
        }
        for (Map.Entry<Element, JCellLayout> entry : this.edgeMap().entrySet()) {
            trafoValue = other.getEdge((Edge)entry.getKey());
            if (trafoValue == null) continue;
            result.putEdge((Edge)trafoValue, (JEdgeLayout)entry.getValue());
        }
        return result;
    }

    public String toString() {
        return "LayoutMap [nodeMap=" + this.nodeMap() + ", edgeMap=" + this.edgeMap() + "]";
    }

    public LayoutMap clone() {
        LayoutMap result = this.newInstance();
        result.nodeMap.putAll(this.nodeMap());
        result.edgeMap.putAll(this.edgeMap());
        return result;
    }

    protected LayoutMap newInstance() {
        return new LayoutMap();
    }

    public static boolean isNode(Object key) {
        return key instanceof DefaultGraphCell && !(key instanceof DefaultEdge) || key instanceof VertexView || key instanceof Node;
    }

    public static Point2D toAbsPosition(List<Point2D> points, Point2D relPosition) {
        Rectangle bounds = LayoutMap.toBounds(points);
        Point2D source = points.get(0);
        Point2D target = points.get(points.size() - 1);
        bounds.add(target);
        int unit = 1000;
        int x0 = bounds.x;
        int xdir = 1;
        if (source.getX() > target.getX()) {
            x0 += bounds.width;
            xdir = -1;
        }
        int y0 = bounds.y;
        int ydir = 1;
        if (source.getY() > target.getY()) {
            y0 += bounds.height;
            ydir = -1;
        }
        double x = (double)x0 + (double)xdir * ((double)bounds.width * relPosition.getX() / (double)unit);
        double y = (double)y0 + (double)ydir * ((double)bounds.height * relPosition.getY() / (double)unit);
        return new Point2D.Double(x, y);
    }

    public static Rectangle toBounds(List<Point2D> points) {
        Rectangle bounds = new Rectangle();
        for (Point2D point : points) {
            bounds.add(point);
        }
        return bounds;
    }

    public static Point2D toRelPosition(List<Point2D> points, Point2D absPosition) {
        Rectangle bounds = LayoutMap.toBounds(points);
        Point2D source = points.get(0);
        Point2D target = points.get(points.size() - 1);
        bounds.add(target);
        int unit = 1000;
        int x0 = bounds.x;
        if (source.getX() > target.getX()) {
            x0 += bounds.width;
        }
        int y0 = bounds.y;
        if (source.getY() > target.getY()) {
            y0 += bounds.height;
        }
        double x = Math.abs((double)x0 - absPosition.getX()) * (double)unit / (double)bounds.width;
        double y = Math.abs((double)y0 - absPosition.getY()) * (double)unit / (double)bounds.height;
        return new Point2D.Double(x, y);
    }

    public static void main(String[] args) {
        LinkedList<Point2D> points = new LinkedList<Point2D>();
        Point relPosition1 = new Point(100, 900);
        Point relPosition2 = new Point(1200, 50);
        points.add(new Point(100, 200));
        points.add(new Point(150, 50));
        LayoutMap.testLabelPosition(points, JCellLayout.defaultLabelPosition);
        LayoutMap.testLabelPosition(points, relPosition1);
        LayoutMap.testLabelPosition(points, relPosition2);
        points.add(new Point(221, 100));
        LayoutMap.testLabelPosition(points, JCellLayout.defaultLabelPosition);
        LayoutMap.testLabelPosition(points, relPosition1);
        LayoutMap.testLabelPosition(points, relPosition2);
        points.add(new Point(0, 150));
        LayoutMap.testLabelPosition(points, JCellLayout.defaultLabelPosition);
        LayoutMap.testLabelPosition(points, relPosition1);
        LayoutMap.testLabelPosition(points, relPosition2);
        points.add(new Point(50, 0));
        LayoutMap.testLabelPosition(points, JCellLayout.defaultLabelPosition);
        LayoutMap.testLabelPosition(points, relPosition1);
        LayoutMap.testLabelPosition(points, relPosition2);
    }

    private static void testLabelPosition(List<Point2D> points, Point2D relPosition) {
        System.out.print("Abs, rel, abs: ");
        Point2D absPosition = LayoutMap.toAbsPosition(points, relPosition);
        System.out.print(absPosition + " ");
        relPosition = LayoutMap.toRelPosition(points, absPosition);
        System.out.print(relPosition + " ");
        absPosition = LayoutMap.toAbsPosition(points, relPosition);
        System.out.println(absPosition);
    }
}

