/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.layout;

import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JEdgeView;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JModel;
import groove.gui.layout.Layouter;
import groove.gui.look.VisualMap;
import groove.util.Pair;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.VertexView;

public abstract class AbstractLayouter
implements Layouter {
    private final String name;
    protected final JGraph<?> jgraph;
    protected JModel<?> jmodel;
    protected final Map<Object, Layoutable> toLayoutableMap = new LinkedHashMap<Object, Layoutable>();
    protected final Set<Layoutable> immovableSet = new HashSet<Layoutable>();

    protected AbstractLayouter(String name) {
        this(name, null);
    }

    protected AbstractLayouter(String name, JGraph<?> jgraph) {
        this.name = name;
        this.jgraph = jgraph;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void prepare() {
        CellView[] cellViews;
        this.jgraph.notifyProgress("Layouting");
        this.jmodel = this.jgraph.getModel();
        this.toLayoutableMap.clear();
        this.immovableSet.clear();
        CellView[] cellViewArray = cellViews = this.jgraph.getGraphLayoutCache().getRoots();
        int n = cellViews.length;
        int n2 = 0;
        while (n2 < n) {
            JCell jCell;
            CellView cellView = cellViewArray[n2];
            if (cellView.getCell() instanceof JCell && !(jCell = (JCell)cellView.getCell()).isGrayedOut()) {
                if (cellView instanceof JEdgeView) {
                    List<Point2D> points = ((JEdgeView)cellView).getCell().getVisuals().getPoints();
                    int p = 1;
                    while (p < points.size() - 1) {
                        Point2D point = points.get(p);
                        if (point instanceof Point2D) {
                            PointLayoutable layoutable = new PointLayoutable(point);
                            this.toLayoutableMap.put(Pair.newPair(jCell, p), layoutable);
                            if (!jCell.isLayoutable()) {
                                this.immovableSet.add(layoutable);
                            }
                        }
                        ++p;
                    }
                } else {
                    assert (cellView instanceof VertexView) : String.format("%s instance of %s", cellView, cellView.getClass());
                    VertexLayoutable layoutable = new VertexLayoutable((VertexView)cellView);
                    this.toLayoutableMap.put(jCell, layoutable);
                    if (!jCell.isLayoutable()) {
                        this.immovableSet.add(layoutable);
                    }
                }
            }
            ++n2;
        }
        this.jgraph.setToolTipEnabled(false);
    }

    protected void finish() {
        CellView[] cellViews;
        final HashMap<JCell, AttributeMap> change = new HashMap<JCell, AttributeMap>();
        CellView[] cellViewArray = cellViews = this.jgraph.getGraphLayoutCache().getRoots();
        int n = cellViews.length;
        int n2 = 0;
        while (n2 < n) {
            CellView view = cellViewArray[n2];
            if (view instanceof VertexView || view instanceof EdgeView) {
                JCell cell = (JCell)view.getCell();
                VisualMap visuals = new VisualMap();
                if (view instanceof VertexView) {
                    Rectangle2D bounds = ((VertexView)view).getCachedBounds();
                    visuals.setNodePos(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
                } else {
                    List<Point2D> points = ((JEdgeView)view).getCell().getVisuals().getPoints();
                    if (points != null) {
                        ArrayList<Point2D> newPoints = new ArrayList<Point2D>(points.size());
                        for (Point2D p : points) {
                            if (p instanceof CellView) {
                                Rectangle2D bounds = ((CellView)p).getBounds();
                                Point2D.Double point = new Point2D.Double();
                                ((Point2D)point).setLocation(bounds.getCenterX(), bounds.getCenterY());
                                newPoints.add(point);
                                continue;
                            }
                            newPoints.add(p);
                        }
                        visuals.setPoints(newPoints);
                    }
                }
                change.put(cell, visuals.getAttributes());
                cell.setLayoutable(false);
            }
            ++n2;
        }
        Runnable edit = new Runnable(){

            @Override
            public void run() {
                if (change.size() != 0) {
                    AbstractLayouter.this.jmodel.edit(change, null, null, null);
                }
                AbstractLayouter.this.jgraph.notifyProgress("");
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            edit.run();
        } else {
            SwingUtilities.invokeLater(edit);
        }
    }

    protected static interface Layoutable {
        public double getX();

        public double getY();

        public double getHeight();

        public double getWidth();

        public void setLocation(double var1, double var3);
    }

    protected static final class PointLayoutable
    implements Layoutable {
        private final Point2D p;

        public PointLayoutable(Point2D p) {
            this.p = p;
        }

        @Override
        public double getX() {
            return this.p.getX();
        }

        @Override
        public double getY() {
            return this.p.getY();
        }

        @Override
        public double getWidth() {
            return 0.0;
        }

        @Override
        public double getHeight() {
            return 0.0;
        }

        @Override
        public void setLocation(double x, double y) {
            this.p.setLocation(x, y);
        }

        public String toString() {
            return "PointLayoutable[x=" + this.getX() + ",y=" + this.getY() + "]";
        }
    }

    protected static final class VertexLayoutable
    implements Layoutable {
        private final Rectangle2D r;

        public VertexLayoutable(VertexView view) {
            this.r = view.getBounds();
        }

        @Override
        public double getX() {
            return this.r.getX();
        }

        @Override
        public double getY() {
            return this.r.getY();
        }

        @Override
        public double getWidth() {
            return this.r.getWidth();
        }

        @Override
        public double getHeight() {
            return this.r.getHeight();
        }

        @Override
        public void setLocation(double x, double y) {
            this.r.setRect(x, y, this.getWidth(), this.getHeight());
        }

        public String toString() {
            return "VertexLayoutable[x=" + this.getX() + ",y=" + this.getY() + ",width=" + this.getWidth() + ",height=" + this.getHeight() + "]";
        }
    }
}

