/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.gui.Icons;
import groove.gui.Options;
import java.awt.Cursor;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public enum JGraphMode {
    SELECT_MODE("Selection mode", Options.SELECT_MODE_KEY, Icons.SELECT_ICON),
    PAN_MODE("Pan and Zoom mode", Options.PAN_MODE_KEY, Icons.HAND_OPEN_ICON, Icons.HAND_OPEN_CURSOR, Icons.HAND_CLOSED_CURSOR),
    EDIT_MODE("Edit mode", Options.EDIT_MODE_KEY, Icons.EDGE_ICON),
    PREVIEW_MODE("Preview mode", Options.PREVIEW_MODE_KEY, Icons.PREVIEW_ICON);

    private final String text;
    private final KeyStroke acceleratorKey;
    private final ImageIcon icon;
    private final Cursor cursor;
    private final Cursor dragCursor;

    private JGraphMode(String text, KeyStroke acceleratorKey, ImageIcon icon, Cursor moveCursor, Cursor dragCursor) {
        this.text = text;
        this.acceleratorKey = acceleratorKey;
        this.icon = icon;
        this.cursor = moveCursor;
        this.dragCursor = dragCursor;
    }

    private JGraphMode(String text, KeyStroke acceleratorKey, ImageIcon icon) {
        this(text, acceleratorKey, icon, Cursor.getDefaultCursor(), Cursor.getPredefinedCursor(1));
    }

    public final String getName() {
        return this.text;
    }

    public final KeyStroke getAcceleratorKey() {
        return this.acceleratorKey;
    }

    public final ImageIcon getIcon() {
        return this.icon;
    }

    public final Cursor getCursor() {
        return this.cursor;
    }

    public final Cursor getDragCursor() {
        return this.dragCursor;
    }
}

