/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.gui.jgraph.JCell;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class JGraphLayoutCache
extends GraphLayoutCache {
    JGraphLayoutCache(CellViewFactory viewFactory) {
        super(null, viewFactory, true);
        this.setSelectsLocalInsertedCells(false);
        this.setShowsExistingConnections(false);
        this.setShowsChangedConnections(false);
        this.setShowsInsertedConnections(false);
        this.setHidesExistingConnections(false);
        this.setHidesDanglingConnections(false);
    }

    public void setModel(GraphModel model) {
        this.partial = false;
        super.setModel(model);
        this.partial = true;
    }

    public boolean isVisible(Object cell) {
        if (cell instanceof JCell) {
            return ((JCell)cell).getVisuals().isVisible();
        }
        if (cell instanceof DefaultPort) {
            return this.isVisible(((DefaultPort)cell).getParent());
        }
        return super.isVisible(cell);
    }

    protected void reloadRoots() {
        Object[] orderedCells = DefaultGraphModel.getAll((GraphModel)this.graphModel);
        ArrayList<CellView> newRoots = new ArrayList<CellView>();
        Object[] objectArray = orderedCells;
        int n = orderedCells.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            CellView view = this.getMapping(element, true);
            if (view != null && view.getParentView() == null) {
                newRoots.add(view);
            }
            ++n2;
        }
        this.roots = newRoots;
    }

    public synchronized void reload() {
        ArrayList<CellView> newRoots = new ArrayList<CellView>();
        Hashtable oldMapping = new Hashtable(this.mapping);
        this.mapping.clear();
        HashSet rootsSet = new HashSet(this.roots);
        for (Map.Entry entry : oldMapping.entrySet()) {
            Object cell = entry.getKey();
            CellView oldView = (CellView)entry.getValue();
            CellView newView = this.getMapping(cell, true);
            if (newView == null) continue;
            newView.changeAttributes((GraphLayoutCache)this, (Map)oldView.getAttributes());
            if (!rootsSet.contains(oldView)) continue;
            newRoots.add(newView);
        }
        this.hiddenMapping.clear();
        this.roots = newRoots;
    }

    public void updatePorts() {
        super.updatePorts();
    }
}

