/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.grammar.GrammarProperties;
import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorModel;
import groove.gui.action.ActionStore;
import groove.gui.action.ExportAction;
import groove.gui.action.LayoutAction;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JCellViewFactory;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JEdgeView;
import groove.gui.jgraph.JGraphFactory;
import groove.gui.jgraph.JGraphLayoutCache;
import groove.gui.jgraph.JGraphMode;
import groove.gui.jgraph.JGraphUI;
import groove.gui.jgraph.JModel;
import groove.gui.jgraph.JVertex;
import groove.gui.layout.ForestLayouter;
import groove.gui.layout.Layouter;
import groove.gui.layout.SpringLayouter;
import groove.gui.look.MultiLabel;
import groove.gui.look.VisualKey;
import groove.gui.look.VisualMap;
import groove.gui.look.VisualValue;
import groove.gui.menu.MyJMenu;
import groove.gui.menu.SetLayoutMenu;
import groove.gui.menu.ShowHideMenu;
import groove.gui.menu.ZoomMenu;
import groove.gui.tree.LabelTree;
import groove.lts.GTS;
import groove.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public abstract class JGraph<G extends Graph>
extends org.jgraph.JGraph {
    private final List<Pair<JMenuItem, RefreshListener>> optionListeners = new LinkedList<Pair<JMenuItem, RefreshListener>>();
    private RefreshListener refreshListener;
    private final Observable progressObservable;
    private JGraphFactory<G> factory;
    private SetLayoutMenu setLayoutMenu;
    private Map<JGraphMode, Action> modeActionMap;
    private Map<JGraphMode, JToggleButton> modeButtonMap;
    private boolean layouting;
    private final Map<VisualKey, VisualValue<?>> visualValueMap = new EnumMap(VisualKey.class);
    private final Simulator simulator;
    private final Options options;
    private JGraphMode mode;
    private CancelEditListener cancelListener;
    private boolean modelRefreshing;
    private LabelTree<G> labelTree;
    private Layouter layouter;
    private ExportAction exportAction;
    private LayoutAction layoutAction;
    private Color enabledBackground;
    private boolean toolTipEnabled;
    private final Layouter incrementalLayouter = new SpringLayouter().newInstance(this);
    public static final float ZOOM_FACTOR = 1.4f;
    public static final String JGRAPH_MODE_PROPERTY = "JGraphMode";
    public static final String CELL_EDIT_PROPERTY = "editedCell";

    protected JGraph(Simulator simulator) {
        super(null);
        this.simulator = simulator;
        this.options = simulator == null ? new Options() : simulator.getOptions();
        this.progressObservable = new Observable(){

            @Override
            public void notifyObservers(Object arg) {
                this.setChanged();
                super.notifyObservers(arg);
            }
        };
        this.getGraphLayoutCache().setSelectsAllInsertedCells(false);
        this.setMarqueeHandler(this.createMarqueeHandler());
        this.setPortsVisible(false);
        this.setInvokesStopCellEditing(true);
        this.setEditable(false);
        this.setConnectable(false);
        this.setDisconnectable(false);
        this.installListeners();
    }

    protected void installListeners() {
        this.addMouseListener(new MyMouseListener());
        this.addKeyListener(this.getCancelEditListener());
        this.getSelectionModel().addGraphSelectionListener((GraphSelectionListener)new MyGraphSelectionListener());
        this.addOptionListener("Show node identities");
        this.addOptionListener("Show all unfiltered edges");
        this.addOptionListener("Show anchors");
        this.addOptionListener("Show arrows on labels");
        this.addOptionListener("Show bidirectional edges");
    }

    public void removeListeners() {
        this.getActions().removeRefreshable(this.getExportAction());
        for (Pair<JMenuItem, RefreshListener> record : this.optionListeners) {
            record.one().removeItemListener(record.two());
            record.one().removePropertyChangeListener(record.two());
        }
        this.optionListeners.clear();
        this.exportAction = null;
    }

    public GraphRole getGraphRole() {
        return GraphRole.NONE;
    }

    public final Options getOptions() {
        return this.options;
    }

    public boolean getOptionValue(String option) {
        return this.getOptions().getItem(option).isEnabled() && this.getOptions().isSelected(option);
    }

    public void addOptionListener(String option) {
        JMenuItem optionItem = this.getOptions().getItem(option);
        if (optionItem == null) {
            throw new IllegalArgumentException(String.format("Unknown option: %s", option));
        }
        RefreshListener listener = this.getRefreshListener(option);
        if (listener != null) {
            optionItem.addItemListener(listener);
            optionItem.addPropertyChangeListener(listener);
            this.optionListeners.add(Pair.newPair(optionItem, listener));
        }
    }

    protected RefreshListener getRefreshListener(String option) {
        if (this.refreshListener == null) {
            this.refreshListener = new RefreshListener();
        }
        return this.refreshListener;
    }

    public boolean isShowNodeIdentities() {
        return this.getOptionValue("Show node identities");
    }

    public boolean isShowUnfilteredEdges() {
        return this.getOptionValue("Show all unfiltered edges");
    }

    public boolean isShowAnchors() {
        return this.getOptionValue("Show anchors");
    }

    public boolean isShowLoopsAsNodeLabels() {
        return this.getProperties() == null || this.getProperties().isShowLoopsAsLabels();
    }

    public boolean isShowArrowsOnLabels() {
        return this.getOptionValue("Show arrows on labels");
    }

    public boolean isShowBidirectionalEdges() {
        return this.getOptionValue("Show bidirectional edges");
    }

    private Simulator getSimulator() {
        return this.simulator;
    }

    public final SimulatorModel getSimulatorModel() {
        return this.getSimulator() == null ? null : this.getSimulator().getModel();
    }

    public final ActionStore getActions() {
        return this.getSimulator() == null ? null : this.getSimulator().getActions();
    }

    private GrammarProperties getProperties() {
        return this.getSimulatorModel() == null ? null : this.getSimulatorModel().getGrammar().getProperties();
    }

    public void addProgressObserver(Observer observer) {
        this.progressObservable.addObserver(observer);
    }

    public void removeProgressObserver(Observer observer) {
        this.progressObservable.deleteObserver(observer);
    }

    public void notifyProgress(String message) {
        this.progressObservable.notifyObservers(message);
    }

    public String convertValueToString(Object value) {
        String result = null;
        if (value instanceof String) {
            result = (String)value;
        } else if (value instanceof JVertex) {
            MultiLabel label = ((JVertex)value).getVisuals().getLabel();
            result = label.toString();
        } else if (value instanceof JEdgeView) {
            MultiLabel label = ((JEdgeView)((Object)value)).getCell().getVisuals().getLabel();
            result = label.toString();
        }
        if (result == null || result.length() == 0) {
            result = " ";
        }
        return result;
    }

    public String getToolTipText(MouseEvent evt) {
        Object jCell = this.getFirstCellForLocation(evt.getX(), evt.getY());
        if (jCell != null && jCell.getVisuals().isVisible()) {
            return jCell.getToolTipText();
        }
        return null;
    }

    public boolean isCellEditable(Object cell) {
        return (!(cell instanceof JCell) || !((JCell)cell).isGrayedOut()) && super.isCellEditable(cell);
    }

    public Object[] getDescendants(Object[] cells) {
        LinkedList<Object> res = new LinkedList<Object>();
        Object[] objectArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            res.add(element);
            if (element instanceof DefaultGraphCell && ((DefaultGraphCell)element).getChildCount() > 0) {
                res.add(((DefaultGraphCell)element).getChildAt(0));
            }
            ++n2;
        }
        return res.toArray();
    }

    public void updateAutoSize(CellView view) {
        if (view != null && !this.isEditing()) {
            Rectangle2D bounds = view.getAttributes() != null ? GraphConstants.getBounds((Map)view.getAttributes()) : null;
            AttributeMap attrs = this.getModel().getAttributes(view.getCell());
            if (bounds == null) {
                bounds = GraphConstants.getBounds((Map)attrs);
            }
            if (bounds != null) {
                boolean autosize = GraphConstants.isAutoSize((Map)view.getAllAttributes());
                boolean resize = GraphConstants.isResize((Map)view.getAllAttributes());
                if (autosize || resize) {
                    Dimension2D d = this.getUI().getPreferredSize(this, view);
                    double shiftX = (bounds.getWidth() - d.getWidth()) / 2.0;
                    double shiftY = (bounds.getHeight() - d.getHeight()) / 2.0;
                    bounds.setFrame(bounds.getX() + shiftX, bounds.getY() + shiftY, d.getWidth(), d.getHeight());
                    this.snap(bounds);
                    if (resize) {
                        if (view.getAttributes() != null) {
                            view.getAttributes().remove((Object)"resize");
                        }
                        attrs.remove((Object)"resize");
                    }
                    view.refresh((GraphLayoutCache)this.getGraphLayoutCache(), (CellMapper)this.getGraphLayoutCache(), false);
                }
            }
        }
    }

    public Rectangle2D getGraphBounds() {
        return this.getCellBounds(this.getRoots());
    }

    public void refreshCells(Collection<? extends JCell<G>> jCellSet) {
        if (!jCellSet.isEmpty()) {
            Rectangle2D scope;
            JGraphLayoutCache cache = this.getGraphLayoutCache();
            HashSet<JCell<G>> visibleCells = new HashSet<JCell<G>>(jCellSet.size());
            HashSet<JCell<G>> hiddenCells = new HashSet<JCell<G>>(jCellSet.size());
            for (JCell<G> jCell : jCellSet) {
                HashSet<JCell<G>> changeCells;
                CellView jView = cache.getMapping(jCell, false);
                boolean wasVisible = jView != null;
                boolean isVisible = jCell.getVisuals().isVisible();
                HashSet<JCell<G>> hashSet = changeCells = wasVisible ? hiddenCells : visibleCells;
                if (isVisible != wasVisible) {
                    changeCells.add(jCell);
                    for (JCell<G> c : jCell.getContext()) {
                        if (c.getVisuals().isVisible() == wasVisible) continue;
                        changeCells.add(c);
                    }
                }
                if (!isVisible) continue;
                visibleCells.add(jCell);
            }
            this.modelRefreshing = true;
            Object[] visibleArray = visibleCells.toArray();
            Object[] hiddenArray = hiddenCells.toArray();
            this.getSelectionModel().removeSelectionCells(hiddenArray);
            boolean selectsInsertedCells = cache.isSelectsLocalInsertedCells();
            cache.setSelectsLocalInsertedCells(false);
            cache.setVisible(visibleArray, hiddenArray);
            cache.setSelectsLocalInsertedCells(selectsInsertedCells);
            if (this.getSelectionCount() > 0 && (scope = (Rectangle2D)this.getCellBounds(this.getSelectionCells()).clone()) != null) {
                this.scrollRectToVisible(this.toScreen(scope).getBounds());
            }
            this.modelRefreshing = false;
        }
    }

    public void refreshAllCells() {
        if (this.getModel() != null) {
            this.refreshCells(this.getModel().getRoots());
        }
    }

    public void changeGrayedOut(Set<JCell<G>> jCells, boolean grayedOut) {
        HashSet<JCell<G>> changedJCells = new HashSet<JCell<G>>();
        for (JCell<G> jCell : jCells) {
            if (!jCell.setGrayedOut(grayedOut)) continue;
            changedJCells.add(jCell);
            if (grayedOut && jCell instanceof JVertex) {
                for (JCell<G> c : jCell.getContext()) {
                    if (!c.setGrayedOut(true)) continue;
                    changedJCells.add(c);
                }
                continue;
            }
            if (grayedOut || !(jCell instanceof JEdge)) continue;
            for (JCell<G> c : jCell.getContext()) {
                if (!c.setGrayedOut(false)) continue;
                changedJCells.add(c);
            }
        }
        this.getModel().toBackSilent(changedJCells);
        this.refreshCells(changedJCells);
    }

    public boolean isModelRefreshing() {
        return this.modelRefreshing;
    }

    protected JCell<G> getFirstCellForLocation(double x, double y, boolean vertex, boolean edge) {
        JCell result = null;
        Rectangle xyArea = new Rectangle((int)((x /= this.scale) - 2.0), (int)((y /= this.scale) - 2.0), 4, 4);
        CellView[] viewRoots = this.graphLayoutCache.getRoots();
        int i = viewRoots.length - 1;
        while (result == null && i >= 0) {
            CellView jCellView = viewRoots[i];
            if (jCellView.getCell() instanceof JCell) {
                boolean typeCorrect;
                JCell jCell = (JCell)jCellView.getCell();
                boolean bl = vertex ? jCell instanceof JVertex : (typeCorrect = edge ? jCell instanceof JEdge : true);
                if (typeCorrect && !jCell.isGrayedOut() && jCellView.intersects((org.jgraph.JGraph)this, (Rectangle2D)xyArea)) {
                    result = jCell;
                }
            }
            --i;
        }
        return result;
    }

    public JCell<G> getFirstCellForLocation(double x, double y) {
        return this.getFirstCellForLocation(x, y, false, false);
    }

    public PortView getPortViewAt(double x, double y) {
        JVertex vertex = (JVertex)this.getFirstCellForLocation(x, y, true, false);
        if (vertex != null) {
            return (PortView)this.getGraphLayoutCache().getMapping(vertex.getPort(), false);
        }
        return null;
    }

    public void setModel(GraphModel model) {
        if (model == null || model instanceof JModel) {
            JModel<G> oldJModel = this.getModel();
            JModel newJModel = (JModel)model;
            if (oldJModel != null) {
                this.clearSelection();
                oldJModel.removeGraphModelListener(this.getCancelEditListener());
            }
            if (newJModel != null) {
                newJModel.refreshVisuals();
            }
            super.setModel((GraphModel)newJModel);
            if (newJModel != null) {
                this.setName(newJModel.getName());
            }
            if (newJModel != null) {
                this.doLayout(false);
            }
            if (newJModel != null) {
                newJModel.addGraphModelListener(this.getCancelEditListener());
            }
            this.setEnabled(newJModel != null);
            if (newJModel != null && this.getActions() != null) {
                this.createPopupMenu(null);
            }
        }
    }

    public JModel<G> getModel() {
        return (JModel)this.graphModel;
    }

    public JModel<G> newModel() {
        return this.getFactory().newModel();
    }

    public final JGraphFactory<G> getFactory() {
        if (this.factory == null) {
            this.factory = this.createFactory();
        }
        return this.factory;
    }

    public final void setFactory(JGraphFactory<G> factory) {
        assert (this.factory == null);
        this.factory = factory;
    }

    protected abstract JGraphFactory<G> createFactory();

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            if (!enabled) {
                this.enabledBackground = this.getBackground();
                this.setBackground(null);
            } else if (this.enabledBackground != null) {
                this.setBackground(this.enabledBackground);
            }
            if (this.getLabelTree() != null) {
                this.getLabelTree().setEnabled(enabled);
            }
            for (JToggleButton button : this.getModeButtonMap().values()) {
                button.setEnabled(enabled);
            }
            this.getModeButton(this.getDefaultMode()).setSelected(true);
            this.getLayoutAction();
            super.setEnabled(enabled);
        }
    }

    public void updateUI() {
        BasicGraphUI ui = this.createGraphUI();
        this.setUI((GraphUI)ui);
        this.invalidate();
    }

    protected BasicGraphUI createGraphUI() {
        return new JGraphUI();
    }

    public JGraphUI<GTS> getUI() {
        return (JGraphUI)super.getUI();
    }

    protected JViewport getViewPort() {
        JViewport result = null;
        Object parent = this;
        while (parent != null) {
            if (parent instanceof JViewport) {
                result = (JViewport)parent;
                break;
            }
            parent = ((Component)parent).getParent();
        }
        return result;
    }

    protected JFrame getFrame() {
        JFrame result = null;
        Object parent = this;
        while (parent != null) {
            if (parent instanceof JFrame) {
                result = (JFrame)parent;
                break;
            }
            parent = ((Component)parent).getParent();
        }
        return result;
    }

    public BufferedImage toImage() {
        Rectangle2D bounds = this.getGraphBounds();
        if (bounds != null) {
            this.toScreen(bounds);
            int extraSpace = 5;
            BufferedImage img = new BufferedImage((int)bounds.getWidth() + 2 * extraSpace, (int)bounds.getHeight() + 2 * extraSpace, 1);
            final Graphics2D graphics = img.createGraphics();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, img.getWidth(), img.getHeight());
            graphics.translate(-bounds.getX() + (double)extraSpace, -bounds.getY() + (double)extraSpace);
            Object[] selection = this.getSelectionCells();
            boolean gridVisible = this.isGridVisible();
            this.setGridVisible(false);
            this.clearSelection();
            Runnable paint = new Runnable(){

                @Override
                public void run() {
                    JGraph.this.paint(graphics);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                paint.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(paint);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            this.setSelectionCells(selection);
            this.setGridVisible(gridVisible);
            return img;
        }
        return null;
    }

    public Layouter getLayouter() {
        if (this.layouter == null) {
            this.layouter = this.createLayouter().newInstance(this);
        }
        return this.layouter;
    }

    protected Layouter createLayouter() {
        return new ForestLayouter();
    }

    public void setLayouter(Layouter prototypeLayouter) {
        this.layouter = prototypeLayouter.newInstance(this);
    }

    public Layouter doLayout(boolean complete) {
        Layouter result = null;
        boolean any = complete;
        if (!any) {
            for (JCell<G> jCell : this.getModel().getRoots()) {
                if (!jCell.isLayoutable()) continue;
                any = true;
                break;
            }
        }
        if (any) {
            if (complete) {
                this.getModel().setLayoutable(true);
                result = this.getLayouter();
            } else {
                result = this.incrementalLayouter;
            }
            result.start();
        }
        return result;
    }

    public void addJGraphModeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(JGRAPH_MODE_PROPERTY, listener);
    }

    public void removeJGraphModeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(JGRAPH_MODE_PROPERTY, listener);
    }

    public boolean setMode(JGraphMode mode) {
        boolean result;
        JGraphMode oldMode = this.mode;
        boolean bl = result = mode != oldMode;
        if (result) {
            this.mode = mode;
            if (mode == JGraphMode.EDIT_MODE) {
                this.clearSelection();
            }
            this.stopEditing();
            this.getModeButton(mode).setSelected(true);
            this.setCursor(mode.getCursor());
            this.firePropertyChange(JGRAPH_MODE_PROPERTY, (Object)oldMode, (Object)mode);
        }
        return result;
    }

    public JGraphMode getMode() {
        if (this.mode == null) {
            this.mode = this.getDefaultMode();
        }
        return this.mode;
    }

    protected JGraphMode getDefaultMode() {
        return JGraphMode.SELECT_MODE;
    }

    public boolean getToolTipEnabled() {
        return this.toolTipEnabled;
    }

    public void setToolTipEnabled(boolean enabled) {
        if (enabled) {
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        } else {
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)((Object)this));
        }
        this.toolTipEnabled = enabled;
    }

    public void setLabelTree(LabelTree<G> labelTree) {
        this.labelTree = labelTree;
    }

    public LabelTree<G> getLabelTree() {
        return this.labelTree;
    }

    public void zoomTo(Rectangle2D bounds) {
        Rectangle2D viewBounds = this.getViewPortBounds();
        double widthScale = viewBounds.getWidth() / bounds.getWidth();
        double heightScale = viewBounds.getHeight() / bounds.getHeight();
        double scale = Math.min(widthScale, heightScale);
        double oldScale = this.getScale();
        this.setScale(oldScale * scale);
        int newX = (int)(bounds.getX() * scale);
        int newY = (int)(bounds.getY() * scale);
        int newWidth = (int)(scale * bounds.getWidth());
        int newHeight = (int)(scale * bounds.getHeight());
        Rectangle newBounds = new Rectangle(newX, newY, newWidth, newHeight);
        this.scrollRectToVisible(newBounds);
    }

    public void scrollRectToVisible(Rectangle aRect) {
        Rectangle viewBounds = this.getViewPortBounds().getBounds();
        if (!viewBounds.contains(aRect)) {
            int newX = aRect.x - (viewBounds.width - aRect.width) / 2;
            int newY = aRect.y - (viewBounds.height - aRect.height) / 2;
            Rectangle newRect = new Rectangle(newX, newY, viewBounds.width, viewBounds.height);
            super.scrollRectToVisible(newRect);
        }
    }

    public ExportAction getExportAction() {
        if (this.exportAction == null) {
            this.exportAction = new ExportAction(this);
        }
        this.exportAction.refresh();
        return this.exportAction;
    }

    public LayoutAction getLayoutAction() {
        if (this.layoutAction == null) {
            this.layoutAction = new LayoutAction(this);
            this.addAccelerator(this.layoutAction);
        }
        return this.layoutAction;
    }

    public JGraphLayoutCache getGraphLayoutCache() {
        JGraphLayoutCache result;
        GraphLayoutCache superCache = super.getGraphLayoutCache();
        if (superCache instanceof JGraphLayoutCache) {
            result = (JGraphLayoutCache)superCache;
        } else {
            result = this.createGraphLayoutCache();
            if (this.getModel() != null) {
                result.setModel((GraphModel)this.getModel());
            }
            this.setGraphLayoutCache(result);
        }
        return result;
    }

    protected JGraphLayoutCache createGraphLayoutCache() {
        return new JGraphLayoutCache((CellViewFactory)this.createViewFactory());
    }

    protected JCellViewFactory createViewFactory() {
        return new JCellViewFactory(this);
    }

    protected BasicMarqueeHandler createMarqueeHandler() {
        return new BasicMarqueeHandler(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() != 3) {
                    super.mousePressed(evt);
                }
            }
        };
    }

    public void changeScale(int change) {
        double scale = this.getScale();
        this.setScale(scale *= Math.pow(1.4f, change));
    }

    protected void maybeShowPopup(MouseEvent evt) {
        if (this.isPopupMenuEvent(evt) && this.getActions() != null) {
            this.getUI().cancelEdgeAdding();
            Point atPoint = evt.getPoint();
            this.createPopupMenu(atPoint).getPopupMenu().show((Component)((Object)this), atPoint.x, atPoint.y);
        }
    }

    protected boolean isPopupMenuEvent(MouseEvent evt) {
        return evt.isPopupTrigger() && !evt.isControlDown();
    }

    public JMenu createPopupMenu(Point atPoint) {
        MyJMenu result = new MyJMenu("Popup");
        result.addSubmenu(this.createExportMenu());
        result.addSubmenu(this.createDisplayMenu());
        result.addSubmenu(this.getLayoutMenu());
        return result;
    }

    public JMenu createExportMenu() {
        JMenu result = new JMenu("Export");
        result.add(this.getExportAction());
        return result;
    }

    public JMenu createDisplayMenu() {
        Action filterAction;
        LabelTree<G> labelTree;
        JMenu result = new JMenu("Display");
        Object[] cells = this.getSelectionCells();
        boolean itemAdded = false;
        if (cells != null && cells.length > 0 && this.getActions() != null) {
            result.add(this.getActions().getFindReplaceAction());
            if (this.getActions().getSelectColorAction().isEnabled()) {
                result.add(this.getActions().getSelectColorAction());
            }
            itemAdded = true;
        }
        if ((labelTree = this.getLabelTree()) != null && cells != null && cells.length > 0 && (filterAction = labelTree.createFilterAction(cells)) != null) {
            result.add(filterAction);
            itemAdded = true;
        }
        if (itemAdded) {
            result.addSeparator();
        }
        result.add(this.getModeAction(JGraphMode.SELECT_MODE));
        result.add(this.getModeAction(JGraphMode.PAN_MODE));
        result.add(this.createShowHideMenu());
        result.add(this.createZoomMenu());
        return result;
    }

    public SetLayoutMenu getSetLayoutMenu() {
        if (this.setLayoutMenu == null) {
            this.setLayoutMenu = this.createSetLayoutMenu();
        }
        return this.setLayoutMenu;
    }

    public SetLayoutMenu createSetLayoutMenu() {
        return new SetLayoutMenu(this);
    }

    public JMenu getLayoutMenu() {
        JMenu result = new JMenu("Layout");
        result.add(this.getSetLayoutMenu().getCurrentLayoutItem());
        result.add(this.getSetLayoutMenu());
        result.add(this.getShowLayoutDialogAction());
        return result;
    }

    public ZoomMenu createZoomMenu() {
        return new ZoomMenu(this);
    }

    public ShowHideMenu<G> createShowHideMenu() {
        return new ShowHideMenu(this);
    }

    private Action getShowLayoutDialogAction() {
        return this.getActions().getLayoutDialogAction();
    }

    public void addAccelerator(Action action) {
        Object actionName = action.getValue("Name");
        KeyStroke actionKey = (KeyStroke)action.getValue("AcceleratorKey");
        if (actionName != null && actionKey != null) {
            ActionMap am = this.getActionMap();
            am.put(actionName, action);
            InputMap im = this.getInputMap(2);
            im.put(actionKey, actionName);
            im = this.getInputMap(1);
            im.put(actionKey, actionName);
        }
    }

    public Action getModeAction(JGraphMode mode) {
        if (this.modeActionMap == null) {
            this.modeActionMap = new EnumMap<JGraphMode, Action>(JGraphMode.class);
            JGraphMode[] jGraphModeArray = JGraphMode.values();
            int n = jGraphModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                final JGraphMode any = jGraphModeArray[n2];
                AbstractAction action = new AbstractAction(any.getName(), any.getIcon()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JGraph.this.setMode(any);
                    }
                };
                if (any.getAcceleratorKey() != null) {
                    action.putValue("AcceleratorKey", any.getAcceleratorKey());
                    this.addAccelerator(action);
                }
                this.modeActionMap.put(any, action);
                ++n2;
            }
        }
        return this.modeActionMap.get((Object)mode);
    }

    public JToggleButton getModeButton(JGraphMode mode) {
        return this.getModeButtonMap().get((Object)mode);
    }

    private Map<JGraphMode, JToggleButton> getModeButtonMap() {
        if (this.modeButtonMap == null) {
            this.modeButtonMap = new EnumMap<JGraphMode, JToggleButton>(JGraphMode.class);
            ButtonGroup modeButtonGroup = new ButtonGroup();
            JGraphMode[] jGraphModeArray = JGraphMode.values();
            int n = jGraphModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                JGraphMode any = jGraphModeArray[n2];
                JToggleButton button = new JToggleButton(this.getModeAction(any));
                Options.setLAF(button);
                button.setToolTipText(any.getName());
                button.setEnabled(this.isEnabled());
                this.modeButtonMap.put(any, button);
                modeButtonGroup.add(button);
                ++n2;
            }
            this.modeButtonMap.get((Object)JGraphMode.EDIT_MODE).setSelected(true);
        }
        return this.modeButtonMap;
    }

    public void startEditingAtCell(Object cell) {
        this.firePropertyChange(CELL_EDIT_PROPERTY, null, cell);
        this.getUI().cancelEdgeAdding();
        super.startEditingAtCell(cell);
    }

    private CancelEditListener getCancelEditListener() {
        if (this.cancelListener == null) {
            this.cancelListener = new CancelEditListener();
        }
        return this.cancelListener;
    }

    public void clearAllEdgePoints() {
        HashMap<JCell<G>, AttributeMap> change = new HashMap<JCell<G>, AttributeMap>();
        for (JCell<G> jCell : this.getModel().getRoots()) {
            if (!(jCell instanceof JEdge)) continue;
            VisualMap visuals = jCell.getVisuals();
            List<Point2D> points = visuals.getPoints();
            visuals.setPoints(Arrays.asList(points.get(0), points.get(points.size() - 1)));
            change.put(jCell, visuals.getAttributes());
        }
        this.getModel().edit(change, null, null, null);
    }

    public void setLayouting(boolean layouting) {
        this.layouting = layouting;
    }

    public boolean isLayouting() {
        return this.layouting;
    }

    protected final void setVisualValue(VisualKey key, VisualValue<?> value) {
        this.visualValueMap.put(key, value);
    }

    public final VisualValue<?> getVisualValue(VisualKey key) {
        VisualValue<?> result = this.visualValueMap.get((Object)key);
        if (result == null) {
            result = this.getFactory().newVisualValue(key);
            this.visualValueMap.put(key, result);
        }
        return result;
    }

    public static interface AttributeFactory {
        public AttributeMap getAttributes(Node var1);

        public AttributeMap getAttributes(Edge var1);
    }

    private final class CancelEditListener
    extends KeyAdapter
    implements GraphModelListener {
        private CancelEditListener() {
        }

        public void graphChanged(GraphModelEvent e) {
            JGraph.this.getUI().cancelEdgeAdding();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == Options.CANCEL_KEY.getKeyCode()) {
                JGraph.this.getUI().cancelEdgeAdding();
            }
        }
    }

    private class MyGraphSelectionListener
    implements GraphSelectionListener {
        private MyGraphSelectionListener() {
        }

        public void valueChanged(GraphSelectionEvent e) {
            Object[] cells = e.getCells();
            int i = 0;
            while (i < cells.length) {
                Object c = cells[i];
                if (c instanceof JCell) {
                    JCell jCell = (JCell)c;
                    jCell.putVisual(VisualKey.EMPHASIS, e.isAddedCell(i));
                }
                ++i;
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            JGraph.this.maybeShowPopup(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            JGraph.this.maybeShowPopup(evt);
        }
    }

    protected class RefreshListener
    implements ItemListener,
    PropertyChangeListener {
        protected RefreshListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (JGraph.this.isEnabled()) {
                this.doRefresh();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(AccessibleState.ENABLED.toDisplayString()) && JGraph.this.isEnabled()) {
                this.doRefresh();
            }
        }

        private void doRefresh() {
            JGraph.this.getModel().refreshVisuals();
            JGraph.this.refreshAllCells();
        }
    }
}

