/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.gui.Options;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.JAttr;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JVertex;
import groove.gui.jgraph.JVertexView;
import groove.gui.jgraph.MultiLinedEditor;
import groove.gui.look.HTMLLineFormat;
import groove.gui.look.LineStyle;
import groove.gui.look.MultiLabel;
import groove.gui.look.Values;
import groove.gui.look.VisualKey;
import groove.gui.look.VisualMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.PortView;

public class JEdgeView
extends EdgeView {
    protected static final MultiLinedEditor editor = new MultiLinedEditor();
    private final JGraph<?> jGraph;

    static {
        renderer = new MyEdgeRenderer();
    }

    public JEdgeView(JEdge<?> jEdge, JGraph<?> jGraph) {
        super(jEdge);
        this.jGraph = jGraph;
    }

    public void setSource(CellView sourceView) {
        this.sourceParentView = null;
        this.source = sourceView;
        if (this.source != null) {
            this.setPoint(0, JEdgeView.getCenterPoint((CellView)sourceView.getParentView()));
        }
        this.invalidate();
    }

    public void setTarget(CellView targetView) {
        this.target = targetView;
        this.targetParentView = null;
        if (this.target != null) {
            int ix = this.points.size() - 1;
            this.setPoint(ix, JEdgeView.getCenterPoint((CellView)targetView.getParentView()));
        }
        this.invalidate();
    }

    public String toString() {
        return this.cell.toString();
    }

    public MyEdgeRenderer getRenderer() {
        return (MyEdgeRenderer)super.getRenderer();
    }

    public GraphCellEditor getEditor() {
        return editor;
    }

    public JEdge<?> getCell() {
        return (JEdge)super.getCell();
    }

    public void refresh(GraphLayoutCache cache, CellMapper mapper, boolean createDependentViews) {
        super.refresh(cache, mapper, createDependentViews);
        if (this.target != null && !this.jGraph.isLayouting()) {
            if (this.isSelfEdge()) {
                this.routeSelfEdge();
            } else if (this.getPointCount() <= 2) {
                this.routeParallelEdge(mapper);
            }
        }
    }

    protected boolean isSelfEdge() {
        return this.source == this.target;
    }

    public CellHandle getHandle(GraphContext context) {
        return new MyEdgeHandle(this, context);
    }

    public Point2D getPoint(int index) {
        Point2D nearestPoint;
        Point2D result = null;
        if (index == 0) {
            nearestPoint = this.getNearestPoint(true);
            if (this.sourceParentView != null) {
                result = this.sourceParentView.getPerimeterPoint((EdgeView)this, JEdgeView.getCenterPoint((CellView)this.sourceParentView), nearestPoint);
            } else if (this.source instanceof PortView) {
                result = ((PortView)this.source).getLocation((EdgeView)this, nearestPoint);
            }
        } else if (index == this.getPointCount() - 1) {
            nearestPoint = this.getNearestPoint(false);
            if (this.targetParentView != null) {
                result = this.targetParentView.getPerimeterPoint((EdgeView)this, JEdgeView.getCenterPoint((CellView)this.targetParentView), nearestPoint);
            } else if (this.target instanceof PortView) {
                result = ((PortView)this.target).getLocation((EdgeView)this, nearestPoint);
            }
        }
        Object obj = this.points.get(index);
        if (result == null && obj instanceof Point2D) {
            result = (Point2D)obj;
        }
        return result;
    }

    protected Point2D getPointLocation(int index) {
        CellView vertex;
        Point2D result = null;
        if (index == 0 && this.source != null) {
            CellView vertex2 = this.source.getParentView();
            if (vertex2 != null) {
                result = JEdgeView.getCenterPoint((CellView)vertex2);
            }
        } else if (index == this.getPointCount() - 1 && this.target != null && (vertex = this.target.getParentView()) != null) {
            result = JEdgeView.getCenterPoint((CellView)vertex);
        }
        if (result == null) {
            result = (Point2D)this.points.get(index);
        }
        return result;
    }

    protected Point2D getNearestPoint(boolean source) {
        if (this.getPointCount() == 2 && !source && this.source instanceof PortView) {
            JVertexView sourceCellView = (JVertexView)((PortView)this.source).getParentView();
            return sourceCellView.getPerimeterPoint(this, null, this.getPointLocation(this.getPointCount() - 1));
        }
        return super.getNearestPoint(source);
    }

    public Point2D getLabelVector() {
        Point2D p0 = this.getPoint(0);
        Point2D p1 = this.getPoint(1);
        if (this.getCell().getVisuals().getLineStyle() == LineStyle.MANHATTAN && p1.getX() != p0.getX()) {
            p1 = new Point2D.Double(p1.getX(), p0.getY());
        }
        double dx = p1.getX() - p0.getX();
        double dy = p1.getY() - p0.getY();
        return new Point2D.Double(dx, dy);
    }

    protected void routeSelfEdge() {
        boolean isManhattan;
        VisualMap visuals = this.getCell().getVisuals();
        LineStyle lineStyle = visuals.getLineStyle();
        boolean bl = isManhattan = lineStyle == LineStyle.MANHATTAN;
        if (isManhattan ? this.getPointCount() == 2 : this.getPointCount() <= 3) {
            Point2D startPoint = this.getPoint(0);
            Point2D endPoint = this.getPoint(1);
            ArrayList<Point2D> newPoints = new ArrayList<Point2D>(4);
            newPoints.add(startPoint);
            VisualMap sourceVisuals = this.getCell().getSourceVertex().getVisuals();
            Point2D pos = sourceVisuals.getNodePos();
            Dimension2D size = sourceVisuals.getNodeSize();
            pos.setLocation(pos.getX() - size.getWidth() / 2.0, pos.getY() - size.getHeight() / 2.0);
            Rectangle bounds = new Rectangle();
            bounds.setFrame(pos, size);
            if (bounds.contains(endPoint)) {
                endPoint.setLocation(endPoint.getX() + size.getWidth() * 2.0, endPoint.getY());
            }
            newPoints.add(1, this.createPointPerpendicular(startPoint, endPoint, true));
            if (!isManhattan) {
                newPoints.add(1, this.createPointPerpendicular(startPoint, endPoint, false));
                visuals.setLineStyle(LineStyle.BEZIER);
            }
            newPoints.add(startPoint);
            visuals.put(VisualKey.POINTS, newPoints);
        }
    }

    protected void routeParallelEdge(CellMapper mapper) {
        boolean parallelEdge = false;
        JVertex sourceVertex = this.getCell().getSourceVertex();
        JVertex targetVertex = this.getCell().getTargetVertex();
        for (JEdge otherEdge : sourceVertex.getContext()) {
            EdgeView otherView = (EdgeView)mapper.getMapping(otherEdge, false);
            if (otherEdge == this.getCell() || otherView == null || otherEdge.getVisuals().getPoints().size() > 2 || otherEdge.getSourceVertex() != targetVertex && otherEdge.getTargetVertex() != targetVertex) continue;
            parallelEdge = true;
            break;
        }
        if (parallelEdge) {
            Point2D startPoint = this.getPoint(0);
            Point2D endPoint = this.getPoint(1);
            Point midPoint = this.createPointBetween(startPoint, endPoint);
            VisualMap visuals = this.getCell().getVisuals();
            visuals.setPoints(Arrays.asList(startPoint, midPoint, endPoint));
            visuals.setLineStyle(LineStyle.BEZIER);
        }
    }

    private Point createPointBetween(Point2D p1, Point2D p2) {
        int y;
        int x;
        double distance = p1.distance(p2);
        int midX = (int)(p1.getX() + p2.getX()) / 2;
        int midY = (int)(p1.getY() + p2.getY()) / 2;
        if (distance == 0.0) {
            x = midX + 20;
            y = midY + 20;
        } else {
            int offset = (int)(5.0 + distance / 4.0);
            double xDelta = p1.getX() - p2.getX();
            double yDelta = p1.getY() - p2.getY();
            x = midX + (int)((double)offset * yDelta / distance);
            y = midY - (int)((double)offset * xDelta / distance);
        }
        return new Point(Math.max(x, 0), Math.max(y, 0));
    }

    protected Point createPointPerpendicular(Point2D p1, Point2D p2, boolean left) {
        int y;
        int x;
        double distance = p1.distance(p2);
        int midX = (int)(p1.getX() + p2.getX()) / 2;
        int midY = (int)(p1.getY() + p2.getY()) / 2;
        if (distance == 0.0) {
            x = midX + 20;
            y = midY + 20;
        } else {
            int offset = (int)(5.0 + distance / 4.0);
            if (left) {
                offset = -offset;
            }
            double xDelta = p1.getX() - p2.getX();
            double yDelta = p1.getY() - p2.getY();
            x = (int)(p2.getX() + (double)offset * yDelta / distance);
            y = (int)(p2.getY() - (double)offset * xDelta / distance);
        }
        return new Point(Math.max(x, 0), Math.max(y, 0));
    }

    protected LineStyle getPreferredLinestyle() {
        return LineStyle.BEZIER;
    }

    public static class MyEdgeHandle
    extends EdgeView.EdgeHandle {
        public MyEdgeHandle(EdgeView edge, GraphContext ctx) {
            super(edge, ctx);
        }

        public void mousePressed(MouseEvent evt) {
            if (!Options.isEdgeEditEvent(evt)) {
                super.mousePressed(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (!Options.isEdgeEditEvent(evt)) {
                super.mouseReleased(evt);
            }
        }

        public boolean isAddPointEvent(MouseEvent event) {
            return Options.isEdgeEditEvent(event) && super.isAddPointEvent(event);
        }

        public boolean isRemovePointEvent(MouseEvent event) {
            return Options.isEdgeEditEvent(event) && super.isRemovePointEvent(event);
        }

        protected ConnectionSet createConnectionSet(EdgeView view, boolean verbose) {
            if (view.getTarget() == null) {
                List points = view.getPoints();
                points.add(points.get(points.size() - 1));
                view.setTarget(view.getSource());
            }
            return super.createConnectionSet(view, verbose);
        }

        protected void paintPort(Graphics g, CellView p) {
            if (p.getParentView() instanceof JVertexView && this.graph instanceof AspectJGraph) {
                ((JVertexView)p.getParentView()).paintArmed(g);
            } else {
                super.paintPort(g, p);
            }
        }
    }

    public static class MyEdgeRenderer
    extends EdgeRenderer {
        private JEdgeView jView;
        private JEdge<?> cell;
        private VisualMap visuals;
        private boolean twoLines = false;
        private Color line2color;
        private boolean error;
        private Rectangle2D errorBounds;
        private final JLabel jLabel = new JLabel();
        private MultiLabel jLabelLines;
        private Color jLabelColor;
        private Dimension jLabelSize;

        MyEdgeRenderer() {
            this.jLabel.setBorder(null);
            this.jLabel.setHorizontalAlignment(0);
        }

        public Component getRendererComponent(org.jgraph.JGraph jGraph, CellView v, boolean sel, boolean focus, boolean preview) {
            assert (v instanceof JEdgeView) : String.format("This renderer is only meant for %s", JEdgeView.class);
            JEdgeView view = this.jView = (JEdgeView)v;
            this.cell = this.jView.getCell();
            VisualMap visuals = this.visuals = this.cell.getVisuals();
            this.line2color = visuals.getInnerLine();
            this.twoLines = this.line2color != null;
            this.error = visuals.isError();
            if (this.error) {
                Rectangle b = this.getLabelBounds(jGraph, view).getBounds();
                b.setRect(b.x - 1, b.y - 1, b.width, b.height + 1);
                this.errorBounds = b;
            }
            super.getRendererComponent(jGraph, v, sel, focus, preview);
            float lineWidth = this.visuals.getLineWidth();
            if (visuals.isEmphasised()) {
                lineWidth += 2.0f;
            }
            this.lineWidth = lineWidth;
            this.defaultBackground = jGraph.getBackground();
            return this;
        }

        public void setBackground(Color background) {
            super.setBackground(this.defaultBackground);
        }

        public void paint(Graphics g) {
            try {
                super.paint(g);
            }
            catch (InternalError internalError) {}
            Graphics2D g2 = (Graphics2D)g;
            if (this.twoLines) {
                g2.setColor(this.line2color);
                g2.setStroke(JAttr.createStroke(1.0f, Values.NO_DASH));
                g2.draw(this.view.lineShape);
                if (this.view.endShape != null) {
                    g2.fill(this.view.endShape);
                    g2.draw(this.view.endShape);
                }
                g2.setStroke(new BasicStroke(1.0f));
                this.paintLabels(g);
            }
            if (this.error) {
                int s = 6;
                g.setColor(Values.ERROR_COLOR);
                g2.setStroke(JAttr.createStroke(this.lineWidth + (float)s, null));
                g2.draw(this.view.lineShape);
                if (this.view.endShape != null) {
                    g2.fill(this.view.endShape);
                    g2.draw(this.view.endShape);
                }
                this.paintLabels(g);
                g.setColor(Values.ERROR_COLOR);
                g2.fill(this.errorBounds);
            }
        }

        protected void paintSelection(Graphics g) {
            if (this.selected) {
                float oldLineWidth = this.lineWidth;
                this.lineWidth = 1.0f;
                super.paintSelection(g);
                this.lineWidth = oldLineWidth;
            }
        }

        protected Shape createShape() {
            if (this.lineStyle == 14 && this.view.getPointCount() > 2) {
                return this.createManhattanShape();
            }
            return super.createShape();
        }

        protected Shape createManhattanShape() {
            int n = this.view.getPointCount();
            if (n > 1) {
                Point2D p0;
                JEdgeView tmp = (JEdgeView)this.view;
                Point2D[] p = null;
                p = new Point2D[n];
                int i = 0;
                while (i < n) {
                    Point2D pt = tmp.getPoint(i);
                    if (pt == null) {
                        return null;
                    }
                    p[i] = new Point2D.Double(pt.getX(), pt.getY());
                    ++i;
                }
                if (this.view != tmp) {
                    this.view = tmp;
                    this.installAttributes((CellView)this.view);
                }
                if (this.view.sharedPath == null) {
                    this.view.sharedPath = new GeneralPath(1, n);
                } else {
                    this.view.sharedPath.reset();
                }
                this.view.endShape = null;
                this.view.lineShape = null;
                this.view.beginShape = null;
                Point2D pe = p0 = p[0];
                Point2D p1 = null;
                Point2D p2 = null;
                this.view.sharedPath.moveTo((float)p0.getX(), (float)p0.getY());
                int i2 = 1;
                while (i2 < n) {
                    float x = (float)p[i2].getX();
                    float y = (float)p[i2 - 1].getY();
                    this.view.sharedPath.lineTo(x, y);
                    p2 = pe;
                    pe = new Point2D.Float(x, y);
                    if (p1 == null) {
                        p1 = pe;
                    }
                    if (p[i2].getY() != (double)y) {
                        y = (float)p[i2].getY();
                        this.view.sharedPath.lineTo(x, y);
                        p2 = pe;
                        pe = new Point2D.Float(x, y);
                    }
                    ++i2;
                }
                if (this.beginDeco != 0) {
                    this.view.beginShape = this.createLineEnd(this.beginSize, this.beginDeco, p1, p0);
                }
                if (this.endDeco != 0) {
                    this.view.endShape = this.createLineEnd(this.endSize, this.endDeco, p2, pe);
                }
                if (this.view.endShape == null && this.view.beginShape == null) {
                    this.view.lineShape = this.view.sharedPath;
                } else {
                    this.view.lineShape = (GeneralPath)this.view.sharedPath.clone();
                    if (this.view.endShape != null) {
                        this.view.sharedPath.append(this.view.endShape, true);
                    }
                    if (this.view.beginShape != null) {
                        this.view.sharedPath.append(this.view.beginShape, true);
                    }
                }
                return this.view.sharedPath;
            }
            return null;
        }

        protected void paintLabel(Graphics g, String label, Point2D p, boolean mainLabel) {
            if (!mainLabel) {
                super.paintLabel(g, label, p, mainLabel);
            } else if (this.labelsEnabled && p != null) {
                this.paintMainLabel(g, p);
            }
        }

        private void paintMainLabel(Graphics g, Point2D p) {
            Dimension size = this.setTextInJLabel(this.jView);
            if (size != null && (size.getWidth() != 0.0 || size.getHeight() != 0.0)) {
                this.jLabel.setSize(size);
                int sw = (int)size.getWidth();
                int sh = (int)size.getHeight();
                Graphics2D g2 = (Graphics2D)g;
                int dx = -sw / 2;
                int offset = this.isMoveBelowZero ? 0 : Math.min(0, (int)((double)dx + p.getX()));
                g2.translate(p.getX() - (double)offset, p.getY());
                if (this.isOpaque()) {
                    g.setColor(this.getBackground());
                    g.fillRect(-sw / 2 - 1, -sh / 2 - 1, sw + 2, sh + 2);
                }
                int dy = -sh / 2;
                g.setColor(this.fontColor);
                g.translate(dx, dy);
                this.jLabel.paint(g);
                g.translate(-dx, -dy);
                g2.translate(-p.getX() + (double)offset, -p.getY());
            }
        }

        private Dimension setTextInJLabel(JEdgeView view) {
            Dimension result = this.jLabelSize;
            Color foreground = this.getForeground();
            MultiLabel lines = view.getCell().getVisuals().getLabel();
            if (lines.isEmpty()) {
                result = this.jLabelSize = new Dimension();
            } else if (lines != this.jLabelLines || foreground != this.jLabelColor) {
                StringBuilder text;
                if (view.getCell().getJGraph().isShowArrowsOnLabels()) {
                    Point2D start = view.getPoint(0);
                    Point2D end = view.getPoint(view.getPointCount() - 1);
                    text = lines.toString(HTMLLineFormat.instance(), start, end);
                } else {
                    text = lines.toString(HTMLLineFormat.instance());
                }
                this.jLabel.setText(HTMLLineFormat.toHtml(text, foreground));
                this.jLabelColor = foreground;
                result = this.jLabelSize = this.jLabel.getPreferredSize();
            }
            return result;
        }

        public Rectangle2D getLabelBounds(org.jgraph.JGraph paintingContext, EdgeView view) {
            Rectangle2D result = null;
            Point2D p = this.getLabelPosition(view);
            Dimension d = this.getLabelSize(view, null);
            result = this.getLabelBounds(p, d, null);
            return result;
        }

        public Dimension getLabelSize(EdgeView view, String label) {
            Dimension result = null;
            result = label != null ? super.getLabelSize(view, label) : this.setTextInJLabel((JEdgeView)view);
            return result;
        }
    }
}

