/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectLabel;
import groove.grammar.aspect.AspectNode;
import groove.grammar.aspect.AspectParser;
import groove.grammar.model.FormatError;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.type.LabelPattern;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeNode;
import groove.graph.Edge;
import groove.graph.GraphRole;
import groove.graph.Label;
import groove.graph.Node;
import groove.gui.jgraph.AJVertex;
import groove.gui.jgraph.AspectJCell;
import groove.gui.jgraph.AspectJEdge;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJModel;
import groove.gui.jgraph.AspectJObject;
import groove.gui.jgraph.JGraphMode;
import groove.gui.look.Look;
import groove.gui.look.VisualKey;
import groove.io.HTMLConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class AspectJVertex
extends AJVertex<AspectGraph, AspectJGraph, AspectJModel, AspectJEdge>
implements AspectJCell {
    private AspectKind aspect;

    private AspectJVertex() {
        this.setUserObject(null);
    }

    @Override
    public AspectNode getNode() {
        return (AspectNode)super.getNode();
    }

    @Override
    public AspectKind getAspect() {
        return this.aspect;
    }

    @Override
    public Set<AspectEdge> getEdges() {
        return super.getEdges();
    }

    @Override
    public void setNode(Node node) {
        AspectNode aspectNode = (AspectNode)node;
        this.aspect = aspectNode.getKind();
        super.setNode(node);
        if (aspectNode.hasAttrAspect()) {
            this.setLook(Look.getLookFor(this.getNode().getAttrKind()), true);
        }
        this.getErrors().addErrors(aspectNode.getErrors(), true);
        this.refreshVisual(VisualKey.COLOR);
    }

    @Override
    public void addEdge(Edge edge) {
        super.addEdge(edge);
        this.getErrors().addErrors(((AspectEdge)edge).getErrors(), true);
    }

    @Override
    public boolean isCompatible(Edge edge) {
        if (super.isCompatible(edge)) {
            return true;
        }
        if (((AspectEdge)edge).getKind() == AspectKind.REMARK) {
            return edge.source() == this.getNode() && edge.target() == this.getNode();
        }
        return false;
    }

    public Set<AspectEdge> getExtraSelfEdges() {
        Set<AspectEdge> result = this.createEdgeSet();
        for (AspectJEdge jEdge : this.getContext()) {
            if (jEdge.getSourceVertex() != this || !jEdge.isSourceLabel()) continue;
            result.addAll(jEdge.getEdges());
        }
        return result;
    }

    void setNodeFixed() {
        this.getNode().setFixed();
        if (this.getNode().hasErrors()) {
            this.getErrors().addErrors(this.getNode().getErrors(), true);
            this.setStale(VisualKey.ERROR);
        }
    }

    @Override
    public String getNodeIdString() {
        if (this.aspect.isMeta()) {
            return null;
        }
        if (this.getNode().hasAttrAspect()) {
            AspectKind attrKind = this.getNode().getAttrKind();
            if (attrKind.hasSignature()) {
                Object content = this.getNode().getAttrAspect().getContent();
                if (content == null) {
                    return "x" + this.getNode().getNumber();
                }
                return content.toString();
            }
            assert (attrKind == AspectKind.PRODUCT);
            return "p" + this.getNode().getNumber();
        }
        return super.getNodeIdString();
    }

    @Override
    StringBuilder getNodeDescription() {
        StringBuilder result = new StringBuilder();
        if (this.hasErrors()) {
            for (FormatError error : this.getErrors()) {
                if (result.length() > 0) {
                    result.append("<br>");
                }
                result.append(error.toString());
            }
            HTMLConverter.EMBARGO_TAG.on(result);
        } else {
            if (this.getNode().getAttrKind().hasSignature()) {
                if (this.getNode().getAttrAspect().hasContent()) {
                    result.append("Constant node");
                } else {
                    result.append("Variable node");
                }
            } else if (this.getNode().hasAttrAspect()) {
                result.append("Product node");
            } else {
                result.append((CharSequence)super.getNodeDescription());
            }
            if (AspectJModel.ROLE_NAMES.containsKey((Object)this.aspect)) {
                HTMLConverter.toUppercase(result, false);
                result.insert(0, " ");
                result.insert(0, AspectJModel.ROLE_NAMES.get((Object)this.aspect));
                result.append("<br>" + AspectJModel.ROLE_DESCRIPTIONS.get((Object)this.aspect));
            }
        }
        return result;
    }

    @Override
    public Collection<? extends Label> getKeys() {
        this.getNode().testFixed(true);
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        if (!this.aspect.isMeta()) {
            TypeEdge key;
            for (Edge edge : this.getEdges()) {
                key = this.getKey(edge);
                if (key == null) continue;
                result.add(key);
            }
            for (AspectEdge aspectEdge : this.getExtraSelfEdges()) {
                key = this.getKey(aspectEdge);
                if (key == null) continue;
                result.add(key);
            }
            result.addAll(this.getNodeKeys(!result.isEmpty()));
        }
        return result;
    }

    @Override
    protected Collection<TypeNode> getNodeKeys(boolean hasEdgeKeys) {
        TypeNode type;
        ArrayList<TypeNode> result = new ArrayList<TypeNode>();
        GraphBasedModel.TypeModelMap typeMap = this.getTypeMap();
        if (!(typeMap == null || (type = (TypeNode)typeMap.getNode(this.getNode())) == null || hasEdgeKeys && type.isTopType())) {
            result.addAll(type.getSupertypes());
        }
        return result;
    }

    @Override
    public TypeEdge getKey(Edge edge) {
        GraphBasedModel.TypeModelMap typeMap = this.getTypeMap();
        return typeMap == null ? null : (TypeEdge)typeMap.getEdge(edge);
    }

    private GraphBasedModel.TypeModelMap getTypeMap() {
        return ((AspectJModel)((Object)this.getJModel())).getResourceModel().getTypeMap();
    }

    @Override
    protected Look getStructuralLook() {
        if (this.isNodeEdge()) {
            return Look.NODIFIED;
        }
        if (this.getNode().getGraphRole() == GraphRole.TYPE && this.getAspect() == AspectKind.DEFAULT) {
            return Look.TYPE;
        }
        return Look.getLookFor(this.getAspect());
    }

    public boolean isNodeEdge() {
        return ((AspectJGraph)((Object)this.getJGraph())).getMode() != JGraphMode.EDIT_MODE && this.getEdgeLabelPattern() != null;
    }

    public LabelPattern getEdgeLabelPattern() {
        TypeNode typeNode;
        LabelPattern result = null;
        if (this.getNode().getGraphRole() == GraphRole.HOST && (typeNode = this.getNodeType()) != null) {
            result = typeNode.getLabelPattern();
        }
        return result;
    }

    public TypeNode getNodeType() {
        GraphBasedModel.TypeModelMap typeMap = this.getTypeMap();
        return typeMap == null ? null : (TypeNode)typeMap.getNode(this.getNode());
    }

    @Override
    public void saveToUserObject() {
        AspectJObject userObject = this.getUserObject();
        userObject.clear();
        userObject.addLabels(this.getNode().getNodeLabels());
        userObject.addEdges(this.getEdges());
    }

    @Override
    public void loadFromUserObject(GraphRole role) {
        AspectNode node = new AspectNode(this.getNode().getNumber(), role);
        AspectParser parser = AspectParser.getInstance();
        ArrayList<AspectLabel> edgeLabels = new ArrayList<AspectLabel>();
        for (String text : this.getUserObject()) {
            AspectLabel label = parser.parse(text, role);
            if (label.isNodeOnly()) {
                node.setAspects(label);
                continue;
            }
            edgeLabels.add(label);
        }
        StringBuilder remarkText = new StringBuilder();
        ArrayList<AspectEdge> newEdges = new ArrayList<AspectEdge>();
        for (AspectLabel label : edgeLabels) {
            AspectEdge edge = new AspectEdge(node, label, node);
            edge.setFixed();
            if (edge.getAspect() != null && edge.getAspect().getKind() == AspectKind.REMARK) {
                if (remarkText.length() > 0) {
                    remarkText.append('\n');
                }
                remarkText.append(label.getInnerText());
                continue;
            }
            newEdges.add(edge);
        }
        if (remarkText.length() > 0) {
            remarkText.insert(0, AspectKind.REMARK.getPrefix());
            AspectEdge edge = new AspectEdge(node, parser.parse(remarkText.toString(), role), node);
            edge.setFixed();
            newEdges.add(edge);
        }
        this.setNode(node);
        for (AspectEdge edge : newEdges) {
            this.addEdge(edge);
        }
        this.setStale(VisualKey.refreshables());
    }

    @Override
    public void setUserObject(Object value) {
        AspectJObject myObject = new AspectJObject();
        if (value instanceof AspectJObject) {
            myObject.addAll((AspectJObject)value);
        } else if (value != null) {
            myObject.load(value.toString());
        }
        super.setUserObject((Object)myObject);
    }

    @Override
    public AspectJObject getUserObject() {
        return (AspectJObject)super.getUserObject();
    }

    public static AspectJVertex newInstance() {
        return new AspectJVertex();
    }
}

