/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectNode;
import groove.grammar.model.ResourceKind;
import groove.graph.Edge;
import groove.graph.Element;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.display.DisplayKind;
import groove.gui.jgraph.AspectJCell;
import groove.gui.jgraph.AspectJEdge;
import groove.gui.jgraph.AspectJModel;
import groove.gui.jgraph.AspectJVertex;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JGraphFactory;
import groove.gui.jgraph.JGraphMode;
import groove.gui.jgraph.JVertex;
import groove.gui.layout.ForestLayouter;
import groove.gui.layout.SpringLayouter;
import groove.gui.look.LineStyle;
import groove.gui.look.VisualKey;
import groove.gui.look.VisualMap;
import groove.gui.menu.MyJMenu;
import groove.gui.menu.SetLayoutMenu;
import groove.gui.tree.RuleLevelTree;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;

public final class AspectJGraph
extends JGraph<AspectGraph> {
    private final boolean startEditingNewNode = true;
    private final boolean startEditingNewEdge = true;
    private final boolean editing;
    private final boolean forState;
    private final GraphRole graphRole;
    private RuleLevelTree levelTree;
    private final Map<LineStyle, JCellEditAction> setLineStyleActionMap = new EnumMap<LineStyle, JCellEditAction>(LineStyle.class);
    private AddPointAction addPointAction;
    private EditLabelAction editLabelAction;
    private RemovePointAction removePointAction;
    private ResetLabelPositionAction resetLabelPositionAction;
    private GraphModelListener refreshListener;

    public AspectJGraph(Simulator simulator, DisplayKind kind, boolean editing) {
        super(simulator);
        this.editing = editing;
        this.forState = kind == DisplayKind.STATE;
        this.graphRole = this.forState ? GraphRole.HOST : kind.getGraphRole();
        this.setEditable(editing);
        this.getGraphLayoutCache().setSelectsLocalInsertedCells(editing);
        this.setCloneable(editing);
        this.setConnectable(editing);
        this.setDisconnectable(editing);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.addOptionListener("Show aspect prefixes");
        this.addOptionListener("Show data values as nodes");
    }

    @Override
    public void setModel(GraphModel model) {
        AspectJModel oldModel = this.getModel();
        if (oldModel != null) {
            oldModel.removeGraphModelListener(this.getRefreshGraphListener());
        }
        super.setModel(model);
        if (model != null) {
            model.addGraphModelListener(this.getRefreshGraphListener());
        }
    }

    public AspectJModel getModel() {
        return (AspectJModel)super.getModel();
    }

    public AspectJModel newModel() {
        AspectJModel result = (AspectJModel)super.newModel();
        if (this.getSimulatorModel() != null) {
            result.setGrammar(this.getSimulatorModel().getGrammar());
        }
        return result;
    }

    public final boolean isShowAspects() {
        return this.getOptionValue("Show aspect prefixes");
    }

    public final boolean isShowValueNodes() {
        return this.hasActiveEditor() || this.getOptionValue("Show data values as nodes");
    }

    @Override
    protected JGraph.RefreshListener getRefreshListener(String option) {
        if (option.equals("Show bidirectional edges")) {
            return new RebuildListener();
        }
        return super.getRefreshListener(option);
    }

    public void setLevelTree(RuleLevelTree levelTree) {
        assert (levelTree == null || this.getGraphRole() == GraphRole.RULE && !this.hasActiveEditor());
        this.levelTree = levelTree;
    }

    public RuleLevelTree getLevelTree() {
        return this.levelTree;
    }

    public boolean hasActiveEditor() {
        return this.editing && this.getMode() != JGraphMode.PREVIEW_MODE;
    }

    public boolean isForState() {
        return this.forState;
    }

    @Override
    public GraphRole getGraphRole() {
        return this.graphRole;
    }

    @Override
    public JMenu createPopupMenu(Point atPoint) {
        MyJMenu result = new MyJMenu("Popup");
        switch (this.getGraphRole()) {
            case HOST: {
                result.add(this.getActions().getApplyMatchAction());
                result.addSeparator();
            }
        }
        SimulatorAction editAction = this.isForState() ? this.getActions().getEditStateAction() : this.getActions().getEditAction(ResourceKind.toResource(this.getGraphRole()));
        result.add(editAction);
        result.addSubmenu(this.createEditMenu(atPoint));
        result.addSubmenu(super.createPopupMenu(atPoint));
        return result;
    }

    @Override
    public JMenu createExportMenu() {
        MyJMenu result = new MyJMenu();
        if (this.getActions() != null) {
            if (this.isForState()) {
                result.add(this.getActions().getSaveStateAction());
            } else {
                ResourceKind resource = ResourceKind.toResource(this.getGraphRole());
                result.add(this.getActions().getSaveAction(resource));
                result.add(this.getActions().getSaveAsAction(resource));
            }
        }
        result.addMenuItems(super.createExportMenu());
        return result;
    }

    @Override
    public SetLayoutMenu createSetLayoutMenu() {
        if (this.editing) {
            SetLayoutMenu result = new SetLayoutMenu(this, new SpringLayouter());
            result.addLayoutItem(new ForestLayouter());
            return result;
        }
        return super.createSetLayoutMenu();
    }

    public JMenu createEditMenu(Point atPoint) {
        JMenu result = new JMenu("Edit");
        if (this.hasActiveEditor()) {
            result.add(this.getEditLabelAction());
            result.add(this.getAddPointAction(atPoint));
            result.add(this.getRemovePointAction(atPoint));
            result.add(this.getResetLabelPositionAction());
            result.add(this.createLineStyleMenu());
        }
        return result;
    }

    public void setEditable(boolean editable) {
        this.setCloneable(editable);
        this.setConnectable(editable);
        this.setDisconnectable(editable);
        super.setEditable(editable);
    }

    void edit(JCell<AspectGraph> jCell, VisualKey key, Object value) {
        VisualMap newVisuals = new VisualMap();
        newVisuals.put(key, value);
        this.edit(jCell, newVisuals);
    }

    void edit(JCell<AspectGraph> jCell, VisualMap newVisuals) {
        this.getModel().edit(Collections.singletonMap(jCell, newVisuals.getAttributes()), null, null, null);
    }

    void addVertex(Point2D screenPoint) {
        this.stopEditing();
        Point2D atPoint = this.fromScreen(this.snap(screenPoint));
        AspectJVertex jVertex = (AspectJVertex)this.getModel().createJVertex(this.getModel().createAspectNode());
        jVertex.setNodeFixed();
        jVertex.putVisual(VisualKey.NODE_POS, atPoint);
        Object[] insert = new Object[]{jVertex};
        this.getModel().insert(insert, null, null, null, null);
        this.setSelectionCell(jVertex);
        this.startEditingAtCell(jVertex);
    }

    void addEdge(Point2D screenFrom, Point2D screenTo) {
        Point2D to;
        this.stopEditing();
        PortView fromPortView = this.getPortViewAt(screenFrom.getX(), screenFrom.getY());
        Point2D from = fromPortView.getLocation();
        PortView toPortView = this.getPortViewAt(screenTo.getX(), screenTo.getY());
        if (toPortView == null) {
            toPortView = fromPortView;
            to = screenTo;
        } else {
            to = toPortView.getLocation();
        }
        assert (fromPortView != null) : "addEdge should not be called with dangling source " + from;
        DefaultPort fromPort = (DefaultPort)fromPortView.getCell();
        DefaultPort toPort = (DefaultPort)toPortView.getCell();
        AspectJEdge newEdge = (AspectJEdge)this.getModel().createJEdge(null);
        newEdge.getUserObject().add("");
        Object[] insert = new Object[]{newEdge};
        ConnectionSet cs = new ConnectionSet();
        cs.connect((Object)newEdge, (Object)fromPort, true);
        cs.connect((Object)newEdge, (Object)toPort, false);
        List<Point2D> points = toPort == fromPort ? Arrays.asList(from, to, to) : Arrays.asList(from, to);
        newEdge.putVisual(VisualKey.POINTS, points);
        this.getModel().insert(insert, null, cs, null, null);
        this.setSelectionCell(newEdge);
        this.startEditingAtCell(newEdge);
    }

    @Override
    protected JGraphMode getDefaultMode() {
        return this.editing ? JGraphMode.EDIT_MODE : super.getDefaultMode();
    }

    public boolean selectJCell(Element elem) {
        AspectJCell cell = null;
        if (elem instanceof Node) {
            cell = this.getModel().getJCellForNode((Node)elem);
        } else if (elem instanceof Edge) {
            cell = this.getModel().getJCellForEdge((Edge)elem);
        }
        if (cell != null) {
            if (cell instanceof AspectJEdge && ((AspectJEdge)cell).isSourceLabel()) {
                cell = ((AspectJEdge)cell).getSourceVertex();
            }
            this.setSelectionCell(cell);
        }
        return cell != null;
    }

    public AddPointAction getAddPointAction(Point atPoint) {
        if (this.addPointAction == null) {
            this.addPointAction = new AddPointAction();
            this.addAccelerator(this.addPointAction);
        }
        this.addPointAction.setLocation(atPoint);
        return this.addPointAction;
    }

    public JCellEditAction getEditLabelAction() {
        if (this.editLabelAction == null) {
            this.editLabelAction = new EditLabelAction();
            this.addAccelerator(this.editLabelAction);
        }
        return this.editLabelAction;
    }

    public RemovePointAction getRemovePointAction(Point atPoint) {
        if (this.removePointAction == null) {
            this.removePointAction = new RemovePointAction();
            this.addAccelerator(this.removePointAction);
        }
        this.removePointAction.setLocation(atPoint);
        return this.removePointAction;
    }

    public JCellEditAction getResetLabelPositionAction() {
        if (this.resetLabelPositionAction == null) {
            this.resetLabelPositionAction = new ResetLabelPositionAction();
        }
        return this.resetLabelPositionAction;
    }

    public JCellEditAction getSetLineStyleAction(LineStyle lineStyle) {
        JCellEditAction result = this.setLineStyleActionMap.get((Object)lineStyle);
        if (result == null) {
            result = new SetLineStyleAction(lineStyle);
            this.setLineStyleActionMap.put(lineStyle, result);
            this.addAccelerator(result);
        }
        return result;
    }

    public JMenu createLineStyleMenu() {
        SetLineStyleMenu result = new SetLineStyleMenu();
        return result;
    }

    private GraphModelListener getRefreshGraphListener() {
        if (this.refreshListener == null) {
            this.refreshListener = new RefreshGraphListener();
        }
        return this.refreshListener;
    }

    @Override
    protected JGraphFactory<AspectGraph> createFactory() {
        return new MyFactory();
    }

    public class AddPointAction
    extends JCellEditAction {
        AddPointAction() {
            super("Add Point", false);
            this.putValue("AcceleratorKey", Options.ADD_POINT_KEY);
        }

        @Override
        public boolean isEnabled() {
            return this.jCells.size() == 1;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.execute(this.jCell);
        }

        public void execute(AspectJCell jCell) {
            VisualMap visuals = jCell.getVisuals();
            List<Point2D> points = this.addPointAt(visuals.getPoints(), this.location);
            AspectJGraph.this.edit(jCell, VisualKey.POINTS, points);
        }
    }

    private class EditLabelAction
    extends JCellEditAction {
        EditLabelAction() {
            super("Edit Label");
            this.putValue("AcceleratorKey", Options.RENAME_KEY);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AspectJGraph.this.startEditingAtCell(this.jCell);
        }
    }

    private abstract class JCellEditAction
    extends AbstractAction
    implements GraphSelectionListener {
        protected final boolean allCells;
        protected final boolean vertexOnly;
        protected AspectJCell jCell;
        protected final List<AspectJCell> jCells;
        protected Point2D location;

        protected JCellEditAction(String name) {
            super(name);
            this.allCells = true;
            this.vertexOnly = true;
            this.jCells = new ArrayList<AspectJCell>();
            this.refresh();
            AspectJGraph.this.addGraphSelectionListener(this);
        }

        protected JCellEditAction(String name, boolean vertexOnly) {
            super(name);
            this.allCells = false;
            this.vertexOnly = vertexOnly;
            this.jCells = new ArrayList<AspectJCell>();
            this.refresh();
            AspectJGraph.this.addGraphSelectionListener(this);
        }

        public void valueChanged(GraphSelectionEvent e) {
            this.refresh();
        }

        private void refresh() {
            this.jCell = null;
            this.jCells.clear();
            Object[] objectArray = AspectJGraph.this.getSelectionCells();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object cell = objectArray[n2];
                AspectJCell jCell = (AspectJCell)cell;
                if (this.allCells || this.vertexOnly == jCell instanceof JVertex) {
                    this.jCell = jCell;
                    this.jCells.add(jCell);
                }
                ++n2;
            }
            this.setEnabled(this.jCell != null);
        }

        public void setLocation(Point2D location) {
            this.location = location;
        }

        protected List<Point2D> addPointAt(List<Point2D> points, Point2D location) {
            LinkedList<Point2D> result = new LinkedList<Point2D>(points);
            if (location == null) {
                result.add(1, this.createPointBetween((Point2D)result.get(0), (Point2D)result.get(1)));
            } else {
                int closestIndex = this.getClosestIndex(result, location);
                assert (closestIndex > 0);
                result.add(closestIndex, (Point)location.clone());
            }
            return result;
        }

        protected int getClosestIndex(List<Point2D> points, Point2D location) {
            int result = 0;
            double closestDistance = Double.MAX_VALUE;
            int i = 1;
            while (i < points.size()) {
                double distance = location.distance(points.get(i - 1)) + location.distance(points.get(i));
                if (distance < closestDistance) {
                    result = i;
                    closestDistance = distance;
                }
                ++i;
            }
            return result;
        }

        private Point createPointBetween(Point2D p1, Point2D p2) {
            int y;
            int x;
            double distance = p1.distance(p2);
            int midX = (int)(p1.getX() + p2.getX()) / 2;
            int midY = (int)(p1.getY() + p2.getY()) / 2;
            if (distance == 0.0) {
                x = midX + 20;
                y = midY + 20;
            } else {
                int offset = (int)(5.0 + distance / 4.0);
                double xDelta = p1.getX() - p2.getX();
                double yDelta = p1.getY() - p2.getY();
                x = midX + (int)((double)offset * yDelta / distance);
                y = midY - (int)((double)offset * xDelta / distance);
            }
            return new Point(Math.max(x, 0), Math.max(y, 0));
        }
    }

    private class MyFactory
    extends JGraphFactory<AspectGraph> {
        public MyFactory() {
            super(AspectJGraph.this);
        }

        public AspectJGraph getJGraph() {
            return (AspectJGraph)super.getJGraph();
        }

        public AspectJVertex newJVertex(Node node) {
            assert (node instanceof AspectNode);
            return AspectJVertex.newInstance();
        }

        public AspectJEdge newJEdge(Edge edge) {
            assert (edge == null || edge instanceof AspectEdge);
            return AspectJEdge.newInstance();
        }

        public AspectJModel newModel() {
            return new AspectJModel(this.getJGraph());
        }
    }

    private class RebuildListener
    extends JGraph.RefreshListener {
        private RebuildListener() {
            super(AspectJGraph.this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (AspectJGraph.this.isEnabled()) {
                this.rebuild();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(AccessibleState.ENABLED.toDisplayString()) && AspectJGraph.this.isEnabled()) {
                this.rebuild();
            }
        }

        private void rebuild() {
            AspectJModel oldModel = AspectJGraph.this.getModel();
            AspectJModel newModel = oldModel.cloneWithNewGraph(oldModel.getGraph());
            AspectJGraph.this.setModel((GraphModel)newModel);
        }
    }

    private class RefreshGraphListener
    implements GraphModelListener {
        private RefreshGraphListener() {
        }

        public void graphChanged(GraphModelEvent e) {
            AspectJGraph.this.refresh();
        }
    }

    public class RemovePointAction
    extends JCellEditAction {
        RemovePointAction() {
            super("Remove Point", false);
            this.putValue("AcceleratorKey", Options.REMOVE_POINT_KEY);
        }

        @Override
        public boolean isEnabled() {
            return this.jCells.size() == 1;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.execute(this.jCell);
        }

        public void execute(AspectJCell jEdge) {
            VisualMap visuals = jEdge.getVisuals();
            List<Point2D> points = visuals.getPoints();
            AspectJGraph.this.edit(jEdge, VisualKey.POINTS, this.removePointAt(points, this.location));
        }

        private List<Point2D> removePointAt(List<Point2D> points, Point2D location) {
            LinkedList<Point2D> result = new LinkedList<Point2D>(points);
            if (!(result.size() <= 2 || result.getFirst().equals(result.getLast()) && result.size() <= 3)) {
                int ix = location == null ? 1 : this.getClosestIndex(points, location);
                result.remove(ix);
            }
            return result;
        }
    }

    private class ResetLabelPositionAction
    extends JCellEditAction {
        ResetLabelPositionAction() {
            super("Reset Label", false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            for (AspectJCell jCell : this.jCells) {
                this.execute(jCell);
            }
        }

        public void execute(AspectJCell jEdge) {
            AspectJGraph.this.edit(jEdge, VisualKey.LABEL_POS, VisualKey.LABEL_POS.getDefaultValue());
        }
    }

    private class SetLineStyleAction
    extends JCellEditAction {
        protected final LineStyle lineStyle;

        SetLineStyleAction(LineStyle lineStyle) {
            super(lineStyle.getName(), false);
            this.putValue("AcceleratorKey", lineStyle.getKey());
            this.lineStyle = lineStyle;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            VisualMap newVisuals = new VisualMap();
            for (AspectJCell jCell : this.jCells) {
                VisualMap visuals = jCell.getVisuals();
                newVisuals.setLineStyle(this.lineStyle);
                List<Point2D> points = visuals.getPoints();
                if (points.size() == 2) {
                    points = this.addPointAt(points, this.location);
                    newVisuals.put(VisualKey.POINTS, points);
                }
                AspectJGraph.this.edit(jCell, newVisuals);
            }
        }
    }

    private class SetLineStyleMenu
    extends JMenu
    implements GraphSelectionListener {
        SetLineStyleMenu() {
            super("Set Line Style");
            this.valueChanged(null);
            AspectJGraph.this.addGraphSelectionListener(this);
            LineStyle[] lineStyleArray = LineStyle.values();
            int n = lineStyleArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineStyle lineStyle = lineStyleArray[n2];
                this.add(AspectJGraph.this.getSetLineStyleAction(lineStyle));
                ++n2;
            }
        }

        public void valueChanged(GraphSelectionEvent e) {
            this.setEnabled(AspectJGraph.this.getSelectionCell() instanceof JEdge);
        }
    }
}

