/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.io.HTMLConverter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class TitledPanel
extends JPanel {
    private final Box labelPanelTop;
    private final JLabel titleLabel;
    private final JComponent inner;
    private Color enabledBackground;

    public TitledPanel(String name, JComponent inner, JToolBar toolBar, boolean scroll) {
        super(new BorderLayout(), false);
        this.setBorder(null);
        this.titleLabel = new JLabel();
        this.titleLabel.setAlignmentX(0.0f);
        this.setName(name);
        this.inner = inner;
        this.labelPanelTop = Box.createVerticalBox();
        this.labelPanelTop.add(this.titleLabel);
        if (toolBar != null) {
            toolBar.setAlignmentX(0.0f);
            this.labelPanelTop.add(toolBar);
        }
        this.add((Component)this.labelPanelTop, "North");
        this.add((Component)(scroll ? new JScrollPane(inner) : inner), "Center");
    }

    public void setTitled(boolean titled) {
        if (titled) {
            this.labelPanelTop.add((Component)this.titleLabel, 0);
        } else {
            this.labelPanelTop.remove(this.titleLabel);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.titleLabel.setText(HTMLConverter.HTML_TAG.on("&#160;" + HTMLConverter.STRONG_TAG.on(name)));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.inner.setEnabled(enabled);
        if (this.enabledBackground != null) {
            this.inner.setBackground(enabled ? this.enabledBackground : null);
        }
    }

    public void setEnabledBackground(Color background) {
        this.enabledBackground = background;
        if (background != null && this.inner.isEnabled()) {
            this.inner.setBackground(background);
        }
    }
}

