/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.gui.action.CancelEditAction;
import groove.gui.action.CopyAction;
import groove.gui.action.EnableUniqueAction;
import groove.gui.action.SaveAction;
import groove.gui.action.SimulatorAction;
import groove.gui.display.Display;
import groove.gui.display.DisplayKind;
import groove.gui.display.GraphEditorTab;
import groove.gui.display.GraphTab;
import groove.gui.display.ResourceTab;
import groove.gui.display.TabLabel;
import groove.gui.display.TextTab;
import groove.gui.tree.ResourceTree;
import groove.io.HTMLConverter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;

public class ResourceDisplay
extends Display
implements SimulatorListener {
    private int frozenDividerPos;
    private JTabbedPane tabPane;
    private JPanel singleInfoPanel;
    private final String SINGLE_INFO_KEY = "Single info panel";
    private JSplitPane splitInfoPanel;
    private final String SPLIT_INFO_KEY = "Split info panel";
    private JToggleButton enableButton;
    private int upperInfoTabIndex;
    private int lowerInfoTabIndex;
    private final Map<String, ResourceTab> editorMap = new HashMap<String, ResourceTab>();
    private boolean listening;
    private ResourceTab mainTab;
    private String enabledText;
    private String disabledText;

    ResourceDisplay(Simulator simulator, ResourceKind resource) {
        super(simulator, DisplayKind.toDisplay(resource));
    }

    @Override
    protected void buildDisplay() {
        this.add(this.getTabPane());
    }

    public final JTabbedPane getTabPane() {
        if (this.tabPane == null) {
            this.tabPane = this.createTabPane();
        }
        return this.tabPane;
    }

    protected final MyTabbedPane createTabPane() {
        return new MyTabbedPane();
    }

    @Override
    protected JTree createList() {
        return new ResourceTree(this);
    }

    @Override
    protected void resetList() {
        ResourceTree list = (ResourceTree)this.getList();
        if (list != null) {
            list.dispose();
        }
        super.resetList();
    }

    @Override
    protected JToolBar createListToolBar() {
        return this.createListToolBar(-1);
    }

    protected JToolBar createListToolBar(int separation) {
        JToolBar result = Options.createToolBar();
        result.add(this.getNewAction());
        result.add(this.getEditAction());
        if (separation >= 0) {
            result.addSeparator(new Dimension(separation, 0));
        } else {
            result.addSeparator();
        }
        result.add(this.getCopyAction());
        result.add(this.getDeleteAction());
        result.add(this.getRenameAction());
        if (separation >= 0) {
            result.addSeparator(new Dimension(separation, 0));
        } else {
            result.addSeparator();
        }
        ResourceKind kind = this.getResourceKind();
        if (kind.isEnableable()) {
            result.add(this.getEnableButton());
            if (this.getResourceKind() == ResourceKind.HOST || this.getResourceKind() == ResourceKind.TYPE || this.getResourceKind() == ResourceKind.PROLOG || this.getResourceKind() == ResourceKind.CONTROL) {
                result.add(this.getEnableUniqueAction());
            }
        }
        if (kind == ResourceKind.GROOVY) {
            result.add(this.getActions().getExecGroovyAction());
        }
        return result;
    }

    @Override
    protected JComponent createInfoPanel() {
        JPanel result = new JPanel();
        result.setLayout(new CardLayout());
        result.add((Component)this.getSingleInfoPanel(), "Single info panel");
        result.add((Component)this.getSplitInfoPanel(), "Split info panel");
        result.setBorder(null);
        return result;
    }

    private JPanel getSingleInfoPanel() {
        JPanel result = this.singleInfoPanel;
        if (result == null) {
            this.singleInfoPanel = result = new JPanel();
            result.setLayout(new BorderLayout());
            result.setBorder(null);
        }
        return result;
    }

    private JSplitPane getSplitInfoPanel() {
        JSplitPane result = this.splitInfoPanel;
        if (result == null) {
            this.splitInfoPanel = result = new JSplitPane(0);
            result.setContinuousLayout(true);
            result.setBorder(null);
        }
        return result;
    }

    protected void buildInfoPanel() {
        String key;
        JComponent upperInfoPanel = null;
        JComponent lowerInfoPanel = null;
        ResourceTab tab = this.getSelectedTab();
        if (tab != null) {
            upperInfoPanel = tab.getUpperInfoPanel();
            lowerInfoPanel = tab.getLowerInfoPanel();
        }
        JPanel infoPanel = (JPanel)this.getInfoPanel();
        if (lowerInfoPanel == null || !lowerInfoPanel.isEnabled()) {
            if (upperInfoPanel != null && upperInfoPanel.getParent() == this.getSplitInfoPanel()) {
                this.frozenDividerPos = this.getSplitInfoPanel().getDividerLocation();
            }
            this.getSingleInfoPanel().removeAll();
            if (upperInfoPanel != null) {
                this.getSingleInfoPanel().add((Component)upperInfoPanel, "Center");
                this.getSingleInfoPanel().validate();
                this.getSingleInfoPanel().repaint();
            }
            key = "Single info panel";
        } else {
            JSplitPane splitInfoPanel = this.getSplitInfoPanel();
            int dividerPos = this.frozenDividerPos;
            this.frozenDividerPos = 0;
            if (dividerPos == 0) {
                dividerPos = splitInfoPanel.getDividerLocation();
            }
            splitInfoPanel.setTopComponent(upperInfoPanel);
            splitInfoPanel.setBottomComponent(lowerInfoPanel);
            splitInfoPanel.setDividerLocation(dividerPos);
            key = "Split info panel";
        }
        ((CardLayout)infoPanel.getLayout()).show(infoPanel, key);
    }

    int getInfoTabIndex(boolean upper) {
        return upper ? this.upperInfoTabIndex : this.lowerInfoTabIndex;
    }

    public void setInfoTabIndex(boolean upper, int index) {
        if (upper) {
            this.upperInfoTabIndex = index;
        } else {
            this.lowerInfoTabIndex = index;
        }
    }

    protected final CopyAction getCopyAction() {
        return this.getActions().getCopyAction(this.getResourceKind());
    }

    protected final SimulatorAction getDeleteAction() {
        return this.getActions().getDeleteAction(this.getResourceKind());
    }

    protected final SimulatorAction getEditAction() {
        return this.getActions().getEditAction(this.getResourceKind());
    }

    protected final SimulatorAction getEnableAction() {
        return this.getActions().getEnableAction(this.getResourceKind());
    }

    protected final SimulatorAction getNewAction() {
        return this.getActions().getNewAction(this.getResourceKind());
    }

    protected final SimulatorAction getRenameAction() {
        return this.getActions().getRenameAction(this.getResourceKind());
    }

    protected final SaveAction getSaveAction() {
        return this.getActions().getSaveAction(this.getResourceKind());
    }

    protected final CancelEditAction getCancelEditAction() {
        return this.getActions().getCancelEditAction(this.getResourceKind());
    }

    protected final EnableUniqueAction getEnableUniqueAction() {
        return this.getActions().getEnableUniqueAction(this.getResourceKind());
    }

    protected final JToggleButton getEnableButton() {
        if (this.enableButton == null) {
            this.enableButton = Options.createToggleButton(this.getEnableAction());
            this.enableButton.setMargin(new Insets(3, 1, 3, 1));
            this.enableButton.setText(null);
        }
        return this.enableButton;
    }

    public ResourceTab getMainTab() {
        if (this.mainTab == null) {
            this.mainTab = this.createMainTab();
        }
        return this.mainTab;
    }

    protected ResourceTab createMainTab() {
        ResourceKind kind = this.getResourceKind();
        if (kind.isGraphBased()) {
            return new GraphTab(this);
        }
        return new TextTab(this);
    }

    public void startEditResource(String name) {
        ResourceTab result = this.getEditors().get(name);
        if (result == null) {
            result = this.createEditorTab(name);
            this.addEditorTab(result);
            if (this.getMainTab().removeResource(name)) {
                this.removeMainTab();
            }
            this.getEditors().put(name, result);
        }
        if (this.getTabPane().getSelectedComponent() == result) {
            this.buildInfoPanel();
            this.getSimulatorModel().setDisplay(this.getKind());
        } else {
            this.getTabPane().setSelectedComponent(result);
        }
    }

    private void addEditorTab(ResourceTab result) {
        this.getTabPane().addTab("", result);
        int index = this.getTabPane().indexOfComponent(result);
        this.getTabPane().setTabComponentAt(index, result.getTabLabel());
        this.getListPanel().repaint();
    }

    protected ResourceTab createEditorTab(String name) {
        ResourceKind kind = this.getResourceKind();
        if (kind.isGraphBased()) {
            AspectGraph graph = this.getSimulatorModel().getStore().getGraphs(this.getResourceKind()).get(name);
            GraphEditorTab result = new GraphEditorTab(this, graph.getRole());
            result.setGraph(graph);
            return result;
        }
        String program = this.getSimulatorModel().getStore().getTexts(this.getResourceKind()).get(name);
        return new TextTab(this, name, program);
    }

    public boolean saveEditor(String name, boolean confirm, boolean dispose) {
        boolean result = true;
        ResourceTab editor = this.getEditors().get(name);
        if (editor != null) {
            result = editor.saveEditor(confirm, dispose);
        }
        return result;
    }

    protected final Map<String, ResourceTab> getEditors() {
        return this.editorMap;
    }

    protected final boolean isEdited(String name) {
        return this.getEditors().containsKey(name);
    }

    public boolean saveAllEditors(boolean dispose) {
        boolean result = true;
        for (ResourceTab editor : new ArrayList<ResourceTab>(this.getEditors().values())) {
            result = editor.saveEditor(true, dispose);
            if (!result) break;
        }
        return result;
    }

    public ResourceTab getEditor(String name) {
        return this.getEditors().get(name);
    }

    public ResourceTab getSelectedTab() {
        return (ResourceTab)this.getTabPane().getSelectedComponent();
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        if (this.suspendListening()) {
            if (changes.contains((Object)SimulatorModel.Change.GRAMMAR)) {
                this.updateGrammar(source.getGrammar(), source.getGrammar() != oldModel.getGrammar());
            }
            ResourceModel<?> resourceModel = source.getResource(this.getResourceKind());
            this.getEnableButton().setSelected(resourceModel != null && resourceModel.isEnabled());
            this.selectResource(source.getSelected(this.getResourceKind()));
            this.buildInfoPanel();
            this.activateListening();
        }
    }

    protected void updateGrammar(GrammarModel grammar, boolean fresh) {
        this.getMainTab().updateGrammar(grammar);
        int tabCount = this.getTabPane().getTabCount();
        int i = tabCount - 1;
        while (i >= 0) {
            ResourceTab tab = (ResourceTab)this.getTabPane().getComponentAt(i);
            if (tab.isEditor() && fresh) {
                tab.dispose();
            } else if (tab != this.getMainTab()) {
                tab.updateGrammar(grammar);
            }
            --i;
        }
        if (this.getMainTab().getName() == null) {
            this.removeMainTab();
        }
    }

    @Override
    protected void installListeners() {
        this.getSimulatorModel().addListener(this, SimulatorModel.Change.GRAMMAR, SimulatorModel.Change.toChange(this.getResourceKind()));
        this.getTabPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ResourceTab tab;
                int index;
                if (e.getButton() == 3 && (index = ResourceDisplay.this.getTabPane().indexAtLocation(e.getX(), e.getY())) >= 0 && (tab = (ResourceTab)ResourceDisplay.this.getTabPane().getComponentAt(index)) != ResourceDisplay.this.getMainTab()) {
                    ResourceDisplay.this.createDetachMenu(tab).show(ResourceDisplay.this, e.getX(), e.getY());
                }
            }
        });
        this.activateListening();
    }

    private JPopupMenu createDetachMenu(final ResourceTab tab) {
        JPopupMenu result = new JPopupMenu();
        result.add(new AbstractAction("Close This Editor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                tab.saveEditor(true, true);
            }
        });
        result.add(new AbstractAction("Close Other Editors"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ResourceTab editor : new ArrayList<ResourceTab>(ResourceDisplay.this.getEditors().values())) {
                    if (editor != tab && !editor.saveEditor(true, true)) break;
                }
            }
        });
        result.add(new AbstractAction("Close All Editors"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceDisplay.this.saveAllEditors(true);
            }
        });
        return result;
    }

    protected boolean isListening() {
        return this.listening;
    }

    protected boolean suspendListening() {
        boolean result = this.listening;
        if (result) {
            this.listening = false;
        }
        return result;
    }

    protected void activateListening() {
        if (this.listening) {
            throw new IllegalStateException();
        }
        this.listening = true;
    }

    protected void selectionChanged() {
        if (this.suspendListening()) {
            Component selection = this.getTabPane().getSelectedComponent();
            String name = selection == null ? null : selection.getName();
            this.getSimulatorModel().doSelect(this.getResourceKind(), name);
            this.buildInfoPanel();
            this.activateListening();
        }
    }

    public ResourceTab selectResource(String name) {
        ResourceTab result;
        if (name == null) {
            this.removeMainTab();
            result = null;
        } else {
            ResourceTab editor = this.getEditors().get(name);
            if (editor == null) {
                this.selectMainTab(name);
                this.getMainTab().repaint();
                result = this.getMainTab();
            } else {
                this.getTabPane().setSelectedComponent(editor);
                result = editor;
            }
        }
        return result;
    }

    protected void removeMainTab() {
        this.getTabPane().remove(this.getMainTab());
    }

    protected void selectMainTab(String name) {
        if (this.getMainTab().setResource(name)) {
            TabLabel tabLabel = this.getMainTab().getTabLabel();
            int index = this.getTabPane().indexOfComponent(this.getMainTab());
            if (index < 0) {
                index = this.getMainTabIndex();
                this.getTabPane().add((Component)this.getMainTab(), index);
                this.getTabPane().setTitleAt(index, null);
                this.getTabPane().setTabComponentAt(index, tabLabel);
            }
            tabLabel.setEnabled(true);
            tabLabel.setTitle(this.getLabelText(name));
            tabLabel.setError(this.hasError(name));
            this.getTabPane().setSelectedIndex(index);
        }
    }

    public final Icon getListIcon(String name) {
        ImageIcon result = this.editorMap.containsKey(name) ? Icons.EDIT_ICON : Icons.getListIcon(this.getResourceKind());
        return result;
    }

    public final String getLabelText(String name) {
        return this.getLabelText(name, this.getResource(name).isEnabled());
    }

    public String getLabelText(String name, boolean enabled) {
        StringBuilder result = new StringBuilder(this.getResource(name).getLastName());
        if (this.isEdited(name)) {
            this.getEditors().get(name).decorateText(result);
        }
        if (enabled) {
            if (this.getKind() != DisplayKind.RULE) {
                HTMLConverter.STRONG_TAG.on(result);
                HTMLConverter.HTML_TAG.on(result);
            }
        } else {
            result.insert(0, "(");
            result.append(")");
        }
        return result.toString();
    }

    protected String getToolTip(String name) {
        ResourceModel<?> model = this.getResource(name);
        boolean enabled = model != null && model.isEnabled();
        return this.getToolTip(name, enabled);
    }

    private String getToolTip(String name, boolean enabled) {
        String result;
        String string = result = enabled ? this.enabledText : this.disabledText;
        if (result == null) {
            this.enabledText = String.format("Enabled %s; doubleclick to edit", this.getResourceKind().getDescription());
            this.disabledText = String.format("Disabled %s; doubleclick to edit", this.getResourceKind().getDescription());
            result = enabled ? this.enabledText : this.disabledText;
        }
        return result;
    }

    protected int getMainTabIndex() {
        return 0;
    }

    public final boolean hasError(String name) {
        ResourceModel<?> model;
        boolean result = this.editorMap.containsKey(name) ? this.editorMap.get(name).hasErrors() : (model = this.getResource(name)) != null && model.hasErrors();
        return result;
    }

    public final ResourceModel<?> getResource(String name) {
        return this.getSimulatorModel().getGrammar().getResource(this.getResourceKind(), name);
    }

    private class MyTabbedPane
    extends JTabbedPane {
        public MyTabbedPane() {
            super(3);
            this.setFocusable(false);
            this.setBorder(new EmptyBorder(0, 0, -4, 0));
        }

        @Override
        public void removeTabAt(int index) {
            boolean isIndexSelected = this.getSelectedIndex() == index;
            Component panel = this.getComponentAt(index);
            super.removeTabAt(index);
            String name = panel.getName();
            if (ResourceDisplay.this.getEditors().remove(name) != null && isIndexSelected) {
                ResourceDisplay.this.selectMainTab(name);
            }
            this.setTabEnabled(this.getSelectedIndex(), true);
            this.setEnabled(this.getTabCount() > 0);
            Display.ListPanel listPanel = ResourceDisplay.this.getListPanel();
            if (listPanel != null) {
                listPanel.repaint();
            }
        }

        @Override
        public void setSelectedIndex(int index) {
            int selectedIndex = this.getSelectedIndex();
            if (index != selectedIndex) {
                if (selectedIndex >= 0) {
                    this.setTabEnabled(selectedIndex, false);
                }
                super.setSelectedIndex(index);
                this.setTabEnabled(index, true);
            }
            ResourceDisplay.this.selectionChanged();
        }

        private void setTabEnabled(int index, boolean enabled) {
            if (index >= 0) {
                Component label = this.getTabComponentAt(index);
                if (label != null) {
                    label.setEnabled(enabled);
                }
                this.getComponentAt(index).requestFocus();
            }
        }
    }
}

