/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.gui.Simulator;
import groove.gui.display.DisplayKind;
import groove.gui.jgraph.JGraph;
import groove.gui.layout.LayoutKind;
import groove.gui.layout.LayouterItem;
import groove.gui.menu.SetLayoutMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class LayoutDialog
extends JDialog
implements ActionListener,
WindowFocusListener {
    private static LayoutDialog INSTANCE;
    private final Simulator simulator;
    private final LayouterItem[] protoLayouterItems;
    private final JComboBox layoutBox;
    private final JPanel panel;
    private JGraph<?> jGraph;

    public static LayoutDialog getInstance(Simulator simulator) {
        if (INSTANCE == null) {
            INSTANCE = new LayoutDialog(simulator);
        }
        return INSTANCE;
    }

    private LayoutDialog(Simulator simulator) {
        super(simulator.getFrame());
        this.setAlwaysOnTop(true);
        this.setTitle("Configure Graph Layout");
        this.simulator = simulator;
        this.protoLayouterItems = new LayouterItem[LayoutKind.values().length];
        this.layoutBox = new JComboBox();
        int i = 0;
        LayoutKind[] layoutKindArray = LayoutKind.values();
        int n = layoutKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutKind kind = layoutKindArray[n2];
            this.protoLayouterItems[i] = LayoutKind.getLayouterItemProto(kind);
            this.layoutBox.addItem(this.protoLayouterItems[i].getName());
            ++i;
            ++n2;
        }
        this.layoutBox.addActionListener(this);
        this.layoutBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.add(this.panel);
        this.addWindowFocusListener(this);
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.refreshJGraph();
        this.refreshPanel(this.layoutBox.getSelectedIndex());
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    public void showDialog() {
        this.setLocationRelativeTo(this.simulator.getFrame());
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.layoutBox.equals(e.getSource())) {
            this.refreshPanel(this.layoutBox.getSelectedIndex());
        }
    }

    private void refreshPanel(int index) {
        this.refreshPanel(this.protoLayouterItems[index]);
    }

    private void refreshPanel(LayouterItem item) {
        if (this.getJGraph() != null) {
            this.getLayoutMenu().selectLayoutAction(item).actionPerformed(null);
            LayouterItem layouterItem = (LayouterItem)this.getJGraph().getLayouter();
            this.replacePanel(layouterItem.getPanel());
        }
    }

    private void replacePanel(JPanel panel) {
        this.panel.removeAll();
        this.panel.add(this.layoutBox);
        this.panel.add(new JSeparator(0));
        if (panel != null) {
            this.panel.add(panel);
        }
        this.panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.pack();
    }

    private SetLayoutMenu getLayoutMenu() {
        return this.getJGraph() == null ? null : this.getJGraph().getSetLayoutMenu();
    }

    private void refreshJGraph() {
        DisplayKind display = this.simulator.getModel().getDisplay();
        if (display.isGraphBased()) {
            this.jGraph = this.simulator.getDisplaysPanel().getGraphPanel().getJGraph();
        }
    }

    private JGraph<?> getJGraph() {
        return this.jGraph;
    }
}

