/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.grammar.aspect.GraphConverter;
import groove.grammar.model.ResourceKind;
import groove.graph.Graph;
import groove.graph.GraphRole;
import groove.gui.Simulator;
import groove.gui.display.DisplayKind;
import groove.gui.display.JGraphPanel;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.CtrlJGraph;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JModel;
import groove.gui.jgraph.LTSJGraph;
import groove.gui.jgraph.PlainJGraph;
import java.awt.Point;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JDialog;
import org.jgraph.graph.GraphModel;

public class GraphPreviewDialog<G extends Graph>
extends JDialog {
    private JGraph<G> jGraph;
    protected final G graph;
    protected final Simulator simulator;
    private static Simulator globalSimulator;
    private static Map<GraphRole, Set<String>> recentPreviews;
    private static final boolean TIMER = true;

    static {
        recentPreviews = new EnumMap<GraphRole, Set<String>>(GraphRole.class);
        GraphRole[] graphRoleArray = GraphRole.values();
        int n = graphRoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphRole role = graphRoleArray[n2];
            recentPreviews.put(role, new HashSet());
            ++n2;
        }
    }

    public GraphPreviewDialog(Simulator simulator, G graph) {
        super(simulator == null ? null : simulator.getFrame());
        this.simulator = simulator;
        this.graph = graph;
        this.setTitle(graph.getName());
        if (simulator != null) {
            Point p = simulator.getFrame().getLocation();
            this.setLocation(new Point(p.x + 50, p.y + 50));
        }
        JGraphPanel<G> autPanel = new JGraphPanel<G>(this.getJGraph());
        autPanel.initialise();
        autPanel.setEnabled(true);
        this.add(autPanel);
        this.setSize(600, 700);
        if (simulator == null) {
            this.setDefaultCloseOperation(2);
        }
    }

    private JGraph<G> getJGraph() {
        if (this.jGraph == null) {
            this.jGraph = this.createJGraph();
        }
        return this.jGraph;
    }

    protected JGraph<G> createJGraph() {
        JGraph jGraph;
        Object shownGraph = this.graph;
        switch (this.graph.getRole()) {
            case CTRL: {
                jGraph = new CtrlJGraph(this.simulator);
                break;
            }
            case HOST: 
            case RULE: 
            case TYPE: {
                shownGraph = GraphConverter.toAspect(this.graph);
                DisplayKind kind = DisplayKind.toDisplay(ResourceKind.toResource(this.graph.getRole()));
                jGraph = new AspectJGraph(this.simulator, kind, false);
                break;
            }
            case LTS: {
                jGraph = new LTSJGraph(this.simulator);
                break;
            }
            default: {
                jGraph = PlainJGraph.newInstance(this.simulator);
            }
        }
        JModel<G> model = jGraph.newModel();
        model.loadGraph(shownGraph);
        jGraph.setModel((GraphModel)model);
        jGraph.doLayout(true);
        return jGraph;
    }

    public static void setSimulator(Simulator simulator) {
        globalSimulator = simulator;
    }

    public static void showGraph(Graph graph) {
        GraphPreviewDialog.showGraph(globalSimulator, graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <G extends Graph> void showGraph(Simulator simulator, G graph) {
        final GraphRole role = graph.getRole();
        final String name = graph.getName();
        Map<GraphRole, Set<String>> map = recentPreviews;
        synchronized (map) {
            if (recentPreviews.get((Object)role).add(name)) {
                new GraphPreviewDialog<G>(simulator, graph).setVisible(true);
                final Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map map = recentPreviews;
                        synchronized (map) {
                            ((Set)recentPreviews.get((Object)role)).remove(name);
                        }
                        timer.cancel();
                    }
                }, 1000L);
            }
        }
    }
}

