/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorUndoManager;
import groove.gui.action.SimulatorAction;
import groove.io.store.EditType;
import groove.io.store.SystemStore;

public class UndoSimulatorAction
extends SimulatorAction {
    private final SimulatorUndoManager undoManager;

    public UndoSimulatorAction(Simulator simulator) {
        super(simulator, "Undo", Icons.UNDO_ICON);
        this.putValue("ShortDescription", "Undo");
        this.putValue("AcceleratorKey", Options.UNDO_KEY);
        this.setEnabled(false);
        this.undoManager = simulator.getUndoManager();
    }

    @Override
    public void execute() {
        SystemStore.Edit edit = this.undoManager.editToBeUndone();
        this.undoManager.undo();
        this.getSimulatorModel().synchronize(edit.getType() != EditType.LAYOUT);
    }

    @Override
    public void refresh() {
        if (this.undoManager.canUndo()) {
            this.setEnabled(true);
            this.putValue("Name", this.undoManager.getUndoPresentationName());
        } else {
            this.setEnabled(false);
            this.putValue("Name", "Undo");
        }
    }
}

