/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.ResourceKind;
import groove.graph.Graph;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.io.graph.GxlIO;
import java.io.File;
import java.io.IOException;

public final class SaveStateAction
extends SimulatorAction {
    private final boolean saveAs;

    public SaveStateAction(Simulator simulator, boolean saveAs) {
        super(simulator, Options.getSaveStateActionName(saveAs), saveAs ? Icons.SAVE_AS_ICON : Icons.SAVE_ICON, null, ResourceKind.HOST);
        if (!saveAs) {
            this.putValue("AcceleratorKey", Options.SAVE_KEY);
        }
        this.saveAs = saveAs;
    }

    @Override
    public void execute() {
        AspectGraph graph = this.getStateDisplay().getStateGraph();
        if (this.saveAs) {
            this.doSaveAs(graph);
        } else {
            this.doSave(graph);
        }
    }

    public boolean doSave(AspectGraph graph) {
        boolean result = false;
        String newName = this.askNewName(graph.getName(), true);
        if (newName != null) {
            try {
                this.getSimulatorModel().doAddGraph(this.getResourceKind(), graph.rename(newName), false);
                result = true;
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, "Error while saving state '%s'", graph.getName());
            }
        }
        return result;
    }

    public boolean doSaveAs(AspectGraph graph) {
        boolean result = false;
        File selectedFile = this.askSaveResource(graph.getName());
        if (selectedFile != null) {
            try {
                String nameInGrammar = this.getNameInGrammar(selectedFile);
                if (nameInGrammar == null) {
                    String newName = this.getResourceKind().getFilter().stripExtension(selectedFile.getName());
                    GxlIO.getInstance().saveGraph((Graph)graph.rename(newName).toPlainGraph(), selectedFile);
                } else {
                    result = this.doSave(graph.rename(nameInGrammar));
                }
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, "Error while writing state to '%s'", selectedFile);
            }
        }
        return result;
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getSimulatorModel().hasState());
    }
}

