/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.GraphConverter;
import groove.graph.Graph;
import groove.graph.GraphRole;
import groove.graph.plain.PlainGraph;
import groove.gui.Icons;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.dialog.SaveLTSAsDialog;
import groove.io.ExtensionFilter;
import groove.io.FileType;
import groove.io.graph.GxlIO;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.util.Groove;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

public class SaveLTSAsAction
extends SimulatorAction {
    public SaveLTSAsAction(Simulator simulator) {
        super(simulator, "Save LTS As ...", Icons.SAVE_AS_ICON);
    }

    @Override
    public void execute() {
        SaveLTSAsDialog dialog = new SaveLTSAsDialog(this.getSimulator());
        if (this.getLastGrammarFile() != null) {
            dialog.setCurrentDirectory(this.getLastGrammarFile().getAbsolutePath());
        }
        if (dialog.showDialog(this.getSimulator())) {
            File ltsFile = dialog.getFile();
            this.doSave(ltsFile, dialog.getExportStates(), dialog.showFinal(), dialog.showNames(), dialog.showStart(), dialog.showOpen());
        }
    }

    private void doSave(File ltsFile, int exportStates, boolean showFinal, boolean showNames, boolean showStart, boolean showOpen) {
        ExtensionFilter ltsFilter = FileType.getFilter(GraphRole.LTS);
        if (ltsFile.isDirectory()) {
            ltsFile = new File(ltsFile, ltsFilter.addExtension("lts"));
        }
        GTS gts = this.getSimulatorModel().getGts();
        gts.setName(ltsFilter.stripExtension(ltsFile.getName()));
        PlainGraph lts = gts.toPlainGraph(showFinal, showStart, showOpen, showNames);
        Collection<Object> export = new HashSet(0);
        if (exportStates == 2) {
            export = gts.nodeSet();
        } else if (exportStates == 1) {
            export = gts.getFinalStates();
        }
        try {
            Groove.saveGraph((Graph)lts, ltsFile);
            ExtensionFilter stateFilter = FileType.STATE_FILTER;
            for (GraphState graphState : export) {
                AspectGraph stateGraph = GraphConverter.toAspect(graphState.getGraph());
                File file = new File(ltsFile.getParentFile(), stateFilter.addExtension(graphState.toString()));
                GxlIO.getInstance().saveGraph((Graph)stateGraph.toPlainGraph(), file);
            }
        }
        catch (IOException e) {
            this.showErrorDialog(e, "Error while saving LTS to %s", ltsFile);
        }
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getSimulatorModel().getGts() != null);
    }
}

