/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.model.GrammarModel;
import groove.grammar.model.HostModel;
import groove.grammar.model.ResourceKind;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.io.store.SystemStore;
import java.io.File;
import java.io.IOException;

public class SaveGrammarAction
extends SimulatorAction {
    public SaveGrammarAction(Simulator simulator) {
        super(simulator, "Save Grammar As ...", null);
        this.putValue("AcceleratorKey", Options.SAVE_GRAMMAR_AS_KEY);
    }

    @Override
    public void execute() {
        int approve = this.getGrammarFileChooser(false).showSaveDialog(this.getFrame());
        if (approve == 0) {
            File selectedFile = this.getGrammarFileChooser(false).getSelectedFile();
            try {
                this.save(selectedFile, true);
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, "Error while saving grammar to " + selectedFile, new Object[0]);
            }
        }
    }

    public boolean save(File grammarFile, boolean clearDir) throws IOException {
        boolean result = false;
        if (this.getDisplaysPanel().saveAllEditors(false)) {
            HostModel startGraph;
            SystemStore newStore = this.getSimulatorModel().getStore().save(grammarFile, clearDir);
            GrammarModel oldGrammar = this.getSimulatorModel().getGrammar();
            GrammarModel newGrammar = newStore.toGrammarModel();
            if (oldGrammar.getActiveNames(ResourceKind.HOST).isEmpty() && (startGraph = oldGrammar.getStartGraphModel()) != null) {
                newGrammar.setStartGraph(startGraph.getSource());
            }
            this.getSimulatorModel().setGrammar(newGrammar);
            this.getSimulator().setTitle();
            this.getGrammarFileChooser().setSelectedFile(grammarFile);
            result = true;
        }
        return result;
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getSimulatorModel().getGrammar() != null);
    }
}

