/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.control.CtrlAut;
import groove.grammar.Grammar;
import groove.grammar.model.ControlModel;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.gui.Icons;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.dialog.GraphPreviewDialog;
import groove.gui.jgraph.CtrlJGraph;
import groove.gui.tree.LabelTree;
import javax.swing.JDialog;

public class PreviewControlAction
extends SimulatorAction {
    private CtrlJGraph jGraph;

    public PreviewControlAction(Simulator simulator) {
        super(simulator, "Preview Control ...", Icons.CONTROL_MODE_ICON, null, ResourceKind.CONTROL);
    }

    @Override
    public void execute() {
        try {
            CtrlAut aut = this.getCtrlAut();
            if (aut != null) {
                this.getJGraph().setModel(aut);
                this.getDialog().setVisible(true);
            }
        }
        catch (FormatException exc) {
            this.showErrorDialog(exc, String.format("Error in control program '%s'", this.getSimulatorModel().getSelected(ResourceKind.CONTROL)), new Object[0]);
        }
    }

    @Override
    public void refresh() {
        try {
            this.setEnabled(this.getCtrlAut() != null);
        }
        catch (FormatException formatException) {
            this.setEnabled(false);
        }
    }

    private CtrlJGraph getJGraph() throws FormatException {
        if (this.jGraph == null) {
            this.jGraph = new CtrlJGraph(this.getSimulator());
            this.jGraph.setModel(this.getCtrlAut());
            this.jGraph.setLabelTree(new LabelTree<CtrlAut>(this.jGraph, true));
            this.jGraph.getLayouter().start();
        }
        return this.jGraph;
    }

    private JDialog getDialog() throws FormatException {
        return new GraphPreviewDialog<CtrlAut>(this.getSimulator(), this.getCtrlAut());
    }

    private CtrlAut getCtrlAut() throws FormatException {
        CtrlAut result = null;
        GrammarModel grammarModel = this.getGrammarModel();
        if (grammarModel != null) {
            Grammar grammar = grammarModel.toGrammar();
            ControlModel controlModel = (ControlModel)this.getSimulatorModel().getTextResource(this.getResourceKind());
            result = controlModel == null || controlModel.isEnabled() ? grammar.getCtrlAut() : (CtrlAut)controlModel.toResource();
        }
        return result;
    }
}

