/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.io.store.SystemStore;
import groove.io.store.SystemStoreFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;

public class LoadGrammarFromURLAction
extends SimulatorAction {
    public LoadGrammarFromURLAction(Simulator simulator) {
        super(simulator, "Load Grammar from URL ...", null);
        this.putValue("AcceleratorKey", Options.OPEN_URL_KEY);
        simulator.addAccelerator(this);
    }

    @Override
    public void execute() {
        String input = JOptionPane.showInputDialog("Input Grammar URL:");
        if (input != null) {
            try {
                URL url = new URL(input);
                SystemStore store = SystemStoreFactory.newStore(url);
                this.getActions().getLoadGrammarAction().load(store);
            }
            catch (MalformedURLException e) {
                this.showErrorDialog(e, String.format("Invalid URL '%s'", e.getMessage()), new Object[0]);
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, exc.getMessage(), new Object[0]);
            }
        }
    }

    @Override
    public void refresh() {
        this.setEnabled(true);
    }
}

