/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.model.GrammarModel;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.lts.GraphState;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;

public class ApplyMatchAction
extends SimulatorAction {
    public ApplyMatchAction(Simulator simulator) {
        super(simulator, "Apply selected match", Icons.GO_NEXT_ICON);
        this.putValue("AcceleratorKey", Options.APPLY_KEY);
        simulator.addAccelerator(this);
    }

    @Override
    public void execute() {
        MatchResult match = this.getSimulatorModel().getMatch();
        if (match == null) {
            this.getActions().getExploreAction().doExploreState();
        } else {
            GraphState state = this.getSimulatorModel().getState();
            RuleTransition trans = match.hasRuleTransitionFrom(state) ? match.getRuleTransition() : state.applyMatch(match);
            this.getSimulatorModel().doSetStateAndMatch(trans.target(), trans);
        }
    }

    @Override
    public void refresh() {
        GrammarModel grammar = this.getSimulatorModel().getGrammar();
        this.setEnabled(this.getSimulatorModel().hasState() && grammar != null && !grammar.hasErrors() && grammar.hasRules());
        this.putValue("ShortDescription", this.getSimulatorModel().hasMatch() ? "Apply selected match" : "Explore current state");
    }
}

