/*
 * Decompiled with CFR 0.152.
 */
package groove.gui;

import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorModel;
import groove.gui.display.DisplayKind;
import groove.gui.display.LTSDisplay;
import groove.io.store.SystemStore;
import groove.io.store.SystemStoreFactory;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class UserSettings {
    private static final Preferences userPrefs = Options.userPrefs;
    private static final String DISPLAY_KEY = "Selected display";
    private static final String DISPLAYS_INFO_DIV_POS_KEY = "Displays+info panel divider position";
    private static final String GRAMMAR_DIV_POS_KEY = "Main panel divider position";
    private static final String LISTS_DIV_POS_KEY = "Rule-Graph divider position";
    private static final String LOCATION_KEY = "Grammar location";
    private static final String SIM_HEIGHT_KEY = "Simulator height";
    private static final String SIM_MAX_KEY = "Simulator maximized";
    private static final String SIM_WIDTH_KEY = "Simulator width";
    private static final String STATE_BOUND_KEY = "Maximum state displayed";

    public static void applyUserSettings(Simulator simulator) {
        UserSettings.applyFrameSettings(simulator);
        UserSettings.applyLocationSettings(simulator);
        UserSettings.applyDisplaySettings(simulator);
    }

    private static void applyFrameSettings(Simulator simulator) {
        String listsPos;
        String displaysInfoPos;
        String grammarPos;
        String simMax = userPrefs.get(SIM_MAX_KEY, "");
        String simWidth = userPrefs.get(SIM_WIDTH_KEY, "");
        String simHeight = userPrefs.get(SIM_HEIGHT_KEY, "");
        if (!(simMax.isEmpty() || simWidth.isEmpty() || simHeight.isEmpty())) {
            JFrame frame = simulator.getFrame();
            if (Boolean.parseBoolean(simMax)) {
                frame.setExtendedState(6);
            } else {
                int w = Integer.parseInt(simWidth);
                int h = Integer.parseInt(simHeight);
                frame.setSize(w, h);
            }
        }
        if (!(grammarPos = userPrefs.get(GRAMMAR_DIV_POS_KEY, "")).isEmpty()) {
            JSplitPane jsp = simulator.getGrammarPanel();
            jsp.setDividerLocation(Integer.parseInt(grammarPos));
        }
        if (!(displaysInfoPos = userPrefs.get(DISPLAYS_INFO_DIV_POS_KEY, "")).isEmpty()) {
            JSplitPane jsp = simulator.getDisplaysInfoPanel();
            jsp.setDividerLocation(Integer.parseInt(displaysInfoPos));
        }
        if (!(listsPos = userPrefs.get(LISTS_DIV_POS_KEY, "")).isEmpty()) {
            JSplitPane jsp = simulator.getListsPanel();
            jsp.setDividerLocation(Integer.parseInt(listsPos));
        }
    }

    private static boolean isFrameMaximized(JFrame frame) {
        return frame.getExtendedState() == 6;
    }

    private static int getFrameWidth(JFrame frame) {
        return frame.getWidth();
    }

    private static int getFrameHeight(JFrame frame) {
        return frame.getHeight();
    }

    private static void applyLocationSettings(final Simulator simulator) {
        String location = userPrefs.get(LOCATION_KEY, "");
        if (!location.isEmpty()) {
            userPrefs.remove(LOCATION_KEY);
            try {
                final SystemStore store = SystemStoreFactory.newStore(location);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            simulator.getActions().getLoadGrammarAction().load(store);
                        }
                        catch (IOException iOException) {}
                    }
                });
            }
            catch (IOException iOException) {}
        }
    }

    private static void applyDisplaySettings(final Simulator simulator) {
        int stateBoundValue;
        String display = userPrefs.get(DISPLAY_KEY, "");
        final DisplayKind kind = display.isEmpty() ? null : DisplayKind.valueOf(display);
        try {
            stateBoundValue = Integer.parseInt(userPrefs.get(STATE_BOUND_KEY, "1000"));
        }
        catch (NumberFormatException numberFormatException) {
            stateBoundValue = 1000;
        }
        final int stateBound = stateBoundValue;
        if (kind != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    simulator.getModel().setDisplay(kind);
                    ((LTSDisplay)simulator.getDisplaysPanel().getDisplay(DisplayKind.LTS)).setStateBound(stateBound);
                }
            });
        }
    }

    public static void syncSettings(Simulator simulator) {
        UserSettings.syncFrameSettings(simulator);
        UserSettings.syncLocationSettings(simulator);
        UserSettings.syncDisplaySettings(simulator);
    }

    private static void syncFrameSettings(Simulator simulator) {
        JFrame frame = simulator.getFrame();
        String simMax = Boolean.toString(UserSettings.isFrameMaximized(frame));
        String simWidth = Integer.toString(UserSettings.getFrameWidth(frame));
        String simHeight = Integer.toString(UserSettings.getFrameHeight(frame));
        userPrefs.put(SIM_MAX_KEY, simMax);
        userPrefs.put(SIM_WIDTH_KEY, simWidth);
        userPrefs.put(SIM_HEIGHT_KEY, simHeight);
        int grammarPos = simulator.getGrammarPanel().getDividerLocation();
        userPrefs.put(GRAMMAR_DIV_POS_KEY, "" + grammarPos);
        int displaysInfoPos = simulator.getDisplaysInfoPanel().getDividerLocation();
        userPrefs.put(DISPLAYS_INFO_DIV_POS_KEY, "" + displaysInfoPos);
        int listsPos = simulator.getListsPanel().getDividerLocation();
        userPrefs.put(LISTS_DIV_POS_KEY, "" + listsPos);
    }

    private static void syncLocationSettings(Simulator simulator) {
        SystemStore store;
        SimulatorModel model = simulator.getModel();
        if (model != null && (store = model.getStore()) != null) {
            Object location = store.getLocation();
            userPrefs.put(LOCATION_KEY, location.toString());
        }
    }

    private static void syncDisplaySettings(Simulator simulator) {
        String display = simulator.getModel().getDisplay().name();
        userPrefs.put(DISPLAY_KEY, display.toString());
        Integer stateBound = ((LTSDisplay)simulator.getDisplaysPanel().getDisplay(DisplayKind.LTS)).getStateBound();
        userPrefs.put(STATE_BOUND_KEY, stateBound.toString());
    }
}

