/*
 * Decompiled with CFR 0.152.
 */
package groove.graph.iso;

import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.graph.Edge;
import groove.graph.Element;
import groove.graph.Graph;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.iso.CertificateStrategy;
import groove.util.collect.TreeHashSet;
import java.util.LinkedList;
import java.util.List;

public class PartitionRefiner
extends CertificateStrategy {
    private final boolean strong;
    private int nodePartitionCount;
    private int iterateCount;
    private static final int TREE_RESOLUTION = 3;
    private static final TreeHashSet<MyNodeCert> certStore = new TreeHashSet<MyNodeCert>(3){

        @Override
        protected boolean allEqual() {
            return true;
        }

        @Override
        protected int getCode(MyNodeCert key) {
            return key.getValue();
        }
    };
    private static int[] tmpCertIxs = new int[100];
    private static final boolean BREAK_DUPLICATES = true;
    private static int totalSymmetryBreakCount;

    public PartitionRefiner(Graph graph) {
        this(graph, false);
    }

    public PartitionRefiner(Graph graph, boolean strong) {
        super(graph);
        this.strong = strong;
    }

    @Override
    public CertificateStrategy newInstance(Graph graph, boolean strong) {
        return new PartitionRefiner(graph, strong);
    }

    @Override
    public int getNodePartitionCount() {
        if (this.nodePartitionCount == 0) {
            this.computeCertificates();
        }
        return this.nodePartitionCount;
    }

    @Override
    public boolean getStrength() {
        return true;
    }

    @Override
    void iterateCertificates() {
        this.iterateCertificates1();
        this.iterateCertificates2();
    }

    private void iterateCertificates1() {
        boolean goOn;
        this.resizeTmpCertIxs();
        int nodeCertCount = this.nodeCertCount;
        do {
            int oldPartitionCount = this.nodePartitionCount;
            this.advanceEdgeCerts();
            this.advanceNodeCerts(this.iterateCount > 0 && this.nodePartitionCount < nodeCertCount);
            goOn = this.iterateCount == 0 ? true : this.nodePartitionCount > oldPartitionCount;
            ++this.iterateCount;
        } while (goOn);
        PartitionRefiner.recordIterateCount(this.iterateCount);
    }

    private void iterateCertificates2() {
        if (!this.strong) {
            // empty if block
        }
        if (this.nodePartitionCount < this.nodeCertCount) {
            this.resizeTmpCertIxs();
            while (true) {
                int oldPartitionCount = this.nodePartitionCount;
                List<MyNodeCert> duplicates = this.getSmallestDuplicates();
                if (duplicates.isEmpty()) break;
                this.checkpointCertificates();
                for (MyNodeCert duplicate : duplicates) {
                    duplicate.breakSymmetry();
                    this.iterateCertificates1();
                    this.rollBackCertificates();
                    this.nodePartitionCount = oldPartitionCount;
                }
                this.accumulateCertificates();
                this.advanceEdgeCerts();
                this.advanceNodeCerts(true);
            }
        }
        int edgeCount = this.edgeCerts.length;
        int i = this.edge2CertCount;
        while (i < edgeCount) {
            ((MyEdge1Cert)this.edgeCerts[i]).setNewValue();
            ++i;
        }
    }

    private void resizeTmpCertIxs() {
        if (this.nodeCertCount > tmpCertIxs.length) {
            tmpCertIxs = new int[this.nodeCertCount + 100];
        }
    }

    private void advanceEdgeCerts() {
        int i = 0;
        while (i < this.edge2CertCount) {
            MyEdge2Cert edgeCert = (MyEdge2Cert)this.edgeCerts[i];
            this.graphCertificate += (long)edgeCert.setNewValue();
            ++i;
        }
    }

    private void advanceNodeCerts(boolean store) {
        int tmpSize = 0;
        int i = 0;
        while (i < this.nodeCertCount) {
            MyNodeCert nodeCert = (MyNodeCert)this.nodeCerts[i];
            this.graphCertificate += (long)nodeCert.setNewValue();
            if (store) {
                if (nodeCert.isSingular()) {
                    PartitionRefiner.tmpCertIxs[tmpSize] = i;
                    ++tmpSize;
                } else {
                    MyNodeCert oldCertForValue = certStore.put(nodeCert);
                    if (oldCertForValue == null) {
                        nodeCert.setSingular(this.iterateCount);
                    } else {
                        oldCertForValue.setSingular(0);
                    }
                }
            }
            ++i;
        }
        if (store) {
            i = 0;
            while (i < tmpSize) {
                certStore.add((MyNodeCert)this.nodeCerts[tmpCertIxs[i]]);
                ++i;
            }
            this.nodePartitionCount = certStore.size();
            certStore.clear();
        }
    }

    private void checkpointCertificates() {
        int i = 0;
        while (i < this.nodeCerts.length) {
            MyCert nodeCert = (MyCert)((Object)this.nodeCerts[i]);
            nodeCert.setCheckpoint();
            ++i;
        }
        i = 0;
        while (i < this.edge2CertCount) {
            MyCert edgeCert = (MyCert)((Object)this.edgeCerts[i]);
            edgeCert.setCheckpoint();
            ++i;
        }
    }

    private void rollBackCertificates() {
        int i = 0;
        while (i < this.nodeCerts.length) {
            MyCert nodeCert = (MyCert)((Object)this.nodeCerts[i]);
            nodeCert.rollBack();
            ++i;
        }
        i = 0;
        while (i < this.edge2CertCount) {
            MyCert edgeCert = (MyCert)((Object)this.edgeCerts[i]);
            edgeCert.rollBack();
            ++i;
        }
    }

    private void accumulateCertificates() {
        int i = 0;
        while (i < this.nodeCerts.length) {
            MyCert nodeCert = (MyCert)((Object)this.nodeCerts[i]);
            nodeCert.accumulate(this.iterateCount);
            ++i;
        }
        i = 0;
        while (i < this.edge2CertCount) {
            MyCert edgeCert = (MyCert)((Object)this.edgeCerts[i]);
            edgeCert.accumulate(this.iterateCount);
            ++i;
        }
    }

    private List<MyNodeCert> getSmallestDuplicates() {
        LinkedList<MyNodeCert> result = new LinkedList<MyNodeCert>();
        MyNodeCert minCert = null;
        int i = 0;
        while (i < this.nodeCerts.length) {
            MyNodeCert cert = (MyNodeCert)this.nodeCerts[i];
            if (!cert.isSingular()) {
                if (minCert == null) {
                    minCert = cert;
                    result.add(cert);
                } else if (cert.getValue() < minCert.getValue()) {
                    minCert = cert;
                    result.clear();
                    result.add(cert);
                } else if (cert.getValue() == minCert.getValue()) {
                    result.add(cert);
                }
            }
            ++i;
        }
        assert (result.size() != 1);
        return result;
    }

    @Override
    CertificateStrategy.NodeCertificate createValueNodeCertificate(ValueNode node) {
        return new MyValueNodeCert(node);
    }

    @Override
    MyNodeCert createNodeCertificate(Node node) {
        return new MyNodeCert(node);
    }

    @Override
    MyEdge1Cert createEdge1Certificate(Edge edge, CertificateStrategy.NodeCertificate source) {
        return new MyEdge1Cert(edge, (MyNodeCert)source);
    }

    @Override
    MyEdge2Cert createEdge2Certificate(Edge edge, CertificateStrategy.NodeCertificate source, CertificateStrategy.NodeCertificate target) {
        return new MyEdge2Cert(edge, (MyNodeCert)source, (MyNodeCert)target);
    }

    public static int getSymmetryBreakCount() {
        return totalSymmetryBreakCount;
    }

    public static abstract class MyCert<E extends Element>
    implements CertificateStrategy.ElementCertificate<E> {
        protected int value;
        private int checkpointValue;
        private int cumulativeValue;
        private final E element;

        MyCert(E element) {
            this.element = element;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            MyCert other = (MyCert)obj;
            return this.value == other.value;
        }

        @Override
        public final int getValue() {
            return this.value;
        }

        @Override
        public void modifyValue(int mod) {
            this.value += mod;
        }

        protected int setNewValue() {
            this.value = this.computeNewValue();
            return this.value;
        }

        protected abstract int computeNewValue();

        @Override
        public E getElement() {
            return this.element;
        }

        public void setCheckpoint() {
            this.checkpointValue = this.value;
        }

        public void rollBack() {
            this.cumulativeValue += this.value;
            this.value = this.checkpointValue;
        }

        public void accumulate(int round) {
            this.value += this.cumulativeValue;
            this.cumulativeValue = 0;
        }
    }

    static class MyEdge1Cert
    extends MyCert<Edge>
    implements CertificateStrategy.EdgeCertificate {
        private final MyNodeCert source;
        private final Label label;
        private final int initValue;

        public MyEdge1Cert(Edge edge, MyNodeCert source) {
            super(edge);
            this.source = source;
            this.label = edge.label();
            this.value = this.initValue = this.label.hashCode();
            source.addValue(this.value);
        }

        public String toString() {
            return "[" + this.source + "," + this.label + "(" + this.initValue + ")]";
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            MyEdge1Cert other = (MyEdge1Cert)obj;
            return this.label.equals(other.label);
        }

        @Override
        protected int computeNewValue() {
            int sourceHashCode = this.source.hashCode();
            int result = (sourceHashCode << 8) + (sourceHashCode >> 24) + this.value;
            return result;
        }
    }

    static class MyEdge2Cert
    extends MyCert<Edge>
    implements CertificateStrategy.EdgeCertificate {
        private final Label label;
        private final MyNodeCert source;
        private final MyNodeCert target;
        private final int initValue;

        public MyEdge2Cert(Edge edge, MyNodeCert source, MyNodeCert target) {
            super(edge);
            this.source = source;
            this.target = target;
            this.label = edge.label();
            this.value = this.initValue = this.label.hashCode();
            source.addValue(this.value);
            target.addValue(this.value << 1);
        }

        public String toString() {
            return "[" + this.source + "," + this.label + "(" + this.initValue + ")," + this.target + "]";
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            MyEdge2Cert other = (MyEdge2Cert)obj;
            if (!this.source.equals(other.source) || !this.label.equals(other.label)) {
                return false;
            }
            if (this.target == this.source) {
                return other.target == other.source;
            }
            return this.target.equals(other.target);
        }

        @Override
        protected int computeNewValue() {
            int targetShift = (this.initValue & 0xF) + 1;
            int sourceHashCode = this.source.value;
            int targetHashCode = this.target.value;
            int result = (sourceHashCode << 8 | sourceHashCode >>> 24) + (targetHashCode << targetShift | targetHashCode >>> targetShift) + this.value;
            this.source.nextValue += 2 * result;
            this.target.nextValue -= 3 * result;
            return result;
        }
    }

    static class MyNodeCert
    extends MyCert<Node>
    implements CertificateStrategy.NodeCertificate {
        private static final int INIT_NODE_VALUE = 4715;
        private final Label label;
        int nextValue;
        boolean singular;

        public MyNodeCert(Node node) {
            super(node);
            if (node instanceof HostNode) {
                this.label = ((HostNode)node).getType().label();
                this.value = this.label.hashCode();
            } else {
                this.label = null;
                this.value = 4715;
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.label == null) {
                return true;
            }
            return this.label.equals(((MyNodeCert)obj).label);
        }

        public String toString() {
            return "c" + this.value;
        }

        public void breakSymmetry() {
            this.value ^= this.value << 5 ^ this.value >> 3;
        }

        @Override
        protected int computeNewValue() {
            int result = this.nextValue ^ this.value;
            this.nextValue = 0;
            return result;
        }

        protected void addValue(int inc) {
            this.value += inc;
        }

        protected void addNextValue(int value) {
            this.nextValue += value;
        }

        protected void setSingular(int round) {
            this.singular = round > 0;
        }

        protected boolean isSingular() {
            return this.singular;
        }
    }

    static class MyValueNodeCert
    extends MyNodeCert {
        private final Object nodeValue;

        public MyValueNodeCert(ValueNode node) {
            super(node);
            this.nodeValue = node.getValue();
            this.value = this.nodeValue.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof MyValueNodeCert && this.nodeValue.equals(((MyValueNodeCert)obj).nodeValue);
        }

        @Override
        protected int computeNewValue() {
            int result = this.nextValue ^ this.value;
            this.nextValue = 0;
            return result;
        }
    }
}

