/*
 * Decompiled with CFR 0.152.
 */
package groove.graph;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum GraphRole {
    NONE("none", "No Graph"),
    HOST("graph", "Graph"),
    RULE("rule", "Rule Graph"),
    TYPE("type", "Type Graph"),
    LTS("lts", "LTS"),
    RETE("rete", "Rete Network"),
    CTRL("control", "Control Automaton"),
    BUCHI("b\u00fcchi", "B\u00fcchi Automaton"),
    SHAPE("shape", "Abstract graph"),
    PATTERN("pattern", "Pattern graph");

    private final String description;
    private final String name;
    public static final Map<String, GraphRole> roles;
    public static final EnumSet<GraphRole> grammarRoles;

    static {
        roles = new HashMap<String, GraphRole>();
        GraphRole[] graphRoleArray = GraphRole.values();
        int n = graphRoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphRole role = graphRoleArray[n2];
            roles.put(role.toString(), role);
            ++n2;
        }
        grammarRoles = EnumSet.of(HOST, RULE, TYPE);
    }

    private GraphRole(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String toString() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString(boolean upper) {
        String roleName = this.toString();
        if (upper) {
            char[] result = roleName.toCharArray();
            result[0] = Character.toUpperCase(result[0]);
            return String.valueOf(result);
        }
        return roleName;
    }

    public boolean inGrammar() {
        return grammarRoles.contains((Object)this);
    }
}

