/*
 * Decompiled with CFR 0.152.
 */
package groove.graph;

import groove.graph.AGraph;
import groove.graph.Edge;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.iso.CertificateStrategy;
import groove.util.DefaultDispenser;
import groove.util.collect.TreeHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GraphCache<N extends Node, E extends Edge> {
    public static final boolean NODE_EDGE_MAP_DYNAMIC = true;
    private static int createCount;
    protected final AGraph<N, E> graph;
    private final boolean dynamic;
    private Map<Label, Set<E>> labelEdgeMap;
    private Map<N, Set<E>> nodeInEdgeMap;
    private Map<N, Set<E>> nodeOutEdgeMap;
    private Map<N, Set<E>> nodeEdgeMap;
    private DefaultDispenser nodeCounter;
    private CertificateStrategy certificateStrategy;

    public GraphCache(AGraph<N, E> graph) {
        this(graph, true);
    }

    public GraphCache(AGraph<N, E> graph, boolean dynamic) {
        this.graph = graph;
        this.dynamic = dynamic;
        ++createCount;
    }

    public static int getCreateCount() {
        return createCount;
    }

    protected void addUpdate(N node) {
        this.addToNodeEdgeMap(this.nodeEdgeMap, node);
        this.addToNodeEdgeMap(this.nodeInEdgeMap, node);
        this.addToNodeEdgeMap(this.nodeOutEdgeMap, node);
        DefaultDispenser nodeCounter = this.getNodeCounter();
        int nodeNr = node.getNumber();
        if (nodeCounter.getCount() <= nodeNr) {
            nodeCounter.setCount(nodeNr + 1);
        }
    }

    protected void addUpdate(E edge) {
        this.addToLabelEdgeMap(this.labelEdgeMap, edge);
        this.addToNodeInEdgeMap(this.nodeInEdgeMap, edge);
        this.addToNodeOutEdgeMap(this.nodeOutEdgeMap, edge);
        this.addToNodeEdgeMap(this.nodeEdgeMap, (N)edge);
    }

    protected void removeUpdate(N node) {
        this.removeFromNodeEdgeMap(this.nodeEdgeMap, node);
        this.removeFromNodeEdgeMap(this.nodeInEdgeMap, node);
        this.removeFromNodeEdgeMap(this.nodeOutEdgeMap, node);
    }

    protected void removeUpdate(E elem) {
        this.removeFromLabelEdgeMap(this.labelEdgeMap, elem);
        this.removeFromNodeEdgeMap(this.nodeEdgeMap, (N)elem);
        this.removeFromNodeInEdgeMap(this.nodeInEdgeMap, elem);
        this.removeFromNodeOutEdgeMap(this.nodeOutEdgeMap, elem);
    }

    public Map<Label, ? extends Set<? extends E>> getLabelEdgeMap() {
        Map<Label, Set<E>> result = this.labelEdgeMap;
        if (result == null) {
            Map<Label, Set<E>> newMaps = this.computeLabelEdgeMap();
            if (this.storeData()) {
                this.labelEdgeMap = newMaps;
            }
            result = newMaps;
        }
        return result;
    }

    public Map<N, ? extends Set<? extends E>> getNodeInEdgeMap() {
        Map<N, Set<E>> result = this.nodeInEdgeMap;
        if (result == null) {
            result = this.computeNodeInEdgeMap();
            if (this.storeData()) {
                this.nodeInEdgeMap = result;
            }
        }
        return result;
    }

    public Map<N, ? extends Set<? extends E>> getNodeOutEdgeMap() {
        Map<N, Set<E>> result = this.nodeOutEdgeMap;
        if (result == null) {
            result = this.computeNodeOutEdgeMap();
            if (this.storeData()) {
                this.nodeOutEdgeMap = result;
            }
        }
        return result;
    }

    public Map<N, ? extends Set<? extends E>> getNodeEdgeMap() {
        Map<N, Set<E>> result = this.nodeEdgeMap;
        if (result == null) {
            result = this.computeNodeEdgeMap();
            if (this.storeData()) {
                this.nodeEdgeMap = result;
            }
        }
        return result;
    }

    private Map<Label, Set<E>> computeLabelEdgeMap() {
        HashMap<Label, Set<E>> result = new HashMap<Label, Set<E>>();
        for (Edge edge : this.graph.edgeSet()) {
            this.addToLabelEdgeMap(result, edge);
        }
        return result;
    }

    private Map<N, Set<E>> computeNodeInEdgeMap() {
        HashMap<Object, Object> result;
        if (this.nodeEdgeMap == null) {
            result = new HashMap();
            for (Node node : this.graph.nodeSet()) {
                result.put(node, this.createEdgeSet(null));
            }
            for (Edge edge : this.graph.edgeSet()) {
                ((Set)result.get(edge.target())).add(edge);
            }
        } else {
            result = new HashMap<N, Set<E>>(this.nodeEdgeMap);
            for (Map.Entry entry : result.entrySet()) {
                Node node = (Node)entry.getKey();
                Set<Edge> inEdges = this.createEdgeSet(null);
                for (Edge edge : (Set)entry.getValue()) {
                    if (!edge.target().equals(node)) continue;
                    inEdges.add(edge);
                }
                entry.setValue(inEdges);
            }
        }
        return result;
    }

    private Map<N, Set<E>> computeNodeOutEdgeMap() {
        HashMap<Object, Object> result;
        if (this.nodeEdgeMap == null) {
            result = new HashMap();
            for (Node node : this.graph.nodeSet()) {
                result.put(node, this.createEdgeSet(null));
            }
            for (Edge edge : this.graph.edgeSet()) {
                ((Set)result.get(edge.source())).add(edge);
            }
        } else {
            result = new HashMap<N, Set<E>>(this.nodeEdgeMap);
            for (Map.Entry entry : result.entrySet()) {
                Node node = (Node)entry.getKey();
                Set<Edge> inEdges = this.createEdgeSet(null);
                for (Edge edge : (Set)entry.getValue()) {
                    if (!edge.source().equals(node)) continue;
                    inEdges.add(edge);
                }
                entry.setValue(inEdges);
            }
        }
        return result;
    }

    private Map<N, Set<E>> computeNodeEdgeMap() {
        HashMap result = new HashMap();
        for (Edge edge : this.graph.edgeSet()) {
            this.addToNodeEdgeMap((Map<N, Set<E>>)result, (N)edge);
        }
        if (result.size() != this.graph.nodeCount()) {
            for (Node node : this.graph.nodeSet()) {
                this.addToNodeEdgeMap((Map<N, Set<E>>)result, (N)node);
            }
        }
        return result;
    }

    private boolean isDynamic() {
        return this.dynamic;
    }

    private void addToLabelEdgeMap(Map<Label, Set<E>> currentMap, E edge) {
        if (currentMap != null) {
            Set<E> labelEdgeSet = currentMap.get(edge.label());
            if (labelEdgeSet == null) {
                labelEdgeSet = this.createSmallEdgeSet();
                currentMap.put(edge.label(), labelEdgeSet);
            }
            labelEdgeSet.add(edge);
        }
    }

    private void removeFromLabelEdgeMap(Map<Label, Set<E>> currentMap, E edge) {
        Set<E> labelEdgeSet;
        if (currentMap != null && (labelEdgeSet = currentMap.get(edge.label())) != null) {
            labelEdgeSet.remove(edge);
        }
    }

    private void addToNodeInEdgeMap(Map<N, Set<E>> currentMap, E edge) {
        if (currentMap != null) {
            this.addToNodeEdgeMap(currentMap, edge.target(), edge);
        }
    }

    private void addToNodeOutEdgeMap(Map<N, Set<E>> currentMap, E edge) {
        if (currentMap != null) {
            this.addToNodeEdgeMap(currentMap, edge.source(), edge);
        }
    }

    private void addToNodeEdgeMap(Map<N, Set<E>> currentMap, E edge) {
        if (currentMap != null) {
            this.addToNodeEdgeMap(currentMap, edge.source(), edge);
            this.addToNodeEdgeMap(currentMap, edge.target(), edge);
        }
    }

    private void addToNodeEdgeMap(Map<N, Set<E>> currentMap, N node, E edge) {
        Set<E> edgeSet = currentMap.get(node);
        if (edgeSet == null) {
            edgeSet = this.createSmallEdgeSet();
            currentMap.put(node, edgeSet);
        }
        edgeSet.add(edge);
    }

    private void addToNodeEdgeMap(Map<N, Set<E>> currentMap, N node) {
        Set<E> currentValue;
        if (currentMap != null && (currentValue = currentMap.put(node, this.createSmallEdgeSet())) != null) {
            currentMap.put(node, currentValue);
        }
    }

    private void removeFromNodeInEdgeMap(Map<N, Set<E>> currentMap, E edge) {
        Set<E> edgeSet;
        if (currentMap != null && (edgeSet = currentMap.get(edge.target())) != null) {
            edgeSet.remove(edge);
        }
    }

    private void removeFromNodeOutEdgeMap(Map<N, Set<E>> currentMap, E edge) {
        Set<E> edgeSet;
        if (currentMap != null && (edgeSet = currentMap.get(edge.source())) != null) {
            edgeSet.remove(edge);
        }
    }

    private void removeFromNodeEdgeMap(Map<N, Set<E>> currentMap, E edge) {
        if (currentMap != null) {
            this.removeFromNodeInEdgeMap(currentMap, edge);
            this.removeFromNodeOutEdgeMap(currentMap, edge);
        }
    }

    private void removeFromNodeEdgeMap(Map<N, Set<E>> currentMap, N node) {
        if (currentMap != null) {
            currentMap.remove(node);
        }
    }

    private Set<E> createEdgeSet(Collection<E> set) {
        Set<E> result = this.createSmallEdgeSet();
        if (set != null) {
            result.addAll(set);
        }
        return result;
    }

    private Set<E> createSmallEdgeSet() {
        return new TreeHashSet();
    }

    private boolean storeData() {
        return this.isDynamic() || this.graph.isFixed();
    }

    protected DefaultDispenser getNodeCounter() {
        if (this.nodeCounter == null) {
            this.nodeCounter = new DefaultDispenser();
            int maxNodeNr = -1;
            for (Node node : this.getGraph().nodeSet()) {
                maxNodeNr = Math.max(maxNodeNr, node.getNumber());
            }
            this.nodeCounter.setCount(maxNodeNr + 1);
        }
        return this.nodeCounter;
    }

    protected boolean hasCertifier(boolean strong) {
        return this.certificateStrategy != null && this.certificateStrategy.getStrength() == strong;
    }

    protected CertificateStrategy getCertifier(boolean strong) {
        CertificateStrategy result;
        if (this.hasCertifier(strong)) {
            result = this.certificateStrategy;
        } else {
            result = AGraph.getCertificateFactory().newInstance(this.getGraph(), strong);
            if (this.graph.isFixed()) {
                this.certificateStrategy = result;
            }
        }
        return result;
    }

    public AGraph<N, E> getGraph() {
        return this.graph;
    }
}

