/*
 * Decompiled with CFR 0.152.
 */
package groove.graph;

import groove.graph.Edge;
import groove.graph.ElementFactory;
import groove.graph.ElementMap;
import groove.graph.Label;
import groove.graph.Node;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class AElementMap<SN extends Node, SE extends Edge, TN extends Node, TE extends Edge>
implements ElementMap,
Cloneable {
    private final Map<SN, TN> nodeMap = this.createNodeMap();
    private final Map<SE, TE> edgeMap = this.createEdgeMap();
    private final ElementFactory<TN, TE> factory;

    public AElementMap(ElementFactory<TN, TE> factory) {
        this.factory = factory;
    }

    public void clear() {
        this.nodeMap().clear();
        this.edgeMap().clear();
    }

    @Override
    public boolean isEmpty() {
        return this.nodeMap().isEmpty() && this.edgeMap().isEmpty();
    }

    @Override
    public int size() {
        return this.nodeMap().size() + this.edgeMap().size();
    }

    public TN getNode(Node key) {
        return (TN)((Node)this.nodeMap().get(key));
    }

    public TE getEdge(Edge key) {
        return (TE)((Edge)this.edgeMap().get(key));
    }

    public TN putNode(SN key, TN value) {
        return (TN)((Node)this.nodeMap.put(key, value));
    }

    public TE putEdge(SE key, TE value) {
        return (TE)((Edge)this.edgeMap.put(key, value));
    }

    public void putAll(AElementMap<SN, SE, TN, TE> other) {
        this.nodeMap.putAll(other.nodeMap());
        this.edgeMap.putAll(other.edgeMap());
    }

    public TN removeNode(SN key) {
        return (TN)((Node)this.nodeMap().remove(key));
    }

    public TE removeEdge(SE key) {
        return (TE)((Edge)this.edgeMap().remove(key));
    }

    @Override
    public boolean isInjective() {
        HashSet<TN> nodeValues = new HashSet<TN>(this.nodeMap().values());
        return this.nodeMap().size() == nodeValues.size();
    }

    public boolean equals(Object obj) {
        return obj instanceof AElementMap && this.nodeMap().equals(((AElementMap)obj).nodeMap()) && this.edgeMap().equals(((AElementMap)obj).edgeMap());
    }

    public int hashCode() {
        return this.nodeMap().hashCode() + this.edgeMap().hashCode();
    }

    public String toString() {
        String result = "Node map: " + this.nodeMap();
        result = String.valueOf(result) + "; Edge map: " + this.edgeMap();
        return result;
    }

    public Label mapLabel(Label label) {
        return this.factory.createLabel(label.toString());
    }

    public TE mapEdge(SE key) {
        TE result = this.getEdge((Edge)key);
        if (result == null && (result = this.createImage(key)) != null) {
            this.putEdge(key, result);
        }
        return result;
    }

    protected TE createImage(SE key) {
        TN sourceImage = this.getNode(key.source());
        if (sourceImage == null) {
            return null;
        }
        Label labelImage = this.mapLabel(key.label());
        if (labelImage == null) {
            return null;
        }
        TN targetImage = this.getNode(key.target());
        if (targetImage == null) {
            return null;
        }
        return this.getFactory().createEdge(sourceImage, labelImage, targetImage);
    }

    public ElementFactory<TN, TE> getFactory() {
        return this.factory;
    }

    public Map<SN, ? extends TN> nodeMap() {
        return this.nodeMap;
    }

    public Map<SE, ? extends TE> edgeMap() {
        return this.edgeMap;
    }

    protected Map<SN, TN> createNodeMap() {
        return new HashMap();
    }

    protected Map<SE, TE> createEdgeMap() {
        return new HashMap();
    }
}

