/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.type;

import groove.automaton.RegExpr;
import groove.automaton.RegExprTyper;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostGraphMorphism;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.model.FormatError;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.rule.DefaultRuleNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.OperatorNode;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleFactory;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleGraphMorphism;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.grammar.type.EdgeMultiplicityVerifier;
import groove.grammar.type.LabelPattern;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeFactory;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.AEdge;
import groove.graph.Edge;
import groove.graph.EdgeRole;
import groove.graph.GraphRole;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.NodeSetEdgeSetGraph;
import groove.util.Groove;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class TypeGraph
extends NodeSetEdgeSetGraph<TypeNode, TypeEdge> {
    private final TypeFactory factory;
    private final Map<Label, TypeNode> typeNodeMap = new HashMap<Label, TypeNode>();
    private final Set<TypeNode> imports = new HashSet<TypeNode>();
    private final boolean implicit;
    private final NodeTypeMap nodeDirectSubtypeMap = new NodeTypeMap(false);
    private final NodeTypeMap nodeDirectSupertypeMap = new NodeTypeMap(false);
    private final NodeTypeMap nodeSubtypeMap = new NodeTypeMap(true);
    private final NodeTypeMap nodeSupertypeMap = new NodeTypeMap(true);
    private final Map<TypeEdge, Set<TypeEdge>> edgeSubtypeMap = new HashMap<TypeEdge, Set<TypeEdge>>();
    private final Map<TypeEdge, Set<TypeEdge>> edgeSupertypeMap = new HashMap<TypeEdge, Set<TypeEdge>>();
    private final SortedMap<String, Sub> componentMap = new TreeMap<String, Sub>();
    private Set<TypeLabel> labels;
    private TypeEdgeMap exactEdgeMap;
    private TypeEdgeMap superEdgeMap;

    public TypeGraph(String name) {
        this(name, false);
    }

    public TypeGraph(String name, boolean implicit) {
        super(name);
        this.implicit = implicit;
        this.factory = new TypeFactory(this);
    }

    @Override
    public GraphRole getRole() {
        return GraphRole.TYPE;
    }

    public Map<TypeNode, TypeNode> add(TypeGraph other) throws FormatException {
        this.testFixed(false);
        HashSet<TypeNode> newNodes = new HashSet<TypeNode>();
        HashSet<TypeEdge> newEdges = new HashSet<TypeEdge>();
        HashMap<TypeNode, TypeNode> otherToThis = new HashMap<TypeNode, TypeNode>();
        for (Node node : other.nodeSet()) {
            TypeNode otherTypeNode = (TypeNode)node;
            TypeNode image = this.addNode(otherTypeNode.label());
            image.setAbstract(otherTypeNode.isAbstract());
            if (otherTypeNode.getColor() != null) {
                image.setColor(otherTypeNode.getColor());
            }
            image.setLabelPattern(otherTypeNode.getLabelPattern());
            boolean imported = image.isImported() && otherTypeNode.isImported();
            image.setImported(imported);
            if (imported) {
                this.imports.add(image);
            } else {
                this.imports.remove(image);
            }
            if (!otherTypeNode.isImported()) {
                newNodes.add(image);
            }
            otherToThis.put(otherTypeNode, image);
        }
        for (TypeEdge typeEdge : other.edgeSet()) {
            TypeEdge image = (TypeEdge)this.addEdge((TypeNode)otherToThis.get(typeEdge.source()), (Label)typeEdge.label(), (TypeNode)otherToThis.get(typeEdge.target()));
            image.setInMult(typeEdge.getInMult());
            image.setOutMult(typeEdge.getOutMult());
            image.setAbstract(typeEdge.isAbstract());
            image.setComposite(typeEdge.isComposite());
            newEdges.add(image);
        }
        for (Map.Entry entry : other.nodeDirectSupertypeMap.entrySet()) {
            for (TypeNode supertype : (Set)entry.getValue()) {
                this.addInheritance((TypeNode)otherToThis.get(entry.getKey()), (TypeNode)otherToThis.get(supertype));
            }
        }
        this.componentMap.put(other.getName(), new Sub(other.getName(), newNodes, newEdges));
        return otherToThis;
    }

    @Override
    public boolean addNode(TypeNode node) {
        boolean result = super.addNode(node);
        if (result) {
            TypeNode oldType = this.typeNodeMap.put(node.label(), node);
            assert (oldType == null) : String.format("Duplicate type node for %s", oldType.label());
            if (node.isImported()) {
                this.imports.add(node);
            }
            this.nodeDirectSubtypeMap.add(node);
            this.nodeDirectSupertypeMap.add(node);
            this.nodeSubtypeMap.add(node);
            this.nodeSupertypeMap.add(node);
        }
        return result;
    }

    public TypeNode addNode(TypeLabel label) {
        assert (label.getRole() == EdgeRole.NODE_TYPE) : String.format("Label %s is not a node type", label);
        TypeNode result = this.typeNodeMap.get(label);
        if (result == null) {
            result = this.getFactory().createNode(label);
        }
        return result;
    }

    @Override
    public TypeGraph clone() {
        TypeGraph result;
        block2: {
            result = new TypeGraph(this.getName());
            try {
                result.add(this);
            }
            catch (FormatException formatException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return result;
    }

    @Override
    public TypeGraph newGraph(String name) {
        return new TypeGraph(this.getName());
    }

    @Override
    public boolean removeEdge(TypeEdge edge) {
        throw new UnsupportedOperationException("Edge removal not allowed in type graphs");
    }

    @Override
    public boolean removeNode(TypeNode node) {
        throw new UnsupportedOperationException("Node removal not allowed in type graphs");
    }

    public void addInheritance(TypeNode subtype, TypeNode supertype) throws FormatException {
        this.testFixed(false);
        if (supertype.label().isDataType()) {
            throw new FormatException("Data type '%s' cannot be supertype", supertype);
        }
        if (subtype.label().isDataType()) {
            throw new FormatException("Data type '%s' cannot be subtype", subtype);
        }
        if (((Set)this.nodeSupertypeMap.get(supertype)).contains(subtype)) {
            throw new FormatException(String.format("The relation '%s -> %s' introduces a cyclic type dependency", subtype, supertype), new Object[0]);
        }
        ((Set)this.nodeDirectSubtypeMap.get(supertype)).add(subtype);
        ((Set)this.nodeDirectSupertypeMap.get(subtype)).add(supertype);
        Set subsubtypes = (Set)this.nodeSubtypeMap.get(subtype);
        Set supersupertypes = (Set)this.nodeSupertypeMap.get(supertype);
        for (TypeNode subsubtype : subsubtypes) {
            ((Set)this.nodeSupertypeMap.get(subsubtype)).addAll(supersupertypes);
        }
        for (TypeNode supersupertype : supersupertypes) {
            ((Set)this.nodeSubtypeMap.get(supersupertype)).addAll(subsubtypes);
        }
    }

    public void test() throws FormatException {
        FormatErrorSet errors = new FormatErrorSet();
        HashSet<TypeLabel> edgeLabels = new HashSet<TypeLabel>();
        for (TypeEdge typeEdge : this.edgeSet()) {
            if (typeEdge.getRole() == EdgeRole.NODE_TYPE || typeEdge.isAbstract()) continue;
            TypeNode source = (TypeNode)typeEdge.source();
            TypeLabel typeLabel = (TypeLabel)typeEdge.label();
            TypeLabel sourceType = source.label();
            if (sourceType.isDataType()) {
                errors.add("Data type '%s' cannot have %s", sourceType.text(), typeLabel.getRole() == EdgeRole.FLAG ? "flags" : "outgoing edges", source);
            }
            edgeLabels.add((TypeLabel)typeEdge.label());
        }
        for (TypeLabel edgeLabel : edgeLabels) {
            ArrayList edges = new ArrayList(this.edgeSet(edgeLabel));
            int i = 0;
            while (i < edges.size() - 1) {
                TypeEdge edge1 = (TypeEdge)edges.get(i);
                if (!edge1.isAbstract()) {
                    int j = i + 1;
                    while (j < edges.size()) {
                        TypeEdge edge2 = (TypeEdge)edges.get(j);
                        if (!edge2.isAbstract() && this.hasCommonSubtype((TypeNode)edge1.source(), (TypeNode)edge2.source()) && this.hasCommonSubtype((TypeNode)edge1.target(), (TypeNode)edge2.target())) {
                            errors.add("Possible type confusion of %s-%ss", edgeLabel.text(), edgeLabel.getRole() == EdgeRole.FLAG ? "flag" : "edge", edge1, edge2);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        errors.throwException();
    }

    @Override
    public boolean setFixed() {
        boolean result = super.setFixed();
        if (result) {
            Set<Object> subtypes;
            for (TypeEdge edge : this.edgeSet()) {
                subtypes = new HashSet<TypeEdge>();
                subtypes.add(edge);
                this.edgeSubtypeMap.put(edge, subtypes);
                HashSet<TypeEdge> supertypes = new HashSet<TypeEdge>();
                supertypes.add(edge);
                this.edgeSupertypeMap.put(edge, supertypes);
            }
            for (TypeEdge edge : this.edgeSet()) {
                subtypes = this.edgeSubtypeMap.get(edge);
                if (!edge.isAbstract()) continue;
                Set sourceSubnodes = (Set)this.nodeSubtypeMap.get(edge.source());
                Set targetSubnodes = (Set)this.nodeSubtypeMap.get(edge.target());
                for (TypeEdge subEdge : this.edgeSet((Label)edge.label())) {
                    if (!sourceSubnodes.contains(subEdge.source()) || !targetSubnodes.contains(subEdge.target())) continue;
                    subtypes.add(subEdge);
                    this.edgeSupertypeMap.get(subEdge).add(edge);
                }
            }
            for (TypeNode node : this.nodeSet()) {
                LabelPattern nodePattern;
                Color nodeColour = node.getColor();
                if (nodeColour != null) {
                    HashSet propagatees = new HashSet((Collection)this.nodeSubtypeMap.get(node));
                    propagatees.remove(node);
                    while (!propagatees.isEmpty()) {
                        Iterator subNodeIter = propagatees.iterator();
                        TypeNode subNode = (TypeNode)subNodeIter.next();
                        subNodeIter.remove();
                        if (subNode.getColor() == null) {
                            subNode.setColor(nodeColour);
                            continue;
                        }
                        propagatees.removeAll((Collection)this.nodeSubtypeMap.get(subNode));
                    }
                }
                if ((nodePattern = node.getLabelPattern()) == null) continue;
                HashSet propagatees = new HashSet((Collection)this.nodeSubtypeMap.get(node));
                propagatees.remove(node);
                while (!propagatees.isEmpty()) {
                    Iterator subNodeIter = propagatees.iterator();
                    TypeNode subNode = (TypeNode)subNodeIter.next();
                    subNodeIter.remove();
                    if (subNode.getLabelPattern() == null) {
                        subNode.setLabelPattern(nodePattern);
                        continue;
                    }
                    propagatees.removeAll((Collection)this.nodeSubtypeMap.get(subNode));
                }
            }
        }
        return result;
    }

    public TypeFactory getFactory() {
        return this.factory;
    }

    public Set<TypeNode> getImports() {
        return this.imports;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public boolean isNodeType(EdgeRole role) {
        return role == EdgeRole.NODE_TYPE && !this.isImplicit();
    }

    public boolean isNodeType(Label label) {
        return this.isNodeType(label.getRole());
    }

    public boolean isNodeType(Edge edge) {
        return this.isNodeType(edge.getRole());
    }

    public boolean isSubtype(TypeNode subtype, TypeNode supertype) {
        if (subtype.equals(supertype)) {
            return true;
        }
        if (this.isImplicit()) {
            return false;
        }
        this.testFixed(true);
        Set<TypeNode> allSubtypes = this.getSubtypes(supertype);
        if (allSubtypes.size() == 1) {
            return false;
        }
        return this.getSubtypes(supertype).contains(subtype);
    }

    public boolean isSubtype(TypeEdge subtype, TypeEdge supertype) {
        if (subtype.equals(supertype)) {
            return true;
        }
        if (this.isImplicit()) {
            return false;
        }
        this.testFixed(true);
        return this.getSubtypes(supertype).contains(subtype);
    }

    public RuleGraphMorphism analyzeRule(RuleGraph source, RuleGraphMorphism parentTyping) throws FormatException {
        RuleLabel edgeLabel;
        RuleElement image;
        this.testFixed(true);
        RuleFactory ruleFactory = parentTyping.getFactory();
        RuleGraphMorphism result = new RuleGraphMorphism(ruleFactory);
        FormatErrorSet errors = new FormatErrorSet();
        result.copyVarTyping(parentTyping);
        for (RuleEdge edge : source.edgeSet()) {
            if (!this.isNodeType(edge) || !((RuleLabel)edge.label()).isWildcard()) continue;
            TypeGuard guard = ((RuleLabel)edge.label()).getWildcardGuard();
            LabelVar var = guard.getVar();
            Set<? extends TypeElement> types = result.getVarTypes(var);
            if (types == null) {
                types = new HashSet(this.nodeSet());
            }
            guard.filter(types);
            result.addVarTypes(var, types);
        }
        ArrayList<OperatorNode> opNodes = new ArrayList<OperatorNode>();
        for (RuleNode node : source.nodeSet()) {
            try {
                RuleNode image2;
                if (node instanceof OperatorNode) {
                    opNodes.add((OperatorNode)node);
                    continue;
                }
                if (node instanceof VariableNode) {
                    VariableNode varNode = (VariableNode)node;
                    image2 = ruleFactory.createVariableNode(varNode.getNumber(), varNode.getTerm());
                    if (!this.nodeSet().contains(image2.getType())) {
                        throw new FormatException("Data type %s not used in type graph", image2.getType(), node);
                    }
                } else if (this.isImplicit()) {
                    image2 = ruleFactory.createNode(node.getNumber());
                } else {
                    RuleNode parentImage = (RuleNode)parentTyping.getNode(node);
                    image2 = this.createRuleNode(parentTyping, source, node, result.getVarTyping());
                    if (parentImage != null) {
                        TypeNode parentType = parentImage.getType();
                        if (!this.isSubtype(image2.getType(), parentType)) {
                            throw new FormatException("Node type %s should specialise %s", image2.getType(), parentType, node);
                        }
                    }
                }
                result.putNode(node, image2);
            }
            catch (FormatException e) {
                errors.addAll(e.getErrors());
            }
        }
        for (OperatorNode opNode : opNodes) {
            boolean imageOk = true;
            ArrayList<VariableNode> newArgs = new ArrayList<VariableNode>();
            for (VariableNode arg : opNode.getArguments()) {
                VariableNode argImage = (VariableNode)result.getNode(arg);
                if (argImage == null) {
                    imageOk = false;
                    break;
                }
                newArgs.add(argImage);
            }
            Iterator newTarget = (VariableNode)result.getNode(opNode.getTarget());
            if (!(imageOk &= newTarget != null)) continue;
            image = ruleFactory.createOperatorNode(opNode.getNumber(), opNode.getOperator(), (List<VariableNode>)newArgs, (VariableNode)((Object)newTarget));
            result.putNode(opNode, image);
        }
        HashSet<RuleEdge> varEdges = new HashSet<RuleEdge>();
        HashSet<RuleEdge> regExprEdges = new HashSet<RuleEdge>();
        HashSet<RuleEdge> simpleEdges = new HashSet<RuleEdge>();
        for (RuleEdge edge : source.edgeSet()) {
            if (!result.nodeMap().containsKey(edge.source()) || !result.nodeMap().containsKey(edge.target()) || this.isNodeType(edge)) continue;
            edgeLabel = (RuleLabel)edge.label();
            if (edgeLabel.isAtom() || edgeLabel.isSharp()) {
                simpleEdges.add(edge);
                continue;
            }
            if (edgeLabel.isWildcard()) {
                varEdges.add(edge);
                continue;
            }
            regExprEdges.add(edge);
        }
        for (RuleEdge varEdge : varEdges) {
            image = ruleFactory.createEdge((RuleNode)result.getNode((Node)varEdge.source()), (Label)varEdge.label(), (RuleNode)result.getNode((Node)varEdge.target()));
            Set<TypeEdge> matchingTypes = ((RuleEdge)image).getMatchingTypes();
            for (TypeGuard guard : ((RuleEdge)image).getTypeGuards()) {
                matchingTypes.retainAll(result.addVarTypes(guard.getVar(), matchingTypes));
            }
            if (((RuleEdge)image).getMatchingTypes().isEmpty()) {
                errors.add("Inconsistent %s type %s", ((RuleLabel)((AEdge)((Object)image)).label()).getRole().getDescription(false), ((AEdge)((Object)image)).label(), varEdge);
            }
            result.putEdge(varEdge, image);
        }
        for (RuleEdge edge : simpleEdges) {
            edgeLabel = (RuleLabel)edge.label();
            RuleNode sourceImage = (RuleNode)result.getNode((Node)edge.source());
            RuleNode targetImage = (RuleNode)result.getNode((Node)edge.target());
            TypeNode sourceType = sourceImage.getType();
            TypeEdge typeEdge = this.getTypeEdge(sourceImage.getType(), edgeLabel.getTypeLabel(), targetImage.getType(), false);
            if (typeEdge == null) {
                if (sourceType.isTopType()) continue;
                errors.add("%s-node has unknown %s-%s", sourceType, edgeLabel, edge.getRole().getDescription(false), edge);
                continue;
            }
            result.putEdge(edge, ruleFactory.createEdge(sourceImage, (Label)edgeLabel, targetImage));
        }
        RegExprTyper regExprTyper = new RegExprTyper(this, result.getVarTyping());
        for (RuleEdge edge : regExprEdges) {
            RuleLabel edgeLabel2 = (RuleLabel)edge.label();
            RuleNode sourceImage = (RuleNode)result.getNode((Node)edge.source());
            RuleNode targetImage = (RuleNode)result.getNode((Node)edge.target());
            RuleLabel checkLabel = edgeLabel2.isNeg() ? edgeLabel2.getNegOperand().toLabel() : edgeLabel2;
            RegExpr expr = checkLabel.getMatchExpr();
            RegExprTyper.Result typeResult = expr.apply(regExprTyper);
            if (typeResult.hasErrors()) {
                if (!sourceImage.getType().isTopType()) {
                    for (FormatError error : typeResult.getErrors()) {
                        errors.add(new FormatError(error, edge));
                    }
                }
            } else {
                boolean fit = false;
                HashSet<TypeNode> targetTypes = new HashSet<TypeNode>(this.getMatchingTypes(targetImage));
                for (TypeNode sourceType : this.getMatchingTypes(sourceImage)) {
                    Set<TypeNode> resultTargetTypes = typeResult.getAll(sourceType);
                    if (resultTargetTypes == null || !targetTypes.removeAll(resultTargetTypes)) continue;
                    fit = true;
                    break;
                }
                if (!fit) {
                    errors.add("No %s-path can exist between %s and %s", checkLabel, sourceImage.getType(), targetImage.getType(), edge);
                }
            }
            result.putEdge(edge, ruleFactory.createEdge(sourceImage, (Label)edgeLabel2, targetImage));
        }
        errors.throwException();
        return result;
    }

    private RuleNode createRuleNode(RuleGraphMorphism parentTyping, RuleGraph graph, RuleNode node, Map<LabelVar, Set<? extends TypeElement>> varTyping) throws FormatException {
        String constraints;
        int n;
        ArrayList<TypeGuard> typeGuards = new ArrayList<TypeGuard>();
        HashSet<LabelVar> labelVars = new HashSet<LabelVar>();
        RuleNode parentImage = (RuleNode)parentTyping.getNode(node);
        TypeNode type = null;
        boolean sharp = false;
        for (RuleEdge edge : graph.outEdgeSet(node)) {
            if (((RuleLabel)edge.label()).getRole() != EdgeRole.NODE_TYPE) continue;
            TypeGuard guard = ((RuleLabel)edge.label()).getWildcardGuard();
            if (guard != null) {
                typeGuards.add(guard);
                labelVars.add(guard.getVar());
                continue;
            }
            TypeLabel typeLabel = ((RuleLabel)edge.label()).getTypeLabel();
            assert (typeLabel != null);
            if (type == null) {
                type = this.getNode(typeLabel);
                sharp = ((RuleLabel)edge.label()).isSharp();
                if (type != null) continue;
                throw new FormatException("Unknown node type %s", typeLabel, edge);
            }
            throw new FormatException("Duplicate node types %s and %s", type.label(), typeLabel, node);
        }
        HashSet<TypeNode> validTypes = new HashSet<TypeNode>();
        for (TypeNode typeNode : parentImage == null ? this.nodeSet() : parentImage.getMatchingTypes()) {
            if (typeNode.isDataType()) continue;
            validTypes.add(typeNode);
        }
        boolean bl = false;
        for (LabelVar var : labelVars) {
            n |= validTypes.retainAll((Collection)varTyping.get(var));
        }
        if (n != 0) {
            for (LabelVar var : labelVars) {
                varTyping.get(var).retainAll(validTypes);
            }
        }
        if (validTypes.isEmpty()) {
            constraints = Groove.toString(typeGuards.toArray(), "", "", ", ", " and ");
            throw new FormatException("Inconsistent type constraint%s %s", typeGuards.size() == 1 ? "" : "s", constraints, node);
        }
        if (type == null) {
            if (parentImage == null && typeGuards.isEmpty()) {
                throw new FormatException("Untyped node", node);
            }
            type = this.getLub(validTypes);
            if (type == null) {
                throw new FormatException("Ambiguous typing: %s do not have least common supertype", validTypes, node);
            }
        } else if (validTypes.retainAll(type.getSubtypes())) {
            for (LabelVar var : labelVars) {
                varTyping.get(var).retainAll(validTypes);
            }
            if (validTypes.isEmpty()) {
                constraints = Groove.toString(typeGuards.toArray(), "", "", ", ", " and ");
                throw new FormatException("Node type %s conflicts with type constraint%s %s", type, typeGuards.size() == 1 ? "" : "s", constraints, node);
            }
        }
        DefaultRuleNode result = parentTyping.getFactory().createNode(node.getNumber(), type.label(), sharp, typeGuards);
        result.getMatchingTypes().retainAll(validTypes);
        return result;
    }

    private Set<TypeNode> getMatchingTypes(RuleNode node) {
        HashSet<TypeNode> result = new HashSet<TypeNode>();
        if (node.isSharp()) {
            result.add(node.getType());
        } else {
            result.addAll(this.getSubtypes(node.getType()));
        }
        return result;
    }

    public HostGraphMorphism analyzeHost(HostGraph source) throws FormatException {
        this.testFixed(true);
        HostFactory hostFactory = HostFactory.newInstance(this.getFactory());
        HostGraphMorphism morphism = new HostGraphMorphism(hostFactory);
        FormatErrorSet errors = new FormatErrorSet();
        for (HostNode node : source.nodeSet()) {
            try {
                HostNode image;
                if (node instanceof ValueNode) {
                    ValueNode valueNode = (ValueNode)node;
                    image = hostFactory.createValueNode(valueNode.getNumber(), valueNode.getAlgebra(), valueNode.getValue());
                } else if (this.isImplicit()) {
                    image = hostFactory.createNode(node.getNumber());
                } else {
                    List<HostEdge> nodeTypeEdges = this.detectNodeType(source, node);
                    if (nodeTypeEdges.isEmpty()) {
                        errors.add("Untyped node", node);
                        image = node;
                    } else if (nodeTypeEdges.size() > 1) {
                        errors.add("Multiple node types %s, %s", nodeTypeEdges.get(0), nodeTypeEdges.get(1), node);
                        image = node;
                    } else {
                        HostEdge nodeTypeEdge = nodeTypeEdges.get(0);
                        TypeLabel nodeType = nodeTypeEdge.label();
                        TypeNode type = this.getNode(nodeType);
                        if (type == null) {
                            throw new FormatException("Unknown node type '%s'", nodeType, nodeTypeEdge);
                        }
                        if (type.isAbstract()) {
                            throw new FormatException("Abstract node type '%s'", type, nodeTypeEdge);
                        }
                        image = hostFactory.createNode(node.getNumber(), nodeType);
                    }
                }
                morphism.putNode(node, image);
            }
            catch (FormatException e) {
                errors.addAll(e.getErrors());
            }
        }
        for (HostEdge edge : source.edgeSet()) {
            if (this.isNodeType(edge)) continue;
            TypeLabel edgeType = edge.label();
            HostNode sourceImage = (HostNode)morphism.getNode(edge.source());
            HostNode targetImage = (HostNode)morphism.getNode(edge.target());
            if (sourceImage == null || targetImage == null) continue;
            TypeNode sourceType = sourceImage.getType();
            TypeNode targetType = targetImage.getType();
            if (sourceType == null || targetType == null) continue;
            TypeEdge typeEdge = this.getTypeEdge(sourceType, edgeType, targetType, false);
            if (typeEdge == null) {
                if (sourceType.isTopType()) continue;
                errors.add("%s-node has unknown %s-%s", sourceType, edgeType.text(), edgeType.getRole().getDescription(false), edge.source());
                continue;
            }
            if (typeEdge.isAbstract()) {
                errors.add("%s-node has abstract %s-%s", sourceType, edgeType.text(), edgeType.getRole().getDescription(false), edge.source());
                continue;
            }
            morphism.putEdge(edge, hostFactory.createEdge(sourceImage, (Label)edgeType, targetImage));
        }
        errors.throwException();
        EdgeMultiplicityVerifier.verifyMultiplicities(source, this);
        return morphism;
    }

    private List<HostEdge> detectNodeType(HostGraph source, HostNode node) throws FormatException {
        ArrayList<HostEdge> result = new ArrayList<HostEdge>();
        for (HostEdge edge : source.outEdgeSet(node)) {
            if (edge.getRole() != EdgeRole.NODE_TYPE) continue;
            result.add(edge);
        }
        return result;
    }

    public TypeEdge getTypeEdge(TypeNode sourceType, TypeLabel label, TypeNode targetType, boolean precise) {
        TypeEdge result = null;
        if (this.isFixed()) {
            TypeEdgeMap edgeMap;
            if (precise) {
                edgeMap = this.exactEdgeMap;
                if (edgeMap == null) {
                    edgeMap = this.exactEdgeMap = this.computeEdgeMap(true);
                }
            } else {
                edgeMap = this.superEdgeMap;
                if (edgeMap == null) {
                    edgeMap = this.superEdgeMap = this.computeEdgeMap(false);
                }
            }
            result = edgeMap.get(sourceType, label, targetType);
        } else {
            result = this.findTypeEdge(sourceType, label, targetType, precise);
        }
        return result;
    }

    private TypeEdgeMap computeEdgeMap(boolean precise) {
        TypeEdgeMap result = new TypeEdgeMap();
        for (TypeEdge edge : this.edgeSet()) {
            if (precise) {
                result.put((TypeNode)edge.source(), (TypeNode)edge.target(), edge);
                continue;
            }
            for (TypeNode source : this.getSubtypes((TypeNode)edge.source())) {
                for (TypeNode target : this.getSubtypes((TypeNode)edge.target())) {
                    TypeEdge image = result.get(source, (TypeLabel)edge.label(), target);
                    if (image != null && edge.isAbstract()) continue;
                    result.put(source, target, edge);
                }
            }
        }
        return result;
    }

    private TypeEdge findTypeEdge(TypeNode sourceType, TypeLabel label, TypeNode targetType, boolean precise) {
        TypeEdge result = null;
        for (TypeEdge edge : this.edgeSet(label)) {
            if (this.isSubtype(sourceType, (TypeNode)edge.source(), precise) && this.isSubtype(targetType, (TypeNode)edge.target(), precise) && (result == null || result.isAbstract()) && !(result = edge).isAbstract()) break;
        }
        return result;
    }

    private boolean isSubtype(TypeNode subtype, TypeNode supertype, boolean precise) {
        return precise ? supertype.equals(subtype) : this.isSubtype(subtype, supertype);
    }

    public TypeNode getNode(String label) {
        return this.getNode(TypeLabel.createLabel(label));
    }

    public TypeNode getNode(Label label) {
        assert (label.getRole() == EdgeRole.NODE_TYPE);
        if (this.isImplicit()) {
            return this.factory.getTopNode();
        }
        return this.typeNodeMap.get(this.getActualType(label));
    }

    private TypeLabel getActualType(Label type) {
        TypeLabel result;
        if (type instanceof RuleLabel) {
            RuleLabel ruleLabel = (RuleLabel)type;
            result = ruleLabel.getTypeLabel();
        } else {
            assert (type instanceof TypeLabel);
            result = (TypeLabel)type;
        }
        return result;
    }

    private boolean hasCommonSubtype(TypeNode node1, TypeNode node2) {
        if (node1.equals(node2)) {
            return true;
        }
        if (this.isImplicit()) {
            return false;
        }
        Set<TypeNode> sub1 = this.getSubtypes(node1);
        Set<TypeNode> sub2 = this.getSubtypes(node2);
        assert (sub1 != null) : String.format("Node type %s does not exist in type graph %s", node1, this);
        assert (sub2 != null) : String.format("Node type %s does not exist in type graph %s", node2, this);
        if (sub1.size() == 1) {
            return sub2.size() > 1 && sub2.contains(node1);
        }
        if (sub2.size() == 1) {
            return sub1.contains(node2);
        }
        return !Collections.disjoint(sub1, sub2);
    }

    public Set<TypeLabel> getLabels() {
        this.testFixed(true);
        if (this.labels == null) {
            this.labels = new HashSet<TypeLabel>();
            for (TypeNode node : this.nodeSet()) {
                this.labels.add(node.label());
            }
            for (TypeEdge edge : this.edgeSet()) {
                this.labels.add((TypeLabel)edge.label());
            }
        }
        return this.labels;
    }

    public Map<TypeNode, Set<TypeNode>> getDirectSupertypeMap() {
        return Collections.unmodifiableMap(this.nodeDirectSupertypeMap);
    }

    public Map<TypeNode, Set<TypeNode>> getDirectSubtypeMap() {
        return Collections.unmodifiableMap(this.nodeDirectSubtypeMap);
    }

    public Set<TypeNode> getSubtypes(TypeNode node) {
        Set result;
        if (this.isImplicit()) {
            result = Collections.singleton(node);
        } else {
            assert (this.isFixed());
            result = (Set)this.nodeSubtypeMap.get(node);
        }
        assert (result != null);
        return result;
    }

    public Set<TypeEdge> getSubtypes(TypeEdge edge) {
        Set<TypeEdge> result;
        if (this.isImplicit()) {
            result = Collections.singleton(edge);
        } else {
            assert (this.isFixed());
            result = this.edgeSubtypeMap.get(edge);
        }
        assert (result != null);
        return result;
    }

    public Set<TypeNode> getSupertypes(TypeNode node) {
        Set result;
        if (this.isImplicit()) {
            result = Collections.singleton(node);
        } else {
            assert (this.isFixed());
            result = (Set)this.nodeSupertypeMap.get(node);
        }
        assert (result != null);
        return result;
    }

    public Set<TypeEdge> getSupertypes(TypeEdge edge) {
        Set<TypeEdge> result;
        if (this.isImplicit()) {
            result = Collections.singleton(edge);
        } else {
            assert (this.isFixed());
            result = this.edgeSupertypeMap.get(edge);
        }
        assert (result != null);
        return result;
    }

    public Set<TypeElement> getMatches(RuleLabel label) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        if (label.isInv()) {
            label = label.getInvLabel();
        }
        if (label.isWildcard()) {
            if (this.isNodeType(label) && !this.isImplicit()) {
                result.addAll(this.nodeSet());
                result.removeAll(this.getFactory().getDataTypes());
            } else {
                for (TypeEdge te : this.edgeSet()) {
                    if (te.getRole() != label.getRole()) continue;
                    result.add(te);
                }
            }
            label.getWildcardGuard().filter(result);
        } else if (label.isSharp()) {
            if (this.isNodeType(label) && !this.isImplicit()) {
                result.add(this.getNode(label));
            } else {
                result.addAll(this.edgeSet(label.getSharpLabel()));
            }
        } else {
            assert (label.isAtom());
            if (this.isNodeType(label) && !this.isImplicit()) {
                TypeNode tn = this.getNode(label);
                if (tn != null) {
                    result.addAll(this.getSubtypes(tn));
                }
            } else {
                result.addAll(this.edgeSet(label.getTypeLabel()));
            }
        }
        return result;
    }

    public Set<? extends TypeElement> getTypes(TypeLabel label) {
        HashSet<TypeNode> result = new HashSet<TypeNode>();
        if (this.isNodeType(label)) {
            result.add(this.getNode(label));
        } else {
            result.addAll(this.edgeSet(label));
        }
        return result;
    }

    public TypeNode getMinimum(Collection<TypeNode> types) {
        TypeNode result = null;
        for (TypeNode typeNode : types) {
            if (typeNode.isDataType() || result != null && !this.isSubtype(typeNode, result)) continue;
            result = typeNode;
        }
        if (result != null && !result.getSupertypes().containsAll(types)) {
            result = null;
        }
        return result;
    }

    public TypeNode getLub(Collection<TypeNode> types) {
        HashSet<TypeNode> ubs = new HashSet<TypeNode>(this.nodeSet());
        for (TypeNode typeNode : types) {
            if (typeNode.isDataType()) continue;
            ubs.retainAll(this.getSupertypes(typeNode));
        }
        return this.getMinimum(ubs);
    }

    public SortedMap<String, Sub> getComponentMap() {
        return Collections.unmodifiableSortedMap(this.componentMap);
    }

    public boolean isComposite() {
        return !this.componentMap.isEmpty();
    }

    @Override
    protected boolean isTypeCorrect(Node node) {
        return node instanceof TypeNode;
    }

    @Override
    protected boolean isTypeCorrect(Edge edge) {
        return edge instanceof TypeEdge;
    }

    private static class NodeTypeMap
    extends HashMap<TypeNode, Set<TypeNode>> {
        private final boolean reflexive;

        public NodeTypeMap(boolean reflexive) {
            this.reflexive = reflexive;
        }

        public void add(TypeNode node) {
            HashSet<TypeNode> record = new HashSet<TypeNode>();
            Set oldRecord = this.put(node, record);
            assert (oldRecord == null);
            if (this.reflexive) {
                record.add(node);
            }
        }
    }

    public static class Sub {
        private final String name;
        private final Set<TypeNode> nodes;
        private final Set<TypeEdge> edges;

        public Sub(String name, Set<TypeNode> nodes, Set<TypeEdge> edges) {
            this.name = name;
            this.nodes = nodes;
            this.edges = edges;
        }

        public String getName() {
            return this.name;
        }

        public Set<TypeNode> getNodes() {
            return this.nodes;
        }

        public Set<TypeEdge> getEdges() {
            return this.edges;
        }
    }

    private class TypeEdgeMap
    extends HashMap<TypeLabel, Map<TypeNode, TypeEdge[]>> {
        private TypeEdgeMap() {
        }

        void put(TypeNode source, TypeNode target, TypeEdge edge) {
            TypeEdge[] targetEdges;
            HashMap<TypeNode, TypeEdge[]> outEdgeMap = (HashMap<TypeNode, TypeEdge[]>)this.get(edge.label());
            if (outEdgeMap == null) {
                outEdgeMap = new HashMap<TypeNode, TypeEdge[]>();
                this.put((TypeLabel)edge.label(), outEdgeMap);
            }
            if ((targetEdges = (TypeEdge[])outEdgeMap.get(source)) == null) {
                targetEdges = new TypeEdge[TypeGraph.this.getFactory().getMaxNodeNr() + 1];
                outEdgeMap.put(source, targetEdges);
            }
            targetEdges[target.getNumber()] = edge;
        }

        TypeEdge get(TypeNode source, TypeLabel label, TypeNode target) {
            TypeEdge[] targetEdges;
            TypeEdge result = null;
            Map outEdgeMap = (Map)this.get(label);
            if (outEdgeMap != null && (targetEdges = (TypeEdge[])outEdgeMap.get(source)) != null) {
                result = targetEdges[target.getNumber()];
            }
            return result;
        }
    }
}

