/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.rule;

import groove.automaton.RegAut;
import groove.automaton.RegAutCalculator;
import groove.automaton.RegExpr;
import groove.grammar.rule.LabelVar;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeLabel;
import groove.graph.ALabel;
import groove.graph.EdgeRole;
import java.util.List;
import java.util.Set;

public class RuleLabel
extends ALabel {
    private final RegExpr regExpr;
    private RegAut automaton;
    private static final RegAutCalculator calculator = new RegAutCalculator();
    public static final int INVALID_ARG_NR = -1;

    public RuleLabel(RegExpr regExpr) {
        if (regExpr == null) {
            throw new IllegalArgumentException("Can't create rule label from null expression");
        }
        this.regExpr = regExpr;
    }

    public RuleLabel(TypeLabel label) {
        this(RegExpr.atom(label.toPrefixedString()));
    }

    public RuleLabel(String text) {
        this(RegExpr.atom(text));
    }

    @Override
    public EdgeRole getRole() {
        EdgeRole result = super.getRole();
        if (this.isWildcard()) {
            result = ((RegExpr.Wildcard)this.getMatchExpr()).getKind();
        } else if (this.isSharp() || this.isAtom()) {
            result = this.getTypeLabel().getRole();
        }
        return result;
    }

    @Override
    public String text() {
        String result = this.getMatchExpr().toString();
        if (this.isAtom() || this.isSharp() || this.isWildcard()) {
            result = EdgeRole.parseLabel(result).two();
        }
        return result;
    }

    public RegExpr getMatchExpr() {
        return this.regExpr;
    }

    public RegAut getAutomaton(TypeGraph typeGraph) {
        if (this.automaton == null || this.automaton.getTypeGraph() != typeGraph) {
            this.automaton = calculator.compute(this.getMatchExpr(), typeGraph);
        }
        return this.automaton;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof RuleLabel) {
            RuleLabel other = (RuleLabel)obj;
            result = this.getMatchExpr().equals(other.getMatchExpr());
        }
        return result;
    }

    public boolean isAtom() {
        return this.getAtomText() != null;
    }

    public String getAtomText() {
        RegExpr expr = this.getMatchExpr();
        return expr instanceof RegExpr.Atom ? ((RegExpr.Atom)expr).text() : null;
    }

    public TypeLabel getTypeLabel() {
        RegExpr expr = this.getMatchExpr();
        if (expr instanceof RegExpr.Atom) {
            return ((RegExpr.Atom)expr).toTypeLabel();
        }
        if (expr instanceof RegExpr.Sharp) {
            return ((RegExpr.Sharp)expr).getSharpLabel();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.getMatchExpr() instanceof RegExpr.Empty;
    }

    public boolean isSharp() {
        RegExpr regExpr = this.getMatchExpr();
        return regExpr == null ? false : regExpr.isSharp();
    }

    public TypeLabel getSharpLabel() {
        RegExpr regExpr = this.getMatchExpr();
        return regExpr == null ? null : regExpr.getSharpLabel();
    }

    public boolean isWildcard() {
        RegExpr regExpr = this.getMatchExpr();
        return regExpr == null ? false : regExpr.isWildcard();
    }

    public TypeGuard getWildcardGuard() {
        RegExpr regExpr = this.getMatchExpr();
        return regExpr == null ? null : regExpr.getWildcardGuard();
    }

    public boolean isChoice() {
        return this.getChoiceOperands() != null;
    }

    public List<RegExpr> getChoiceOperands() {
        RegExpr expr = this.getMatchExpr();
        if (expr instanceof RegExpr.Choice) {
            return ((RegExpr.Choice)expr).getOperands();
        }
        return null;
    }

    public boolean isSeq() {
        return this.getSeqOperands() != null;
    }

    public List<RegExpr> getSeqOperands() {
        RegExpr expr = this.getMatchExpr();
        if (expr instanceof RegExpr.Seq) {
            return ((RegExpr.Seq)expr).getOperands();
        }
        return null;
    }

    public boolean isStar() {
        return this.getStarOperand() != null;
    }

    public RegExpr getStarOperand() {
        RegExpr expr = this.getMatchExpr();
        if (expr instanceof RegExpr.Star) {
            return ((RegExpr.Star)expr).getOperand();
        }
        return null;
    }

    public boolean isPlus() {
        return this.getPlusOperand() != null;
    }

    public RegExpr getPlusOperand() {
        RegExpr expr = this.getMatchExpr();
        if (expr instanceof RegExpr.Plus) {
            return ((RegExpr.Plus)expr).getOperand();
        }
        return null;
    }

    public boolean isInv() {
        return this.getInvLabel() != null;
    }

    public RuleLabel getInvLabel() {
        RuleLabel result = null;
        RegExpr expr = this.getMatchExpr();
        if (expr instanceof RegExpr.Inv) {
            result = ((RegExpr.Inv)expr).getOperand().toLabel();
        }
        return result;
    }

    public boolean isNeg() {
        return this.getNegOperand() != null;
    }

    public RegExpr getNegOperand() {
        RegExpr expr = this.getMatchExpr();
        if (expr instanceof RegExpr.Neg) {
            return ((RegExpr.Neg)expr).getOperand();
        }
        return null;
    }

    public Set<LabelVar> allVarSet() {
        return this.getMatchExpr().allVarSet();
    }
}

