/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.model;

import groove.algebra.Constant;
import groove.algebra.Term;
import groove.algebra.Variable;
import groove.automaton.RegExpr;
import groove.control.CtrlPar;
import groove.control.CtrlType;
import groove.control.CtrlVar;
import groove.grammar.Condition;
import groove.grammar.EdgeEmbargo;
import groove.grammar.GrammarProperties;
import groove.grammar.Rule;
import groove.grammar.aspect.Aspect;
import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectElement;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectNode;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.rule.DefaultRuleNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.OperatorNode;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleFactory;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleGraphMorphism;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.Edge;
import groove.graph.EdgeComparator;
import groove.graph.GraphInfo;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.NodeComparator;
import groove.util.DefaultFixable;
import groove.util.Fixable;
import groove.util.Groove;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class RuleModel
extends GraphBasedModel<Rule>
implements Comparable<RuleModel> {
    private TypeGraph oldTypeGraph;
    private RuleFactory ruleFactory;
    private RuleModelMap modelMap;
    private GraphBasedModel.TypeModelMap typeMap;
    private AspectGraph normalSource;
    private Set<TypeLabel> labelSet;
    private LevelTree levelTree;
    private static final boolean TO_RULE_DEBUG = false;
    private static final boolean NORMALISE_DEBUG = false;

    public RuleModel(GrammarModel grammar, AspectGraph graph) {
        super(grammar, graph);
        assert (grammar != null);
        graph.testFixed(true);
    }

    @Override
    boolean isShouldRebuild() {
        boolean result = super.isShouldRebuild();
        boolean bl = this.oldTypeGraph != this.getType();
        this.oldTypeGraph = this.getType();
        return result |= this.isStale(ResourceKind.PROPERTIES) | bl;
    }

    @Override
    public boolean isEnabled() {
        return GraphInfo.isEnabled(this.getSource()) || this.hasRecipes();
    }

    public Set<String> getRecipes() {
        return this.getGrammar().getControlModel().getRecipes(this.getFullName());
    }

    public boolean hasRecipes() {
        return !this.getRecipes().isEmpty();
    }

    public int getPriority() {
        return GraphInfo.getPriority(this.getSource());
    }

    public String getTransitionLabel() {
        return GraphInfo.getTransitionLabel(this.getSource());
    }

    public String getFormatString() {
        return GraphInfo.getFormatString(this.getSource());
    }

    @Override
    Rule compute() throws FormatException {
        this.ruleFactory = RuleFactory.newInstance(this.getType().getFactory());
        this.modelMap = new RuleModelMap(this.ruleFactory);
        GraphInfo.throwException(this.getSource());
        AspectGraph normalSource = this.getNormalSource();
        GraphInfo.throwException(normalSource);
        this.levelTree = new LevelTree(normalSource);
        this.modelMap.putAll(this.levelTree.getModelMap());
        this.typeMap = new GraphBasedModel.TypeModelMap(this.getType().getFactory());
        for (Map.Entry entry : this.modelMap.nodeMap().entrySet()) {
            this.typeMap.putNode(entry.getKey(), ((RuleNode)entry.getValue()).getType());
        }
        for (Map.Entry<AspectElement, Object> entry : this.modelMap.edgeMap().entrySet()) {
            this.typeMap.putEdge((AspectEdge)entry.getKey(), ((RuleEdge)entry.getValue()).getType());
        }
        return this.computeRule(this.levelTree);
    }

    @Override
    void notifyWillRebuild() {
        super.notifyWillRebuild();
        this.labelSet = null;
        this.levelTree = null;
        this.typeMap = null;
    }

    @Override
    public Set<TypeLabel> getLabels() {
        if (this.labelSet == null) {
            this.labelSet = new HashSet<TypeLabel>();
            for (AspectEdge edge : this.getNormalSource().edgeSet()) {
                RegExpr labelExpr;
                RuleLabel label = edge.getRuleLabel();
                if (label == null || (labelExpr = label.getMatchExpr()) == null) continue;
                this.labelSet.addAll(labelExpr.getTypeLabels());
            }
        }
        return this.labelSet;
    }

    public RuleModelMap getMap() {
        this.synchronise();
        if (this.hasErrors()) {
            throw new IllegalStateException();
        }
        return this.modelMap;
    }

    @Override
    public GraphBasedModel.TypeModelMap getTypeMap() {
        this.synchronise();
        return this.typeMap;
    }

    public TreeMap<Index, Set<AspectElement>> getLevelTree() {
        this.synchronise();
        if (this.levelTree == null) {
            return null;
        }
        TreeMap<Index, Set<AspectElement>> result = new TreeMap<Index, Set<AspectElement>>();
        for (Map.Entry<Index, Level1> levelEntry : this.levelTree.getLevel1Map().entrySet()) {
            Index index = levelEntry.getKey();
            Level1 level = levelEntry.getValue();
            HashSet<AspectElement> elements = new HashSet<AspectElement>();
            result.put(index, elements);
            elements.addAll(level.modelNodes);
            elements.addAll(level.modelEdges);
        }
        return result;
    }

    @Override
    public int compareTo(RuleModel o) {
        int result = this.getPriority() - o.getPriority();
        if (result == 0) {
            result = this.getFullName().compareTo(o.getFullName());
        }
        return result;
    }

    public String toString() {
        return String.format("Rule model on '%s'", this.getFullName());
    }

    final TypeGraph getType() {
        return this.getGrammar().getTypeGraph();
    }

    final GrammarProperties getSystemProperties() {
        return this.getGrammar().getProperties();
    }

    final boolean isInjective() {
        return this.getSystemProperties() != null && this.getSystemProperties().isInjective();
    }

    final boolean isRhsAsNac() {
        return this.getSystemProperties() != null && this.getSystemProperties().isRhsAsNac();
    }

    final boolean isCheckCreatorEdges() {
        return this.getSystemProperties() != null && this.getSystemProperties().isCheckCreatorEdges();
    }

    private Rule computeRule(LevelTree levelTree) throws FormatException {
        Rule result;
        FormatErrorSet errors = this.createErrors();
        TreeMap<Index, Condition> conditionTree = new TreeMap<Index, Condition>();
        try {
            for (Level4 level4 : levelTree.getLevel4Map().values()) {
                Index index = level4.getIndex();
                Condition.Op operator = index.getOperator();
                Condition condition = operator.isQuantifier() ? level4.computeFlatRule() : new Condition(index.getName(), operator);
                conditionTree.put(index, condition);
                if (!condition.hasRule() || index.isTopLevel()) continue;
                Index parentIndex = index.getParent();
                while (!((Condition)conditionTree.get(parentIndex)).hasRule()) {
                    parentIndex = parentIndex.getParent();
                }
                condition.getRule().setParent(((Condition)conditionTree.get(parentIndex)).getRule(), index.getIntArray());
            }
            for (Map.Entry entry : conditionTree.descendingMap().entrySet()) {
                Condition condition = (Condition)entry.getValue();
                assert (condition != null);
                Index index = (Index)entry.getKey();
                if (index.isTopLevel()) continue;
                condition.setFixed();
                Condition parentCond = (Condition)conditionTree.get(index.getParent());
                parentCond.addSubCondition(condition);
            }
        }
        catch (FormatException formatException) {
            errors.addAll(formatException.getErrors());
        }
        if (conditionTree.isEmpty()) {
            result = null;
        } else {
            result = ((Condition)conditionTree.firstEntry().getValue()).getRule();
            if (result != null) {
                result.setProperties(GraphInfo.getProperties(this.getSource()));
                result.setCheckDangling(this.getSystemProperties().isCheckDangling());
                Parameters parameters = new Parameters();
                result.setSignature(parameters.getSignature(), parameters.getHiddenPars());
            }
        }
        this.transferErrors(errors, levelTree.getModelMap()).throwException();
        result.setFixed();
        return result;
    }

    private AspectGraph getNormalSource() {
        if (this.normalSource == null) {
            this.normalSource = this.getSource().normalise(null);
        }
        return this.normalSource;
    }

    public static class Index
    extends DefaultFixable
    implements Comparable<Index> {
        private final String namePrefix;
        final Condition.Op operator;
        final boolean positive;
        final AspectNode levelNode;
        List<Integer> index;
        Index parent;

        public Index(Condition.Op operator, boolean positive, AspectNode levelNode, String namePrefix) {
            assert (levelNode == null || levelNode.getKind().isQuantifier());
            this.namePrefix = namePrefix;
            this.operator = operator;
            this.positive = positive;
            this.levelNode = levelNode;
        }

        public void setParent(Index parent, int nr) {
            this.testFixed(false);
            assert (this.parent == null && parent.isFixed());
            this.parent = parent;
            this.index = new ArrayList<Integer>(parent.index.size() + 1);
            this.index.addAll(parent.index);
            this.index.add(nr);
            this.setFixed();
        }

        @Override
        public boolean setFixed() {
            boolean result = super.setFixed();
            if (result && this.index == null) {
                this.index = Collections.emptyList();
            }
            return result;
        }

        public Index getParent() {
            this.testFixed(true);
            return this.parent;
        }

        public AspectNode getLevelNode() {
            return this.levelNode;
        }

        public String getName() {
            AspectNode levelNode = this.levelNode;
            String suffix = levelNode == null || levelNode.getLevelName() == null ? (this.isTopLevel() ? "" : Groove.toString(this.index.toArray())) : "-" + levelNode.getLevelName();
            return String.valueOf(this.namePrefix) + suffix;
        }

        @Override
        public int compareTo(Index o) {
            int result = 0;
            int[] mine = this.getIntArray();
            int[] other = o.getIntArray();
            int minLength = Math.min(mine.length, other.length);
            int i = 0;
            while (result == 0 && i < minLength) {
                result = mine[i] - other[i];
                ++i;
            }
            if (result == 0) {
                result = mine.length - other.length;
            }
            return result;
        }

        public boolean higherThan(Index other) {
            assert (this.isFixed() && other.isFixed());
            boolean result = this.index.size() <= other.index.size();
            int i = 0;
            while (result && i < this.index.size()) {
                result = this.index.get(i).equals(other.index.get(i));
                ++i;
            }
            return result;
        }

        public int[] getIntArray() {
            this.testFixed(true);
            int[] result = new int[this.index.size()];
            int i = 0;
            while (i < this.index.size()) {
                result[i] = this.index.get(i);
                ++i;
            }
            return result;
        }

        public boolean isTopLevel() {
            this.testFixed(true);
            return this.parent == null;
        }

        public Condition.Op getOperator() {
            return this.operator;
        }

        public boolean isPositive() {
            return this.positive;
        }

        public String toString() {
            return this.index.toString();
        }
    }

    private class Level1
    implements Comparable<Level1> {
        final Index index;
        private final Level1 parent;
        private final List<Level1> children = new ArrayList<Level1>();
        final Set<AspectNode> modelNodes = new HashSet<AspectNode>();
        final Set<AspectEdge> modelEdges = new HashSet<AspectEdge>();
        final Map<LabelVar, Set<AspectEdge>> modelVars = new HashMap<LabelVar, Set<AspectEdge>>();
        AspectNode matchCountNode;

        public Level1(Index index, Level1 parent) {
            this.index = index;
            this.parent = parent;
            if (parent != null) {
                assert (index.getParent().equals(parent.getIndex())) : String.format("Parent index %s should be parent of %s", parent.index, index);
                parent.addChild(this);
            } else assert (index.isTopLevel()) : String.format("Level with index %s should have non-null parent", index);
        }

        private void addChild(Level1 child) {
            assert (this.index.equals(child.index.parent));
            this.children.add(child);
        }

        public void addNode(AspectNode modelNode) {
            if (this.isForThisLevel(modelNode)) {
                this.modelNodes.add(modelNode);
            }
            if (this.isForNextLevel(modelNode)) {
                for (Level1 sublevel : this.children) {
                    sublevel.addNode(modelNode);
                }
            }
        }

        public void addEdge(AspectEdge modelEdge) {
            if (this.isForThisLevel(modelEdge)) {
                this.modelEdges.add(modelEdge);
                this.addNodeToParents((AspectNode)modelEdge.source());
                this.addNodeToParents((AspectNode)modelEdge.target());
                this.addToVars(modelEdge);
            }
            if (this.isForNextLevel(modelEdge)) {
                for (Level1 sublevel : this.children) {
                    sublevel.addEdge(modelEdge);
                }
            }
        }

        private void addToVars(AspectEdge modelEdge) {
            RuleLabel ruleLabel = modelEdge.getRuleLabel();
            if (ruleLabel != null) {
                for (LabelVar var : ruleLabel.allVarSet()) {
                    Set<AspectEdge> binders = this.modelVars.get(var);
                    if (binders == null) {
                        binders = new HashSet<AspectEdge>();
                        this.modelVars.put(var, binders);
                    }
                    binders.add(modelEdge);
                }
            }
        }

        public void setMatchCount(AspectNode matchCount) {
            this.matchCountNode = matchCount;
        }

        private void addNodeToParents(AspectNode modelNode) {
            Level1 ascendingLevel = this;
            while (ascendingLevel.modelNodes.add(modelNode)) {
                assert (!ascendingLevel.index.isTopLevel()) : String.format("Node not found at any level", new Object[0]);
                ascendingLevel = ascendingLevel.parent;
                assert (ascendingLevel.modelNodes != null) : String.format("Nodes on level %s not yet initialised", ascendingLevel.getIndex());
            }
        }

        private boolean isForThisLevel(AspectElement elem) {
            return this.index.getOperator().hasPattern();
        }

        private boolean isForNextLevel(AspectElement elem) {
            assert (elem.getKind() == AspectKind.CONNECT || !elem.getKind().isMeta());
            boolean result = false;
            if (!this.index.getOperator().hasPattern()) {
                result = true;
            } else if (elem instanceof AspectNode) {
                result = RuleModel.this.isInjective() && elem.getKind().inLHS() && elem.getAttrAspect() == null;
            }
            return result;
        }

        public final Index getIndex() {
            return this.index;
        }

        public String toString() {
            return String.format("Rule %s, level %s, stage 1", RuleModel.this.getFullName(), this.getIndex());
        }

        @Override
        public int compareTo(Level1 o) {
            return this.getIndex().compareTo(o.getIndex());
        }

        public void setFixed() {
            if (this.parent != null) {
                for (LabelVar var : this.modelVars.keySet()) {
                    this.parent.testParentBinding(var);
                }
            }
        }

        private boolean testParentBinding(LabelVar var) {
            boolean result = this.modelVars.containsKey(var);
            if (!result && this.parent != null && (result = this.parent.testParentBinding(var))) {
                this.modelVars.put(var, new HashSet());
            }
            return result;
        }
    }

    private class Level2 {
        private final RuleFactory factory;
        private final RuleModelMap modelMap;
        private final Index index;
        private final Map<AspectEdge, Set<RuleNode>> connectMap = new HashMap<AspectEdge, Set<RuleNode>>();
        private VariableNode matchCountImage;
        private final Map<RuleNode, Color> colorMap = new HashMap<RuleNode, Color>();
        private boolean isRule;
        private final RuleGraph lhs;
        private final RuleGraph rhs;
        private final RuleGraph mid;
        private final Set<RuleNode> nacNodeSet = new HashSet<RuleNode>();
        private final Set<RuleEdge> nacEdgeSet = new HashSet<RuleEdge>();
        private final List<RuleGraph> nacs = new ArrayList<RuleGraph>();
        private final Set<LabelVar> parentVars = new HashSet<LabelVar>();

        public Level2(Level1 origin, RuleModelMap modelMap) throws FormatException {
            this.factory = modelMap.getFactory();
            Index index = this.index = origin.index;
            this.modelMap = modelMap;
            this.isRule = index.isTopLevel();
            this.lhs = this.createGraph(String.valueOf(RuleModel.this.getFullName()) + "-" + index + "-lhs");
            this.mid = this.createGraph(String.valueOf(RuleModel.this.getFullName()) + "-" + index + "-mid");
            this.rhs = this.createGraph(String.valueOf(RuleModel.this.getFullName()) + "-" + index + "-rhs");
            FormatErrorSet errors = RuleModel.this.createErrors();
            try {
                if (origin.matchCountNode != null) {
                    this.matchCountImage = (VariableNode)this.getNodeImage(origin.matchCountNode);
                }
            }
            catch (FormatException exc) {
                errors.addAll(exc.getErrors());
            }
            for (AspectNode modelNode : origin.modelNodes) {
                try {
                    if (modelNode.getAttrKind() == AspectKind.PRODUCT) continue;
                    this.processNode(modelNode);
                }
                catch (FormatException exc) {
                    errors.addAll(exc.getErrors());
                }
            }
            errors.throwException();
            for (AspectEdge modelEdge : origin.modelEdges) {
                try {
                    if (modelEdge.getKind() == AspectKind.CONNECT) {
                        this.addConnect(modelEdge);
                        continue;
                    }
                    if (modelEdge.getAttrKind() == AspectKind.DEFAULT) {
                        this.processEdge(modelEdge);
                        continue;
                    }
                    if (modelEdge.getAttrKind() == AspectKind.ARGUMENT) continue;
                    this.addOperator(modelEdge);
                }
                catch (FormatException exc) {
                    errors.addAll(exc.getErrors());
                }
            }
            for (LabelVar modelVar : origin.modelVars.keySet()) {
                this.processVar(modelVar);
            }
            try {
                this.nacs.addAll(this.computeNacs());
            }
            catch (FormatException exc) {
                errors.addAll(exc.getErrors());
            }
            if (!index.isTopLevel()) {
                this.parentVars.addAll(((Level1)origin).parent.modelVars.keySet());
            }
            this.checkAttributes(errors);
            this.checkVariables(errors);
            errors.throwException();
        }

        private void processVar(LabelVar modelVar) {
            this.lhs.addVar(modelVar);
        }

        private void processNode(AspectNode modelNode) throws FormatException {
            AspectKind nodeKind = modelNode.getKind();
            this.isRule |= nodeKind.inLHS() ^ nodeKind.inRHS();
            RuleNode ruleNode = this.getNodeImage(modelNode);
            if (nodeKind.inLHS()) {
                this.lhs.addNode(ruleNode);
                if (nodeKind.inRHS()) {
                    this.rhs.addNode(ruleNode);
                    this.mid.addNode(ruleNode);
                }
            } else {
                if (nodeKind.inNAC()) {
                    this.nacNodeSet.add(ruleNode);
                }
                if (nodeKind.inRHS()) {
                    this.rhs.addNode(ruleNode);
                    if (RuleModel.this.isRhsAsNac()) {
                        this.nacNodeSet.add(ruleNode);
                    }
                }
            }
            if (modelNode.hasColor()) {
                this.colorMap.put(ruleNode, (Color)modelNode.getColor().getContent());
            }
        }

        private void processEdge(AspectEdge modelEdge) throws FormatException {
            AspectKind edgeKind = modelEdge.getKind();
            this.isRule |= edgeKind.inLHS() ^ edgeKind.inRHS();
            RuleEdge ruleEdge = this.getEdgeImage(modelEdge);
            if (ruleEdge == null) {
                return;
            }
            if (edgeKind.inLHS()) {
                boolean freshInLhs = this.lhs.addEdgeContext(ruleEdge);
                if (freshInLhs) {
                    if (edgeKind.inRHS()) {
                        this.rhs.addEdgeContext(ruleEdge);
                        this.mid.addEdgeContext(ruleEdge);
                    } else if (RuleModel.this.getType().isNodeType(ruleEdge) && this.rhs.containsNode((Node)ruleEdge.source())) {
                        throw new FormatException("Node type label %s cannot be deleted", ((RuleLabel)ruleEdge.label()).text(), modelEdge.source());
                    }
                } else if (!edgeKind.inRHS()) {
                    this.rhs.removeEdge(ruleEdge);
                    this.mid.removeEdge(ruleEdge);
                }
            } else {
                if (edgeKind.inNAC()) {
                    this.nacEdgeSet.add(ruleEdge);
                }
                if (edgeKind.inRHS()) {
                    if (RuleModel.this.getType().isNodeType(ruleEdge) && this.lhs.containsNode((Node)ruleEdge.source())) {
                        throw new FormatException("Node type %s cannot be created", ruleEdge.label(), modelEdge.source());
                    }
                    this.rhs.addEdgeContext(ruleEdge);
                    if (RuleModel.this.isRhsAsNac()) {
                        this.nacEdgeSet.add(ruleEdge);
                    } else if (RuleModel.this.isCheckCreatorEdges() && ((AspectNode)modelEdge.source()).getKind().inLHS() && ((AspectNode)modelEdge.target()).getKind().inLHS()) {
                        this.nacEdgeSet.add(ruleEdge);
                    }
                }
            }
        }

        private void addConnect(AspectEdge connectEdge) throws FormatException {
            RuleNode node1 = this.getNodeImage((AspectNode)connectEdge.source());
            RuleNode node2 = this.getNodeImage((AspectNode)connectEdge.target());
            HashSet<RuleNode> nodeSet = new HashSet<RuleNode>(Arrays.asList(node1, node2));
            this.connectMap.put(connectEdge, nodeSet);
        }

        private void addOperator(AspectEdge operatorEdge) throws FormatException {
            AspectNode productNode = (AspectNode)operatorEdge.source();
            boolean embargo = productNode.getKind().inNAC();
            ArrayList<VariableNode> arguments = new ArrayList<VariableNode>();
            for (AspectNode argModelNode : productNode.getArgNodes()) {
                VariableNode argument = (VariableNode)this.getNodeImage(argModelNode);
                if (!(this.lhs.nodeSet().contains(argument) || embargo && this.nacNodeSet.contains(argument))) {
                    throw new FormatException("Argument must exist on the level of the product node", argModelNode, productNode);
                }
                arguments.add(argument);
            }
            VariableNode target = (VariableNode)this.getNodeImage((AspectNode)operatorEdge.target());
            if (!(this.lhs.nodeSet().contains(target) || embargo && this.nacNodeSet.contains(target))) {
                throw new FormatException("Operation target must exist on the level of the operator edge", operatorEdge);
            }
            OperatorNode opNode = this.factory.createOperatorNode(productNode.getNumber(), operatorEdge.getOperator(), arguments, target);
            if (operatorEdge.getKind().inNAC()) {
                this.nacNodeSet.add(opNode);
            } else {
                this.lhs.addNode(opNode);
                this.mid.addNode(opNode);
                this.rhs.addNode(opNode);
            }
        }

        private List<RuleGraph> computeNacs() throws FormatException {
            ArrayList<RuleGraph> result = new ArrayList<RuleGraph>();
            for (Cell cell : this.getConnectedSets()) {
                RuleGraph nac = this.createGraph(String.valueOf(this.lhs.getName()) + "-nac-" + result.size());
                for (RuleNode node : cell.getNodes()) {
                    nac.addNode(node);
                    if (!(node instanceof OperatorNode)) continue;
                    nac.addNodeSet(((OperatorNode)node).getArguments());
                }
                nac.addEdgeSetContext(cell.getEdges());
                result.add(nac);
            }
            return result;
        }

        private SortedSet<Cell> getConnectedSets() throws FormatException {
            HashMap<RuleElement, Cell> result = new HashMap<RuleElement, Cell>();
            for (RuleNode ruleNode : this.nacNodeSet) {
                Cell nodeCell = new Cell();
                nodeCell.add(ruleNode);
                result.put(ruleNode, nodeCell);
            }
            for (RuleNode ruleNode : this.nacNodeSet) {
                if (!(ruleNode instanceof OperatorNode)) continue;
                OperatorNode opNode = (OperatorNode)ruleNode;
                Cell nodeCell = (Cell)result.get(opNode);
                for (RuleNode ruleNode2 : opNode.getArguments()) {
                    Cell argCell = (Cell)result.get(ruleNode2);
                    if (argCell == null) continue;
                    nodeCell.addAll(argCell);
                }
                VariableNode variableNode = opNode.getTarget();
                Cell targetCell = (Cell)result.get(variableNode);
                if (targetCell != null) {
                    nodeCell.addAll(targetCell);
                }
                for (RuleElement elem : nodeCell) {
                    result.put(elem, nodeCell);
                }
            }
            for (RuleEdge ruleEdge : this.nacEdgeSet) {
                Cell cell;
                Cell edgeCell = new Cell();
                edgeCell.add(ruleEdge);
                Cell sourceCell = (Cell)result.get(ruleEdge.source());
                if (sourceCell != null) {
                    edgeCell.addAll(sourceCell);
                }
                if ((cell = (Cell)result.get(ruleEdge.target())) != null) {
                    edgeCell.addAll(cell);
                }
                for (RuleElement elem : edgeCell) {
                    result.put(elem, edgeCell);
                }
            }
            for (Map.Entry entry : this.connectMap.entrySet()) {
                Cell newCell = new Cell();
                for (RuleNode node : (Set)entry.getValue()) {
                    Cell nodeCell = (Cell)result.get(node);
                    if (nodeCell == null) {
                        throw new FormatException("Connect edge should be between distinct NACs", entry.getKey());
                    }
                    newCell.addAll(nodeCell);
                }
                for (RuleElement elem : newCell) {
                    result.put(elem, newCell);
                }
            }
            return new TreeSet<Cell>(result.values());
        }

        private void checkAttributes(FormatErrorSet errors) {
            for (RuleNode prodNode : this.lhs.nodeSet()) {
                if (!(prodNode instanceof OperatorNode)) continue;
                OperatorNode opNode = (OperatorNode)prodNode;
                for (RuleNode ruleNode : opNode.getArguments()) {
                    if (this.lhs.nodeSet().contains(ruleNode)) continue;
                    errors.add("Argument must occur on the level of the product node", opNode, ruleNode);
                }
                VariableNode variableNode = opNode.getTarget();
                if (this.lhs.nodeSet().contains(variableNode)) continue;
                errors.add("Operation target must occur on the level of the product node", opNode, variableNode);
            }
        }

        private void checkVariables(FormatErrorSet errors) {
            LabelVar var;
            HashMap<LabelVar, Set<RuleElement>> allVars = new HashMap<LabelVar, Set<RuleElement>>();
            allVars.putAll(this.lhs.varMap());
            allVars.putAll(this.rhs.varMap());
            for (RuleGraph nac : this.nacs) {
                allVars.putAll(nac.varMap());
            }
            HashMap<String, LabelVar> varNames = new HashMap<String, LabelVar>();
            for (Map.Entry varEntry : allVars.entrySet()) {
                var = (LabelVar)varEntry.getKey();
                LabelVar oldVar = varNames.put(var.getKey(), var);
                if (oldVar == null || oldVar.equals(var)) continue;
                errors.add("Duplicate variable '%s' for %s and %s labels", var, var.getKind().getDescription(false), oldVar.getKind().getDescription(false), ((Set)varEntry.getValue()).toArray());
            }
            allVars.keySet().removeAll(this.lhs.getBoundVars());
            allVars.keySet().removeAll(this.parentVars);
            for (Map.Entry varEntry : allVars.entrySet()) {
                var = (LabelVar)varEntry.getKey();
                errors.add("Unassigned label variable %s", var, ((Set)varEntry.getValue()).toArray());
            }
        }

        private RuleNode getNodeImage(AspectNode modelNode) throws FormatException {
            RuleNode result = (RuleNode)this.modelMap.getNode(modelNode);
            if (result == null) {
                result = this.computeNodeImage(modelNode);
                this.modelMap.putNode(modelNode, result);
            }
            return result;
        }

        private RuleEdge getEdgeImage(AspectEdge modelEdge) throws FormatException {
            RuleEdge result = (RuleEdge)this.modelMap.getEdge(modelEdge);
            if (result == null && (result = this.computeEdgeImage(modelEdge, this.modelMap.nodeMap())) != null) {
                this.modelMap.putEdge(modelEdge, result);
            }
            return result;
        }

        private RuleNode computeNodeImage(AspectNode node) throws FormatException {
            RuleNode result;
            if (node.hasParam() && !this.index.isTopLevel()) {
                throw new FormatException("Parameter '%d' only allowed on top existential level", node.getNumber(), node);
            }
            AspectKind nodeAttrKind = node.getAttrKind();
            int nr = node.getNumber();
            if (nodeAttrKind.hasSignature()) {
                Aspect nodeAttr = node.getAttrAspect();
                Term term = nodeAttr.hasContent() ? (Constant)nodeAttr.getContent() : new Variable("x" + nr, nodeAttrKind.getSignature());
                result = this.factory.createVariableNode(nr, term);
            } else {
                result = this.factory.createNode(nr);
            }
            return result;
        }

        private RuleEdge computeEdgeImage(AspectEdge edge, Map<AspectNode, ? extends RuleNode> elementMap) throws FormatException {
            assert (edge.getRuleLabel() != null) : String.format("Edge '%s' does not belong in model", edge);
            RuleNode sourceImage = elementMap.get(edge.source());
            if (sourceImage == null) {
                throw new FormatException("Cannot compute image of '%s'-edge: source node does not have image", edge.label(), edge.source());
            }
            RuleNode targetImage = elementMap.get(edge.target());
            if (targetImage == null) {
                throw new FormatException("Cannot compute image of '%s'-edge: target node does not have image", edge.label(), edge.target());
            }
            return this.factory.createEdge(sourceImage, (Label)edge.getRuleLabel(), targetImage);
        }

        private RuleGraph createGraph(String name) {
            return new RuleGraph(name, this.factory);
        }

        public String toString() {
            return String.format("Rule %s, level %s, stage 2", RuleModel.this.getFullName(), this.getIndex());
        }

        public final Index getIndex() {
            return this.index;
        }

        private class Cell
        extends HashSet<RuleElement>
        implements Comparable<Cell>,
        Fixable {
            private boolean fixed = false;
            private SortedSet<RuleNode> nodes;
            private SortedSet<RuleEdge> edges;

            @Override
            public boolean setFixed() {
                boolean result = !this.fixed;
                this.fixed = true;
                return result;
            }

            @Override
            public boolean isFixed() {
                return this.fixed;
            }

            @Override
            public void testFixed(boolean fixed) {
                if (this.fixed != fixed) {
                    throw new IllegalStateException();
                }
            }

            @Override
            public boolean add(RuleElement e) {
                this.testFixed(false);
                return super.add(e);
            }

            @Override
            public boolean remove(Object o) {
                this.testFixed(false);
                return super.remove(o);
            }

            @Override
            public void clear() {
                this.testFixed(false);
                super.clear();
            }

            public SortedSet<RuleNode> getNodes() {
                this.setFixed();
                if (this.nodes == null) {
                    this.nodes = this.computeNodes();
                }
                return this.nodes;
            }

            private SortedSet<RuleNode> computeNodes() {
                TreeSet<Node> result = new TreeSet<Node>(NodeComparator.instance());
                for (RuleElement elem : this) {
                    if (!(elem instanceof RuleNode)) continue;
                    result.add((RuleNode)elem);
                }
                return result;
            }

            public SortedSet<RuleEdge> getEdges() {
                this.setFixed();
                if (this.edges == null) {
                    this.edges = this.computeEdges();
                }
                return this.edges;
            }

            private SortedSet<RuleEdge> computeEdges() {
                TreeSet<Edge> result = new TreeSet<Edge>(EdgeComparator.instance());
                for (RuleElement elem : this) {
                    if (!(elem instanceof RuleEdge)) continue;
                    result.add((RuleEdge)elem);
                }
                return result;
            }

            @Override
            public int compareTo(Cell o) {
                int result = this.getNodes().size() - o.getNodes().size();
                if (result != 0) {
                    return result;
                }
                result = this.getEdges().size() - o.getEdges().size();
                if (result != 0) {
                    return result;
                }
                Iterator myNodeIter = this.getNodes().iterator();
                Iterator otherNodeIter = o.getNodes().iterator();
                Comparator<RuleNode> nodeComp = this.getNodes().comparator();
                while (myNodeIter.hasNext()) {
                    result = nodeComp.compare((RuleNode)myNodeIter.next(), (RuleNode)otherNodeIter.next());
                    if (result == 0) continue;
                    return result;
                }
                Iterator myEdgeIter = this.getEdges().iterator();
                Iterator otherEdgeIter = o.getEdges().iterator();
                Comparator<RuleEdge> edgeComp = this.getEdges().comparator();
                while (myEdgeIter.hasNext()) {
                    result = edgeComp.compare((RuleEdge)myEdgeIter.next(), (RuleEdge)otherEdgeIter.next());
                    if (result == 0) continue;
                    return result;
                }
                return result;
            }
        }
    }

    private class Level3 {
        private final RuleFactory factory;
        private final Index index;
        private final VariableNode matchCountImage;
        private final RuleGraphMorphism globalTypeMap;
        private final RuleGraphMorphism typeMap;
        private final Map<RuleNode, Color> colorMap = new HashMap<RuleNode, Color>();
        private final boolean isRule;
        private final RuleGraph lhs;
        private final RuleGraph rhs;
        private final List<RuleGraph> nacs = new ArrayList<RuleGraph>();
        private final FormatErrorSet errors;

        public Level3(Level2 origin, Level3 parent, RuleGraphMorphism globalTypeMap) throws FormatException {
            this.errors = RuleModel.this.createErrors();
            this.factory = globalTypeMap.getFactory();
            this.index = origin.index;
            this.matchCountImage = origin.matchCountImage;
            this.globalTypeMap = globalTypeMap;
            RuleGraphMorphism parentTypeMap = parent == null ? new RuleGraphMorphism(this.factory) : parent.typeMap;
            this.typeMap = new RuleGraphMorphism(this.factory);
            this.isRule = origin.isRule;
            this.lhs = this.toTypedGraph(origin.lhs, parentTypeMap, this.typeMap);
            RuleGraphMorphism lhsTypeMap = new RuleGraphMorphism(this.factory);
            lhsTypeMap.putAll(parentTypeMap);
            lhsTypeMap.putAll(this.typeMap);
            this.rhs = this.toTypedGraph(origin.rhs, lhsTypeMap, this.typeMap);
            for (Map.Entry<LabelVar, Set<? extends TypeElement>> entry : lhsTypeMap.getVarTyping().entrySet()) {
                LabelVar var = entry.getKey();
                if (!this.typeMap.getVarTyping().containsKey(var)) continue;
                Set<? extends TypeElement> lhsTypes = entry.getValue();
                lhsTypes.removeAll(this.typeMap.getVarTypes(var));
                if (lhsTypes.isEmpty()) continue;
                this.errors.add("Invalid %s type%s %s for creator variable %s", var.getKind().getDescription(false), lhsTypes.size() == 1 ? "" : "s", Groove.toString(lhsTypes.toArray(), "", "", ", "), var);
            }
            try {
                HashSet<RuleNode> hashSet = new HashSet<RuleNode>();
                for (RuleNode origParentNode : parentTypeMap.nodeMap().keySet()) {
                    hashSet.add((RuleNode)this.typeMap.getNode(origParentNode));
                }
                this.checkTypeSpecialisation(hashSet, this.lhs, this.rhs);
            }
            catch (FormatException formatException) {
                this.errors.addAll(RuleModel.this.transferErrors(formatException.getErrors(), this.typeMap));
            }
            this.errors.throwException();
            for (RuleGraph ruleGraph : origin.nacs) {
                this.nacs.add(this.toTypedGraph(ruleGraph, this.typeMap, null));
            }
            this.errors.throwException();
            for (Map.Entry<LabelVar, Set<TypeElement>> entry : origin.colorMap.entrySet()) {
                this.colorMap.put((RuleNode)globalTypeMap.getNode((Node)((Object)entry.getKey())), (Color)((Object)entry.getValue()));
            }
        }

        public Index getIndex() {
            return this.index;
        }

        private RuleGraph toTypedGraph(RuleGraph graph, RuleGraphMorphism parentTypeMap, RuleGraphMorphism typeMap) {
            RuleGraph result = this.createGraph(graph.getName());
            try {
                RuleElement globalImage;
                RuleElement image;
                RuleElement key;
                RuleGraphMorphism typing = RuleModel.this.getType().analyzeRule(graph, parentTypeMap);
                if (typeMap != null) {
                    typeMap.putAll(typing);
                }
                for (Map.Entry entry : typing.nodeMap().entrySet()) {
                    key = (RuleNode)entry.getKey();
                    image = (RuleNode)entry.getValue();
                    assert (image != null);
                    globalImage = (RuleNode)this.globalTypeMap.getNode((Node)((Object)key));
                    if (globalImage == null) {
                        this.globalTypeMap.putNode(key, image);
                        result.addNode((RuleNode)image);
                        continue;
                    }
                    result.addNode((RuleNode)globalImage);
                }
                for (Map.Entry<Object, Object> entry : typing.edgeMap().entrySet()) {
                    key = (RuleEdge)entry.getKey();
                    image = (RuleEdge)entry.getValue();
                    assert (image != null);
                    globalImage = (RuleEdge)this.globalTypeMap.getEdge((Edge)((Object)key));
                    if (globalImage == null) {
                        globalImage = image;
                        this.globalTypeMap.putEdge(key, globalImage);
                    }
                    result.addEdgeContext(globalImage);
                }
                result.addVarSet(graph.varSet());
            }
            catch (FormatException e) {
                this.errors.addAll(e.getErrors());
            }
            return result;
        }

        private void checkTypeSpecialisation(Set<RuleNode> parentNodes, RuleGraph lhs, RuleGraph rhs) throws FormatException {
            FormatErrorSet errors = RuleModel.this.createErrors();
            for (RuleNode node : rhs.nodeSet()) {
                TypeNode nodeType = node.getType();
                if (nodeType == null || !nodeType.isAbstract() || lhs.containsNode(node)) continue;
                errors.add("Creation of abstract %s-edge not allowed", nodeType.label().text(), node);
            }
            HashSet<RuleNode> mergedNodes = new HashSet<RuleNode>();
            for (RuleEdge edge : this.rhs.edgeSet()) {
                if (this.isMerger(edge)) {
                    RuleNode source = (RuleNode)edge.source();
                    TypeNode sourceType = source.getType();
                    RuleNode target = (RuleNode)edge.target();
                    TypeNode targetType = target.getType();
                    if (!source.isSharp()) {
                        errors.add("Merged %s-node must be sharply typed", sourceType.label().text(), source);
                        continue;
                    }
                    if (parentNodes.contains(source) && !target.isSharp()) {
                        errors.add("Merged %s-node must be on same quantification level as merge target", sourceType.label().text(), source);
                        continue;
                    }
                    if (!RuleModel.this.getType().isSubtype(targetType, sourceType)) {
                        errors.add("Merged %s-node must be supertype of %s", sourceType.label().text(), targetType.label().text(), source);
                        continue;
                    }
                    if (!target.isSharp()) {
                        if (mergedNodes.add((RuleNode)edge.source())) continue;
                        errors.add("%s-node is merged with two distinct non-sharp nodes", sourceType.label().text(), source);
                        continue;
                    }
                    if (!source.getType().isDataType()) continue;
                    errors.add("Primitive %s-node can't be merged", sourceType.label().text(), source);
                    continue;
                }
                TypeEdge edgeType = edge.getType();
                if (edgeType == null || !edgeType.isAbstract() || lhs.containsEdge(edge)) continue;
                errors.add("Creation of abstract %s-edge not allowed", ((TypeLabel)edgeType.label()).text(), edge);
            }
            errors.throwException();
        }

        private boolean isMerger(RuleEdge rhsEdge) {
            return !this.lhs.containsEdge(rhsEdge) && ((RuleLabel)rhsEdge.label()).isEmpty();
        }

        private RuleGraph createGraph(String name) {
            return new RuleGraph(name, this.factory);
        }
    }

    private class Level4 {
        private final Index index;
        private final Level4 parent;
        private final VariableNode matchCountImage;
        private final Map<RuleNode, Color> colorMap;
        private final boolean isRule;
        private final RuleGraph lhs;
        private final RuleGraph rhs;
        private final List<RuleGraph> nacs;

        public Level4(Level3 origin, Level4 parent) {
            this.isRule = origin.isRule;
            this.index = origin.index;
            this.parent = parent;
            this.lhs = origin.lhs;
            this.nacs = origin.nacs;
            this.rhs = origin.rhs;
            this.matchCountImage = origin.matchCountImage;
            this.colorMap = origin.colorMap;
        }

        public Condition computeFlatRule() throws FormatException {
            FormatErrorSet errors = RuleModel.this.createErrors();
            Condition result = this.createCondition(this.getRootGraph(), this.lhs);
            if (this.isRule) {
                Rule rule = this.createRule(result, this.rhs, this.getCoRootGraph());
                rule.addColorMap(this.colorMap);
                result.setRule(rule);
            }
            for (RuleGraph nac : this.nacs) {
                try {
                    result.addSubCondition(this.computeNac(this.lhs, nac));
                }
                catch (FormatException e) {
                    errors.addAll(e.getErrors());
                }
            }
            errors.throwException();
            return result;
        }

        private RuleGraph getRootGraph() {
            return this.index.isTopLevel() ? null : this.getIntersection(this.parent.lhs, this.lhs);
        }

        private RuleGraph getCoRootGraph() {
            Level4 parent = this.parent;
            while (parent != null && !parent.isRule) {
                parent = parent.parent;
            }
            return parent == null ? null : this.getIntersection(parent.rhs, this.rhs);
        }

        private RuleGraph getIntersection(RuleGraph parentGraph, RuleGraph myGraph) {
            RuleGraph result = parentGraph.newGraph(String.valueOf(RuleModel.this.getFullName()) + "-" + this.getIndex() + "-root");
            for (RuleNode node : parentGraph.nodeSet()) {
                if (!myGraph.containsNode(node)) continue;
                result.addNode(node);
            }
            for (RuleEdge edge : parentGraph.edgeSet()) {
                if (!myGraph.containsEdge(edge)) continue;
                result.addEdgeContext(edge);
            }
            for (LabelVar var : parentGraph.varSet()) {
                if (!myGraph.containsVar(var)) continue;
                result.addVar(var);
            }
            return result;
        }

        private Condition computeNac(RuleGraph lhs, RuleGraph nac) throws FormatException {
            Condition result = null;
            if (nac.edgeCount() == 1) {
                RuleEdge embargoEdge = nac.edgeSet().iterator().next();
                HashSet<RuleNode> ends = new HashSet<RuleNode>(Arrays.asList((RuleNode)embargoEdge.source(), (RuleNode)embargoEdge.target()));
                if (nac.nodeSet().equals(ends) && lhs.nodeSet().containsAll(ends) && nac.varSet().isEmpty()) {
                    result = this.createEdgeEmbargo(lhs, embargoEdge);
                }
            }
            if (result == null) {
                if (RuleModel.this.isInjective()) {
                    for (RuleNode node : lhs.nodeSet()) {
                        if (!(node instanceof DefaultRuleNode)) continue;
                        nac.addNode(node);
                    }
                }
                result = this.createNAC(lhs, nac);
            }
            result.setFixed();
            return result;
        }

        private EdgeEmbargo createEdgeEmbargo(RuleGraph context, RuleEdge embargoEdge) {
            return new EdgeEmbargo(context, embargoEdge, RuleModel.this.getSystemProperties());
        }

        private Condition createNAC(RuleGraph lhs, RuleGraph nac) {
            String name = nac.getName();
            return new Condition(name, Condition.Op.NOT, nac, this.getIntersection(lhs, nac), RuleModel.this.getSystemProperties());
        }

        private Rule createRule(Condition condition, RuleGraph rhs, RuleGraph coRoot) {
            Rule result = new Rule(condition, rhs, coRoot);
            return result;
        }

        private Condition createCondition(RuleGraph root, RuleGraph pattern) {
            Condition result = new Condition(this.index.getName(), this.index.getOperator(), pattern, root, RuleModel.this.getSystemProperties());
            result.setTypeGraph(RuleModel.this.getType());
            if (this.index.isPositive()) {
                result.setPositive();
            }
            if (this.matchCountImage != null) {
                result.setCountNode(this.matchCountImage);
            }
            return result;
        }

        public String toString() {
            return String.format("Rule %s, level %s, stage 4", RuleModel.this.getFullName(), this.getIndex());
        }

        public final Index getIndex() {
            return this.index;
        }
    }

    private class LevelTree {
        private final AspectGraph source;
        private Index topLevelIndex;
        private SortedMap<Index, Level1> level1Map;
        private SortedMap<Index, Level4> level4Map;
        private Map<AspectNode, Index> metaIndexMap;
        private Map<String, Index> nameIndexMap;
        private Map<AspectNode, Level1> nodeLevelMap;
        private Map<Index, AspectNode> matchCountMap;
        private RuleModelMap modelMap;

        public LevelTree(AspectGraph source) throws FormatException {
            RuleElement image;
            SortedMap<Index, Level2> level2Map;
            this.source = source;
            SortedSet<Index> indexSet = this.buildTree();
            this.level1Map = this.buildLevels1(indexSet);
            RuleModelMap untypedModelMap = new RuleModelMap();
            try {
                level2Map = this.buildLevels2(this.level1Map, untypedModelMap);
            }
            catch (FormatException e) {
                throw new FormatException(RuleModel.this.transferErrors(e.getErrors(), untypedModelMap));
            }
            RuleFactory typedFactory = RuleModel.this.ruleFactory;
            RuleGraphMorphism typingMap = new RuleGraphMorphism(typedFactory);
            try {
                SortedMap<Index, Level3> level3Map = this.buildLevels3(level2Map, typingMap);
                this.level4Map = this.build4From3(level3Map);
            }
            catch (FormatException e) {
                throw new FormatException(RuleModel.this.transferErrors(e.getErrors(), untypedModelMap));
            }
            RuleModelMap modelMap = new RuleModelMap(typedFactory);
            for (Map.Entry entry : untypedModelMap.nodeMap().entrySet()) {
                image = (RuleNode)typingMap.getNode((Node)entry.getValue());
                if (image == null) continue;
                modelMap.putNode(entry.getKey(), image);
            }
            for (Map.Entry<AspectElement, Object> entry : untypedModelMap.edgeMap().entrySet()) {
                image = (RuleEdge)typingMap.getEdge((Edge)entry.getValue());
                if (image == null) continue;
                modelMap.putEdge((AspectEdge)entry.getKey(), image);
            }
            this.modelMap = modelMap;
        }

        private SortedSet<Index> buildTree() {
            HashMap<Index, List<Index>> indexTree = new HashMap<Index, List<Index>>();
            this.topLevelIndex = this.createIndex(Condition.Op.EXISTS, false, null, indexTree);
            this.metaIndexMap = new HashMap<AspectNode, Index>();
            this.nameIndexMap = new HashMap<String, Index>();
            this.matchCountMap = new HashMap<Index, AspectNode>();
            indexTree.put(this.topLevelIndex, new ArrayList());
            for (AspectNode node : this.source.nodeSet()) {
                Index parentIndex;
                AspectKind nodeKind = node.getKind();
                if (!nodeKind.isQuantifier()) continue;
                AspectNode parentNode = node.getNestingParent();
                if (parentNode == null) {
                    parentIndex = this.topLevelIndex;
                } else {
                    AspectKind parentKind = parentNode.getKind();
                    parentIndex = this.getIndex(parentKind, parentNode, indexTree);
                }
                Index myIndex = this.getIndex(nodeKind, node, indexTree);
                ((List)indexTree.get(parentIndex)).add(myIndex);
                if (node.getMatchCount() == null) continue;
                this.matchCountMap.put(myIndex, node.getMatchCount());
            }
            TreeSet<Index> indexSet = new TreeSet<Index>();
            LinkedList<Index> indexQueue = new LinkedList<Index>();
            indexQueue.add(this.topLevelIndex);
            while (!indexQueue.isEmpty()) {
                Index next = (Index)indexQueue.poll();
                next.setFixed();
                List children = (List)indexTree.get(next);
                if (next.getOperator() == Condition.Op.FORALL && children.isEmpty()) {
                    Index implicitChild = this.createIndex(Condition.Op.EXISTS, true, null, indexTree);
                    children.add(implicitChild);
                }
                int i = 0;
                while (i < children.size()) {
                    ((Index)children.get(i)).setParent(next, i);
                    ++i;
                }
                indexQueue.addAll(children);
                indexSet.add(next);
            }
            return indexSet;
        }

        private Index getIndex(AspectKind quantifier, AspectNode metaNode, Map<Index, List<Index>> indexTree) {
            Index result = this.metaIndexMap.get(metaNode);
            if (result == null) {
                AspectKind kind = metaNode.getKind();
                Condition.Op operator = kind.isExists() ? Condition.Op.EXISTS : Condition.Op.FORALL;
                boolean positive = kind == AspectKind.EXISTS || kind == AspectKind.FORALL_POS;
                result = this.createIndex(operator, positive, metaNode, indexTree);
                this.metaIndexMap.put(metaNode, result);
                Aspect id = metaNode.getId();
                if (id != null) {
                    String name = id.getContentString();
                    Index oldIndex = this.nameIndexMap.put(name, result);
                    assert (oldIndex == null) : String.format("Duplicate quantifier name %s", name);
                }
            }
            return result;
        }

        private Index createIndex(Condition.Op operator, boolean positive, AspectNode levelNode, Map<Index, List<Index>> levelTree) {
            Index result = new Index(operator, positive, levelNode, RuleModel.this.getFullName());
            levelTree.put(result, new ArrayList());
            return result;
        }

        private Level1 max(Level1 first, Level1 other) {
            if (first.index.higherThan(other.index)) {
                return other;
            }
            if (other.index.higherThan(first.index)) {
                return first;
            }
            return null;
        }

        private SortedMap<Index, Level1> buildLevels1(SortedSet<Index> indexSet) throws FormatException {
            FormatErrorSet errors = RuleModel.this.createErrors();
            TreeMap<Index, Level1> result = new TreeMap<Index, Level1>();
            for (Index index : indexSet) {
                Level1 parentLevel = index.isTopLevel() ? null : (Level1)result.get(index.getParent());
                Level1 level = new Level1(index, parentLevel);
                result.put(index, level);
            }
            for (Map.Entry entry : this.matchCountMap.entrySet()) {
                Index usedAt;
                AspectNode matchCount = (AspectNode)entry.getValue();
                Index definedAt = this.getLevel(result, matchCount).getIndex();
                if (!definedAt.higherThan(usedAt = (Index)entry.getKey()) || definedAt.equals(usedAt)) {
                    throw new FormatException("Match count not defined at appropriate level", matchCount);
                }
                Level1 level = (Level1)result.get(usedAt);
                Index addTo = usedAt.getParent();
                while (addTo != null && !addTo.equals(definedAt)) {
                    ((Level1)result.get(addTo)).addNode(matchCount);
                    addTo = addTo.getParent();
                }
                level.setMatchCount(matchCount);
            }
            for (AspectNode aspectNode : this.source.nodeSet()) {
                if (aspectNode.getKind().isMeta()) continue;
                this.getLevel(result, aspectNode).addNode(aspectNode);
            }
            for (AspectEdge aspectEdge : this.source.edgeSet()) {
                try {
                    if (aspectEdge.getKind() != AspectKind.CONNECT && aspectEdge.getKind().isMeta()) continue;
                    this.getLevel(result, aspectEdge).addEdge(aspectEdge);
                }
                catch (FormatException exc) {
                    errors.addAll(exc.getErrors());
                }
            }
            HashMap<LabelVar, Set<AspectEdge>> hashMap = new HashMap<LabelVar, Set<AspectEdge>>();
            for (Level1 level : result.values()) {
                hashMap.putAll(level.modelVars);
            }
            HashMap<String, LabelVar> nameVarMap = new HashMap<String, LabelVar>();
            for (Map.Entry varEntry : hashMap.entrySet()) {
                LabelVar var = (LabelVar)varEntry.getKey();
                LabelVar oldVar = nameVarMap.put(var.getName(), var);
                if (oldVar == null || oldVar.equals(var)) continue;
                errors.add("Duplicate variable '%s' for %s and %s labels", var, var.getKind().getDescription(false), oldVar.getKind().getDescription(false), ((Set)varEntry.getValue()).toArray(), ((Set)hashMap.get(oldVar)).toArray());
            }
            for (Level1 level : result.values()) {
                level.setFixed();
            }
            errors.throwException();
            return result;
        }

        private Level1 getLevel(Map<Index, Level1> level1Map, AspectNode node) {
            Level1 result = this.getNodeLevelMap().get(node);
            if (result == null) {
                Index index;
                AspectNode nestingNode = node.getNestingLevel();
                Index index2 = index = nestingNode == null ? this.topLevelIndex : this.metaIndexMap.get(nestingNode);
                assert (index != null) : String.format("No valid nesting level found for %s", node);
                result = level1Map.get(index);
                assert (result != null) : String.format("Level map %s does not contain entry for index %s", level1Map, index);
                this.getNodeLevelMap().put(node, result);
            }
            return result;
        }

        private Level1 getLevel(Map<Index, Level1> level1Map, AspectEdge edge) throws FormatException {
            Level1 sourceLevel = this.getLevel(level1Map, (AspectNode)edge.source());
            Level1 targetLevel = this.getLevel(level1Map, (AspectNode)edge.target());
            Level1 result = this.max(sourceLevel, targetLevel);
            if (((AspectNode)edge.source()).getKind().inNAC() && !sourceLevel.equals(result) || ((AspectNode)edge.target()).getKind().inNAC() && !targetLevel.equals(result)) {
                result = null;
            }
            if (result == null) {
                throw new FormatException("Source and target of edge %s have incompatible nesting", edge);
            }
            String levelName = edge.getLevelName();
            if (levelName != null) {
                Index edgeLevelIndex = this.nameIndexMap.get(levelName);
                if (edgeLevelIndex == null) {
                    throw new FormatException("Undefined nesting level '%s' in edge %s", levelName, edge);
                }
                if ((result = this.max(result, level1Map.get(edgeLevelIndex))) == null) {
                    throw new FormatException("Nesting level %s in edge %s is incompatible with end nodes", levelName, edge);
                }
            }
            return result;
        }

        private Map<AspectNode, Level1> getNodeLevelMap() {
            if (this.nodeLevelMap == null) {
                this.nodeLevelMap = new HashMap<AspectNode, Level1>();
            }
            return this.nodeLevelMap;
        }

        private SortedMap<Index, Level2> buildLevels2(SortedMap<Index, Level1> level1Map, RuleModelMap modelMap) throws FormatException {
            TreeMap<Index, Level2> result = new TreeMap<Index, Level2>();
            FormatErrorSet errors = RuleModel.this.createErrors();
            for (Level1 level1 : level1Map.values()) {
                try {
                    Index index = level1.getIndex();
                    Level2 level2 = new Level2(level1, modelMap);
                    result.put(index, level2);
                }
                catch (FormatException e) {
                    errors.addAll(e.getErrors());
                }
            }
            errors.throwException();
            return result;
        }

        private SortedMap<Index, Level3> buildLevels3(SortedMap<Index, Level2> level2Map, RuleGraphMorphism typingMap) throws FormatException {
            TreeMap<Index, Level3> result = new TreeMap<Index, Level3>();
            FormatErrorSet errors = RuleModel.this.createErrors();
            for (Level2 level2 : level2Map.values()) {
                Index index = level2.getIndex();
                Level3 parent = index.isTopLevel() ? null : (Level3)result.get(index.getParent());
                Level3 level3 = new Level3(level2, parent, typingMap);
                result.put(index, level3);
            }
            errors.throwException();
            return result;
        }

        private SortedMap<Index, Level4> build4From3(SortedMap<Index, Level3> level3Map) {
            TreeMap<Index, Level4> result = new TreeMap<Index, Level4>();
            for (Level3 level3 : level3Map.values()) {
                Index index = level3.getIndex();
                Level4 parent = index.isTopLevel() ? null : (Level4)result.get(index.getParent());
                Level4 level4 = new Level4(level3, parent);
                result.put(index, level4);
            }
            return result;
        }

        public final Map<Index, Level1> getLevel1Map() {
            return this.level1Map;
        }

        public final Map<Index, Level4> getLevel4Map() {
            return this.level4Map;
        }

        public final RuleModelMap getModelMap() {
            return this.modelMap;
        }

        public String toString() {
            return "LevelMap: " + this.level4Map;
        }
    }

    private class Parameters {
        private Set<RuleNode> hiddenPars;
        private List<CtrlPar.Var> sig;

        public Parameters() throws FormatException {
            FormatErrorSet errors = RuleModel.this.createErrors();
            this.hiddenPars = new HashSet<RuleNode>();
            HashMap<Integer, CtrlPar.Var> parMap = new HashMap<Integer, CtrlPar.Var>();
            int parCount = 0;
            for (AspectNode node : RuleModel.this.getSource().nodeSet()) {
                if (!node.hasParam()) continue;
                Integer nr = (Integer)node.getParam().getContent();
                if (nr != null) {
                    parCount = Math.max(parCount, nr + 1);
                    try {
                        this.processNode(parMap, node, nr);
                    }
                    catch (FormatException exc) {
                        errors.addAll(exc.getErrors());
                    }
                    continue;
                }
                if (node.getParamKind() != AspectKind.PARAM_BI) {
                    throw new FormatException("Anchor node cannot be input or output", node);
                }
                if (!node.getKind().inLHS()) {
                    throw new FormatException("Anchor node must be in LHS", node);
                }
                RuleNode nodeImage = (RuleNode)RuleModel.this.modelMap.getNode(node);
                assert (nodeImage != null);
                this.hiddenPars.add(nodeImage);
            }
            errors.throwException();
            TreeSet<Integer> missingPars = new TreeSet<Integer>();
            int i = 0;
            while (i < parCount) {
                missingPars.add(i);
                ++i;
            }
            missingPars.removeAll(parMap.keySet());
            if (!missingPars.isEmpty()) {
                throw new FormatException("Parameters %s missing", missingPars);
            }
            CtrlPar.Var[] sigArray = new CtrlPar.Var[parCount];
            for (Map.Entry parEntry : parMap.entrySet()) {
                sigArray[((Integer)parEntry.getKey()).intValue()] = (CtrlPar.Var)parEntry.getValue();
            }
            this.sig = Arrays.asList(sigArray);
        }

        private void processNode(Map<Integer, CtrlPar.Var> parMap, AspectNode node, Integer nr) throws FormatException {
            boolean creator;
            AspectKind nodeKind = node.getKind();
            AspectKind paramKind = node.getParamKind();
            AspectKind attrKind = node.getAttrKind();
            CtrlType varType = attrKind.hasSignature() ? CtrlType.getDataType(attrKind.getSignature()) : CtrlType.NODE;
            CtrlVar var = new CtrlVar("arg" + nr, varType);
            boolean inOnly = paramKind == AspectKind.PARAM_IN;
            boolean outOnly = paramKind == AspectKind.PARAM_OUT;
            RuleNode nodeImage = (RuleNode)RuleModel.this.modelMap.getNode(node);
            assert (nodeImage != null);
            if (nodeKind.inLHS()) {
                creator = false;
            } else if (nodeKind.inRHS()) {
                if (inOnly) {
                    throw new FormatException("Creator node cannot be used as input parameter", node);
                }
                outOnly = true;
                creator = true;
            } else {
                throw new FormatException("Parameter '%d' may not occur in NAC", nr, node);
            }
            CtrlPar.Var par = inOnly || outOnly ? new CtrlPar.Var(var, inOnly) : new CtrlPar.Var(var);
            par.setRuleNode(nodeImage, creator);
            CtrlPar.Var oldPar = parMap.put(nr, par);
            if (oldPar != null) {
                throw new FormatException("Parameter '%d' defined more than once", nr, node, oldPar.getRuleNode());
            }
        }

        public Set<RuleNode> getHiddenPars() {
            return this.hiddenPars;
        }

        public List<CtrlPar.Var> getSignature() {
            return this.sig;
        }
    }

    private static class RuleModelMap
    extends GraphBasedModel.ModelMap<RuleNode, RuleEdge> {
        public RuleModelMap(RuleFactory factory) {
            super(factory);
        }

        public RuleModelMap() {
            super(RuleFactory.newInstance());
        }

        public RuleFactory getFactory() {
            return (RuleFactory)super.getFactory();
        }
    }
}

