/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.model;

import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectNode;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeFactory;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.AElementMap;
import groove.graph.Edge;
import groove.graph.Element;
import groove.graph.ElementFactory;
import groove.graph.ElementMap;
import groove.graph.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class GraphBasedModel<R>
extends ResourceModel<R> {
    private final AspectGraph source;

    protected GraphBasedModel(GrammarModel grammar, AspectGraph source) {
        super(grammar, ResourceKind.toResource(source.getRole()), source.getName());
        this.source = source;
    }

    @Override
    public AspectGraph getSource() {
        return this.source;
    }

    public abstract ModelMap<?, ?> getMap();

    public abstract Set<TypeLabel> getLabels();

    public abstract TypeModelMap getTypeMap();

    final FormatErrorSet transferErrors(FormatErrorSet errors, ElementMap map) {
        return errors.transfer(this.getInverseMap(map));
    }

    private final Map<Element, Element> getInverseMap(ElementMap map) {
        HashMap<Element, Element> result = new HashMap<Element, Element>();
        for (Map.Entry<? extends Node, ? extends Node> entry : map.nodeMap().entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<Element, Element> entry : map.edgeMap().entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static abstract class ModelMap<N extends Node, E extends Edge>
    extends AElementMap<AspectNode, AspectEdge, N, E> {
        public ModelMap(ElementFactory<N, E> factory) {
            super(factory);
        }

        @Override
        public Map<AspectNode, N> nodeMap() {
            return super.nodeMap();
        }

        @Override
        public Map<AspectEdge, E> edgeMap() {
            return super.edgeMap();
        }
    }

    public static class TypeModelMap
    extends ModelMap<TypeNode, TypeEdge> {
        public TypeModelMap(TypeFactory factory) {
            super(factory);
        }

        public TypeFactory getFactory() {
            return (TypeFactory)super.getFactory();
        }
    }
}

