/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.model;

import groove.grammar.model.FormatError;
import groove.grammar.model.FormatErrorSet;
import groove.util.Groove;
import java.util.Collection;

public class FormatException
extends Exception {
    public static final String FORMAT_EXCEPTION = "Format exception";
    private final FormatErrorSet errors;

    public FormatException(String message, Object ... parameters) {
        super(String.format(message, parameters));
        this.errors = new FormatErrorSet(message, parameters);
    }

    public FormatException(Collection<?> errors) {
        this.errors = new FormatErrorSet();
        for (Object error : errors) {
            if (error instanceof FormatError) {
                this.errors.add((FormatError)error);
                continue;
            }
            this.errors.add(error.toString(), new Object[0]);
        }
    }

    public FormatException() {
        this(FORMAT_EXCEPTION, new Object[0]);
    }

    public void insert(FormatException prior) {
        if (prior != null) {
            this.errors.addAll(prior.getErrors());
        }
    }

    public FormatErrorSet getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        return Groove.toString(this.getErrors().toArray(), "", "", "\n");
    }

    public FormatException extend(Object par) {
        FormatErrorSet newErrors = new FormatErrorSet();
        for (FormatError error : this.getErrors()) {
            newErrors.add(error.extend(par));
        }
        return new FormatException(newErrors);
    }
}

