/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.model;

import groove.control.CtrlAut;
import groove.control.CtrlLoader;
import groove.grammar.Recipe;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.TextBasedModel;
import groove.graph.GraphInfo;
import java.util.Set;

public class ControlModel
extends TextBasedModel<CtrlAut> {
    private final CtrlLoader loader = new CtrlLoader();
    private Set<Recipe> recipes;

    public ControlModel(GrammarModel grammar, String name, String program) {
        super(grammar, ResourceKind.CONTROL, name, program);
    }

    public CtrlAut toCtrlAut() throws FormatException {
        return (CtrlAut)this.toResource();
    }

    @Override
    public CtrlAut compute() throws FormatException {
        this.loader.init(this.getGrammar().getProperties().getAlgebraFamily(), this.getRules());
        this.loader.parse(this.getFullName(), this.getProgram());
        CtrlAut result = this.loader.buildAutomaton(this.getFullName());
        if (result == null) {
            result = this.loader.buildDefaultAutomaton();
        } else {
            GraphInfo.throwException(result);
            result = result.normalise();
        }
        result.setFixed();
        return result;
    }

    public Set<Recipe> getRecipes() {
        this.synchronise();
        return this.recipes;
    }

    public boolean isDefault() {
        boolean result = false;
        try {
            CtrlAut aut = (CtrlAut)this.toResource();
            result = aut == null || aut.isDefault();
        }
        catch (FormatException formatException) {}
        return result;
    }
}

