/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.aspect;

import groove.grammar.aspect.Expression;
import groove.grammar.model.FormatException;
import groove.grammar.type.TypeLabel;
import groove.graph.EdgeRole;

public class Assignment {
    private final Expression rhs;
    private final String lhs;

    public Assignment(String lhs, Expression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public String getLhs() {
        return this.lhs;
    }

    public Expression getRhs() {
        return this.rhs;
    }

    public String toString() {
        return String.valueOf(this.getLhs()) + " = " + this.getRhs().toString();
    }

    public String toDisplayString(String assignSymbol) {
        StringBuilder result = new StringBuilder(this.getLhs());
        result.append(' ');
        result.append(assignSymbol == null ? "=" : assignSymbol);
        result.append(' ');
        result.append(this.getRhs().toDisplayString());
        return result.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.lhs.hashCode();
        result = 31 * result + this.rhs.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Assignment)) {
            return false;
        }
        Assignment other = (Assignment)obj;
        return this.lhs.equals(other.lhs) && this.rhs.equals(other.rhs);
    }

    public Assignment relabel(TypeLabel oldLabel, TypeLabel newLabel) {
        Assignment result = this;
        if (oldLabel.getRole() == EdgeRole.BINARY) {
            String newLhs;
            Expression newRhs = this.getRhs().relabel(oldLabel, newLabel);
            String string = newLhs = oldLabel.text().equals(this.getLhs()) ? newLabel.text() : this.getLhs();
            if (newRhs != this.getRhs() || newLhs != this.getLhs()) {
                result = new Assignment(newLhs, newRhs);
            }
        }
        return result;
    }

    public static Assignment parse(String text) throws FormatException {
        if (text.length() == 0) {
            throw new FormatException("Empty string cannot be parsed as assignment", new Object[0]);
        }
        int pos = text.indexOf(61);
        if (pos < 0) {
            throw new FormatException("Assignment expression '%s' does not contain '='", text);
        }
        String lhs = text.substring(0, pos).trim();
        String rhs = text.substring(pos + 1, text.length()).trim();
        if (!Assignment.isIdentifier(lhs)) {
            throw new FormatException("Assignment target '%s' is not an identifier", lhs);
        }
        return new Assignment(lhs, Expression.parse(rhs));
    }

    private static boolean isIdentifier(String text) {
        boolean result;
        boolean bl = result = text.length() > 0;
        if (result) {
            result = Character.isJavaIdentifierStart(text.charAt(0));
            int i = 1;
            while (result && i < text.length()) {
                result = Character.isJavaIdentifierPart(text.charAt(i));
                ++i;
            }
        }
        return result;
    }
}

