/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar;

import groove.control.CtrlAut;
import groove.grammar.Action;
import groove.grammar.GrammarProperties;
import groove.grammar.Recipe;
import groove.grammar.Rule;
import groove.grammar.host.DefaultHostGraph;
import groove.grammar.host.HostGraph;
import groove.grammar.model.FormatException;
import groove.grammar.type.TypeGraph;
import groove.prolog.GrooveEnvironment;
import groove.util.Fixable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class Grammar {
    private final Map<String, Rule> nameRuleMap = new TreeMap<String, Rule>();
    private final Map<String, Recipe> nameRecipeMap = new TreeMap<String, Recipe>();
    private final SortedMap<Integer, Set<Action>> priorityActionMap = new TreeMap<Integer, Set<Action>>(Action.PRIORITY_COMPARATOR);
    private final Set<Action> actions = new TreeSet<Action>(Action.ACTION_COMPARATOR);
    private final Set<Rule> allRules = new HashSet<Rule>();
    private GrammarProperties properties;
    private TypeGraph typeGraph;
    private boolean fixed;
    private final String name;
    private HostGraph startGraph;
    private CtrlAut ctrlAut;
    private GrooveEnvironment prologEnvironment;

    public Grammar(String name) {
        this.name = name;
    }

    public Grammar(Grammar other, DefaultHostGraph startGraph) {
        this(other.getName());
        this.startGraph = startGraph;
        this.getProperties().putAll((Map<?, ?>)other.getProperties());
        this.nameRuleMap.putAll(other.nameRuleMap);
        for (Map.Entry<Integer, Set<Action>> priorityRuleEntry : other.priorityActionMap.entrySet()) {
            Set<Action> newRuleSet = this.createActionSet();
            newRuleSet.addAll((Collection<Action>)priorityRuleEntry.getValue());
            this.priorityActionMap.put(priorityRuleEntry.getKey(), newRuleSet);
        }
    }

    public String getName() {
        return this.name;
    }

    public Rule getRule(String name) {
        return this.nameRuleMap.get(name);
    }

    public Recipe getRecipe(String name) {
        return this.nameRecipeMap.get(name);
    }

    public boolean hasRecipes() {
        return !this.nameRecipeMap.isEmpty();
    }

    public Action getAction(String name) {
        Action result = this.getRule(name);
        if (result == null) {
            result = this.getRecipe(name);
        }
        return result;
    }

    public SortedMap<Integer, Set<Action>> getActionMap() {
        return Collections.unmodifiableSortedMap(this.priorityActionMap);
    }

    public Set<Action> getActions() {
        return this.actions;
    }

    public Set<Rule> getAllRules() {
        return this.allRules;
    }

    public boolean hasMultiplePriorities() {
        return this.priorityActionMap.size() > 1;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("Rule system:\n    ");
        for (Action action : this.getActions()) {
            res.append(action + "\n");
        }
        res.append("\nStart graph:\n    ");
        res.append(this.getStartGraph().toString());
        return res.toString();
    }

    public void add(Action action) {
        this.testFixed(false);
        assert (action instanceof Fixable && ((Fixable)((Object)action)).isFixed());
        String actionName = action.getFullName();
        int priority = action.getPriority();
        Set<Action> priorityRuleSet = (Set<Action>)this.priorityActionMap.get(priority);
        if (priorityRuleSet == null) {
            priorityRuleSet = this.createActionSet();
            this.priorityActionMap.put(priority, priorityRuleSet);
        }
        priorityRuleSet.add(action);
        this.actions.add(action);
        switch (action.getKind()) {
            case RULE: {
                Rule rule = (Rule)action;
                this.nameRuleMap.put(actionName, rule);
                this.allRules.add(rule);
                break;
            }
            case RECIPE: {
                Recipe recipe = (Recipe)action;
                this.nameRecipeMap.put(actionName, recipe);
                for (Rule subRule : recipe.getRules()) {
                    subRule.setPartial();
                    this.allRules.add(subRule);
                }
                break;
            }
        }
    }

    public final boolean isFixed() {
        assert (!this.fixed || this.typeGraph != null);
        return this.fixed;
    }

    public void setFixed() throws FormatException {
        this.fixed = true;
    }

    public final void testFixed(boolean value) throws IllegalStateException {
        if (this.isFixed() != value) {
            if (value) {
                throw new IllegalStateException("Operation not allowed: Rule system is not fixed");
            }
            throw new IllegalStateException("Operation not allowed: Rule system is fixed");
        }
    }

    public void setProperties(Properties properties) {
        this.testFixed(false);
        GrammarProperties currentRuleProperties = this.getProperties();
        currentRuleProperties.clear();
        currentRuleProperties.putAll((Map<?, ?>)properties);
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public GrammarProperties getProperties() {
        if (this.properties == null) {
            this.properties = this.createProperties();
        }
        return this.properties;
    }

    public final void setTypeGraph(TypeGraph type) {
        this.testFixed(false);
        assert (type.isFixed());
        this.typeGraph = type;
    }

    public final TypeGraph getTypeGraph() {
        return this.typeGraph;
    }

    public HostGraph getStartGraph() {
        return this.startGraph;
    }

    public void setStartGraph(HostGraph startGraph) {
        this.testFixed(false);
        assert (startGraph.isFixed());
        this.startGraph = startGraph;
    }

    public void setCtrlAut(CtrlAut aut) {
        this.testFixed(false);
        assert (aut.isFixed());
        this.ctrlAut = aut;
    }

    public CtrlAut getCtrlAut() {
        return this.ctrlAut;
    }

    public void setPrologEnvironment(GrooveEnvironment prologEnvironment) {
        this.testFixed(false);
        this.prologEnvironment = prologEnvironment;
    }

    public GrooveEnvironment getPrologEnvironment() {
        return this.prologEnvironment;
    }

    public boolean equals(Object obj) {
        return obj instanceof Grammar && this.getStartGraph().equals(((Grammar)obj).getStartGraph()) && super.equals(obj);
    }

    public int hashCode() {
        return this.getStartGraph().hashCode() << 8 ^ super.hashCode();
    }

    private GrammarProperties createProperties() {
        return new GrammarProperties();
    }

    private Set<Action> createActionSet() {
        return new TreeSet<Action>();
    }
}

