/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.encode;

import groove.explore.encode.EncodedType;
import groove.explore.encode.EncodedTypeEditor;
import groove.explore.encode.StringEditor;
import groove.grammar.Grammar;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;

public class EncodedInt
implements EncodedType<Integer, String> {
    private int lowerBound;
    private int upperBound;

    public EncodedInt(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public EncodedTypeEditor<Integer, String> createEditor(GrammarModel grammar) {
        return new StringEditor<Integer>(grammar, Integer.toString(this.lowerBound), 4);
    }

    @Override
    public Integer parse(Grammar rules, String source) throws FormatException {
        Integer value;
        try {
            value = Integer.parseInt(source, 10);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormatException("'" + source + "' is not a valid number.", new Object[0]);
        }
        if (value < this.lowerBound) {
            throw new FormatException("Illegal input: '" + source + "' is smaller than the permitted lowerbound '" + Integer.toString(this.lowerBound) + "'.", new Object[0]);
        }
        if (this.upperBound >= 0 && value > this.upperBound) {
            throw new FormatException("Illegal input: '" + source + "' is greater than the permitted upperbound '" + Integer.toString(this.upperBound) + "'.", new Object[0]);
        }
        return value;
    }
}

